#! /bin/sh


WD=`pwd`


PRISM_LIBS=libs/runtime/

#Get machine type
unameOut="$(uname -s)"
case "${unameOut}" in
    Linux*)     machine=Linux
    				export LD_LIBRARY_PATH="$PRISM_LIBS":$LD_LIBRARY_PATH
    				JAVA_EXEC=java
    				;;

    Darwin*)    machine=Mac
    				export DYLD_LIBRARY_PATH="$PRISM_LIBS":$DYLD_LIBRARY_PATH

					if [ -x /usr/libexec/java_home ]; then
						JAVA_EXEC=`/usr/libexec/java_home`"/bin/java"
					else
						JAVA_EXEC=java
					fi    

					;;
	CYGWIN*)    machine=Cygwin;;

    
    MINGW*)     machine=MinGw;;
    *)          machine="UNKNOWN:${unameOut}"
esac


$JAVA_EXEC -jar fPMC.jar
