/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import simulator.SimulatorEngine;
import userinterface.simulator.GUISimulator;
import userinterface.simulator.GUISimulatorPathTableModel;
import userinterface.simulator.SimulationView;
import userinterface.util.GUIGroupedTable;

public class GUISimulatorPathTable
extends GUIGroupedTable {
    private static final long serialVersionUID = 1L;
    private GUISimulator simulator;
    private GUISimulatorPathTableModel ptm;
    private JList loopIndicator;
    private LoopIndicatorListModel loopIndicatorModel;

    public GUISimulatorPathTable(GUISimulator gUISimulator, GUISimulatorPathTableModel gUISimulatorPathTableModel, SimulatorEngine simulatorEngine) {
        super(gUISimulatorPathTableModel);
        this.ptm = gUISimulatorPathTableModel;
        this.simulator = gUISimulator;
        this.setColumnSelectionAllowed(false);
        this.getSelectionModel().setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new PathChangeTableRenderer(true));
        this.loopIndicatorModel = new LoopIndicatorListModel();
        this.loopIndicator = new JList(this.loopIndicatorModel);
        this.loopIndicator.setBackground(new JPanel().getBackground());
        this.loopIndicator.setFixedCellWidth(25);
        this.loopIndicator.setFixedCellHeight(this.getRowHeight());
        this.loopIndicator.setCellRenderer(new LoopIndicatorRenderer(this));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
        if (this.loopIndicator != null) {
            this.loopIndicator.setFixedCellHeight(this.getRowHeight());
        }
    }

    public boolean usingChangeRenderer() {
        return ((PathChangeTableRenderer)this.getDefaultRenderer(Object.class)).onlyShowChange();
    }

    public void switchToChangeRenderer() {
        this.setDefaultRenderer(Object.class, new PathChangeTableRenderer(true));
        this.repaint();
    }

    public void switchToBoringRenderer() {
        this.setDefaultRenderer(Object.class, new PathChangeTableRenderer(false));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.loopIndicatorModel.updateIndicator();
    }

    public Component getPathLoopIndicator() {
        return this.loopIndicator;
    }

    public static Rectangle getStringBounds(String string, Graphics2D graphics2D) {
        if (string == null) {
            return new Rectangle(0, 0);
        }
        if (string.length() == 0) {
            return new Rectangle(0, 0);
        }
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        return textLayout.getOutline(new AffineTransform()).getBounds();
    }

    public static double getStringWidth(String string, Graphics2D graphics2D) {
        return GUISimulatorPathTable.getStringBounds(string, graphics2D).getWidth();
    }

    public static double getStringHeight(String string, Graphics2D graphics2D) {
        return GUISimulatorPathTable.getStringBounds(string, graphics2D).getHeight();
    }

    class PathChangeTableRenderer
    implements TableCellRenderer {
        private boolean onlyShowChange;
        private Color defaultColor;
        private Color selectedColor;
        private Color labelColor;
        private Color selectedLabelColor;

        public PathChangeTableRenderer(boolean bl) {
            this.onlyShowChange = bl;
            this.defaultColor = Color.white;
            this.selectedColor = new Color(this.defaultColor.getRed() - 20, this.defaultColor.getGreen() - 20, this.defaultColor.getBlue());
            this.selectedLabelColor = new Color(this.selectedColor.getRed() - 20, this.selectedColor.getGreen(), this.selectedColor.getBlue() - 20);
            this.labelColor = new Color(this.defaultColor.getRed() - 50, this.defaultColor.getGreen(), this.defaultColor.getBlue() - 50);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            PathChangeCellRenderer pathChangeCellRenderer = new PathChangeCellRenderer(this, object, bl, n);
            boolean bl3 = GUISimulatorPathTable.this.ptm.shouldColourRow(n);
            Color color = this.defaultColor;
            if (bl && !bl3) {
                color = this.selectedColor;
            } else if (bl && bl3) {
                color = this.selectedLabelColor;
            } else if (!bl && bl3) {
                color = this.labelColor;
            }
            pathChangeCellRenderer.setBackground(color);
            return pathChangeCellRenderer;
        }

        public boolean onlyShowChange() {
            return this.onlyShowChange;
        }
    }

    class PathChangeCellRenderer
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private PathChangeTableRenderer pctr;
        private Object value;
        private String stringValue;
        private boolean isSelected;

        public PathChangeCellRenderer(PathChangeTableRenderer pathChangeTableRenderer, Object object, boolean bl, int n) {
            this.pctr = pathChangeTableRenderer;
            this.value = object;
            this.isSelected = bl;
            if (object instanceof String) {
                this.stringValue = (String)object;
                this.setToolTipText("State " + n);
            } else if (object instanceof SimulationView.ActionValue) {
                SimulationView.ActionValue actionValue = (SimulationView.ActionValue)object;
                if (actionValue.isActionValueUnknown()) {
                    this.stringValue = "?";
                    this.setToolTipText("Module name or [action] label for transition from state " + (n - 1) + " to " + n + " (not yet known)");
                } else {
                    this.stringValue = actionValue.getValue();
                    String string = n == 0 ? null : "Module name or [action] label for transition from state " + (n - 1) + " to " + n;
                    this.setToolTipText(string);
                }
            } else if (object instanceof SimulationView.TimeValue) {
                SimulationView.TimeValue timeValue = (SimulationView.TimeValue)object;
                if (timeValue.isTimeValueUnknown()) {
                    this.stringValue = "?";
                    if (timeValue.isCumulative()) {
                        this.setToolTipText("Cumulative time up until entering state " + n + " (not yet known)");
                    } else {
                        this.setToolTipText("Time spent in state " + n + " (not yet known)");
                    }
                } else {
                    this.stringValue = GUISimulatorPathTable.this.simulator.formatDouble(timeValue.getValue());
                    if (timeValue.isCumulative()) {
                        this.setToolTipText("Cumulative time up until entering state " + n);
                    } else {
                        this.setToolTipText("Time spent in state " + n);
                    }
                }
            } else if (object instanceof SimulationView.VariableValue) {
                SimulationView.VariableValue variableValue = (SimulationView.VariableValue)object;
                this.stringValue = variableValue.getValue() instanceof Double ? GUISimulatorPathTable.this.simulator.formatDouble((Double)variableValue.getValue()) : variableValue.getValue().toString();
                this.setToolTipText("Value of variable \"" + variableValue.getVariable().getName() + "\" in state " + n);
            } else if (object instanceof SimulationView.RewardStructureValue) {
                SimulationView.RewardStructureValue rewardStructureValue = (SimulationView.RewardStructureValue)object;
                String string = rewardStructureValue.getRewardStructureColumn().getRewardStructure().getColumnName();
                if (rewardStructureValue.isRewardValueUnknown()) {
                    this.stringValue = "?";
                    if (rewardStructureValue.getRewardStructureColumn().isCumulativeReward()) {
                        this.setToolTipText("Cumulative reward of reward structure " + string + " up until state " + n + " (not yet known)");
                    }
                    if (rewardStructureValue.getRewardStructureColumn().isStateReward()) {
                        this.setToolTipText("State reward of reward structure " + string + " in state " + n + " (not yet known)");
                    }
                    if (rewardStructureValue.getRewardStructureColumn().isTransitionReward()) {
                        this.setToolTipText("Transition reward of reward structure " + string + " from state " + n + " to " + (n + 1) + " (not yet known)");
                    }
                } else {
                    this.stringValue = GUISimulatorPathTable.this.simulator.formatDouble(rewardStructureValue.getRewardValue());
                    if (rewardStructureValue.getRewardStructureColumn().isCumulativeReward()) {
                        this.setToolTipText("Cumulative reward of reward structure " + string + " up until state " + n);
                    }
                    if (rewardStructureValue.getRewardStructureColumn().isStateReward()) {
                        this.setToolTipText("State reward of reward structure " + string + " in state " + n);
                    }
                    if (rewardStructureValue.getRewardStructureColumn().isTransitionReward()) {
                        this.setToolTipText("Transition reward of reward structure " + string + " from state " + n + " to " + (n + 1));
                    }
                }
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = GUISimulatorPathTable.getStringBounds(this.stringValue, graphics2D);
            int n = (int)Math.ceil(rectangle.getWidth());
            int n2 = (int)Math.ceil(rectangle.getHeight());
            if (this.value instanceof String || this.value instanceof SimulationView.ActionValue) {
                int n3 = this.getWidth() / 2 - n / 2;
                int n4 = this.getHeight() / 2 + n2 / 2;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(this.stringValue, n3, n4);
            } else if (this.value instanceof SimulationView.VariableValue) {
                Color color;
                SimulationView.VariableValue variableValue = (SimulationView.VariableValue)this.value;
                int n5 = this.getWidth() / 2 - n / 2;
                int n6 = this.getHeight() / 2 + n2 / 2;
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n5 - 5, 2.0, n + 10, this.getHeight() - 5, 8.0, 8.0);
                Color color2 = color = variableValue.hasChanged() ? Color.black : Color.lightGray;
                if (this.pctr.onlyShowChange()) {
                    graphics2D.setColor(Color.black);
                    graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                    if (this.isSelected || variableValue.hasChanged()) {
                        graphics2D.setColor(Color.white);
                        graphics2D.fill(double_);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.setColor(color);
                        graphics2D.draw(double_);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        graphics2D.drawString(this.stringValue, n5, n6);
                    }
                } else {
                    graphics2D.setColor(color);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.drawString(this.stringValue, n5, n6);
                }
            } else if (this.value instanceof SimulationView.RewardStructureValue) {
                SimulationView.RewardStructureValue rewardStructureValue = (SimulationView.RewardStructureValue)this.value;
                if (!GUISimulatorPathTable.this.ptm.canShowTime() || !rewardStructureValue.getRewardStructureColumn().isCumulativeReward()) {
                    Color color;
                    int n7 = this.getWidth() / 2 - n / 2;
                    int n8 = this.getHeight() / 2 + n2 / 2;
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n7 - 5, 2.0, n + 10, this.getHeight() - 5, 8.0, 8.0);
                    Color color3 = color = rewardStructureValue.hasChanged() || rewardStructureValue.isRewardValueUnknown() ? Color.black : Color.lightGray;
                    if (this.pctr.onlyShowChange()) {
                        graphics2D.setColor(Color.black);
                        graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                        if (this.isSelected || rewardStructureValue.hasChanged()) {
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(double_);
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            graphics2D.setColor(color);
                            graphics2D.draw(double_);
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            graphics2D.drawString(this.stringValue, n7, n8);
                        }
                    } else {
                        graphics2D.setColor(color);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        graphics2D.drawString(this.stringValue, n7, n8);
                    }
                } else {
                    int n9 = 3;
                    int n10 = this.getHeight() / 2 + n2 / 2;
                    graphics2D.setColor(Color.black);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.drawString(this.stringValue, n9, n10);
                }
            } else if (this.value instanceof SimulationView.TimeValue) {
                int n11 = 3;
                int n12 = this.getHeight() / 2 + n2 / 2;
                graphics2D.setColor(Color.black);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.drawString(this.stringValue, n11, n12);
            }
        }
    }

    class LoopIndicatorListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;

        LoopIndicatorListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return "";
        }

        @Override
        public int getSize() {
            return GUISimulatorPathTable.this.ptm.getRowCount();
        }

        public void updateIndicator() {
            this.fireContentsChanged(this, 0, GUISimulatorPathTable.this.ptm.getRowCount());
        }
    }

    class LoopIndicatorRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        boolean startLoop;
        boolean midLoop;
        boolean endLoop;

        LoopIndicatorRenderer(JTable jTable) {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (GUISimulatorPathTable.this.ptm.isPathLooping()) {
                if (n == GUISimulatorPathTable.this.ptm.getLoopEnd() && n == GUISimulatorPathTable.this.ptm.getLoopStart()) {
                    this.startLoop = true;
                    this.endLoop = true;
                    this.midLoop = false;
                } else if (n == GUISimulatorPathTable.this.ptm.getLoopEnd()) {
                    this.startLoop = false;
                    this.midLoop = false;
                    this.endLoop = true;
                } else if (n == GUISimulatorPathTable.this.ptm.getLoopStart()) {
                    this.startLoop = true;
                    this.midLoop = false;
                    this.endLoop = false;
                } else if (n > GUISimulatorPathTable.this.ptm.getLoopStart() && n < GUISimulatorPathTable.this.ptm.getLoopEnd()) {
                    this.startLoop = false;
                    this.midLoop = true;
                    this.endLoop = false;
                } else {
                    this.startLoop = false;
                    this.midLoop = false;
                    this.endLoop = false;
                }
            } else {
                this.startLoop = false;
                this.midLoop = false;
                this.endLoop = false;
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!GUISimulatorPathTable.this.simulator.isDisplayPathLoops()) {
                return;
            }
            graphics2D.setColor(Color.black);
            if (this.startLoop && this.endLoop) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(this.getWidth(), this.getHeight() / 2 + 5);
                generalPath.lineTo(this.getWidth() / 2 + 5, this.getHeight() / 2 + 5);
                generalPath.quadTo(this.getWidth() / 2, this.getHeight() / 2 + 5, this.getWidth() / 2, this.getHeight() / 2);
                generalPath.quadTo(this.getWidth() / 2, this.getHeight() / 2 - 5, this.getWidth() / 2 + 5, this.getHeight() / 2 - 5);
                generalPath.lineTo(this.getWidth(), this.getHeight() / 2 - 5);
                graphics2D.draw(generalPath);
                generalPath = new GeneralPath();
                generalPath.moveTo(this.getWidth(), this.getHeight() / 2 - 5);
                generalPath.lineTo(this.getWidth() - 5, this.getHeight() / 2 - 8);
                generalPath.lineTo(this.getWidth() - 5, this.getHeight() / 2 - 2);
                generalPath.closePath();
                graphics2D.fill(generalPath);
            } else if (this.startLoop) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(this.getWidth(), this.getHeight() / 2);
                generalPath.lineTo(this.getWidth() / 2 + 5, this.getHeight() / 2);
                generalPath.quadTo(this.getWidth() / 2, this.getHeight() / 2, this.getWidth() / 2, this.getHeight() / 2 + 5);
                generalPath.lineTo(this.getWidth() / 2, this.getHeight());
                graphics2D.draw(generalPath);
                generalPath = new GeneralPath();
                generalPath.moveTo(this.getWidth(), this.getHeight() / 2);
                generalPath.lineTo(this.getWidth() - 5, this.getHeight() / 2 - 3);
                generalPath.lineTo(this.getWidth() - 5, this.getHeight() / 2 + 3);
                generalPath.closePath();
                graphics2D.fill(generalPath);
            } else if (this.midLoop) {
                graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
            } else if (this.endLoop) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(this.getWidth(), this.getHeight() / 2);
                generalPath.lineTo(this.getWidth() / 2 + 5, this.getHeight() / 2);
                generalPath.quadTo(this.getWidth() / 2, this.getHeight() / 2, this.getWidth() / 2, this.getHeight() / 2 - 5);
                generalPath.lineTo(this.getWidth() / 2, 0.0f);
                graphics2D.draw(generalPath);
            }
        }
    }
}

