/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeClock;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import userinterface.GUIPrism;
import userinterface.model.GUIMultiModelHandler;

public class GUIMultiModelTree
extends JPanel
implements MouseListener {
    public static final int TREE_SYNCHRONIZED_GOOD = 0;
    public static final int TREE_SYNCHRONIZED_BAD = 1;
    public static final int TREE_NOT_SYNCHRONIZED = 2;
    private GUIMultiModelHandler handler;
    private boolean editable;
    private JTree tree;
    private JPopupMenu moduleCollectionPopup;
    private Action addModule;
    private JPopupMenu declarationCollectionPopup;
    private Action addBooleanGlobal;
    private Action addIntegerGlobal;
    private JPopupMenu constantsCollectionPopup;
    private Action addBooleanConstant;
    private Action addDoubleConstant;
    private Action addIntegerConstant;
    private JPopupMenu modulePopup;
    private Action renameModule;
    private Action removeModule;
    private Action addBoolean;
    private Action addInteger;
    private JPopupMenu declarationPopup;
    private Action renameDeclaration;
    private Action removeDeclaration;
    private JPopupMenu expressionPopup;
    private Action editExpression;
    private JPopupMenu modelTypePopup;
    private JRadioButton non;
    private JRadioButton pro;
    private JRadioButton sto;
    private DefaultTreeModel theModel;
    private ModelRootNode root;
    private ModelTypeNode modelType;
    private ModuleCollectionNode modules;
    private DeclarationCollectionNode declarations;
    private ConstantCollectionNode constants;
    private ArrayList<ModuleNode> editableModules;
    private ArrayList<DeclarationNode> editableDeclarations;
    private ArrayList<ConstantNode> editableConstants;
    private ImageIcon animIcon;
    private boolean isParsing;
    private IconThread parseThread;
    private PrismTreeNode lastPopNode;
    private int parseSynchState;
    static int modCounter = 1;
    static int globCounter = 1;
    static int consCount = 1;
    static int varCount = 1;
    public static final String TAB = "\t";
    public static final int LOCAL_INTEGER = 0;
    public static final int LOCAL_BOOL = 1;
    public static final int GLOBAL_INTEGER = 2;
    public static final int GLOBAL_BOOL = 3;
    public static final int CONST_INTEGER = 4;
    public static final int CONST_BOOL = 5;
    public static final int CONST_DOUBLE = 6;

    public GUIMultiModelTree(GUIMultiModelHandler gUIMultiModelHandler, boolean bl) {
        this.handler = gUIMultiModelHandler;
        this.editable = bl;
        this.root = new ModelRootNode();
        this.theModel = new DefaultTreeModel(this.root);
        this.newTree(bl);
        this.initComponents();
        this.animIcon = GUIPrism.getIconFromImage("smallClockAnim1.png");
        this.isParsing = false;
        this.tree.addMouseListener(this);
        this.tree.setEditable(true);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    public GUIMultiModelTree(GUIMultiModelHandler gUIMultiModelHandler) {
        this(gUIMultiModelHandler, false);
    }

    public void a_addModule() {
        ModuleNode moduleNode = new ModuleNode("newModule" + modCounter, true);
        moduleNode.addVariable(new StateVarNode(moduleNode));
        this.editableModules.add(moduleNode);
        this.modules.addModule(moduleNode);
        int n = this.modules.getIndex(moduleNode);
        this.theModel.nodesWereInserted(this.modules, new int[]{n});
        ++modCounter;
    }

    public ModuleNode a_requestNewModule(String string) {
        ModuleNode moduleNode = new ModuleNode(string, true);
        moduleNode.addVariable(new StateVarNode(moduleNode));
        this.editableModules.add(moduleNode);
        this.modules.addModule(moduleNode);
        int n = this.modules.getIndex(moduleNode);
        this.theModel.nodesWereInserted(this.modules, new int[]{n});
        ++modCounter;
        return moduleNode;
    }

    public void a_addIntegerGlobal() {
        try {
            Expression expression = Prism.parseSingleExpressionString("0");
            Expression expression2 = Prism.parseSingleExpressionString("0");
            Expression expression3 = Prism.parseSingleExpressionString("0");
            GlobalNode globalNode = new GlobalNode("g" + globCounter, expression, expression2, expression3, true);
            this.editableDeclarations.add(globalNode);
            this.declarations.addDeclaration(globalNode);
            int n = this.declarations.getIndex(globalNode);
            this.theModel.nodesWereInserted(this.declarations, new int[]{n});
            ++globCounter;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addIntegerGlobal(String string, String string2, String string3, String string4) throws PrismException {
        try {
            Expression expression = Prism.parseSingleExpressionString(string4);
            Expression expression2 = Prism.parseSingleExpressionString(string2);
            Expression expression3 = Prism.parseSingleExpressionString(string3);
            GlobalNode globalNode = new GlobalNode(string, expression, expression2, expression3, true);
            this.editableDeclarations.add(globalNode);
            this.declarations.addDeclaration(globalNode);
            int n = this.declarations.getIndex(globalNode);
            this.theModel.nodesWereInserted(this.declarations, new int[]{n});
            ++globCounter;
        }
        catch (Exception exception) {
            throw new PrismException("Global integer " + string + " has invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addBooleanGlobal() {
        try {
            Expression expression = Prism.parseSingleExpressionString("false");
            GlobalBoolNode globalBoolNode = new GlobalBoolNode("g" + globCounter, expression, true);
            this.editableDeclarations.add(globalBoolNode);
            this.declarations.addDeclaration(globalBoolNode);
            int n = this.declarations.getIndex(globalBoolNode);
            this.theModel.nodesWereInserted(this.declarations, new int[]{n});
            ++globCounter;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addBooleanGlobal(String string, String string2) throws PrismException {
        try {
            Expression expression = Prism.parseSingleExpressionString(string2);
            GlobalBoolNode globalBoolNode = new GlobalBoolNode(string, expression, true);
            this.editableDeclarations.add(globalBoolNode);
            this.declarations.addDeclaration(globalBoolNode);
            int n = this.declarations.getIndex(globalBoolNode);
            this.theModel.nodesWereInserted(this.declarations, new int[]{n});
            ++globCounter;
        }
        catch (Exception exception) {
            throw new PrismException("Global boolean " + string + " has invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addIntegerConstant() {
        try {
            Expression expression = Prism.parseSingleExpressionString("0");
            IntegerConstantNode integerConstantNode = new IntegerConstantNode("c" + consCount, expression, true);
            this.editableConstants.add(integerConstantNode);
            this.constants.addConstant(integerConstantNode);
            int n = this.constants.getIndex(integerConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addIntegerConstant(String string, String string2) throws PrismException {
        try {
            Expression expression = string2 == null ? null : Prism.parseSingleExpressionString(string2);
            IntegerConstantNode integerConstantNode = new IntegerConstantNode(string, expression, true);
            this.editableConstants.add(integerConstantNode);
            this.constants.addConstant(integerConstantNode);
            int n = this.constants.getIndex(integerConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            throw new PrismException("Constant integer " + string + " has invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addBooleanConstant() {
        try {
            Expression expression = Prism.parseSingleExpressionString("false");
            BoolConstantNode boolConstantNode = new BoolConstantNode("c" + consCount, expression, true);
            this.editableConstants.add(boolConstantNode);
            this.constants.addConstant(boolConstantNode);
            int n = this.constants.getIndex(boolConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addBooleanConstant(String string, String string2) throws PrismException {
        try {
            Expression expression = string2 == null ? null : Prism.parseSingleExpressionString(string2);
            BoolConstantNode boolConstantNode = new BoolConstantNode(string, expression, true);
            this.editableConstants.add(boolConstantNode);
            this.constants.addConstant(boolConstantNode);
            int n = this.constants.getIndex(boolConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            throw new PrismException("Constant boolean " + string + " has invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addDoubleConstant() {
        try {
            Expression expression = Prism.parseSingleExpressionString("0.0");
            DoubleConstantNode doubleConstantNode = new DoubleConstantNode("c" + consCount, expression, true);
            this.editableConstants.add(doubleConstantNode);
            this.constants.addConstant(doubleConstantNode);
            int n = this.constants.getIndex(doubleConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addDoubleConstant(String string, String string2) throws PrismException {
        try {
            Expression expression = string2 == null ? null : Prism.parseSingleExpressionString(string2);
            DoubleConstantNode doubleConstantNode = new DoubleConstantNode(string, expression, true);
            this.editableConstants.add(doubleConstantNode);
            this.constants.addConstant(doubleConstantNode);
            int n = this.constants.getIndex(doubleConstantNode);
            this.theModel.nodesWereInserted(this.constants, new int[]{n});
            ++consCount;
        }
        catch (Exception exception) {
            throw new PrismException("Constant double " + string + " has invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_removeModule(ModuleNode moduleNode) {
        int n = this.modules.getIndex(moduleNode);
        this.editableModules.remove(moduleNode);
        this.modules.remove(moduleNode);
        this.theModel.nodesWereRemoved(this.modules, new int[]{n}, new Object[]{moduleNode});
        this.handler.hasModified(true);
    }

    public void a_renameModule(ModuleNode moduleNode) {
        String string = JOptionPane.showInputDialog("New module name:", (Object)moduleNode.getName());
        if (string == null) {
            return;
        }
        try {
            Expression expression = Prism.parseSingleExpressionString(string);
            if (expression instanceof ExpressionIdent) {
                moduleNode.setName(string);
                this.theModel.nodeChanged(moduleNode);
                this.theModel.nodeStructureChanged(moduleNode);
            } else {
                this.handler.getGUIPlugin().error("Invalid module name");
            }
        }
        catch (PrismException prismException) {
            this.handler.getGUIPlugin().error("Invalid module name");
        }
        this.handler.hasModified(true);
    }

    public void a_renameDeclaration(DeclarationNode declarationNode) {
        String string = "";
        if (declarationNode instanceof BoolNode || declarationNode instanceof VarNode) {
            string = " variable";
        } else if (declarationNode instanceof GlobalNode || declarationNode instanceof GlobalBoolNode) {
            string = " global";
        } else if (declarationNode instanceof ConstantNode) {
            string = " constant";
        }
        String string2 = JOptionPane.showInputDialog("New" + string + " name:", (Object)declarationNode.getName());
        if (string2 == null) {
            return;
        }
        try {
            Expression expression = Prism.parseSingleExpressionString(string2);
            if (expression instanceof ExpressionIdent) {
                declarationNode.setName(string2);
                this.theModel.nodeChanged(declarationNode);
                this.theModel.nodeStructureChanged(declarationNode);
            } else {
                this.handler.getGUIPlugin().error("Invalid declaration name");
            }
        }
        catch (PrismException prismException) {
            this.handler.getGUIPlugin().error("Invalid module name");
        }
        this.handler.hasModified(true);
    }

    public void a_removeVariable(DeclarationNode declarationNode, ModuleNode moduleNode) {
        int n = moduleNode.getIndex(declarationNode);
        moduleNode.remove(declarationNode);
        this.theModel.nodesWereRemoved(moduleNode, new int[]{n}, new Object[]{declarationNode});
        this.handler.hasModified(true);
    }

    public void a_removeGlobal(DeclarationNode declarationNode) {
        int n = this.declarations.getIndex(declarationNode);
        this.editableDeclarations.remove(declarationNode);
        this.declarations.remove(declarationNode);
        this.theModel.nodesWereRemoved(this.declarations, new int[]{n}, new Object[]{declarationNode});
        this.handler.hasModified(true);
    }

    public void a_removeConstant(ConstantNode constantNode) {
        int n = this.constants.getIndex(constantNode);
        this.editableConstants.remove(constantNode);
        this.constants.remove(constantNode);
        this.theModel.nodesWereRemoved(this.constants, new int[]{n}, new Object[]{constantNode});
        this.handler.hasModified(true);
    }

    public void a_addLocalBoolean(ModuleNode moduleNode, BooleanVariable booleanVariable) throws PrismException {
        try {
            Expression expression = booleanVariable != null ? Prism.parseSingleExpressionString(booleanVariable.init) : Prism.parseSingleExpressionString("false");
            BoolNode boolNode = new BoolNode(booleanVariable.name, expression, true);
            moduleNode.add(boolNode);
            int n = moduleNode.getIndex(boolNode);
            this.theModel.nodesWereInserted(moduleNode, new int[]{n});
            ++varCount;
        }
        catch (Exception exception) {
            throw new PrismException("Local boolean " + booleanVariable.name + " has an invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addLocalBoolean(ModuleNode moduleNode) {
        try {
            Expression expression = Prism.parseSingleExpressionString("false");
            BoolNode boolNode = new BoolNode("v" + varCount, expression, true);
            moduleNode.add(boolNode);
            int n = moduleNode.getIndex(boolNode);
            this.theModel.nodesWereInserted(moduleNode, new int[]{n});
            ++varCount;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_addLocalInteger(ModuleNode moduleNode, IntegerVariable integerVariable) throws PrismException {
        try {
            Expression expression = integerVariable.init == null ? Prism.parseSingleExpressionString("0") : Prism.parseSingleExpressionString(integerVariable.init);
            Expression expression2 = Prism.parseSingleExpressionString(integerVariable.min);
            Expression expression3 = Prism.parseSingleExpressionString(integerVariable.max);
            VarNode varNode = new VarNode(integerVariable.name, expression, expression2, expression3, true);
            moduleNode.addVariable(varNode);
            int n = moduleNode.getIndex(varNode);
            this.theModel.nodesWereInserted(moduleNode, new int[]{n});
            ++varCount;
        }
        catch (Exception exception) {
            throw new PrismException("Local integer " + integerVariable.name + " has an invalid parameter");
        }
        this.handler.hasModified(true);
    }

    public void a_addLocalInteger(ModuleNode moduleNode) {
        try {
            Expression expression = Prism.parseSingleExpressionString("0");
            Expression expression2 = Prism.parseSingleExpressionString("0");
            Expression expression3 = Prism.parseSingleExpressionString("0");
            VarNode varNode = new VarNode("v" + varCount, expression, expression2, expression3, true);
            moduleNode.addVariable(varNode);
            int n = moduleNode.getIndex(varNode);
            this.theModel.nodesWereInserted(moduleNode, new int[]{n});
            ++varCount;
        }
        catch (Exception exception) {
            System.err.println("UNEXPECTED ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.handler.hasModified(true);
    }

    public void a_editExpression(ExpressionNode expressionNode) {
        String string = expressionNode.getValue() == null ? "?" : expressionNode.getValue().toString();
        String string2 = JOptionPane.showInputDialog("New Expression:", (Object)string);
        if (string2 == null) {
            return;
        }
        try {
            if (string2.equals("")) {
                expressionNode.setValue(null);
            } else {
                Expression expression = Prism.parseSingleExpressionString(string2);
                expressionNode.setValue(expression);
            }
            this.theModel.nodeChanged(expressionNode);
        }
        catch (Exception exception) {
            this.handler.getGUIPlugin().error("Syntax error in expression:\n" + string2);
        }
        this.handler.hasModified(true);
    }

    public void a_setModelType(ModelType modelType) {
        this.modelType.setModelType(modelType);
        this.handler.hasModified(true);
    }

    public int getParseSynchState() {
        return this.parseSynchState;
    }

    public void startParsing() {
        this.isParsing = true;
        if (this.parseThread != null) {
            this.parseThread.interrupt();
        }
        this.parseThread = new IconThread(0);
        this.parseThread.start();
    }

    public void stopParsing() {
        this.isParsing = false;
        if (this.parseThread != null) {
            this.parseThread.interrupt();
        }
        this.tree.repaint();
    }

    public void newTree() {
        this.newTree(false);
    }

    public void newTree(boolean bl) {
        this.editable = bl;
        this.root.removeAllChildren();
        this.parseSynchState = 2;
        this.root.setUserObject("Model: " + this.handler.getShortActiveFileName());
        this.modelType = new ModelTypeNode("<Unknown>", bl);
        this.root.add(this.modelType);
        if (bl) {
            this.modules = new ModuleCollectionNode();
            this.declarations = new DeclarationCollectionNode();
            this.constants = new ConstantCollectionNode();
            this.root.add(this.modules);
            this.root.add(this.declarations);
            this.root.add(this.constants);
            this.theModel.nodeStructureChanged(this.root);
        } else {
            this.modules = new ModuleCollectionNode();
            this.declarations = new DeclarationCollectionNode();
            this.constants = new ConstantCollectionNode();
            this.theModel.nodeStructureChanged(this.root);
        }
        this.editableModules = new ArrayList();
        this.editableDeclarations = new ArrayList();
        this.editableConstants = new ArrayList();
        modCounter = 1;
    }

    public void update(ModulesFile modulesFile) {
        int n = this.parseSynchState = modulesFile == null ? 2 : 0;
        if (this.editable) {
            this.updateEditable(modulesFile);
        } else {
            this.updateUnEditable(modulesFile);
        }
    }

    private void updateUnEditable(ModulesFile modulesFile) {
        String string = this.handler.getShortActiveFileName();
        if (!this.root.getUserObject().equals(string)) {
            this.root.setUserObject("Model: " + string);
            this.theModel.nodeChanged(this.root);
        }
        if (modulesFile != null) {
            ConstantNode constantNode;
            int n;
            int n2;
            int n3;
            int n4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Module module;
            int n5;
            String string2 = modulesFile.getTypeString();
            if (!this.modelType.getValue().equals(string2)) {
                this.modelType.setUserObject(string2);
                this.theModel.nodeChanged(this.modelType);
            }
            if (this.root.getIndex(this.modules) == -1 && modulesFile.getNumModules() > 0) {
                this.root.add(this.modules);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.modules)});
            } else if (this.root.getIndex(this.modules) != -1 && modulesFile.getNumModules() == 0) {
                int n6 = this.root.getIndex(this.modules);
                this.root.remove(this.modules);
                this.theModel.nodesWereRemoved(this.root, new int[]{n6}, new Object[]{this.modules});
            }
            ArrayList<Module> arrayList = new ArrayList<Module>();
            ArrayList<Module> arrayList2 = new ArrayList<Module>();
            for (n5 = 0; n5 < modulesFile.getNumModules(); ++n5) {
                module = modulesFile.getModule(n5);
                if (this.moduleIsMember(module)) {
                    arrayList.add(module);
                    continue;
                }
                arrayList2.add(module);
            }
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                int n7;
                DeclarationNode declarationNode;
                Object object7;
                int n8;
                module = (Module)arrayList.get(n5);
                int n9 = this.getModuleTreeIndexOf(module);
                ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(n9);
                object6 = new ArrayList();
                object5 = new ArrayList<Declaration>();
                for (n8 = 0; n8 < module.getNumDeclarations(); ++n8) {
                    object7 = module.getDeclaration(n8);
                    if (this.variableIsMember((Declaration)object7, moduleNode)) {
                        ((ArrayList)object6).add(object7);
                        continue;
                    }
                    ((ArrayList)object5).add(object7);
                }
                for (n8 = 0; n8 < ((ArrayList)object6).size(); ++n8) {
                    object7 = (Declaration)((ArrayList)object6).get(n8);
                    int n10 = this.getVarTreeIndexOf((Declaration)object7, moduleNode);
                    object4 = (DeclarationNode)moduleNode.getChildAt(n10);
                    if (object4 instanceof VarNode) {
                        declarationNode = (VarNode)object4;
                        ((VarNode)declarationNode).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object7).getStartOrDefault() : null);
                        if (((Declaration)object7).getDeclType() instanceof DeclarationInt) {
                            object3 = (DeclarationInt)((Declaration)object7).getDeclType();
                            ((VarNode)declarationNode).setMin(((DeclarationInt)object3).getLow());
                            ((VarNode)declarationNode).setMax(((DeclarationInt)object3).getHigh());
                        }
                        this.theModel.nodesChanged(declarationNode, new int[]{0, 1, 2});
                        continue;
                    }
                    if (!(object4 instanceof BoolNode)) continue;
                    declarationNode = (BoolNode)object4;
                    ((BoolNode)declarationNode).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object7).getStartOrDefault() : null);
                    this.theModel.nodesChanged(declarationNode, new int[]{0});
                }
                object2 = new int[((ArrayList)object5).size()];
                for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                    Declaration declaration = (Declaration)((ArrayList)object5).get(i);
                    if (declaration.getType() instanceof TypeInt) {
                        if (declaration.getDeclType() instanceof DeclarationInt) {
                            object4 = (DeclarationInt)declaration.getDeclType();
                            declarationNode = new VarNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, ((DeclarationInt)object4).getLow(), ((DeclarationInt)object4).getHigh(), false);
                            moduleNode.add(declarationNode);
                            object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                            continue;
                        }
                        object4 = new VarNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, null, null, false);
                        moduleNode.add((MutableTreeNode)object4);
                        object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                        continue;
                    }
                    if (declaration.getType() instanceof TypeBool) {
                        object4 = new BoolNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, false);
                        moduleNode.add((MutableTreeNode)object4);
                        object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                        continue;
                    }
                    if (!(declaration.getType() instanceof TypeClock)) continue;
                    object4 = new VarNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, Expression.Int(0), null, false);
                    moduleNode.add((MutableTreeNode)object4);
                    object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                }
                this.theModel.nodesWereInserted(moduleNode, (int[])object2);
                object7 = new ArrayList();
                for (int i = 0; i < moduleNode.getChildCount(); ++i) {
                    object4 = (DeclarationNode)moduleNode.getChildAt(i);
                    if (this.variableExists((DeclarationNode)object4, (ArrayList<Declaration>)object6, (ArrayList<Declaration>)object5)) continue;
                    ((ArrayList)object7).add(object4);
                }
                object = new Object[((ArrayList)object7).size()];
                object4 = new int[((ArrayList)object7).size()];
                for (n7 = 0; n7 < ((ArrayList)object7).size(); ++n7) {
                    object3 = (DeclarationNode)((ArrayList)object7).get(n7);
                    int n11 = moduleNode.getIndex((TreeNode)object3);
                    object[n7] = object3;
                    object4[n7] = n11;
                }
                for (n7 = ((ArrayList)object7).size() - 1; n7 >= 0; --n7) {
                    moduleNode.remove((int)object4[n7]);
                }
                this.theModel.nodesWereRemoved(moduleNode, (int[])object4, (Object[])object);
            }
            for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                int n12;
                module = (Module)arrayList2.get(n5);
                ModuleNode moduleNode = new ModuleNode(module.getName(), false);
                for (n12 = 0; n12 < module.getNumDeclarations(); ++n12) {
                    object6 = module.getDeclaration(n12);
                    if (((ASTElement)object6).getType() instanceof TypeInt) {
                        if (((Declaration)object6).getDeclType() instanceof DeclarationInt) {
                            object5 = (DeclarationInt)((Declaration)object6).getDeclType();
                            object2 = new VarNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, ((DeclarationInt)object5).getLow(), ((DeclarationInt)object5).getHigh(), false);
                            moduleNode.add((MutableTreeNode)object2);
                        } else {
                            object5 = new VarNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, null, null, false);
                            moduleNode.add((MutableTreeNode)object5);
                        }
                    } else if (((ASTElement)object6).getType() instanceof TypeBool) {
                        object5 = new BoolNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, false);
                        moduleNode.add((MutableTreeNode)object5);
                    }
                    if (!(((ASTElement)object6).getType() instanceof TypeClock)) continue;
                    object5 = new VarNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, Expression.Int(0), null, false);
                    moduleNode.add((MutableTreeNode)object5);
                }
                this.modules.addModule(moduleNode);
                n12 = this.modules.getIndex(moduleNode);
                this.theModel.nodesWereInserted(this.modules, new int[]{n12});
            }
            ArrayList<DefaultMutableTreeNode> arrayList3 = new ArrayList<DefaultMutableTreeNode>();
            for (int i = 0; i < this.modules.getChildCount(); ++i) {
                ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(i);
                if (this.moduleExists(moduleNode, arrayList, arrayList2)) continue;
                arrayList3.add(moduleNode);
            }
            Object[] objectArray = new Object[arrayList3.size()];
            int[] nArray = new int[arrayList3.size()];
            for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                object6 = (ModuleNode)arrayList3.get(n4);
                int n13 = this.modules.getIndex((TreeNode)object6);
                objectArray[n4] = object6;
                nArray[n4] = n13;
            }
            for (n4 = arrayList3.size() - 1; n4 >= 0; --n4) {
                this.modules.remove(nArray[n4]);
            }
            this.theModel.nodesWereRemoved(this.modules, nArray, objectArray);
            if (this.root.getIndex(this.declarations) == -1 && modulesFile.getNumGlobals() > 0) {
                this.root.add(this.declarations);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.declarations)});
            } else if (this.root.getIndex(this.declarations) != -1 && modulesFile.getNumGlobals() == 0) {
                n4 = this.root.getIndex(this.declarations);
                this.root.remove(this.declarations);
                this.theModel.nodesWereRemoved(this.root, new int[]{n4}, new Object[]{this.declarations});
            }
            ArrayList<Declaration> arrayList4 = new ArrayList<Declaration>();
            object6 = new ArrayList<Declaration>();
            for (n3 = 0; n3 < modulesFile.getNumGlobals(); ++n3) {
                object2 = modulesFile.getGlobal(n3);
                if (this.declarationIsMember((Declaration)object2)) {
                    arrayList4.add((Declaration)object2);
                    continue;
                }
                ((ArrayList)object6).add((Declaration)object2);
            }
            for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                object2 = (Declaration)arrayList4.get(n3);
                int n14 = this.getIndexOfDec((Declaration)object2);
                object = (DeclarationNode)this.declarations.getChildAt(n14);
                if (object instanceof GlobalNode) {
                    object4 = (GlobalNode)this.declarations.getChildAt(n14);
                    ((GlobalNode)object4).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object2).getStartOrDefault() : null);
                    if (((Declaration)object2).getDeclType() instanceof DeclarationInt) {
                        DeclarationInt declarationInt = (DeclarationInt)((Declaration)object2).getDeclType();
                        ((GlobalNode)object4).setMin(declarationInt.getLow());
                        ((GlobalNode)object4).setMax(declarationInt.getHigh());
                    }
                    this.theModel.nodesChanged((TreeNode)object4, new int[]{0, 1, 2});
                    continue;
                }
                if (!(object instanceof BoolNode)) continue;
                object4 = (BoolNode)object;
                ((BoolNode)object4).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object2).getStartOrDefault() : null);
                this.theModel.nodesChanged((TreeNode)object4, new int[]{0});
            }
            int[] nArray2 = new int[((ArrayList)object6).size()];
            for (n2 = 0; n2 < ((ArrayList)object6).size(); ++n2) {
                Declaration declaration = ((ArrayList)object6).get(n2);
                if (declaration.getType() instanceof TypeInt) {
                    if (declaration.getDeclType() instanceof DeclarationInt) {
                        object = (DeclarationInt)declaration.getDeclType();
                        object4 = new GlobalNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, ((DeclarationInt)object).getLow(), ((DeclarationInt)object).getHigh(), false);
                        this.declarations.add((MutableTreeNode)object4);
                    } else {
                        object = new GlobalNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, null, null, false);
                        this.declarations.add((MutableTreeNode)object);
                    }
                    nArray2[n2] = this.getIndexOfDec(declaration);
                    continue;
                }
                if (!(declaration.getType() instanceof TypeBool)) continue;
                object = new BoolNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, false);
                this.declarations.add((MutableTreeNode)object);
                nArray2[n2] = this.getIndexOfDec(declaration);
            }
            this.theModel.nodesWereInserted(this.declarations, nArray2);
            arrayList3 = new ArrayList();
            for (n2 = 0; n2 < this.declarations.getChildCount(); ++n2) {
                DeclarationNode declarationNode = (DeclarationNode)this.declarations.getChildAt(n2);
                if (this.declarationExists(declarationNode, arrayList4, (ArrayList<Declaration>)object6)) continue;
                arrayList3.add(declarationNode);
            }
            objectArray = new Object[arrayList3.size()];
            nArray = new int[arrayList3.size()];
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                DeclarationNode declarationNode = (DeclarationNode)arrayList3.get(n2);
                int n15 = this.declarations.getIndex(declarationNode);
                objectArray[n2] = declarationNode;
                nArray[n2] = n15;
            }
            for (n2 = arrayList3.size() - 1; n2 >= 0; --n2) {
                this.declarations.remove(nArray[n2]);
            }
            this.theModel.nodesWereRemoved(this.declarations, nArray, objectArray);
            ConstantList constantList = modulesFile.getConstantList();
            if (this.root.getIndex(this.constants) == -1 && constantList.size() > 0) {
                this.root.add(this.constants);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.constants)});
            } else if (this.root.getIndex(this.constants) != -1 && constantList.size() == 0) {
                int n16 = this.root.getIndex(this.constants);
                this.root.remove(this.constants);
                this.theModel.nodesWereRemoved(this.root, new int[]{n16}, new Object[]{this.constants});
            }
            ArrayList<ConstantNode> arrayList5 = new ArrayList<ConstantNode>();
            ArrayList<ConstantNode> arrayList6 = new ArrayList<ConstantNode>();
            for (n = 0; n < constantList.size(); ++n) {
                String string3 = constantList.getConstantName(n);
                object3 = constantList.getConstant(n);
                Type type = constantList.getConstantType(n);
                constantNode = type instanceof TypeBool ? new BoolConstantNode(string3, (Expression)object3, false) : (type instanceof TypeDouble ? new DoubleConstantNode(string3, (Expression)object3, false) : new IntegerConstantNode(string3, (Expression)object3, false));
                if (this.constantIsMember(constantNode)) {
                    arrayList5.add(constantNode);
                    continue;
                }
                arrayList6.add(constantNode);
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                ConstantNode constantNode2 = (ConstantNode)arrayList5.get(n);
                int n17 = this.getIndexOfCon(constantNode2);
                ConstantNode constantNode3 = (ConstantNode)this.constants.getChildAt(n17);
                if (constantNode3 instanceof IntegerConstantNode) {
                    constantNode = (IntegerConstantNode)constantNode3;
                    constantNode.setName(constantNode2.getName());
                    ((IntegerConstantNode)constantNode).setValue(constantNode2.getValue());
                    this.theModel.nodesChanged(constantNode, new int[]{0});
                    continue;
                }
                if (constantNode3 instanceof BoolConstantNode) {
                    constantNode = (BoolConstantNode)constantNode3;
                    constantNode.setName(constantNode2.getName());
                    ((BoolConstantNode)constantNode).setValue(constantNode2.getValue());
                    this.theModel.nodesChanged(constantNode, new int[]{0});
                    continue;
                }
                if (!(constantNode3 instanceof DoubleConstantNode)) continue;
                constantNode = (DoubleConstantNode)constantNode3;
                constantNode.setName(constantNode2.getName());
                ((DoubleConstantNode)constantNode).setValue(constantNode2.getValue());
                this.theModel.nodesChanged(constantNode, new int[]{0});
            }
            nArray2 = new int[arrayList6.size()];
            for (n = 0; n < arrayList6.size(); ++n) {
                ConstantNode constantNode4 = (ConstantNode)arrayList6.get(n);
                this.constants.add(constantNode4);
                nArray2[n] = this.getIndexOfCon(constantNode4);
            }
            this.theModel.nodesWereInserted(this.constants, nArray2);
            arrayList3 = new ArrayList();
            for (n = 0; n < this.constants.getChildCount(); ++n) {
                ConstantNode constantNode5 = (ConstantNode)this.constants.getChildAt(n);
                if (this.constantExists(constantNode5, arrayList5, arrayList6)) continue;
                arrayList3.add(constantNode5);
            }
            objectArray = new Object[arrayList3.size()];
            nArray = new int[arrayList3.size()];
            for (n = 0; n < arrayList3.size(); ++n) {
                ConstantNode constantNode6 = (ConstantNode)arrayList3.get(n);
                int n18 = this.constants.getIndex(constantNode6);
                objectArray[n] = constantNode6;
                nArray[n] = n18;
            }
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                this.constants.remove(nArray[n]);
            }
            this.theModel.nodesWereRemoved(this.constants, nArray, objectArray);
        } else {
            String string4 = "<Unknown>";
            if (!this.modelType.getValue().equals(string4)) {
                this.modelType.setUserObject(string4);
                this.theModel.nodeChanged(this.modelType);
            }
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    public boolean moduleExists(ModuleNode moduleNode, ArrayList<Module> arrayList, ArrayList<Module> arrayList2) {
        Module module;
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            module = arrayList.get(n);
            if (!moduleNode.getName().equals(module.getName())) continue;
            return true;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            module = arrayList2.get(n);
            if (!moduleNode.getName().equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean variableExists(DeclarationNode declarationNode, ArrayList<Declaration> arrayList, ArrayList<Declaration> arrayList2) {
        Declaration declaration;
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            declaration = arrayList.get(n);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            return true;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            declaration = arrayList2.get(n);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean declarationExists(DeclarationNode declarationNode, ArrayList<Declaration> arrayList, ArrayList<Declaration> arrayList2) {
        Declaration declaration;
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            declaration = arrayList.get(n);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            return true;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            declaration = arrayList2.get(n);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean constantExists(ConstantNode constantNode, ArrayList<ConstantNode> arrayList, ArrayList<ConstantNode> arrayList2) {
        ConstantNode constantNode2;
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            constantNode2 = arrayList.get(n);
            if (!constantNode2.equals(constantNode)) continue;
            return true;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            constantNode2 = arrayList2.get(n);
            if (!constantNode2.equals(constantNode)) continue;
            return true;
        }
        return false;
    }

    public boolean moduleIsMember(Module module) {
        boolean bl = false;
        for (int i = 0; i < this.modules.getChildCount(); ++i) {
            ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(i);
            if (!moduleNode.getName().equals(module.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean declarationIsMember(Declaration declaration) {
        boolean bl = false;
        for (int i = 0; i < this.declarations.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)this.declarations.getChildAt(i);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            if (declarationNode instanceof GlobalBoolNode && declaration.getType() instanceof TypeBool) {
                bl = true;
                break;
            }
            if (!(declarationNode instanceof GlobalNode) || !(declaration.getType() instanceof TypeInt)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean constantIsMember(ConstantNode constantNode) {
        boolean bl = false;
        for (int i = 0; i < this.constants.getChildCount(); ++i) {
            ConstantNode constantNode2 = (ConstantNode)this.constants.getChildAt(i);
            if (!constantNode2.equals(constantNode)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean variableIsMember(Declaration declaration, ModuleNode moduleNode) {
        boolean bl = false;
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            if (declarationNode instanceof BoolNode && declaration.getType() instanceof TypeBool) {
                bl = true;
                break;
            }
            if (!(declarationNode instanceof VarNode) || !(declaration.getType() instanceof TypeInt)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getVarTreeIndexOf(Declaration declaration, ModuleNode moduleNode) {
        int n = -1;
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getModuleTreeIndexOf(Module module) {
        int n = -1;
        for (int i = 0; i < this.modules.getChildCount(); ++i) {
            ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(i);
            if (!moduleNode.getName().equals(module.getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getIndexOfDec(Declaration declaration) {
        int n = -1;
        for (int i = 0; i < this.declarations.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)this.declarations.getChildAt(i);
            if (!declarationNode.getName().equals(declaration.getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getIndexOfCon(ConstantNode constantNode) {
        int n = -1;
        for (int i = 0; i < this.constants.getChildCount(); ++i) {
            ConstantNode constantNode2 = (ConstantNode)this.constants.getChildAt(i);
            if (!constantNode2.equals(constantNode)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void updateEditable(ModulesFile modulesFile) {
        String string = this.handler.getShortActiveFileName();
        if (!this.root.getUserObject().equals(string)) {
            this.root.setUserObject("Model: " + string);
            this.theModel.nodeChanged(this.root);
        }
        if (modulesFile != null) {
            ConstantNode constantNode;
            int n;
            int n2;
            int n3;
            int n4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Module module;
            int n5;
            if (!this.modelType.getValue().equals(modulesFile.getType().toString())) {
                this.modelType.setModelType(modulesFile.getModelType());
            }
            if (this.root.getIndex(this.modules) == -1 && modulesFile.getNumModules() > 0) {
                this.root.add(this.modules);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.modules)});
            }
            ArrayList<Module> arrayList = new ArrayList<Module>();
            ArrayList<Module> arrayList2 = new ArrayList<Module>();
            for (n5 = 0; n5 < modulesFile.getNumModules(); ++n5) {
                module = modulesFile.getModule(n5);
                if (this.moduleIsMember(module)) {
                    arrayList.add(module);
                    continue;
                }
                arrayList2.add(module);
            }
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                int n6;
                DeclarationNode declarationNode;
                Object object7;
                int n7;
                module = (Module)arrayList.get(n5);
                int n8 = this.getModuleTreeIndexOf(module);
                ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(n8);
                object6 = new ArrayList();
                object5 = new ArrayList<Declaration>();
                for (n7 = 0; n7 < module.getNumDeclarations(); ++n7) {
                    object7 = module.getDeclaration(n7);
                    if (this.variableIsMember((Declaration)object7, moduleNode)) {
                        ((ArrayList)object6).add(object7);
                        continue;
                    }
                    ((ArrayList)object5).add(object7);
                }
                for (n7 = 0; n7 < ((ArrayList)object6).size(); ++n7) {
                    object7 = (Declaration)((ArrayList)object6).get(n7);
                    int n9 = this.getVarTreeIndexOf((Declaration)object7, moduleNode);
                    object4 = (DeclarationNode)moduleNode.getChildAt(n9);
                    if (object4 instanceof VarNode) {
                        declarationNode = (VarNode)object4;
                        ((VarNode)declarationNode).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object7).getStartOrDefault() : null);
                        if (((Declaration)object7).getDeclType() instanceof DeclarationInt) {
                            object3 = (DeclarationInt)((Declaration)object7).getDeclType();
                            ((VarNode)declarationNode).setMin(((DeclarationInt)object3).getLow());
                            ((VarNode)declarationNode).setMax(((DeclarationInt)object3).getHigh());
                        }
                        this.theModel.nodesChanged(declarationNode, new int[]{0, 1, 2});
                        continue;
                    }
                    if (!(object4 instanceof BoolNode)) continue;
                    declarationNode = (BoolNode)object4;
                    ((BoolNode)declarationNode).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object7).getStartOrDefault() : null);
                    this.theModel.nodesChanged(declarationNode, new int[]{0});
                }
                object2 = new int[((ArrayList)object5).size()];
                for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                    Declaration declaration = (Declaration)((ArrayList)object5).get(i);
                    if (declaration.getType() instanceof TypeInt) {
                        if (declaration.getDeclType() instanceof DeclarationInt) {
                            object4 = (DeclarationInt)declaration.getDeclType();
                            declarationNode = new VarNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, ((DeclarationInt)object4).getLow(), ((DeclarationInt)object4).getHigh(), false);
                            moduleNode.add(declarationNode);
                            object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                            continue;
                        }
                        object4 = new VarNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, null, null, false);
                        moduleNode.add((MutableTreeNode)object4);
                        object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                        continue;
                    }
                    if (!(declaration.getType() instanceof TypeBool)) continue;
                    object4 = new BoolNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, false);
                    moduleNode.add((MutableTreeNode)object4);
                    object2[i] = this.getVarTreeIndexOf(declaration, moduleNode);
                }
                this.theModel.nodesWereInserted(moduleNode, (int[])object2);
                object7 = new ArrayList();
                for (int i = 0; i < moduleNode.getChildCount(); ++i) {
                    object4 = (DeclarationNode)moduleNode.getChildAt(i);
                    if (this.variableExists((DeclarationNode)object4, (ArrayList<Declaration>)object6, (ArrayList<Declaration>)object5)) continue;
                    ((ArrayList)object7).add(object4);
                }
                object = new Object[((ArrayList)object7).size()];
                object4 = new int[((ArrayList)object7).size()];
                for (n6 = 0; n6 < ((ArrayList)object7).size(); ++n6) {
                    object3 = (DeclarationNode)((ArrayList)object7).get(n6);
                    int n10 = moduleNode.getIndex((TreeNode)object3);
                    object[n6] = object3;
                    object4[n6] = n10;
                }
                for (n6 = ((ArrayList)object7).size() - 1; n6 >= 0; --n6) {
                    moduleNode.remove((int)object4[n6]);
                }
                this.theModel.nodesWereRemoved(moduleNode, (int[])object4, (Object[])object);
            }
            for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                int n11;
                module = (Module)arrayList2.get(n5);
                ModuleNode moduleNode = new ModuleNode(module.getName(), false);
                for (n11 = 0; n11 < module.getNumDeclarations(); ++n11) {
                    object6 = module.getDeclaration(n11);
                    if (((ASTElement)object6).getType() instanceof TypeInt) {
                        if (((Declaration)object6).getDeclType() instanceof DeclarationInt) {
                            object5 = (DeclarationInt)((Declaration)object6).getDeclType();
                            object2 = new VarNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, ((DeclarationInt)object5).getLow(), ((DeclarationInt)object5).getHigh(), false);
                            moduleNode.add((MutableTreeNode)object2);
                            continue;
                        }
                        object5 = new VarNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, null, null, false);
                        moduleNode.add((MutableTreeNode)object5);
                        continue;
                    }
                    if (!(((ASTElement)object6).getType() instanceof TypeBool)) continue;
                    object5 = new BoolNode(((Declaration)object6).getName(), modulesFile.getSystemDefn() == null ? ((Declaration)object6).getStartOrDefault() : null, false);
                    moduleNode.add((MutableTreeNode)object5);
                }
                this.modules.addModule(moduleNode);
                n11 = this.modules.getIndex(moduleNode);
                this.theModel.nodesWereInserted(this.modules, new int[]{n11});
            }
            ArrayList<DefaultMutableTreeNode> arrayList3 = new ArrayList<DefaultMutableTreeNode>();
            for (int i = 0; i < this.modules.getChildCount(); ++i) {
                ModuleNode moduleNode = (ModuleNode)this.modules.getChildAt(i);
                if (moduleNode.isEditable() || this.moduleExists(moduleNode, arrayList, arrayList2)) continue;
                arrayList3.add(moduleNode);
            }
            Object[] objectArray = new Object[arrayList3.size()];
            int[] nArray = new int[arrayList3.size()];
            for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                object6 = (ModuleNode)arrayList3.get(n4);
                int n12 = this.modules.getIndex((TreeNode)object6);
                objectArray[n4] = object6;
                nArray[n4] = n12;
            }
            for (n4 = arrayList3.size() - 1; n4 >= 0; --n4) {
                this.modules.remove(nArray[n4]);
            }
            this.theModel.nodesWereRemoved(this.modules, nArray, objectArray);
            if (this.root.getIndex(this.declarations) == -1 && modulesFile.getNumGlobals() > 0) {
                this.root.add(this.declarations);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.declarations)});
            }
            ArrayList<Declaration> arrayList4 = new ArrayList<Declaration>();
            object6 = new ArrayList<Declaration>();
            for (n3 = 0; n3 < modulesFile.getNumGlobals(); ++n3) {
                object2 = modulesFile.getGlobal(n3);
                if (this.declarationIsMember((Declaration)object2)) {
                    arrayList4.add((Declaration)object2);
                    continue;
                }
                ((ArrayList)object6).add((Declaration)object2);
            }
            for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                object2 = (Declaration)arrayList4.get(n3);
                int n13 = this.getIndexOfDec((Declaration)object2);
                object = (DeclarationNode)this.declarations.getChildAt(n13);
                if (object instanceof GlobalNode) {
                    object4 = (GlobalNode)this.declarations.getChildAt(n13);
                    ((GlobalNode)object4).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object2).getStartOrDefault() : null);
                    if (((Declaration)object2).getDeclType() instanceof DeclarationInt) {
                        DeclarationInt declarationInt = (DeclarationInt)((Declaration)object2).getDeclType();
                        ((GlobalNode)object4).setMin(declarationInt.getLow());
                        ((GlobalNode)object4).setMax(declarationInt.getHigh());
                    }
                    this.theModel.nodesChanged((TreeNode)object4, new int[]{0, 1, 2});
                    continue;
                }
                if (!(object instanceof GlobalBoolNode)) continue;
                object4 = (GlobalBoolNode)object;
                ((GlobalBoolNode)object4).setInitial(modulesFile.getSystemDefn() == null ? ((Declaration)object2).getStartOrDefault() : null);
                this.theModel.nodesChanged((TreeNode)object4, new int[]{0});
            }
            int[] nArray2 = new int[((ArrayList)object6).size()];
            for (n2 = 0; n2 < ((ArrayList)object6).size(); ++n2) {
                Declaration declaration = ((ArrayList)object6).get(n2);
                if (declaration.getType() instanceof TypeInt) {
                    if (declaration.getDeclType() instanceof DeclarationInt) {
                        object = (DeclarationInt)declaration.getDeclType();
                        object4 = new GlobalNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, ((DeclarationInt)object).getLow(), ((DeclarationInt)object).getHigh(), false);
                        this.declarations.add((MutableTreeNode)object4);
                    } else {
                        object = new GlobalNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, null, null, false);
                        this.declarations.add((MutableTreeNode)object);
                    }
                    nArray2[n2] = this.getIndexOfDec(declaration);
                    continue;
                }
                if (!(declaration.getType() instanceof TypeBool)) continue;
                object = new GlobalBoolNode(declaration.getName(), modulesFile.getSystemDefn() == null ? declaration.getStartOrDefault() : null, false);
                this.declarations.add((MutableTreeNode)object);
                nArray2[n2] = this.getIndexOfDec(declaration);
            }
            this.theModel.nodesWereInserted(this.declarations, nArray2);
            arrayList3 = new ArrayList();
            for (n2 = 0; n2 < this.declarations.getChildCount(); ++n2) {
                DeclarationNode declarationNode = (DeclarationNode)this.declarations.getChildAt(n2);
                if (declarationNode.isEditable() || this.declarationExists(declarationNode, arrayList4, (ArrayList<Declaration>)object6)) continue;
                arrayList3.add(declarationNode);
            }
            objectArray = new Object[arrayList3.size()];
            nArray = new int[arrayList3.size()];
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                DeclarationNode declarationNode = (DeclarationNode)arrayList3.get(n2);
                int n14 = this.declarations.getIndex(declarationNode);
                objectArray[n2] = declarationNode;
                nArray[n2] = n14;
            }
            for (n2 = arrayList3.size() - 1; n2 >= 0; --n2) {
                this.declarations.remove(nArray[n2]);
            }
            this.theModel.nodesWereRemoved(this.declarations, nArray, objectArray);
            ConstantList constantList = modulesFile.getConstantList();
            if (this.root.getIndex(this.constants) == -1 && constantList.size() > 0) {
                this.root.add(this.constants);
                this.theModel.nodesWereInserted(this.root, new int[]{this.root.getIndex(this.constants)});
            }
            ArrayList<ConstantNode> arrayList5 = new ArrayList<ConstantNode>();
            ArrayList<ConstantNode> arrayList6 = new ArrayList<ConstantNode>();
            for (n = 0; n < constantList.size(); ++n) {
                String string2 = constantList.getConstantName(n);
                object3 = constantList.getConstant(n);
                Type type = constantList.getConstantType(n);
                constantNode = type instanceof TypeBool ? new BoolConstantNode(string2, (Expression)object3, false) : (type instanceof TypeDouble ? new DoubleConstantNode(string2, (Expression)object3, false) : new IntegerConstantNode(string2, (Expression)object3, false));
                if (this.constantIsMember(constantNode)) {
                    arrayList5.add(constantNode);
                    continue;
                }
                arrayList6.add(constantNode);
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                ConstantNode constantNode2 = (ConstantNode)arrayList5.get(n);
                int n15 = this.getIndexOfCon(constantNode2);
                ConstantNode constantNode3 = (ConstantNode)this.constants.getChildAt(n15);
                if (constantNode3 instanceof IntegerConstantNode) {
                    constantNode = (IntegerConstantNode)constantNode3;
                    constantNode.setName(constantNode2.getName());
                    ((IntegerConstantNode)constantNode).setValue(constantNode2.getValue());
                    this.theModel.nodesChanged(constantNode, new int[]{0});
                    continue;
                }
                if (constantNode3 instanceof BoolConstantNode) {
                    constantNode = (BoolConstantNode)constantNode3;
                    constantNode.setName(constantNode2.getName());
                    ((BoolConstantNode)constantNode).setValue(constantNode2.getValue());
                    this.theModel.nodesChanged(constantNode, new int[]{0});
                    continue;
                }
                if (!(constantNode3 instanceof DoubleConstantNode)) continue;
                constantNode = (DoubleConstantNode)constantNode3;
                constantNode.setName(constantNode2.getName());
                ((DoubleConstantNode)constantNode).setValue(constantNode2.getValue());
                this.theModel.nodesChanged(constantNode, new int[]{0});
            }
            nArray2 = new int[arrayList6.size()];
            for (n = 0; n < arrayList6.size(); ++n) {
                ConstantNode constantNode4 = (ConstantNode)arrayList6.get(n);
                this.constants.add(constantNode4);
                nArray2[n] = this.getIndexOfCon(constantNode4);
            }
            this.theModel.nodesWereInserted(this.constants, nArray2);
            arrayList3 = new ArrayList();
            for (n = 0; n < this.constants.getChildCount(); ++n) {
                ConstantNode constantNode5 = (ConstantNode)this.constants.getChildAt(n);
                if (constantNode5.isEditable() || this.constantExists(constantNode5, arrayList5, arrayList6)) continue;
                arrayList3.add(constantNode5);
            }
            objectArray = new Object[arrayList3.size()];
            nArray = new int[arrayList3.size()];
            for (n = 0; n < arrayList3.size(); ++n) {
                ConstantNode constantNode6 = (ConstantNode)arrayList3.get(n);
                int n16 = this.constants.getIndex(constantNode6);
                objectArray[n] = constantNode6;
                nArray[n] = n16;
            }
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                this.constants.remove(nArray[n]);
            }
            this.theModel.nodesWereRemoved(this.constants, nArray, objectArray);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    public void lastParseFailed() {
        this.parseSynchState = 1;
        this.tree.repaint();
    }

    public void makeNotUpToDate() {
        this.parseSynchState = 2;
        this.tree.repaint();
    }

    private void initComponents() {
        this.tree = new JTree(this.theModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                TreePath treePath = GUIMultiModelTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    if (GUIMultiModelTree.this.parseSynchState == 1) {
                        return GUIMultiModelTree.this.handler.getParseErrorMessage();
                    }
                    if (GUIMultiModelTree.this.parseSynchState == 0) {
                        return "Model parsed successfully";
                    }
                    if (!GUIMultiModelTree.this.handler.isAutoParse()) {
                        return "Auto-parsing disabled";
                    }
                    return "Model not parsed";
                }
                return string;
            }

            @Override
            public boolean isPathEditable(TreePath treePath) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof ValueNode) {
                    ValueNode valueNode = (ValueNode)object;
                    return valueNode.isEditable();
                }
                return false;
            }
        };
        PrismNodeRenderer prismNodeRenderer = new PrismNodeRenderer();
        this.tree.setCellRenderer(prismNodeRenderer);
        this.tree.setEditable(true);
        this.tree.setCellEditor(new ModelTreeCellEditor(this.tree, prismNodeRenderer));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.tree);
        this.add((Component)jScrollPane, "Center");
        this.moduleCollectionPopup = new JPopupMenu();
        this.addModule = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addModule();
            }
        };
        this.addModule.putValue("LongDescription", "Adds an editable module to the tree");
        this.addModule.putValue("MnemonicKey", new Integer(65));
        this.addModule.putValue("Name", "Add Module");
        this.moduleCollectionPopup.add(this.addModule);
        this.declarationCollectionPopup = new JPopupMenu();
        this.addIntegerGlobal = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addIntegerGlobal();
            }
        };
        this.addIntegerGlobal.putValue("Name", "Add Global Integer");
        this.addBooleanGlobal = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addBooleanGlobal();
            }
        };
        this.addBooleanGlobal.putValue("Name", "Add Global Boolean");
        this.declarationCollectionPopup.add(this.addIntegerGlobal);
        this.declarationCollectionPopup.add(this.addBooleanGlobal);
        this.constantsCollectionPopup = new JPopupMenu();
        this.addIntegerConstant = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addIntegerConstant();
            }
        };
        this.addIntegerConstant.putValue("Name", "Add Integer Constant");
        this.addBooleanConstant = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addBooleanConstant();
            }
        };
        this.addBooleanConstant.putValue("Name", "Add Boolean Constant");
        this.addDoubleConstant = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMultiModelTree.this.a_addDoubleConstant();
            }
        };
        this.addDoubleConstant.putValue("Name", "Add Double Constant");
        this.constantsCollectionPopup.add(this.addIntegerConstant);
        this.constantsCollectionPopup.add(this.addBooleanConstant);
        this.constantsCollectionPopup.add(this.addDoubleConstant);
        this.modulePopup = new JPopupMenu();
        this.removeModule = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null && GUIMultiModelTree.this.lastPopNode instanceof ModuleNode) {
                    GUIMultiModelTree.this.a_removeModule((ModuleNode)GUIMultiModelTree.this.lastPopNode);
                    GUIMultiModelTree.this.lastPopNode = null;
                }
            }
        };
        this.removeModule.putValue("Name", "Remove");
        this.addBoolean = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null && GUIMultiModelTree.this.lastPopNode instanceof ModuleNode) {
                    GUIMultiModelTree.this.a_addLocalBoolean((ModuleNode)GUIMultiModelTree.this.lastPopNode);
                    GUIMultiModelTree.this.lastPopNode = null;
                }
            }
        };
        this.addBoolean.putValue("Name", "Add Boolean Variable");
        this.addInteger = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null && GUIMultiModelTree.this.lastPopNode instanceof ModuleNode) {
                    GUIMultiModelTree.this.a_addLocalInteger((ModuleNode)GUIMultiModelTree.this.lastPopNode);
                    GUIMultiModelTree.this.lastPopNode = null;
                }
            }
        };
        this.addInteger.putValue("Name", "Add Integer Variable");
        this.renameModule = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null && GUIMultiModelTree.this.lastPopNode instanceof ModuleNode) {
                    GUIMultiModelTree.this.a_renameModule((ModuleNode)GUIMultiModelTree.this.lastPopNode);
                    GUIMultiModelTree.this.lastPopNode = null;
                }
            }
        };
        this.renameModule.putValue("Name", "Rename");
        this.modulePopup.add(this.renameModule);
        this.modulePopup.add(this.removeModule);
        this.modulePopup.add(this.addInteger);
        this.modulePopup.add(this.addBoolean);
        this.declarationPopup = new JPopupMenu();
        this.removeDeclaration = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null) {
                    if (GUIMultiModelTree.this.lastPopNode instanceof BoolNode || GUIMultiModelTree.this.lastPopNode instanceof VarNode) {
                        ModuleNode moduleNode = GUIMultiModelTree.this.whichModule((DeclarationNode)GUIMultiModelTree.this.lastPopNode);
                        if (moduleNode != null) {
                            GUIMultiModelTree.this.a_removeVariable((DeclarationNode)GUIMultiModelTree.this.lastPopNode, moduleNode);
                        }
                    } else if (GUIMultiModelTree.this.lastPopNode instanceof GlobalNode || GUIMultiModelTree.this.lastPopNode instanceof GlobalBoolNode) {
                        GUIMultiModelTree.this.a_removeGlobal((DeclarationNode)GUIMultiModelTree.this.lastPopNode);
                    } else if (GUIMultiModelTree.this.lastPopNode instanceof ConstantNode) {
                        GUIMultiModelTree.this.a_removeConstant((ConstantNode)GUIMultiModelTree.this.lastPopNode);
                    }
                }
            }
        };
        this.removeDeclaration.putValue("Name", "Remove");
        this.declarationPopup.add(this.removeDeclaration);
        this.renameDeclaration = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null) {
                    GUIMultiModelTree.this.a_renameDeclaration((DeclarationNode)GUIMultiModelTree.this.lastPopNode);
                }
            }
        };
        this.renameDeclaration.putValue("Name", "Rename");
        this.declarationPopup.add(this.renameDeclaration);
        this.expressionPopup = new JPopupMenu();
        this.editExpression = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.lastPopNode != null) {
                    GUIMultiModelTree.this.a_editExpression((ExpressionNode)GUIMultiModelTree.this.lastPopNode);
                }
            }
        };
        this.editExpression.putValue("Name", "Edit");
        this.expressionPopup.add(this.editExpression);
        this.modelTypePopup = new JPopupMenu();
        this.non = new JRadioButton("Non-deterministic (mdp)");
        this.pro = new JRadioButton("Probabilistic (dtmc)");
        this.sto = new JRadioButton("Stochastic (ctmc)");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.non);
        buttonGroup.add(this.pro);
        buttonGroup.add(this.sto);
        this.non.setSelected(true);
        this.modelTypePopup.add(this.non);
        this.modelTypePopup.add(this.pro);
        this.modelTypePopup.add(this.sto);
        this.non.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.non.isSelected()) {
                    GUIMultiModelTree.this.a_setModelType(ModelType.MDP);
                }
                GUIMultiModelTree.this.modelTypePopup.setVisible(false);
            }
        });
        this.pro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.pro.isSelected()) {
                    GUIMultiModelTree.this.a_setModelType(ModelType.DTMC);
                }
                GUIMultiModelTree.this.modelTypePopup.setVisible(false);
            }
        });
        this.sto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIMultiModelTree.this.sto.isSelected()) {
                    GUIMultiModelTree.this.a_setModelType(ModelType.CTMC);
                }
                GUIMultiModelTree.this.modelTypePopup.setVisible(false);
            }
        });
    }

    public ModuleNode whichModule(DeclarationNode declarationNode) {
        for (int i = 0; i < this.editableModules.size(); ++i) {
            ModuleNode moduleNode = this.editableModules.get(i);
            int n = moduleNode.getIndex(declarationNode);
            if (n <= -1) continue;
            return moduleNode;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.lastPopNode = null;
            if (this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.root.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.root.getPath()));
            }
            if (this.editable && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.modelType.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.modelType.getPath()));
                this.modelTypePopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.modules != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.modules.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.modules.getPath()));
                this.moduleCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.declarations != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.declarations.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.declarations.getPath()));
                this.declarationCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.constants != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.constants.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.constants.getPath()));
                this.constantsCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode;
                int n;
                TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                for (n = 0; n < this.editableModules.size(); ++n) {
                    defaultMutableTreeNode = this.editableModules.get(n);
                    if (new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) {
                        this.tree.setSelectionPath(treePath);
                        if (((ModuleNode)defaultMutableTreeNode).isEditable()) {
                            this.modulePopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                            this.lastPopNode = defaultMutableTreeNode;
                        }
                        return;
                    }
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        DeclarationNode declarationNode = (DeclarationNode)defaultMutableTreeNode.getChildAt(i);
                        if (!new TreePath(declarationNode.getPath()).equals(treePath)) continue;
                        this.tree.setSelectionPath(treePath);
                        if (declarationNode.isEditable()) {
                            this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                            this.lastPopNode = declarationNode;
                        }
                        return;
                    }
                }
                for (n = 0; n < this.editableDeclarations.size(); ++n) {
                    defaultMutableTreeNode = this.editableDeclarations.get(n);
                    if (!new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) continue;
                    this.tree.setSelectionPath(treePath);
                    if (((DeclarationNode)defaultMutableTreeNode).isEditable()) {
                        this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                        this.lastPopNode = defaultMutableTreeNode;
                    }
                    return;
                }
                for (n = 0; n < this.editableConstants.size(); ++n) {
                    defaultMutableTreeNode = this.editableConstants.get(n);
                    if (!new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) continue;
                    this.tree.setSelectionPath(treePath);
                    if (((DeclarationNode)defaultMutableTreeNode).isEditable()) {
                        this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                        this.lastPopNode = defaultMutableTreeNode;
                    }
                    return;
                }
                if (this.tree.getSelectionPath() != null && (treeNode = (TreeNode)this.tree.getSelectionPath().getLastPathComponent()) instanceof ExpressionNode && ((ExpressionNode)(defaultMutableTreeNode = (ExpressionNode)treeNode)).isEditable()) {
                    this.expressionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                    this.lastPopNode = defaultMutableTreeNode;
                }
            }
        } else {
            TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            for (int i = 0; i < this.editableModules.size(); ++i) {
                ModuleNode moduleNode = this.editableModules.get(i);
                if (!new TreePath(moduleNode.getPath()).equals(treePath)) continue;
                this.tree.setSelectionPath(treePath);
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.lastPopNode = null;
            if (this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.root.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.root.getPath()));
            }
            if (this.editable && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.modelType.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.modelType.getPath()));
                this.modelTypePopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.modules != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.modules.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.modules.getPath()));
                this.moduleCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.declarations != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.declarations.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.declarations.getPath()));
                this.declarationCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.editable && this.constants != null && this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).equals(new TreePath(this.constants.getPath()))) {
                this.tree.setSelectionPath(new TreePath(this.constants.getPath()));
                this.constantsCollectionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else {
                TreeNode treeNode;
                DefaultMutableTreeNode defaultMutableTreeNode;
                int n;
                TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                for (n = 0; n < this.editableModules.size(); ++n) {
                    defaultMutableTreeNode = this.editableModules.get(n);
                    if (new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) {
                        this.tree.setSelectionPath(treePath);
                        if (((ModuleNode)defaultMutableTreeNode).isEditable()) {
                            this.modulePopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                            this.lastPopNode = defaultMutableTreeNode;
                        }
                        return;
                    }
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        DeclarationNode declarationNode = (DeclarationNode)defaultMutableTreeNode.getChildAt(i);
                        if (!new TreePath(declarationNode.getPath()).equals(treePath)) continue;
                        this.tree.setSelectionPath(treePath);
                        if (declarationNode.isEditable()) {
                            this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                            this.lastPopNode = declarationNode;
                        }
                        return;
                    }
                }
                for (n = 0; n < this.editableDeclarations.size(); ++n) {
                    defaultMutableTreeNode = this.editableDeclarations.get(n);
                    if (!new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) continue;
                    this.tree.setSelectionPath(treePath);
                    if (((DeclarationNode)defaultMutableTreeNode).isEditable()) {
                        this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                        this.lastPopNode = defaultMutableTreeNode;
                    }
                    return;
                }
                for (n = 0; n < this.editableConstants.size(); ++n) {
                    defaultMutableTreeNode = this.editableConstants.get(n);
                    if (!new TreePath(defaultMutableTreeNode.getPath()).equals(treePath)) continue;
                    this.tree.setSelectionPath(treePath);
                    if (((DeclarationNode)defaultMutableTreeNode).isEditable()) {
                        this.declarationPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                        this.lastPopNode = defaultMutableTreeNode;
                    }
                    return;
                }
                if (this.tree.getSelectionPath() != null && (treeNode = (TreeNode)this.tree.getSelectionPath().getLastPathComponent()) instanceof ExpressionNode && ((ExpressionNode)(defaultMutableTreeNode = (ExpressionNode)treeNode)).isEditable()) {
                    this.expressionPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
                    this.lastPopNode = defaultMutableTreeNode;
                }
            }
        } else {
            TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            for (int i = 0; i < this.editableModules.size(); ++i) {
                ModuleNode moduleNode = this.editableModules.get(i);
                if (!new TreePath(moduleNode.getPath()).equals(treePath)) continue;
                this.tree.setSelectionPath(treePath);
                return;
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.handler.getParseErrorMessage();
    }

    public ModelType getModelType() {
        return ModelType.valueOf(this.modelType.getUserObject().toString());
    }

    public ArrayList<String> getEditableConstantNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableConstants.size(); ++i) {
            DeclarationNode declarationNode = this.editableConstants.get(i);
            arrayList.add(declarationNode.getName());
        }
        return arrayList;
    }

    public ArrayList<String> getEditableConstantValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableConstants.size(); ++i) {
            ConstantNode constantNode = this.editableConstants.get(i);
            if (constantNode.getValue() != null) {
                if (!constantNode.getValue().toString().equals("")) {
                    arrayList.add(constantNode.getValue().toString());
                    continue;
                }
                arrayList.add(null);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<Type> getEditableConstantTypes() {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < this.editableConstants.size(); ++i) {
            ConstantNode constantNode = this.editableConstants.get(i);
            if (constantNode instanceof BoolConstantNode) {
                arrayList.add(TypeBool.getInstance());
                continue;
            }
            if (constantNode instanceof IntegerConstantNode) {
                arrayList.add(TypeInt.getInstance());
                continue;
            }
            if (constantNode instanceof DoubleConstantNode) {
                arrayList.add(TypeDouble.getInstance());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getEditableGlobalNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableDeclarations.size(); ++i) {
            DeclarationNode declarationNode = this.editableDeclarations.get(i);
            arrayList.add(declarationNode.getName());
        }
        return arrayList;
    }

    public ArrayList<String> getEditableGlobalMins() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableDeclarations.size(); ++i) {
            DeclarationNode declarationNode = this.editableDeclarations.get(i);
            if (declarationNode instanceof GlobalNode) {
                GlobalNode globalNode = (GlobalNode)declarationNode;
                arrayList.add(globalNode.getMin().toString());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getEditableGlobalMaxs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableDeclarations.size(); ++i) {
            DeclarationNode declarationNode = this.editableDeclarations.get(i);
            if (declarationNode instanceof GlobalNode) {
                GlobalNode globalNode = (GlobalNode)declarationNode;
                arrayList.add(globalNode.getMax().toString());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getEditableGlobalInits() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.editableDeclarations.size(); ++i) {
            DeclarationNode declarationNode;
            DeclarationNode declarationNode2 = this.editableDeclarations.get(i);
            if (declarationNode2 instanceof GlobalNode) {
                declarationNode = (GlobalNode)declarationNode2;
                arrayList.add(((GlobalNode)declarationNode).getInitial().toString());
                continue;
            }
            if (!(declarationNode2 instanceof GlobalBoolNode)) continue;
            declarationNode = (GlobalBoolNode)declarationNode2;
            arrayList.add(((GlobalBoolNode)declarationNode).getInitial().toString());
        }
        return arrayList;
    }

    public ArrayList<Type> getEditableGlobalTypes() {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < this.editableDeclarations.size(); ++i) {
            DeclarationNode declarationNode = this.editableDeclarations.get(i);
            if (declarationNode instanceof GlobalBoolNode) {
                arrayList.add(TypeBool.getInstance());
                continue;
            }
            if (declarationNode instanceof GlobalNode) {
                arrayList.add(TypeInt.getInstance());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getVariableNames(ModuleNode moduleNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (declarationNode instanceof StateVarNode) continue;
            arrayList.add(declarationNode.getName());
        }
        return arrayList;
    }

    public ArrayList<Type> getVariableTypes(ModuleNode moduleNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (declarationNode instanceof StateVarNode) continue;
            if (declarationNode instanceof BoolNode) {
                arrayList.add(TypeBool.getInstance());
                continue;
            }
            if (declarationNode instanceof VarNode) {
                arrayList.add(TypeInt.getInstance());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getVariableMins(ModuleNode moduleNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (declarationNode instanceof StateVarNode) continue;
            if (declarationNode instanceof BoolNode) {
                arrayList.add(null);
                continue;
            }
            if (declarationNode instanceof VarNode) {
                VarNode varNode = (VarNode)declarationNode;
                String string = varNode.getMin().toString();
                arrayList.add(string);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getVariableMaxs(ModuleNode moduleNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            DeclarationNode declarationNode = (DeclarationNode)moduleNode.getChildAt(i);
            if (declarationNode instanceof StateVarNode) continue;
            if (declarationNode instanceof BoolNode) {
                arrayList.add(null);
                continue;
            }
            if (declarationNode instanceof VarNode) {
                VarNode varNode = (VarNode)declarationNode;
                String string = varNode.getMax().toString();
                arrayList.add(string);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public ArrayList<String> getVariableInits(ModuleNode moduleNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            String string;
            DeclarationNode declarationNode;
            DeclarationNode declarationNode2 = (DeclarationNode)moduleNode.getChildAt(i);
            if (declarationNode2 instanceof StateVarNode) continue;
            if (declarationNode2 instanceof BoolNode) {
                declarationNode = (BoolNode)declarationNode2;
                string = ((BoolNode)declarationNode).getInitial().toString();
                arrayList.add(string);
                continue;
            }
            if (declarationNode2 instanceof VarNode) {
                declarationNode = (VarNode)declarationNode2;
                string = ((VarNode)declarationNode).getInitial().toString();
                arrayList.add(string);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public void updateTooltip() {
        this.tree.setToolTipText(this.handler.getParseErrorMessage());
    }

    private static String removeCarriages(String string) {
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            object = c != '\n' ? (String)object + c : (String)object + " ";
        }
        return object;
    }

    public class BooleanVariable
    extends Variable {
        public String init;

        public BooleanVariable(String string, String string2) {
            this.init = "false";
            this.init = string2;
            this.name = string;
        }

        public BooleanVariable(String string) {
            this.init = "false";
            this.name = string;
        }
    }

    public class IntegerVariable
    extends Variable {
        public String min;
        public String max;
        public String init;

        public IntegerVariable(String string, String string2, String string3, String string4) {
            this.init = "0";
            this.name = string;
            this.min = string2;
            this.max = string3;
            this.init = string4;
        }

        public IntegerVariable(String string, String string2, String string3) {
            this.init = "0";
            this.name = string;
            this.min = string2;
            this.max = string3;
        }
    }

    public class Variable {
        public String name;
    }

    class IconThread
    extends Thread {
        int index;
        ImageIcon[] images;
        boolean canContinue = false;

        public IconThread(int n) {
            this.index = n;
            this.images = new ImageIcon[8];
            this.images[0] = GUIPrism.getIconFromImage("smallClockAnim1.png");
            this.images[1] = GUIPrism.getIconFromImage("smallClockAnim2.png");
            this.images[2] = GUIPrism.getIconFromImage("smallClockAnim3.png");
            this.images[3] = GUIPrism.getIconFromImage("smallClockAnim4.png");
            this.images[4] = GUIPrism.getIconFromImage("smallClockAnim5.png");
            this.images[5] = GUIPrism.getIconFromImage("smallClockAnim6.png");
            this.images[6] = GUIPrism.getIconFromImage("smallClockAnim7.png");
            this.images[7] = GUIPrism.getIconFromImage("smallClockAnim8.png");
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (!IconThread.interrupted() && this.index > -1) {
                    ++n;
                    GUIMultiModelTree.this.animIcon = this.images[n %= 8];
                    GUIMultiModelTree.this.tree.repaint();
                    IconThread.sleep(150L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.canContinue = true;
        }
    }

    class ModelTreeCellEditor
    extends DefaultTreeCellEditor {
        ModelTypeEditor modelTypeEditor;
        ExpressionEditor expressionEditor;
        ModuleEditor moduleEditor;
        DeclarationEditor declarationEditor;
        String[] types;

        public ModelTreeCellEditor(JTree jTree, PrismNodeRenderer prismNodeRenderer) {
            super(jTree, prismNodeRenderer);
            this.types = new String[]{"Non-deterministic", "Probabilistic", "Stochastic"};
            this.modelTypeEditor = new ModelTypeEditor(this.types);
            this.expressionEditor = new ExpressionEditor();
            this.moduleEditor = new ModuleEditor();
            this.declarationEditor = new DeclarationEditor();
            this.realEditor = this.declarationEditor;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (object instanceof ExpressionNode) {
                this.realEditor = this.expressionEditor;
            } else if (object instanceof ModelTypeNode) {
                this.realEditor = this.modelTypeEditor;
                this.modelTypeEditor.setSelectedType(((ModelTypeNode)object).getValue());
            } else if (object instanceof ModuleNode) {
                this.realEditor = this.moduleEditor;
                this.moduleEditor.setText(((ModuleNode)object).getName());
            } else if (object instanceof DeclarationNode) {
                this.realEditor = this.declarationEditor;
                this.declarationEditor.setText(((DeclarationNode)object).getName());
            }
            return super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.modelTypeEditor.addCellEditorListener(cellEditorListener);
            this.expressionEditor.addCellEditorListener(cellEditorListener);
            this.moduleEditor.addCellEditorListener(cellEditorListener);
            this.declarationEditor.addCellEditorListener(cellEditorListener);
            super.addCellEditorListener(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.modelTypeEditor.removeCellEditorListener(cellEditorListener);
            this.expressionEditor.removeCellEditorListener(cellEditorListener);
            this.moduleEditor.removeCellEditorListener(cellEditorListener);
            this.declarationEditor.removeCellEditorListener(cellEditorListener);
            super.removeCellEditorListener(cellEditorListener);
        }
    }

    class PrismNodeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon VAR = GUIPrism.getIconFromImage("smallVariable.png");
        ImageIcon MOD = GUIPrism.getIconFromImage("smallModule.png");
        ImageIcon VAL = GUIPrism.getIconFromImage("smallValue.png");
        ImageIcon GOOD = GUIPrism.getIconFromImage("smallTick.png");
        ImageIcon BAD = GUIPrism.getIconFromImage("smallCross.png");
        ImageIcon OUT_OF_SYNCH = GUIPrism.getIconFromImage("smallFilePrism.png");
        ImageIcon CLOCK = GUIPrism.getIconFromImage("smallClockAnim1.png");

        PrismNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            PrismTreeNode prismTreeNode = (PrismTreeNode)object;
            if (prismTreeNode == GUIMultiModelTree.this.root) {
                if (GUIMultiModelTree.this.isParsing) {
                    this.setIcon(GUIMultiModelTree.this.animIcon);
                } else {
                    switch (GUIMultiModelTree.this.parseSynchState) {
                        case 0: {
                            this.setIcon(this.GOOD);
                            break;
                        }
                        case 1: {
                            this.setIcon(this.BAD);
                            break;
                        }
                        case 2: {
                            this.setIcon(this.OUT_OF_SYNCH);
                        }
                    }
                }
            } else if (prismTreeNode instanceof VarNode) {
                this.setIcon(this.VAR);
            } else if (prismTreeNode instanceof BoolNode) {
                this.setIcon(this.VAR);
            } else if (prismTreeNode instanceof DeclarationNode) {
                this.setIcon(this.VAR);
            } else if (prismTreeNode instanceof ModuleNode) {
                this.setIcon(this.MOD);
            } else if (prismTreeNode instanceof ValueNode) {
                this.setIcon(this.VAL);
            } else if (prismTreeNode instanceof ModuleCollectionNode || prismTreeNode instanceof DeclarationCollectionNode || prismTreeNode instanceof ConstantCollectionNode) {
                this.setIcon(this.getDefaultClosedIcon());
            }
            if (prismTreeNode.isEditable()) {
                this.setForeground(Color.blue);
            } else {
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    class ModelTypeEditor
    extends JComboBox
    implements TreeCellEditor {
        String value;
        Vector<CellEditorListener> listeners;
        Object[] list;

        public ModelTypeEditor(Object[] objectArray) {
            super(objectArray);
            this.listeners = new Vector();
            this.setFont(GUIMultiModelTree.this.tree.getFont());
            this.setBackground(Color.white);
            this.setForeground(Color.blue);
            this.list = objectArray;
            this.setEditable(false);
            this.value = objectArray[0].toString();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ModelTypeEditor.this.stopCellEditing()) {
                        ModelTypeEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        public void setSelectedType(String string) {
            for (int i = 0; i < this.list.length; ++i) {
                String string2 = (String)this.list[i];
                if (!string2.equals(string)) continue;
                super.setSelectedIndex(i);
                break;
            }
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.value = (String)this.getSelectedItem();
                if (this.value == null) {
                    this.value = (String)this.getItemAt(0);
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            MouseEvent mouseEvent;
            return (eventObject == null || eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown()) && (mouseEvent = (MouseEvent)eventObject).getClickCount() >= 2;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            MouseEvent mouseEvent;
            return eventObject == null | (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown()) && (mouseEvent = (MouseEvent)eventObject).getClickCount() >= 2;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.removeElement(cellEditorListener);
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.elementAt(i).editingStopped(changeEvent);
                }
            }
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this;
        }
    }

    class ModelTypeNode
    extends StringNode {
        public ModelTypeNode(String string, boolean bl) {
            super("Type: ", string, bl);
        }

        public void setModelType(ModelType modelType) {
            this.setUserObject(modelType.toString());
            switch (modelType) {
                case MDP: {
                    GUIMultiModelTree.this.non.setSelected(true);
                    break;
                }
                case DTMC: {
                    GUIMultiModelTree.this.pro.setSelected(true);
                    break;
                }
                case CTMC: {
                    GUIMultiModelTree.this.sto.setSelected(true);
                }
            }
            GUIMultiModelTree.this.theModel.nodeChanged(this);
        }

        @Override
        public void setUserObject(Object object) {
            super.setUserObject(object);
        }
    }

    class ExpressionEditor
    extends JTextField
    implements TreeCellEditor {
        Expression exp;
        Vector<CellEditorListener> listeners;
        private static final int minWidth = 64;

        public ExpressionEditor() {
            super("");
            this.listeners = new Vector();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExpressionEditor.this.stopCellEditing()) {
                        ExpressionEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public void cancelCellEditing() {
            this.setText("");
        }

        @Override
        public boolean stopCellEditing() {
            String string = this.getText();
            try {
                Expression expression;
                this.exp = expression = Prism.parseSingleExpressionString(string);
            }
            catch (Exception exception) {
                GUIMultiModelTree.this.handler.getGUIPlugin().message("Error: Syntax Error");
                return true;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.exp;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            MouseEvent mouseEvent;
            return eventObject == null | (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown()) && (mouseEvent = (MouseEvent)eventObject).getClickCount() >= 2;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            MouseEvent mouseEvent;
            return eventObject == null | (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown()) && (mouseEvent = (MouseEvent)eventObject).getClickCount() >= 2;
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.elementAt(i).editingStopped(changeEvent);
                }
            }
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            rectangle.width = Math.max(64, rectangle.width);
            super.setBounds(rectangle);
            GUIMultiModelTree.this.tree.repaint();
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            n3 = Math.max(64, n3);
            super.setBounds(n, n2, n3, n4);
            GUIMultiModelTree.this.tree.repaint();
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this;
        }
    }

    class ExpressionNode
    extends ValueNode {
        private boolean editable;

        public ExpressionNode(String string, Expression expression, boolean bl) {
            super(string, expression);
            this.editable = bl;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        public Expression getValue() {
            return (Expression)this.getUserObject();
        }

        public void setValue(Expression expression) {
            super.setUserObject(expression);
        }
    }

    class StringNode
    extends ValueNode {
        private boolean editable;

        public StringNode(String string, String string2, boolean bl) {
            super(string, string2);
            this.editable = bl;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        public String getValue() {
            return (String)this.getUserObject();
        }
    }

    abstract class ValueNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        private String tag;

        public ValueNode(String string, Object object) {
            super(object);
            this.tag = string;
        }

        @Override
        public String toString() {
            if (this.getUserObject() == null) {
                return this.tag + "?";
            }
            return this.tag + this.getUserObject().toString();
        }

        @Override
        public abstract boolean isEditable();

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void setUserObject(Object object) {
            super.setUserObject(object);
        }
    }

    class BoolConstantNode
    extends ConstantNode {
        public BoolConstantNode(String string, Expression expression, boolean bl) {
            super(5, string, bl);
            super.add(new ExpressionNode("value: ", expression, bl));
        }

        @Override
        public void setValue(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        @Override
        public Expression getValue() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = "const bool " + this.getName();
            string = this.getValue() != null ? string + " = " + this.getValue() + ";" : string + ";";
            return string;
        }
    }

    class DoubleConstantNode
    extends ConstantNode {
        public DoubleConstantNode(String string, Expression expression, boolean bl) {
            super(6, string, bl);
            super.add(new ExpressionNode("value: ", expression, bl));
        }

        @Override
        public void setValue(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        @Override
        public Expression getValue() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = "const double " + this.getName();
            string = this.getValue() != null ? string + " = " + this.getValue() + ";" : string + ";";
            return string;
        }
    }

    class IntegerConstantNode
    extends ConstantNode {
        public IntegerConstantNode(String string, Expression expression, boolean bl) {
            super(4, string, bl);
            super.add(new ExpressionNode("value: ", expression, bl));
        }

        @Override
        public void setValue(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        @Override
        public Expression getValue() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = "const int " + this.getName();
            string = this.getValue() != null ? string + " = " + this.getValue() + ";" : string + ";";
            return string;
        }
    }

    abstract class ConstantNode
    extends DeclarationNode {
        public ConstantNode(int n, String string, boolean bl) {
            super(n, string, bl);
        }

        public abstract void setValue(Expression var1);

        public abstract Expression getValue();

        public boolean equals(Object object) {
            if (object instanceof ConstantNode) {
                ConstantNode constantNode = (ConstantNode)object;
                return constantNode.getName().equals(this.getName());
            }
            return false;
        }

        @Override
        public abstract String getParseText();
    }

    class GlobalBoolNode
    extends DeclarationNode {
        public GlobalBoolNode(String string, Expression expression, boolean bl) {
            super(3, string, bl);
            super.add(new ExpressionNode("init: ", expression, bl));
        }

        public void setInitial(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        public Expression getInitial() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = "global " + this.getName() + " : bool init " + this.getInitial() + ";";
            return string;
        }
    }

    class GlobalNode
    extends DeclarationNode {
        public GlobalNode(String string, Expression expression, Expression expression2, Expression expression3, boolean bl) {
            super(2, string, bl);
            super.add(new ExpressionNode("min: ", expression2, bl));
            super.add(new ExpressionNode("max: ", expression3, bl));
            super.add(new ExpressionNode("init: ", expression, bl));
        }

        public void setInitial(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(2);
            expressionNode.setUserObject(expression);
        }

        public Expression getInitial() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(2);
            return expressionNode.getValue();
        }

        public void setMin(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        public Expression getMin() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        public void setMax(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(1);
            expressionNode.setUserObject(expression);
        }

        public Expression getMax() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(1);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = "global " + this.getName() + " : [" + this.getMin() + ".." + this.getMax() + "] init " + this.getInitial() + ";";
            return string;
        }
    }

    class BoolNode
    extends DeclarationNode {
        public BoolNode(String string, Expression expression, boolean bl) {
            super(1, string, bl);
            super.add(new ExpressionNode("init: ", expression, bl));
        }

        public void setInitial(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
        }

        public Expression getInitial() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = this.getName() + " : bool init " + this.getInitial() + ";";
            return string;
        }
    }

    public class StateVarNode
    extends VarNode {
        ModuleNode mn;

        public StateVarNode(ModuleNode moduleNode) {
            super("statevariable", "0", "0", "0", false);
            this.mn = moduleNode;
        }

        @Override
        public String getName() {
            return this.mn.getName() + "_s";
        }
    }

    class VarNode
    extends DeclarationNode {
        public VarNode(String string, Expression expression, Expression expression2, Expression expression3, boolean bl) {
            super(0, string, bl);
            super.add(new ExpressionNode("min: ", expression2, bl));
            super.add(new ExpressionNode("max: ", expression3, bl));
            super.add(new ExpressionNode("init: ", expression, bl));
        }

        public VarNode(String string, String string2, String string3, String string4, boolean bl) {
            super(0, string, bl);
            try {
                Expression expression = Prism.parseSingleExpressionString(string2);
                Expression expression2 = Prism.parseSingleExpressionString(string3);
                Expression expression3 = Prism.parseSingleExpressionString(string4);
                super.add(new ExpressionNode("min: ", expression2, bl));
                super.add(new ExpressionNode("max: ", expression3, bl));
                super.add(new ExpressionNode("init: ", expression, bl));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setInitial(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(2);
            expressionNode.setUserObject(expression);
            GUIMultiModelTree.this.theModel.nodeChanged(this.getChildAt(2));
        }

        public Expression getInitial() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(2);
            return expressionNode.getValue();
        }

        public void setMin(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            expressionNode.setUserObject(expression);
            GUIMultiModelTree.this.theModel.nodeChanged(this.getChildAt(0));
        }

        public Expression getMin() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(0);
            return expressionNode.getValue();
        }

        public void setMax(Expression expression) {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(1);
            expressionNode.setUserObject(expression);
            GUIMultiModelTree.this.theModel.nodeChanged(this.getChildAt(1));
        }

        public Expression getMax() {
            ExpressionNode expressionNode = (ExpressionNode)this.getChildAt(1);
            return expressionNode.getValue();
        }

        @Override
        public String getParseText() {
            String string = this.getName() + " : [" + this.getMin() + ".." + this.getMax() + "] init " + this.getInitial() + ";";
            return string;
        }
    }

    class DeclarationEditor
    extends JTextField
    implements TreeCellEditor {
        String name;
        Vector<CellEditorListener> listeners;
        private static final int minWidth = 64;

        public DeclarationEditor() {
            super("");
            this.listeners = new Vector();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DeclarationEditor.this.stopCellEditing()) {
                        DeclarationEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public void cancelCellEditing() {
            this.setText("");
        }

        @Override
        public boolean stopCellEditing() {
            Expression expression;
            String string = this.getText();
            try {
                expression = Prism.parseSingleExpressionString(string);
            }
            catch (PrismException prismException) {
                return false;
            }
            if (expression instanceof ExpressionIdent) {
                this.name = string;
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.name;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return eventObject == null | (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown());
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.elementAt(i).editingStopped(changeEvent);
                }
            }
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            rectangle.width = Math.max(64, rectangle.width);
            super.setBounds(rectangle);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            n3 = Math.max(64, n3);
            super.setBounds(n, n2, n3, n4);
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this;
        }
    }

    abstract class DeclarationNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        private boolean editable;
        private int type;

        public DeclarationNode(int n, String string, boolean bl) {
            super(string, true);
            this.editable = bl;
            this.type = n;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        public String getName() {
            return (String)this.getUserObject();
        }

        public void setName(String string) {
            this.setUserObject(string);
        }

        @Override
        public String toString() {
            String string = this.getName();
            switch (this.type) {
                case 0: {
                    return string;
                }
                case 2: 
                case 4: {
                    return string + " : int";
                }
                case 1: 
                case 3: 
                case 5: {
                    return string + " : bool";
                }
                case 6: {
                    return string + " : double";
                }
            }
            return "";
        }

        public abstract String getParseText();
    }

    class ModuleEditor
    extends JTextField
    implements TreeCellEditor {
        String name;
        Vector<CellEditorListener> listeners;
        private static final int minWidth = 64;

        public ModuleEditor() {
            super("");
            this.listeners = new Vector();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ModuleEditor.this.stopCellEditing()) {
                        ModuleEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public void cancelCellEditing() {
            this.setText("");
        }

        @Override
        public boolean stopCellEditing() {
            Expression expression;
            String string = this.getText();
            try {
                expression = Prism.parseSingleExpressionString(string);
            }
            catch (PrismException prismException) {
                return false;
            }
            if (expression instanceof ExpressionIdent) {
                this.name = string;
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.name;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return eventObject == null | (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).isMetaDown());
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public void removeCellEditroLIstner(CellEditorListener cellEditorListener) {
            this.listeners.removeElement(cellEditorListener);
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.elementAt(i).editingStopped(changeEvent);
                }
            }
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            rectangle.width = Math.max(64, rectangle.width);
            super.setBounds(rectangle);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            n3 = Math.max(64, n3);
            super.setBounds(n, n2, n3, n4);
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.removeElement(cellEditorListener);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this;
        }
    }

    public class ModuleNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        private boolean editable;

        public ModuleNode(String string, boolean bl) {
            super(string, true);
            this.editable = bl;
        }

        public void addVariable(VarNode varNode) {
            this.add(varNode);
        }

        public void removeVariable(VarNode varNode) {
            this.remove(varNode);
        }

        public void setName(String string) {
            this.setUserObject(string);
        }

        public String getName() {
            return (String)this.getUserObject();
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }

        public void childrenChanged() {
            GUIMultiModelTree.this.theModel.nodeChanged(this);
            GUIMultiModelTree.this.theModel.nodeStructureChanged(this);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    class ConstantCollectionNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        public ConstantCollectionNode() {
            super("Constants", true);
        }

        public void addConstant(ConstantNode constantNode) {
            this.add(constantNode);
        }

        public void removeConstant(ConstantNode constantNode) {
            this.remove(constantNode);
        }

        @Override
        public boolean isEditable() {
            return GUIMultiModelTree.this.editable;
        }
    }

    class DeclarationCollectionNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        public DeclarationCollectionNode() {
            super("Global Variables", true);
            super.setAllowsChildren(true);
        }

        public void addDeclaration(DeclarationNode declarationNode) {
            this.add(declarationNode);
        }

        public void removeDeclaration(DeclarationNode declarationNode) {
            this.remove(declarationNode);
        }

        @Override
        public boolean isEditable() {
            return GUIMultiModelTree.this.editable;
        }
    }

    class ModuleCollectionNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        public ModuleCollectionNode() {
            super("Modules", true);
            super.setAllowsChildren(true);
        }

        public void addModule(ModuleNode moduleNode) {
            this.add(moduleNode);
        }

        public void removeModule(ModuleNode moduleNode) {
            this.remove(moduleNode);
        }

        @Override
        public boolean isEditable() {
            return GUIMultiModelTree.this.editable;
        }
    }

    class ModelRootNode
    extends DefaultMutableTreeNode
    implements PrismTreeNode {
        public ModelRootNode() {
            super("", true);
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }

    static interface PrismTreeNode {
        public boolean isEditable();
    }
}

