/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.type.Type;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.RewardGenerator;
import simulator.TransitionList;
import simulator.Updater;

public class ModulesFileModelGenerator
implements ModelGenerator,
RewardGenerator {
    protected PrismComponent parent;
    private ModulesFile originalModulesFile;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private Values mfConstants;
    private VarList varList;
    private LabelList labelList;
    private List<String> labelNames;
    private State exploreState;
    protected Updater updater;
    protected TransitionList transitionList;
    protected boolean transitionListBuilt;

    public ModulesFileModelGenerator(ModulesFile modulesFile) throws PrismException {
        this(modulesFile, null);
    }

    public ModulesFileModelGenerator(ModulesFile modulesFile, PrismComponent prismComponent) throws PrismException {
        this.parent = prismComponent;
        if (modulesFile.getModelType() == ModelType.PTA) {
            throw new PrismException("PTAs are not currently supported");
        }
        if (modulesFile.getSystemDefn() != null) {
            throw new PrismException("The system...endsystem construct is not currently supported");
        }
        this.modulesFile = modulesFile;
        this.originalModulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.mfConstants = modulesFile.getConstantValues();
        if (this.mfConstants != null) {
            this.initialise();
        }
    }

    private void initialise() throws PrismLangException {
        this.modulesFile = (ModulesFile)this.modulesFile.deepCopy().replaceConstants(this.mfConstants).simplify();
        this.varList = this.modulesFile.createVarList();
        this.labelList = this.modulesFile.getLabelList();
        this.labelNames = this.labelList.getLabelNames();
        this.updater = new Updater(this.modulesFile, this.varList, this.parent);
        this.transitionList = new TransitionList();
        this.transitionListBuilt = false;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public void setSomeUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(values, false);
    }

    @Override
    public void setSomeUndefinedConstants(Values values, boolean bl) throws PrismException {
        this.modulesFile = (ModulesFile)this.originalModulesFile.deepCopy();
        this.modulesFile.setSomeUndefinedConstants(values, bl);
        this.mfConstants = this.modulesFile.getConstantValues();
        this.initialise();
    }

    @Override
    public Values getConstantValues() {
        return this.mfConstants;
    }

    @Override
    public boolean containsUnboundedVariables() {
        return this.modulesFile.containsUnboundedVariables();
    }

    @Override
    public int getNumVars() {
        return this.modulesFile.getNumVars();
    }

    @Override
    public List<String> getVarNames() {
        return this.modulesFile.getVarNames();
    }

    @Override
    public List<Type> getVarTypes() {
        return this.modulesFile.getVarTypes();
    }

    @Override
    public int getNumLabels() {
        return this.labelList.size();
    }

    @Override
    public String getActionStringDescription() {
        return "Module/[action]";
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelNames;
    }

    @Override
    public String getLabelName(int n) throws PrismException {
        return this.labelList.getLabelName(n);
    }

    @Override
    public int getLabelIndex(String string) {
        return this.labelList.getLabelIndex(string);
    }

    @Override
    public VarList createVarList() {
        return this.varList;
    }

    @Override
    public boolean hasSingleInitialState() throws PrismException {
        return this.modulesFile.getInitialStates() == null;
    }

    @Override
    public State getInitialState() throws PrismException {
        if (this.modulesFile.getInitialStates() == null) {
            return this.modulesFile.getDefaultInitialState();
        }
        return this.getInitialStates().get(0);
    }

    @Override
    public List<State> getInitialStates() throws PrismException {
        ArrayList<State> arrayList = new ArrayList<State>();
        if (this.modulesFile.getInitialStates() == null) {
            State state = this.modulesFile.getDefaultInitialState();
            arrayList.add(state);
        } else {
            Expression expression = this.modulesFile.getInitialStates();
            List<State> list = this.varList.getAllStates();
            for (State state : list) {
                if (!expression.evaluateBoolean(this.modulesFile.getConstantValues(), state)) continue;
                arrayList.add(state);
            }
        }
        return arrayList;
    }

    @Override
    public void exploreState(State state) throws PrismException {
        this.exploreState = state;
        this.transitionListBuilt = false;
    }

    @Override
    public int getNumChoices() throws PrismException {
        return this.getTransitionList().getNumChoices();
    }

    @Override
    public int getNumTransitions() throws PrismException {
        return this.getTransitionList().getNumTransitions();
    }

    @Override
    public int getNumTransitions(int n) throws PrismException {
        return this.getTransitionList().getChoice(n).size();
    }

    @Override
    public int getChoiceIndexOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceIndexOfTransition(n);
    }

    @Override
    public int getChoiceOffsetOfTransition(int n) throws PrismException {
        return this.getTransitionList().getChoiceOffsetOfTransition(n);
    }

    @Override
    public int getTotalIndexOfTransition(int n, int n2) throws PrismException {
        return this.getTransitionList().getTotalIndexOfTransition(n, n2);
    }

    @Override
    public Object getTransitionAction(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return n3 < 0 ? null : this.modulesFile.getSynch(n3 - 1);
    }

    @Override
    public String getTransitionActionString(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n3 = transitionList.getTransitionModuleOrActionIndex(transitionList.getTotalIndexOfTransition(n, n2));
        return this.getDescriptionForModuleOrActionIndex(n3);
    }

    @Override
    public Object getChoiceAction(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return n2 < 0 ? null : this.modulesFile.getSynch(n2 - 1);
    }

    @Override
    public String getChoiceActionString(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        int n2 = transitionList.getChoiceModuleOrActionIndex(n);
        return this.getDescriptionForModuleOrActionIndex(n2);
    }

    private String getDescriptionForModuleOrActionIndex(int n) {
        if (n < 0) {
            return this.modulesFile.getModuleName(-n - 1);
        }
        if (n > 0) {
            return "[" + this.modulesFile.getSynchs().get(n - 1) + "]";
        }
        return "?";
    }

    @Override
    public double getTransitionProbability(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getChoice(n).getProbability(n2);
    }

    @Override
    public double getChoiceProbabilitySum(int n) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getChoice(n).getProbabilitySum();
    }

    @Override
    public double getProbabilitySum() throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getProbabilitySum();
    }

    @Override
    public String getTransitionUpdateString(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateString(transitionList.getTotalIndexOfTransition(n, n2), this.exploreState);
    }

    @Override
    public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        TransitionList transitionList = this.getTransitionList();
        return transitionList.getTransitionUpdateStringFull(transitionList.getTotalIndexOfTransition(n, n2));
    }

    @Override
    public State computeTransitionTarget(int n, int n2) throws PrismException {
        return this.getTransitionList().getChoice(n).computeTarget(n2, this.exploreState);
    }

    @Override
    public boolean isLabelTrue(int n) throws PrismException {
        Expression expression = this.labelList.getLabel(n);
        return expression.evaluateBoolean(this.exploreState);
    }

    @Override
    public List<String> getRewardStructNames() {
        return this.modulesFile.getRewardStructNames();
    }

    @Override
    public boolean rewardStructHasStateRewards(int n) {
        return this.modulesFile.rewardStructHasStateRewards(n);
    }

    @Override
    public boolean rewardStructHasTransitionRewards(int n) {
        return this.modulesFile.rewardStructHasTransitionRewards(n);
    }

    @Override
    public double getStateReward(int n, State state) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            Expression expression;
            if (rewardStruct.getRewardStructItem(i).isTransitionReward() || !(expression = rewardStruct.getStates(i)).evaluateBoolean(this.modulesFile.getConstantValues(), state)) continue;
            double d2 = rewardStruct.getReward(i).evaluateDouble(this.modulesFile.getConstantValues(), state);
            if (Double.isNaN(d2)) {
                throw new PrismLangException("Reward structure evaluates to NaN at state " + state, rewardStruct.getReward(i));
            }
            d += d2;
        }
        return d;
    }

    @Override
    public double getStateActionReward(int n, State state, Object object) throws PrismException {
        RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n);
        int n2 = rewardStruct.getNumItems();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!rewardStruct.getRewardStructItem(i).isTransitionReward()) continue;
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            if (!(object == null ? string.isEmpty() : object.equals(string)) || !expression.evaluateBoolean(this.modulesFile.getConstantValues(), state)) continue;
            double d2 = rewardStruct.getReward(i).evaluateDouble(this.modulesFile.getConstantValues(), state);
            if (Double.isNaN(d2)) {
                throw new PrismLangException("Reward structure evaluates to NaN at state " + state, rewardStruct.getReward(i));
            }
            d += d2;
        }
        return d;
    }

    private TransitionList getTransitionList() throws PrismException {
        if (!this.transitionListBuilt) {
            this.updater.calculateTransitions(this.exploreState, this.transitionList);
            this.transitionListBuilt = true;
        }
        return this.transitionList;
    }
}

