/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.BadLocationException;
import settings.Setting;
import settings.SettingEditor;

public class MultipleLineStringEditor
implements SettingEditor,
KeyListener,
CaretListener,
FocusListener {
    private JTextArea area = new JTextArea();
    private Font font;
    private JTable lastTable = null;
    private int tableRow = -1;
    private int tableCol = -1;
    private boolean valueGot = true;
    private boolean multiDifferent = false;

    public MultipleLineStringEditor() {
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.font = new Font("monospaced", 0, 12);
        this.area.addCaretListener(this);
        this.area.addKeyListener(this);
        this.area.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.multiDifferent && this.area.getText().equals("")) {
            this.valueGot = true;
            this.multiDifferent = false;
            return "$%^&*NOTCHANGED*&^%$";
        }
        this.valueGot = true;
        return this.area.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        Object object2;
        this.area.setMargin(new Insets(0, 2, 4, 2));
        if (bl) {
            jTable.getSelectionModel().setSelectionInterval(-1, -1);
            this.area.setForeground(jTable.getSelectionForeground());
            this.area.setBackground(jTable.getSelectionBackground());
        } else {
            this.area.setForeground(jTable.getForeground());
            this.area.setBackground(jTable.getBackground());
        }
        this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.multiDifferent = false;
        if (object instanceof String) {
            object2 = (String)object;
            this.area.setText((String)object2);
            this.area.setCaretColor(Color.black);
            this.area.setFont(this.font);
        } else if (object instanceof ArrayList && ((ArrayList)(object2 = (ArrayList)object)).size() > 0) {
            String string = null;
            boolean bl2 = true;
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                if (!(((ArrayList)object2).get(i) instanceof String)) continue;
                String string2 = (String)((ArrayList)object2).get(i);
                if (string != null) {
                    if (!string2.equals(string)) {
                        bl2 = false;
                        break;
                    }
                    string = string2;
                    continue;
                }
                string = string2;
            }
            if (bl2) {
                this.area.setText(string);
                this.area.setFont(this.font);
            } else {
                this.area.setText("");
                this.multiDifferent = true;
            }
        }
        int n3 = (int)this.area.getPreferredSize().getHeight();
        if (++n3 != jTable.getRowHeight(n)) {
            jTable.setRowHeight(n, n3);
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        this.valueGot = false;
        return this.area;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        try {
            int n = this.area.getLineStartOffset(this.area.getLineCount() - 1);
            int n2 = this.area.getLineEndOffset(0);
            int n3 = this.area.getCaretPosition();
            if (keyEvent.getKeyCode() == 38) {
                if (n3 < n2 && this.lastTable != null) {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                    int n4 = this.tableRow - 1;
                    if (n4 < 0) {
                        n4 = this.lastTable.getRowCount() - 1;
                    }
                    this.lastTable.getSelectionModel().setSelectionInterval(n4, n4);
                }
            } else if (keyEvent.getKeyCode() == 40) {
                if (n3 >= n || this.area.getText().length() == 0) {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                    int n5 = (this.tableRow + 1) % this.lastTable.getRowCount();
                    this.lastTable.getSelectionModel().setSelectionInterval(n5, n5);
                }
            } else if (keyEvent.getKeyCode() == 10) {
                if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                    keyEvent.setModifiers(0);
                } else {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                    int n6 = (this.tableRow + 1) % this.lastTable.getRowCount();
                    this.lastTable.getSelectionModel().setSelectionInterval(n6, n6);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.lastTable == null) {
            return;
        }
        this.area.getCaret().setVisible(true);
        int n = (int)this.area.getPreferredSize().getHeight();
        if (++n != this.lastTable.getRowHeight(this.tableRow)) {
            this.lastTable.setRowHeight(this.tableRow, n);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.valueGot && this.lastTable != null) {
            if (this.multiDifferent && this.area.getText().equals("")) {
                this.valueGot = true;
                this.multiDifferent = false;
            } else {
                this.valueGot = true;
                this.lastTable.setValueAt(this.area.getText(), this.tableRow, this.tableCol);
            }
            if (this.lastTable.getCellEditor() != null) {
                this.lastTable.removeEditor();
            }
        }
    }
}

