/*
 * Decompiled with CFR 0.152.
 */
package pta.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import prism.PrismLangException;
import pta.Constraint;
import pta.Edge;
import pta.PTA;
import pta.Transition;
import pta.parser.PTAParserConstants;
import pta.parser.PTAParserTokenManager;
import pta.parser.ParseException;
import pta.parser.SimpleCharStream;
import pta.parser.Token;

public class PTAParser
implements PTAParserConstants {
    private static boolean jj_initialized_once = false;
    public static PTAParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    public static void main(String[] stringArray) {
        PTAParser pTAParser = null;
        InputStream inputStream = null;
        String string = null;
        try {
            pTAParser = new PTAParser();
            inputStream = stringArray.length > 0 ? new FileInputStream(stringArray[0]) : System.in;
            string = stringArray.length > 0 ? "file " + stringArray[0] : "stdin";
            System.out.println("Reading from " + string + "...\n");
            PTA pTA = pTAParser.parsePTA(inputStream);
            System.out.print(pTA);
        }
        catch (PrismLangException prismLangException) {
            System.out.println("Error in " + string + ": " + prismLangException.getMessage() + ".");
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            System.exit(1);
        }
    }

    public PTAParser() {
        this(System.in);
    }

    public PTA parsePTA(InputStream inputStream) throws PrismLangException {
        astPTA astPTA2 = null;
        PTAParser.ReInit(inputStream);
        try {
            astPTA2 = PTAParser.PTA();
        }
        catch (ParseException parseException) {
            throw new PrismLangException(parseException.getMessage());
        }
        return astPTA2.createDataStructures();
    }

    public static final astPTA PTA() throws ParseException {
        astPTA astPTA2 = new astPTA();
        block3: while (true) {
            switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    PTAParser.jj_la1[0] = jj_gen;
                    break block3;
                }
            }
            PTAParser.Location(astPTA2);
        }
        PTAParser.jj_consume_token(0);
        return astPTA2;
    }

    public static final void Location(astPTA astPTA2) throws ParseException {
        PTAParser.jj_consume_token(21);
        switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 3: {
                PTAParser.jj_consume_token(3);
                break;
            }
            default: {
                PTAParser.jj_la1[1] = jj_gen;
            }
        }
        PTAParser.jj_consume_token(4);
        String string = PTAParser.Identifier();
        astPTA2.addLocation(string);
        PTAParser.jj_consume_token(14);
        LinkedHashSet<Constraint> linkedHashSet = PTAParser.ConstraintList(astPTA2);
        astPTA2.setInvariantConditions(string, linkedHashSet);
        block10: while (true) {
            switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    PTAParser.jj_la1[2] = jj_gen;
                    break block10;
                }
            }
            PTAParser.Transition(astPTA2, string);
        }
        switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 22: {
                PTAParser.jj_consume_token(22);
                break;
            }
            case 31: {
                PTAParser.jj_consume_token(31);
                break;
            }
            default: {
                PTAParser.jj_la1[3] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void Transition(astPTA astPTA2, String string) throws ParseException {
        PTAParser.jj_consume_token(19);
        astTransition astTransition2 = astPTA2.addTransition(string);
        block3: while (true) {
            switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
                case 6: 
                case 40: {
                    break;
                }
                default: {
                    PTAParser.jj_la1[4] = jj_gen;
                    break block3;
                }
            }
            PTAParser.Edge(astPTA2, astTransition2);
        }
        PTAParser.jj_consume_token(20);
    }

    public static final void Edge(astPTA astPTA2, astTransition astTransition2) throws ParseException {
        String string = null;
        switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 40: {
                string = PTAParser.Identifier();
                PTAParser.jj_consume_token(10);
                PTAParser.jj_consume_token(10);
                break;
            }
            default: {
                PTAParser.jj_la1[5] = jj_gen;
            }
        }
        PTAParser.jj_consume_token(6);
        String string2 = PTAParser.Identifier();
        PTAParser.jj_consume_token(14);
        LinkedHashSet<Constraint> linkedHashSet = PTAParser.ConstraintList(astPTA2);
        PTAParser.jj_consume_token(14);
        HashMap<Integer, Integer> hashMap = PTAParser.Resets(astPTA2);
        PTAParser.jj_consume_token(14);
        double d = PTAParser.Probability();
        astTransition2.setAction(string);
        astEdge astEdge2 = astTransition2.addEdge(d, string2);
        for (Map.Entry<Integer, Integer> object : hashMap.entrySet()) {
            astEdge2.addReset(object.getKey(), object.getValue());
        }
        for (Constraint constraint : linkedHashSet) {
            astTransition2.addGuardConstraint(constraint);
        }
    }

    public static final LinkedHashSet<Constraint> ConstraintList(astPTA astPTA2) throws ParseException {
        LinkedHashSet<Constraint> linkedHashSet = new LinkedHashSet<Constraint>();
        block0 : switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 40: {
                PTAParser.Constraint(astPTA2, linkedHashSet);
                while (true) {
                    switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
                        case 15: {
                            break;
                        }
                        default: {
                            PTAParser.jj_la1[6] = jj_gen;
                            break block0;
                        }
                    }
                    PTAParser.jj_consume_token(15);
                    PTAParser.Constraint(astPTA2, linkedHashSet);
                }
            }
            case 7: {
                PTAParser.jj_consume_token(7);
                break;
            }
            default: {
                PTAParser.jj_la1[7] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return linkedHashSet;
    }

    public static final void Constraint(astPTA astPTA2, LinkedHashSet<Constraint> linkedHashSet) throws ParseException {
        Token token;
        String string = PTAParser.Identifier();
        switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 25: {
                token = PTAParser.jj_consume_token(25);
                break;
            }
            case 27: {
                token = PTAParser.jj_consume_token(27);
                break;
            }
            case 26: {
                token = PTAParser.jj_consume_token(26);
                break;
            }
            case 28: {
                token = PTAParser.jj_consume_token(28);
                break;
            }
            case 23: {
                token = PTAParser.jj_consume_token(23);
                break;
            }
            default: {
                PTAParser.jj_la1[8] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7 : switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 37: {
                int n = PTAParser.Integer();
                int n2 = astPTA2.getOrAddClock(string);
                switch (token.kind) {
                    case 25: {
                        linkedHashSet.add(Constraint.buildLt(n2, n));
                        break;
                    }
                    case 27: {
                        linkedHashSet.add(Constraint.buildLeq(n2, n));
                        break;
                    }
                    case 26: {
                        linkedHashSet.add(Constraint.buildGt(n2, n));
                        break;
                    }
                    case 28: {
                        linkedHashSet.add(Constraint.buildGeq(n2, n));
                        break;
                    }
                    case 23: {
                        linkedHashSet.add(Constraint.buildLeq(n2, n));
                        linkedHashSet.add(Constraint.buildGeq(n2, n));
                    }
                }
                break;
            }
            case 40: {
                String string2 = PTAParser.Identifier();
                int n = astPTA2.getOrAddClock(string);
                int n3 = astPTA2.getOrAddClock(string2);
                switch (token.kind) {
                    case 25: {
                        linkedHashSet.add(Constraint.buildLt(n, n3));
                        break block7;
                    }
                }
                System.err.println("Error: Unsupported constraint type");
                System.exit(1);
                break;
            }
            default: {
                PTAParser.jj_la1[9] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final HashMap<Integer, Integer> Resets(astPTA astPTA2) throws ParseException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        block0 : switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 40: {
                PTAParser.Reset(astPTA2, hashMap);
                while (true) {
                    switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
                        case 15: {
                            break;
                        }
                        default: {
                            PTAParser.jj_la1[10] = jj_gen;
                            break block0;
                        }
                    }
                    PTAParser.jj_consume_token(15);
                    PTAParser.Reset(astPTA2, hashMap);
                }
            }
            case 5: {
                PTAParser.jj_consume_token(5);
                break;
            }
            default: {
                PTAParser.jj_la1[11] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return hashMap;
    }

    public static final void Reset(astPTA astPTA2, HashMap<Integer, Integer> hashMap) throws ParseException {
        String string = PTAParser.Identifier();
        PTAParser.jj_consume_token(23);
        int n = PTAParser.Integer();
        int n2 = astPTA2.getOrAddClock(string);
        hashMap.put(n2, n);
    }

    public static final double Probability() throws ParseException {
        Token token;
        switch (jj_ntk == -1 ? PTAParser.jj_ntk_f() : jj_ntk) {
            case 38: {
                token = PTAParser.jj_consume_token(38);
                break;
            }
            case 37: {
                token = PTAParser.jj_consume_token(37);
                break;
            }
            default: {
                PTAParser.jj_la1[12] = jj_gen;
                PTAParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Double.parseDouble(token.image);
    }

    public static final String Identifier() throws ParseException {
        PTAParser.jj_consume_token(40);
        return PTAParser.getToken((int)0).image;
    }

    public static final int Integer() throws ParseException {
        PTAParser.jj_consume_token(37);
        return Integer.parseInt(PTAParser.getToken((int)0).image);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x200000, 8, 524288, -2143289344, 64, 0, 32768, 128, 511705088, 0, 32768, 32, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 256, 256, 0, 256, 0, 288, 0, 256, 96};
    }

    public PTAParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public PTAParser(InputStream inputStream, String string) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        token_source = new PTAParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream inputStream) {
        PTAParser.ReInit(inputStream, null);
    }

    public static void ReInit(InputStream inputStream, String string) {
        try {
            jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        PTAParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    public PTAParser(Reader reader) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(reader, 1, 1);
        token_source = new PTAParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader reader) {
        jj_input_stream.ReInit(reader, 1, 1);
        PTAParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    public PTAParser(PTAParserTokenManager pTAParserTokenManager) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = pTAParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(PTAParserTokenManager pTAParserTokenManager) {
        token_source = pTAParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            PTAParser.jj_la1[i] = -1;
        }
    }

    private static Token jj_consume_token(int n) throws ParseException {
        Token token = PTAParser.token;
        PTAParser.token = token.next != null ? PTAParser.token.next : (PTAParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (PTAParser.token.kind == n) {
            ++jj_gen;
            return PTAParser.token;
        }
        PTAParser.token = token;
        jj_kind = n;
        throw PTAParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = PTAParser.token.next != null ? PTAParser.token.next : (PTAParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = PTAParser.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = token_source.getNextToken());
        }
        return token;
    }

    private static int jj_ntk_f() {
        jj_nt = PTAParser.token.next;
        if (jj_nt == null) {
            PTAParser.token.next = token_source.getNextToken();
            jj_ntk = PTAParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = PTAParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.clear();
        boolean[] blArray = new boolean[42];
        if (jj_kind >= 0) {
            blArray[PTAParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 13; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 42; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            PTAParser.jj_expentry[0] = n2;
            jj_expentries.add(jj_expentry);
        }
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = jj_expentries.get(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_la1 = new int[13];
        PTAParser.jj_la1_init_0();
        PTAParser.jj_la1_init_1();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
    }

    static class astEdge {
        public double prob;
        public String dest;
        public HashMap<Integer, Integer> resets;

        public astEdge(double d, String string) {
            this.prob = d;
            this.dest = string;
            this.resets = new HashMap();
        }

        public void addReset(int n, int n2) {
            this.resets.put(n, n2);
        }

        public void createDataStructures(astPTA astPTA2, Transition transition) {
            int n = astPTA2.getLocationIndex(this.dest);
            if (n == -1) {
                System.err.println("Error: Location \"" + this.dest + "\" does not exist");
                System.exit(1);
            }
            Edge edge = transition.addEdge(this.prob, n);
            for (Map.Entry<Integer, Integer> entry : this.resets.entrySet()) {
                edge.addReset(entry.getKey(), entry.getValue());
            }
        }
    }

    static class astTransition {
        private String action = null;
        private ArrayList<Constraint> guard = new ArrayList();
        public ArrayList<astEdge> edges = new ArrayList();

        public void setAction(String string) {
            this.action = string;
        }

        public void addGuardConstraint(Constraint constraint) {
            this.guard.add(constraint);
        }

        public astEdge addEdge(double d, String string) {
            astEdge astEdge2 = new astEdge(d, string);
            this.edges.add(astEdge2);
            return astEdge2;
        }

        public void createDataStructures(astPTA astPTA2, Transition transition) {
            for (Constraint object : this.guard) {
                transition.addGuardConstraint(object);
            }
            for (astEdge astEdge2 : this.edges) {
                astEdge2.createDataStructures(astPTA2, transition);
            }
        }
    }

    static class astPTA {
        public ArrayList<String> clockNames = new ArrayList();
        public ArrayList<String> locationNames = new ArrayList();
        public HashMap<String, LinkedHashSet<Constraint>> invariants = new HashMap();
        public HashMap<String, ArrayList<astTransition>> transitions = new HashMap();

        public int getOrAddClock(String string) {
            int n = this.clockNames.indexOf(string);
            if (n == -1) {
                this.clockNames.add(string);
                return this.clockNames.size();
            }
            return n + 1;
        }

        public void addLocation(String string) {
            this.locationNames.add(string);
            this.invariants.put(string, new LinkedHashSet());
            this.transitions.put(string, new ArrayList());
        }

        public void addInvariantCondition(String string, Constraint constraint) {
            this.invariants.get(string).add(constraint);
        }

        public void setInvariantConditions(String string, LinkedHashSet<Constraint> linkedHashSet) {
            this.invariants.put(string, linkedHashSet);
        }

        public astTransition addTransition(String string) {
            astTransition astTransition2 = new astTransition();
            this.transitions.get(string).add(astTransition2);
            return astTransition2;
        }

        public int getLocationIndex(String string) {
            return this.locationNames.indexOf(string);
        }

        public PTA createDataStructures() {
            ArrayList<astTransition> arrayList;
            int n;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            int n2 = this.locationNames.size();
            for (n = 0; n < n2; ++n) {
                arrayList = this.transitions.get(this.locationNames.get(n));
                if (arrayList == null || arrayList.isEmpty()) continue;
                for (astTransition astTransition2 : arrayList) {
                    if (astTransition2.action == null || astTransition2.action.equals("")) continue;
                    linkedHashSet.add(astTransition2.action);
                }
            }
            PTA pTA = new PTA(new ArrayList<String>(linkedHashSet));
            n2 = this.clockNames.size();
            for (n = 0; n < n2; ++n) {
                pTA.addClock(this.clockNames.get(n));
            }
            n2 = this.locationNames.size();
            for (n = 0; n < n2; ++n) {
                pTA.addLocation(this.locationNames.get(n));
            }
            n2 = this.locationNames.size();
            for (n = 0; n < n2; ++n) {
                String string = this.locationNames.get(n);
                pTA.setInvariantConditions(n, this.invariants.get(string));
                arrayList = this.transitions.get(string);
                if (arrayList == null || arrayList.isEmpty()) continue;
                for (astTransition astTransition2 : arrayList) {
                    if (astTransition2.edges.isEmpty()) continue;
                    Transition transition = pTA.addTransition(n, astTransition2.action);
                    astTransition2.createDataStructures(this, transition);
                }
            }
            return pTA;
        }
    }
}

