/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import odd.ODDUtils;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.type.TypeInt;
import prism.Model;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.StateList;

public class StateListMTBDD
implements StateList {
    protected JDDNode states;
    protected JDDVars vars;
    protected int numVars;
    protected ODDNode odd;
    protected VarList varList;
    protected double size;
    protected int[] varSizes;
    protected int[] varValues;
    protected int currentVar;
    protected int currentVarLevel;
    protected boolean limit;
    protected int numToPrint;
    protected int count;
    protected PrismLog outputLog;
    protected List<String> strList;
    protected OutputFormat outputFormat = OutputFormat.NORMAL;

    public StateListMTBDD(JDDNode jDDNode, Model model) {
        this.states = jDDNode;
        this.vars = model.getAllDDRowVars();
        this.numVars = this.vars.n();
        this.odd = model.getODD();
        this.varList = model.getVarList();
        this.size = JDD.GetNumMinterms(jDDNode, model.getNumDDRowVars());
        this.varSizes = new int[this.varList.getNumVars()];
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varSizes[i] = this.varList.getRangeLogTwo(i);
        }
        this.varValues = new int[this.varList.getNumVars()];
    }

    public StateListMTBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode, VarList varList) {
        this.states = jDDNode;
        this.vars = jDDVars;
        this.numVars = jDDVars.n();
        this.odd = oDDNode;
        this.varList = varList;
        this.size = JDD.GetNumMinterms(jDDNode, this.numVars);
        this.varSizes = new int[varList.getNumVars()];
        for (int i = 0; i < varList.getNumVars(); ++i) {
            this.varSizes[i] = varList.getRangeLogTwo(i);
        }
        this.varValues = new int[varList.getNumVars()];
    }

    @Override
    public int size() {
        return this.size > 2.147483647E9 ? -1 : (int)Math.round(this.size);
    }

    @Override
    public String sizeString() {
        return this.size > 9.223372036854776E18 ? "" + this.size : "" + Math.round(this.size);
    }

    @Override
    public void print(PrismLog prismLog) {
        this.outputFormat = OutputFormat.NORMAL;
        this.limit = false;
        this.outputLog = prismLog;
        this.doPrint();
        if (this.count == 0) {
            this.outputLog.println("(none)");
        }
    }

    @Override
    public void print(PrismLog prismLog, int n) {
        this.outputFormat = OutputFormat.NORMAL;
        this.limit = true;
        this.numToPrint = n;
        this.outputLog = prismLog;
        this.doPrint();
        if (this.count == 0) {
            this.outputLog.println("(none)");
        }
    }

    @Override
    public void printMatlab(PrismLog prismLog) {
        this.outputFormat = OutputFormat.MATLAB;
        this.limit = false;
        this.outputLog = prismLog;
        this.doPrint();
    }

    @Override
    public void printMatlab(PrismLog prismLog, int n) {
        this.outputFormat = OutputFormat.MATLAB;
        this.limit = true;
        this.numToPrint = n;
        this.outputLog = prismLog;
        this.doPrint();
    }

    @Override
    public void printDot(PrismLog prismLog) throws PrismException {
        this.outputFormat = OutputFormat.DOT;
        this.limit = false;
        this.outputLog = prismLog;
        if (this.odd == null) {
            throw new PrismNotSupportedException("Cannot export state list as DOT, too many states");
        }
        this.doPrint();
    }

    @Override
    public List<String> exportToStringList() {
        this.strList = new ArrayList<String>((int)this.size);
        this.outputFormat = OutputFormat.STRINGS;
        this.limit = false;
        this.doPrint();
        return this.strList;
    }

    private void doPrint() {
        this.count = 0;
        for (int i = 0; i < this.varList.getNumVars(); ++i) {
            this.varValues[i] = 0;
        }
        this.currentVar = 0;
        this.currentVarLevel = 0;
        this.printRec(this.states, 0, this.odd, 0L);
    }

    private void printRec(JDDNode jDDNode, int n, ODDNode oDDNode, long l) {
        JDDNode jDDNode2;
        JDDNode jDDNode3;
        if (this.limit && this.count >= this.numToPrint) {
            return;
        }
        if (jDDNode.equals(JDD.ZERO)) {
            return;
        }
        if (n == this.numVars) {
            switch (this.outputFormat) {
                case NORMAL: {
                    if (oDDNode != null) {
                        this.outputLog.print(l + ":(");
                        break;
                    }
                    this.outputLog.print("(");
                    break;
                }
                case MATLAB: {
                    break;
                }
                case DOT: {
                    assert (oDDNode != null);
                    this.outputLog.print(l + " [label=\"" + l + "\\n(");
                    break;
                }
            }
            int n2 = this.varList.getNumVars();
            Object object = "";
            for (int i = 0; i < n2; ++i) {
                object = this.varList.getType(i) instanceof TypeInt ? (String)object + (this.varValues[i] + this.varList.getLow(i)) : (String)object + (this.varValues[i] == 1);
                if (i >= n2 - 1) continue;
                object = (String)object + ",";
            }
            switch (this.outputFormat) {
                case NORMAL: {
                    this.outputLog.println((String)object + ")");
                    break;
                }
                case MATLAB: {
                    this.outputLog.println((String)object);
                    break;
                }
                case DOT: {
                    this.outputLog.println((String)object + ")\"];");
                    break;
                }
                case STRINGS: {
                    this.strList.add((String)object);
                }
            }
            ++this.count;
            return;
        }
        if (jDDNode.getIndex() > this.vars.getVarIndex(n)) {
            jDDNode2 = jDDNode3 = jDDNode;
        } else {
            jDDNode2 = jDDNode.getElse();
            jDDNode3 = jDDNode.getThen();
        }
        ODDNode oDDNode2 = oDDNode != null ? oDDNode.getElse() : null;
        ODDNode oDDNode3 = oDDNode != null ? oDDNode.getThen() : null;
        long l2 = oDDNode != null ? oDDNode.getEOff() : 0L;
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode2, n + 1, oDDNode2, l);
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n3 = this.currentVar;
        this.varValues[n3] = this.varValues[n3] + (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
        ++this.currentVarLevel;
        if (this.currentVarLevel == this.varSizes[this.currentVar]) {
            ++this.currentVar;
            this.currentVarLevel = 0;
        }
        this.printRec(jDDNode3, n + 1, oDDNode3, l + l2);
        --this.currentVarLevel;
        if (this.currentVarLevel == -1) {
            --this.currentVar;
            this.currentVarLevel = this.varSizes[this.currentVar] - 1;
        }
        int n4 = this.currentVar;
        this.varValues[n4] = this.varValues[n4] - (1 << this.varSizes[this.currentVar] - 1 - this.currentVarLevel);
    }

    @Override
    public boolean includes(JDDNode jDDNode) {
        JDD.Ref(this.states);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(this.states, jDDNode);
        boolean bl = !jDDNode2.equals(JDD.ZERO);
        JDD.Deref(jDDNode2);
        return bl;
    }

    @Override
    public boolean includesAll(JDDNode jDDNode) {
        JDD.Ref(this.states);
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(this.states, jDDNode);
        boolean bl = jDDNode2.equals(jDDNode);
        JDD.Deref(jDDNode2);
        return bl;
    }

    @Override
    public Values getFirstAsValues() throws PrismException {
        if (this.size < 1.0) {
            throw new PrismException("The state list contains no states");
        }
        JDD.Ref(this.states);
        JDDNode jDDNode = JDD.RestrictToFirst(this.states, this.vars);
        JDDNode jDDNode2 = this.states;
        Values values = new Values();
        int n = this.varList.getNumVars();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            int n4 = this.varSizes[i];
            for (int j = 0; j < n4; ++j) {
                if (jDDNode2.getIndex() <= this.vars.getVarIndex(n2)) {
                    if (!jDDNode2.getElse().equals(JDD.ZERO)) {
                        jDDNode2 = jDDNode2.getElse();
                    } else {
                        jDDNode2 = jDDNode2.getThen();
                        n3 += 1 << n4 - 1 - j;
                    }
                }
                ++n2;
            }
            Constable constable = this.varList.getType(i) instanceof TypeInt ? (Constable)new Integer(n3) : (Constable)new Boolean((n3 += this.varList.getLow(i)) == 1);
            values.addValue(this.varList.getName(i), constable);
        }
        JDD.Deref(jDDNode);
        return values;
    }

    @Override
    public int getIndexOfState(State state) throws PrismNotSupportedException {
        JDDNode jDDNode = this.states;
        ODDNode oDDNode = this.odd;
        ODDUtils.checkInt(this.odd, "Cannot get index of state in model");
        int n = 0;
        int n2 = 0;
        int n3 = this.varList.getNumVars();
        for (int i = 0; i < n3; ++i) {
            int n4 = -1;
            try {
                n4 = this.varList.encodeToInt(i, state.varValues[i]);
            }
            catch (PrismLangException prismLangException) {
                return -1;
            }
            int n5 = this.varSizes[i];
            for (int j = 0; j < n5; ++j) {
                if (jDDNode.equals(JDD.ZERO)) {
                    return -1;
                }
                if (jDDNode.getIndex() <= this.vars.getVarIndex(n)) {
                    if ((n4 & 1 << n5 - 1 - j) == 0) {
                        jDDNode = jDDNode.getElse();
                    } else {
                        jDDNode.getThen();
                    }
                }
                ++n;
                if ((n4 & 1 << n5 - 1 - j) == 0) {
                    oDDNode = oDDNode.getElse();
                    continue;
                }
                n2 = (int)((long)n2 + oDDNode.getEOff());
                oDDNode = oDDNode.getThen();
            }
        }
        return n2;
    }

    @Override
    public void clear() {
        JDD.Deref(this.states);
    }

    protected static enum OutputFormat {
        NORMAL,
        MATLAB,
        DOT,
        STRINGS;

    }
}

