/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Collections;
import java.util.List;
import parser.State;
import parser.ast.RewardStruct;
import prism.PrismException;

public interface RewardGenerator {
    default public List<String> getRewardStructNames() {
        return Collections.emptyList();
    }

    default public int getNumRewardStructs() {
        return this.getRewardStructNames().size();
    }

    default public int getRewardStructIndex(String string) {
        return this.getRewardStructNames().indexOf(string);
    }

    default public String getRewardStructName(int n) {
        return this.getRewardStructNames().get(n);
    }

    default public boolean rewardStructHasStateRewards(int n) {
        return true;
    }

    default public boolean rewardStructHasTransitionRewards(int n) {
        return true;
    }

    default public boolean isRewardLookupSupported(RewardLookup rewardLookup) {
        return rewardLookup == RewardLookup.BY_STATE;
    }

    default public double getStateReward(int n, State state) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE)) {
            throw new PrismException("Reward lookup by State not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        return 0.0;
    }

    default public double getStateActionReward(int n, State state, Object object) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE)) {
            throw new PrismException("Reward lookup by State not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        return 0.0;
    }

    default public double getStateReward(int n, int n2) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE_INDEX)) {
            throw new PrismException("Reward lookup by state index not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        return 0.0;
    }

    default public double getStateActionReward(int n, int n2, Object object) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE_INDEX)) {
            throw new PrismException("Reward lookup by state index not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        return 0.0;
    }

    default public RewardStruct getRewardStruct(int n) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_REWARD_STRUCT)) {
            throw new PrismException("Reward lookup by reward struct not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        return null;
    }

    public static enum RewardLookup {
        BY_STATE,
        BY_STATE_INDEX,
        BY_REWARD_STRUCT;

    }
}

