/*
 * Decompiled with CFR 0.152.
 */
package prism;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceType;
import automata.DA;
import common.StopWatch;
import dv.DoubleVector;
import dv.IntegerVector;
import explicit.MinMax;
import hybrid.PrismHybrid;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import parser.BooleanUtils;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import parser.ast.RelOp;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import prism.ECComputer;
import prism.ECComputerDefault;
import prism.IntegerBound;
import prism.LTLModelChecker;
import prism.MDPQuotient;
import prism.Model;
import prism.MultiObjModelChecker;
import prism.NonProbModelChecker;
import prism.NondetModel;
import prism.OpRelOpBound;
import prism.Operator;
import prism.OpsAndBoundsList;
import prism.OptionsIntervalIteration;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.ProbModel;
import prism.ProbModelChecker;
import prism.StateValues;
import prism.StateValuesDV;
import prism.StateValuesMTBDD;
import prism.StateValuesVoid;
import prism.TileList;
import sparse.PrismSparse;
import strat.MDStrategyIV;

public class NondetModelChecker
extends NonProbModelChecker {
    protected NondetModel model;
    protected JDDNode nondetMask;
    protected JDDVars allDDNondetVars;
    protected boolean precomp;
    protected boolean prob0;
    protected boolean prob1;
    protected boolean fairness;

    public NondetModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
        boolean bl;
        if (!(model instanceof NondetModel)) {
            throw new PrismException("Wrong model type passed to NondetModelChecker.");
        }
        this.model = (NondetModel)model;
        this.nondetMask = this.model.getNondetMask();
        this.allDDNondetVars = this.model.getAllDDNondetVars();
        this.precomp = prism.getPrecomp();
        this.prob0 = prism.getProb0();
        this.prob1 = prism.getProb1();
        this.fairness = prism.getFairness();
        boolean bl2 = bl = this.genStrat || prism.getExportAdv() != 1;
        if (bl) {
            if (this.engine != 2) {
                this.mainLog.println("Switching engine since only sparse engine currently supports this computation...");
                this.engine = 2;
            }
            if (this.precomp && this.prob1) {
                this.mainLog.printWarning("Disabling Prob1 since this is needed for adversary generation");
                this.prob1 = false;
            }
        }
        PrismNative.setCompact(prism.getCompact());
        PrismNative.setTermCrit(prism.getTermCrit());
        PrismNative.setTermCritParam(prism.getTermCritParam());
        PrismNative.setMaxIters(prism.getMaxIters());
        PrismNative.setSBMaxMem(prism.getSBMaxMem());
        PrismNative.setNumSBLevels(prism.getNumSBLevels());
        PrismNative.setExportAdv(prism.getExportAdv());
        PrismNative.setExportAdvFilename(prism.getExportAdvFilename());
    }

    public NondetModelChecker createNewModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        return new NondetModelChecker(prism, model, propertiesFile);
    }

    @Override
    public StateValues checkExpression(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionStrategy ? this.checkExpressionStrategy((ExpressionStrategy)expression, jDDNode) : (expression instanceof ExpressionProb ? this.checkExpressionProb((ExpressionProb)expression, jDDNode) : (expression instanceof ExpressionReward ? this.checkExpressionReward((ExpressionReward)expression, jDDNode) : (expression instanceof ExpressionFunc ? (((ExpressionFunc)expression).getName().equals("multi") ? this.checkExpressionMultiObjective((ExpressionFunc)expression, jDDNode) : super.checkExpression(expression, jDDNode)) : super.checkExpression(expression, jDDNode))));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionStrategy(ExpressionStrategy expressionStrategy, JDDNode jDDNode) throws PrismException {
        List<Expression> list;
        boolean bl = !expressionStrategy.isThereExists();
        Coalition coalition = expressionStrategy.getCoalition();
        if (coalition != null) {
            if (coalition.isEmpty()) {
                bl = !bl;
            }
            coalition = null;
        }
        if ((list = expressionStrategy.getOperands()).size() == 1 && list.get(0) instanceof ExpressionProb) {
            return this.checkExpressionProb((ExpressionProb)list.get(0), bl, jDDNode);
        }
        if (list.size() == 1 && list.get(0) instanceof ExpressionReward) {
            return this.checkExpressionReward((ExpressionReward)list.get(0), bl, jDDNode);
        }
        return this.checkExpressionMultiObjective(list, bl, jDDNode);
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb, JDDNode jDDNode) throws PrismException {
        return this.checkExpressionProb(expressionProb, true, jDDNode);
    }

    protected StateValues checkExpressionProb(ExpressionProb expressionProb, boolean bl, JDDNode jDDNode) throws PrismException {
        OpRelOpBound opRelOpBound = expressionProb.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType(), bl);
        if (opRelOpBound.isTriviallyTrue()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies all states");
            JDD.Ref(this.reach);
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(this.reach, this.model);
        }
        if (opRelOpBound.isTriviallyFalse()) {
            this.mainLog.printWarning("Checking for probability " + opRelOpBound.relOpBoundString() + " - formula trivially satisfies no states");
            JDD.Deref(jDDNode);
            return new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        }
        boolean bl2 = opRelOpBound.isQualitative() && this.precomp && this.prob0 && this.prob1;
        StateValues stateValues = this.checkProbPathFormula(expressionProb.getExpression(), bl2, minMax.isMin(), jDDNode);
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " probabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        JDDNode jDDNode2 = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        jDDNode2 = JDD.And(jDDNode2, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD(jDDNode2, this.model);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward, JDDNode jDDNode) throws PrismException {
        return this.checkExpressionReward(expressionReward, true, jDDNode);
    }

    protected StateValues checkExpressionReward(ExpressionReward expressionReward, boolean bl, JDDNode jDDNode) throws PrismException {
        Object object;
        OpRelOpBound opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(this.model.getModelType(), bl);
        Object object2 = expressionReward.getRewardStructIndex();
        JDDNode jDDNode2 = this.getStateRewardsByIndexObject(object2, this.model, this.constantValues);
        JDDNode jDDNode3 = this.getTransitionRewardsByIndexObject(object2, this.model, this.constantValues);
        StateValues stateValues = null;
        Expression expression = expressionReward.getExpression();
        if (expression.getType() instanceof TypePathDouble) {
            object = (ExpressionTemporal)expression;
            switch (((ExpressionTemporal)object).getOperator()) {
                case 11: {
                    if (((ExpressionTemporal)object).hasBounds()) {
                        stateValues = this.checkRewardCumul((ExpressionTemporal)object, jDDNode2, jDDNode3, minMax.isMin(), jDDNode);
                        break;
                    }
                    stateValues = this.checkRewardTotal((ExpressionTemporal)object, jDDNode2, jDDNode3, minMax.isMin(), jDDNode);
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInst((ExpressionTemporal)object, jDDNode2, jDDNode3, minMax.isMin(), jDDNode);
                }
            }
        } else if (expression.getType() instanceof TypePathBool || expression.getType() instanceof TypeBool) {
            stateValues = this.checkRewardPathFormula(expression, jDDNode2, jDDNode3, minMax.isMin(), jDDNode);
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        if (this.verbose) {
            this.mainLog.print("\n" + (minMax.isMin() ? "Minimum" : "Maximum") + " rewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) {
            return stateValues;
        }
        object = stateValues.getBDDFromInterval(opRelOpBound.getRelOp(), opRelOpBound.getBound());
        JDD.Ref(this.reach);
        object = JDD.And((JDDNode)object, this.reach);
        stateValues.clear();
        return new StateValuesMTBDD((JDDNode)object, this.model);
    }

    protected StateValues checkExpressionMultiObjective(List<Expression> list, boolean bl, JDDNode jDDNode) throws PrismException {
        if (this.fairness) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("Multi-objective reasoning under fairness currently not supported");
        }
        if (list.size() > 1) {
            JDD.Deref(jDDNode);
            throw new PrismException("Cannot currently check strategy operators with lists of expressions");
        }
        Expression expression = list.get(0);
        if (expression.getType() instanceof TypeBool) {
            expression = (ExpressionStrategy)expression.deepCopy();
            if (bl) {
                expression = Expression.Not(expression);
            }
            List<List<Expression>> list2 = BooleanUtils.convertToDNFLists(expression);
            for (List<Expression> object : list2) {
                for (Expression expression2 : object) {
                    if (Expression.isNot(expression2)) {
                        expression2 = ((ExpressionUnaryOp)expression2).getOperand();
                    }
                    if (expression2 instanceof ExpressionQuant) continue;
                    JDD.Deref(jDDNode);
                    throw new PrismException("Expression " + expression2 + " is not allowed in a multi-objective query");
                }
            }
            for (List<Expression> list3 : list2) {
                for (int i = 0; i < list3.size(); ++i) {
                    Expression expression2;
                    expression2 = list3.get(i);
                    if (!Expression.isNot(expression2)) continue;
                    ExpressionQuant expressionQuant = (ExpressionQuant)((ExpressionUnaryOp)expression2).getOperand();
                    expressionQuant.setRelOp(expressionQuant.getRelOp().negate());
                    list3.set(i, expressionQuant);
                }
            }
            this.mainLog.println("\nReducing multi-objective query to DNF: " + BooleanUtils.convertDNFListsToExpression(list2));
            if (list2.size() > 1) {
                JDD.Deref(jDDNode);
                throw new PrismException("Multi-objective model checking of multiple disjuncts not yet supported");
            }
            ExpressionFunc expressionFunc = new ExpressionFunc("multi");
            for (Expression expression3 : list2.get(0)) {
                expressionFunc.addOperand(expression3);
            }
            if (bl) {
                return this.checkExpression(Expression.Not(expressionFunc), jDDNode);
            }
            return this.checkExpressionMultiObjective(expressionFunc, jDDNode);
        }
        if (expression.getType() instanceof TypeDouble) {
            return this.checkExpressionMultiObjective(list, jDDNode);
        }
        JDD.Deref(jDDNode);
        throw new PrismException("Multi-objective model checking not supported for: " + expression);
    }

    protected StateValues checkExpressionMultiObjective(ExpressionFunc expressionFunc, JDDNode jDDNode) throws PrismException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = expressionFunc.getNumOperands();
        for (int i = 0; i < n; ++i) {
            arrayList.add(expressionFunc.getOperand(i));
        }
        return this.checkExpressionMultiObjective(arrayList, jDDNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateValues checkExpressionMultiObjective(List<Expression> list, JDDNode jDDNode) throws PrismException {
        Object object;
        ArrayList<JDDNode> arrayList;
        JDDNode jDDNode22;
        ArrayList<JDDNode> arrayList2 = null;
        ArrayList<Integer> arrayList3 = null;
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        if (this.fairness) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("Multi-objective reasoning under fairness currently not supported");
        }
        if (this.doIntervalIteration) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("Interval iteration currently not supported for multi-objective reasoning");
        }
        if (!JDD.isSingleton(jDDNode, this.model.getAllDDRowVars())) {
            JDD.Deref(jDDNode);
            throw new PrismException("Multi-objective model checking can only compute values from a single state");
        }
        JDDNode jDDNode3 = jDDNode;
        int n2 = list.size();
        OpsAndBoundsList opsAndBoundsList = new OpsAndBoundsList();
        ArrayList<JDDNode> arrayList4 = new ArrayList<JDDNode>();
        ArrayList<Expression> arrayList5 = new ArrayList<Expression>(n2);
        for (int i = 0; i < n2; ++i) {
            this.extractInfoFromMultiObjectiveOperand((ExpressionQuant)list.get(i), opsAndBoundsList, arrayList4, arrayList5, i);
        }
        if (opsAndBoundsList.numberOfNumerical() > 1 && opsAndBoundsList.numberOfNumerical() < opsAndBoundsList.probSize() + opsAndBoundsList.rewardSize()) {
            JDD.Deref(jDDNode3);
            throw new PrismException("Multiple min/max queries cannot be combined with boolean queries.");
        }
        bl = opsAndBoundsList.contains(Operator.P_MIN);
        bl2 = opsAndBoundsList.contains(Operator.R_GE) || opsAndBoundsList.contains(Operator.R_MAX);
        Expression[] expressionArray = new Expression[n2];
        DA[] dAArray = new DA[n2];
        JDDVars[] jDDVarsArray = new JDDVars[n2];
        JDDVars[] jDDVarsArray2 = new JDDVars[n2];
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        MultiObjModelChecker multiObjModelChecker = new MultiObjModelChecker(this.prism, this.prism);
        NondetModel nondetModel = this.model;
        long l = System.currentTimeMillis();
        boolean bl3 = true;
        for (int i = 0; i < n2; ++i) {
            if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
            jDDVarsArray[i] = new JDDVars();
            jDDVarsArray2[i] = new JDDVars();
            NondetModel nondetModel2 = multiObjModelChecker.constructDRAandProductMulti(nondetModel, lTLModelChecker, this, expressionArray[i], i, dAArray, opsAndBoundsList.getOperator(i), (Expression)arrayList5.get(i), jDDVarsArray[i], jDDVarsArray2[i], jDDNode3);
            if (i > 0 & !bl3) {
                nondetModel.clear();
            }
            nondetModel = nondetModel2;
            bl3 = false;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Total time for product construction: " + (double)l / 1000.0 + " seconds.");
        opsAndBoundsList.makeAllProbUp();
        this.outputProductMulti(nondetModel);
        ArrayList<JDDNode> arrayList6 = new ArrayList<JDDNode>();
        for (JDDNode jDDNode22 : arrayList4) {
            JDD.Ref(jDDNode22);
            JDD.Ref(nondetModel.getTrans01());
            arrayList6.add(JDD.Apply(3, jDDNode22, nondetModel.getTrans01()));
        }
        if (bl2) {
            multiObjModelChecker.removeNonZeroMecsForMax(nondetModel, lTLModelChecker, arrayList4, opsAndBoundsList, n2, dAArray, jDDVarsArray, jDDVarsArray2);
        }
        JDDNode jDDNode4 = nondetModel.getTrans();
        jDDNode22 = nondetModel.getTrans01();
        boolean bl4 = multiObjModelChecker.removeNonZeroRewardTrans(nondetModel, arrayList4, opsAndBoundsList);
        ArrayList<ArrayList<JDDNode>> arrayList7 = new ArrayList<ArrayList<JDDNode>>(n2);
        ArrayList<ArrayList<JDDNode>> arrayList8 = new ArrayList<ArrayList<JDDNode>>(n2);
        JDDNode jDDNode5 = JDD.Constant(0.0);
        JDDNode jDDNode6 = JDD.Constant(0.0);
        for (int i = 0; i < n2; ++i) {
            if (opsAndBoundsList.isProbabilityObjective(i)) {
                arrayList = new ArrayList<JDDNode>();
                ArrayList<JDDNode> arrayList9 = new ArrayList<JDDNode>();
                for (int j = 0; j < ((AcceptanceRabin)dAArray[i].getAcceptance()).size(); ++j) {
                    JDDNode jDDNode7 = JDD.Constant(0.0);
                    JDDNode jDDNode8 = JDD.Constant(0.0);
                    for (int k = 0; k < dAArray[i].size(); ++k) {
                        if (!((AcceptanceRabin.RabinPair)((AcceptanceRabin)dAArray[i].getAcceptance()).get(j)).getL().get(k)) {
                            jDDNode7 = JDD.SetVectorElement(jDDNode7, jDDVarsArray[i], k, 1.0);
                        }
                        if (!((AcceptanceRabin.RabinPair)((AcceptanceRabin)dAArray[i].getAcceptance()).get(j)).getK().get(k)) continue;
                        jDDNode8 = JDD.SetVectorElement(jDDNode8, jDDVarsArray[i], k, 1.0);
                    }
                    arrayList.add(jDDNode7);
                    JDD.Ref(jDDNode7);
                    jDDNode5 = JDD.Or(jDDNode5, jDDNode7);
                    arrayList9.add(jDDNode8);
                    JDD.Ref(jDDNode8);
                    jDDNode6 = JDD.Or(jDDNode6, jDDNode8);
                }
                arrayList7.add(i, arrayList);
                arrayList8.add(i, arrayList9);
                continue;
            }
            arrayList7.add(i, null);
            arrayList8.add(i, null);
        }
        List<JDDNode> list2 = multiObjModelChecker.computeAllEcs(nondetModel, lTLModelChecker, arrayList7, arrayList8, jDDNode5, jDDNode6, jDDVarsArray, jDDVarsArray2, opsAndBoundsList, n2);
        arrayList = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            if (opsAndBoundsList.isProbabilityObjective(i)) {
                this.mainLog.println("\nFinding accepting end components for " + ((Expression)arrayList5.get(i)).toString() + "...");
                arrayList.add(multiObjModelChecker.computeAcceptingEndComponent(dAArray[i], nondetModel, jDDVarsArray[i], jDDVarsArray2[i], list2, (List<JDDNode>)arrayList7.get(i), (List<JDDNode>)arrayList8.get(i), lTLModelChecker, n > 1));
                continue;
            }
            if (arrayList5.get(i) == null) continue;
            JDDNode jDDNode9 = this.checkExpressionDD((Expression)arrayList5.get(i), this.model.getReach().copy());
            JDD.Ref(nondetModel.getReach());
            jDDNode9 = JDD.And(jDDNode9, nondetModel.getReach());
            arrayList.add(jDDNode9);
        }
        if (n > 1) {
            arrayList2 = new ArrayList<JDDNode>();
            arrayList3 = new ArrayList<Integer>();
            multiObjModelChecker.checkConflictsInObjectives(nondetModel, lTLModelChecker, n, n2, opsAndBoundsList, dAArray, jDDVarsArray, jDDVarsArray2, arrayList, arrayList7, arrayList8, arrayList2, arrayList3);
        }
        for (JDDNode jDDNode10 : list2) {
            JDD.Deref(jDDNode10);
        }
        if (arrayList.isEmpty() && this.prism.getMDPSolnMethod() == 3) {
            this.addDummyFormula(nondetModel, lTLModelChecker, arrayList, opsAndBoundsList);
        }
        if (bl4) {
            JDD.Deref(nondetModel.getTrans());
            JDD.Deref(nondetModel.getTrans01());
            nondetModel.trans = jDDNode4;
            nondetModel.trans01 = jDDNode22;
        }
        try {
            object = multiObjModelChecker.computeMultiReachProbs(nondetModel, lTLModelChecker, arrayList6, nondetModel.getStart(), arrayList, arrayList2, arrayList3, opsAndBoundsList, n > 1);
        }
        finally {
            JDD.Deref(jDDNode3);
            if (nondetModel != null && nondetModel != this.model) {
                nondetModel.clear();
            }
            for (int i = 0; i < n2; ++i) {
                if (!opsAndBoundsList.isProbabilityObjective(i)) continue;
                jDDVarsArray[i].derefAll();
                jDDVarsArray2[i].derefAll();
            }
            for (JDDNode jDDNode7 : arrayList) {
                JDD.Deref(jDDNode7);
            }
            if (arrayList2 != null) {
                for (JDDNode jDDNode7 : arrayList2) {
                    JDD.Deref(jDDNode7);
                }
            }
        }
        if (object instanceof TileList) {
            if (opsAndBoundsList.numberOfNumerical() == 2) {
                List<TileList> list3 = TileList.getStoredTileLists();
                synchronized (list3) {
                    TileList.storedFormulasX.add(list.get(0));
                    TileList.storedFormulasY.add(list.get(1));
                    TileList.storedFormulas.add(list);
                    TileList.storedTileLists.add((TileList)object);
                }
            }
            return new StateValuesVoid(object);
        }
        if (object instanceof Double) {
            if (bl) {
                object = 1.0 - (Double)object;
            }
            return new StateValuesMTBDD(JDD.Constant((Double)object), this.model);
        }
        throw new PrismException("Do not know how to treat the returned value " + object);
    }

    protected void extractInfoFromMultiObjectiveOperand(ExpressionQuant expressionQuant, OpsAndBoundsList opsAndBoundsList, List<JDDNode> list, List<Expression> list2, int n) throws PrismException {
        double d;
        Operator operator;
        Object object;
        Object object2;
        ExpressionProb expressionProb = null;
        ExpressionReward expressionReward = null;
        if (expressionQuant instanceof ExpressionProb) {
            expressionProb = (ExpressionProb)expressionQuant;
            expressionReward = null;
        } else if (expressionQuant instanceof ExpressionReward) {
            expressionReward = (ExpressionReward)expressionQuant;
            expressionProb = null;
        } else {
            throw new PrismException("Multi-objective properties can only contain P and R operators");
        }
        if (expressionReward != null) {
            Object object3 = expressionReward.getRewardStructIndex();
            object2 = this.getStateRewardsByIndexObject(object3, this.model, this.constantValues);
            if (object2 != null && !((JDDNode)object2).equals(JDD.ZERO)) {
                throw new PrismNotSupportedException("Multi-objective model checking does not support state rewards; please convert to transition rewards");
            }
            list.add(this.getTransitionRewardsByIndexObject(object3, this.model, this.constantValues));
        }
        int n2 = 0;
        if (expressionProb != null) {
            object2 = expressionProb.getExpression();
            if (((Expression)object2).isSimplePathFormula() && Expression.isReach((Expression)object2)) {
                object = (ExpressionTemporal)object2;
                if (((ExpressionTemporal)object).getLowerBound() != null) {
                    throw new PrismException("Lower time bounds are not supported in multi-objective queries");
                }
                n2 = ((ExpressionTemporal)object).getUpperBound() != null ? ((ExpressionTemporal)object).getUpperBound().evaluateInt(this.constantValues) : -1;
            } else {
                if (Expression.containsTemporalTimeBounds((Expression)object2)) {
                    throw new PrismException("Time bounds in multi-objective queries can only be on F or C operators");
                }
                n2 = -1;
            }
        }
        if (expressionReward != null) {
            object2 = (ExpressionTemporal)expressionReward.getExpression();
            if (((ExpressionTemporal)object2).getOperator() != 11) {
                throw new PrismException("Only the C and C>=k reward operators are currently supported for multi-objective properties (not " + ((ExpressionTemporal)object2).getOperatorSymbol() + ")");
            }
            n2 = ((ExpressionTemporal)object2).getUpperBound() != null ? ((ExpressionTemporal)object2).getUpperBound().evaluateInt(this.constantValues) : -1;
        }
        if (((RelOp)((Object)(object = ((OpRelOpBound)(object2 = expressionQuant.getRelopBoundInfo(this.constantValues))).getRelOp()))).isStrict()) {
            throw new PrismException("Multi-objective properties can not use strict inequalities on P/R operators");
        }
        if (object == RelOp.MAX) {
            operator = expressionProb != null ? Operator.P_MAX : Operator.R_MAX;
        } else if (object == RelOp.GEQ) {
            operator = expressionProb != null ? Operator.P_GE : Operator.R_GE;
        } else if (object == RelOp.MIN) {
            operator = expressionProb != null ? Operator.P_MIN : Operator.R_MIN;
        } else if (object == RelOp.LEQ) {
            operator = expressionProb != null ? Operator.P_LE : Operator.R_LE;
        } else {
            throw new PrismException("Multi-objective properties can only contain P/R operators with max/min=? or lower/upper probability bounds");
        }
        double d2 = d = ((OpRelOpBound)object2).isNumeric() ? -1.0 : ((OpRelOpBound)object2).getBound();
        if (((OpRelOpBound)object2).isProbabilistic() && ((OpRelOpBound)object2).getRelOp().isUpperBound()) {
            d = 1.0 - d;
        }
        opsAndBoundsList.add((OpRelOpBound)object2, operator, d, n2, n);
        if (expressionProb != null) {
            list2.add(expressionProb.getExpression());
        }
        if (expressionReward != null) {
            list2.add(null);
        }
    }

    protected void addDummyFormula(NondetModel nondetModel, LTLModelChecker lTLModelChecker, List<JDDNode> list, OpsAndBoundsList opsAndBoundsList) throws PrismException {
        List<JDDNode> list2 = lTLModelChecker.findMECStates(nondetModel, nondetModel.getReach());
        JDDNode jDDNode = JDD.Constant(0.0);
        for (JDDNode jDDNode2 : list2) {
            jDDNode = JDD.Or(jDDNode, jDDNode2);
        }
        list.add(jDDNode);
        OpRelOpBound opRelOpBound = new OpRelOpBound("P", RelOp.GEQ, 0.0);
        opsAndBoundsList.add(opRelOpBound, Operator.P_GE, 0.0, -1, -1);
    }

    protected void outputProductMulti(NondetModel nondetModel) throws PrismException {
        this.mainLog.println();
        nondetModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                nondetModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.prism.getExportProductStatesFilename());
            nondetModel.exportStates(1, prismFileLog);
            prismFileLog.close();
        }
    }

    protected StateValues checkProbPathFormula(Expression expression, boolean bl, boolean bl2, JDDNode jDDNode) throws PrismException {
        boolean bl3 = expression.isSimplePathFormula();
        if (bl3 && this.prism.getSettings().getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(this.model.getModelType(), expression)) {
            bl3 = false;
        }
        if (bl3) {
            return this.checkProbPathFormulaSimple(expression, bl, bl2, jDDNode);
        }
        return this.checkProbPathFormulaLTL(expression, bl, bl2, jDDNode);
    }

    protected StateValues checkProbPathFormulaSimple(Expression expression, boolean bl, boolean bl2, JDDNode jDDNode) throws PrismException {
        boolean bl3 = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl3 = true;
            bl2 = !bl2;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(expressionTemporal, bl2, jDDNode);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(expressionTemporal, bl2, jDDNode) : this.checkProbUntil(expressionTemporal, bl, bl2, jDDNode);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl3) {
            stateValues.subtractFromOne();
        }
        return stateValues;
    }

    protected StateValues checkProbNext(ExpressionTemporal expressionTemporal, boolean bl, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        JDDNode jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        stateValues = this.computeNextProbs(this.trans, jDDNode2, bl);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        if (n2 == null) {
            try {
                stateValues = this.checkProbUntil(jDDNode3, jDDNode2, false, bl);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
        }
        if (n2 == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
        } else {
            try {
                stateValues = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode2, n2, bl);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stateValues = this.computeRestrictedNext(this.trans, jDDNode3, stateValues, bl);
            }
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbUntil(ExpressionTemporal expressionTemporal, boolean bl, boolean bl2, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        StateValues stateValues = null;
        JDD.Deref(jDDNode);
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        try {
            stateValues = this.checkProbUntil(jDDNode3, jDDNode2, bl, bl2);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            JDD.Deref(jDDNode2);
            throw prismException;
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return stateValues;
    }

    protected StateValues checkProbUntil(JDDNode jDDNode, JDDNode jDDNode2, boolean bl, boolean bl2) throws PrismException {
        JDDNode jDDNode3;
        JDDNode jDDNode4;
        StateValues stateValues = null;
        if (bl2 && this.fairness) {
            this.mainLog.print("\nDoing conversion for fairness...\n");
            long l = System.currentTimeMillis();
            jDDNode4 = PrismMTBDD.Prob0A(this.trans01, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode, jDDNode2);
            JDD.Ref(jDDNode4);
            JDDNode jDDNode5 = JDD.Not(jDDNode4);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode2);
            jDDNode3 = JDD.And(jDDNode5, JDD.Not(jDDNode2));
            JDD.Deref(jDDNode5);
            JDD.Ref(this.reach);
            jDDNode3 = JDD.And(this.reach, jDDNode3);
            JDD.Ref(this.reach);
            jDDNode4 = JDD.And(this.reach, jDDNode4);
            l = System.currentTimeMillis() - l;
            this.mainLog.print("\nTime for fairness conversion: " + (double)l / 1000.0 + " seconds.\n");
        } else {
            JDD.Ref(jDDNode);
            jDDNode3 = jDDNode;
            JDD.Ref(jDDNode2);
            jDDNode4 = jDDNode2;
        }
        if (bl) {
            this.mainLog.print("\nProbability bound in formula is 0/1 so not computing exact probabilities...\n");
            stateValues = this.computeUntilProbsQual(this.trans01, jDDNode3, jDDNode4, bl2 && !this.fairness);
        } else {
            try {
                stateValues = this.computeUntilProbs(this.trans, this.transActions, this.trans01, jDDNode3, jDDNode4, bl2 && !this.fairness);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode4);
                throw prismException;
            }
        }
        if (bl2 && this.fairness) {
            stateValues.subtractFromOne();
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues checkProbPathFormulaLTL(Expression expression, boolean bl, boolean bl2, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        Object object;
        DA<BitSet, ? extends AcceptanceOmega> dA;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        Vector<JDDNode> vector = new Vector<JDDNode>();
        if (bl2 && !this.fairness) {
            expression = Expression.Not(Expression.Parenth(expression));
        }
        if (expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getName().equals("dfa")) {
            throw new PrismException("Model checking for \"dfa\" specifications not supported yet");
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.BUCHI, AcceptanceType.RABIN, AcceptanceType.GENERALIZED_RABIN, AcceptanceType.REACH};
        try {
            dA = lTLModelChecker.constructDAForLTLFormula(this, this.model, expression, vector, acceptanceTypeArray);
        }
        catch (Exception exception) {
            JDD.Deref(jDDNode);
            throw exception;
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nConstructing MDP-" + dA.getAutomataType() + " product...");
        JDDVars jDDVars = new JDDVars();
        JDDVars jDDVars2 = new JDDVars();
        NondetModel nondetModel = lTLModelChecker.constructProductMDP(dA, this.model, vector, jDDVars, jDDVars2, jDDNode);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for product construction: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.println();
        nondetModel.printTransInfo(this.mainLog, this.prism.getExtraDDInfo());
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                nondetModel.exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.prism.getExportProductStatesFilename());
            nondetModel.exportStates(1, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        if ((object = dA.getAcceptance().toAcceptanceDD(jDDVars)) instanceof AcceptanceReachDD) {
            this.mainLog.println("\nSkipping accepting MEC computation since acceptance is defined via goal states...");
            jDDNode2 = ((AcceptanceReachDD)object).getGoalStates();
            JDD.Ref(nondetModel.getReach());
            jDDNode2 = JDD.And(jDDNode2, nondetModel.getReach());
        } else {
            this.mainLog.println("\nFinding accepting end components...");
            jDDNode2 = lTLModelChecker.findAcceptingECStates((AcceptanceOmegaDD)object, nondetModel, jDDVars, jDDVars2, this.fairness);
        }
        object.clear();
        this.mainLog.println("\nComputing reachability probabilities...");
        NondetModelChecker nondetModelChecker = new NondetModelChecker(this.prism, nondetModel, null);
        stateValues = nondetModelChecker.checkProbUntil(nondetModel.getReach(), jDDNode2, bl, bl2 && this.fairness);
        if (bl2 && !this.fairness) {
            stateValues.subtractFromOne();
        }
        if (this.prism.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.prism.getExportProductVectorFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.prism.getExportProductVectorFilename());
            stateValues.print(prismFileLog, false, false, false, false);
            prismFileLog.close();
        }
        JDDNode jDDNode3 = lTLModelChecker.buildStartMask(dA, vector, jDDVars);
        JDD.Ref(this.model.getReach());
        jDDNode3 = JDD.And(this.model.getReach(), jDDNode3);
        stateValues.filter(jDDNode3);
        stateValues2 = stateValues.sumOverDDVars(jDDVars, this.model);
        stateValues.clear();
        nondetModel.clear();
        for (int i = 0; i < vector.size(); ++i) {
            JDD.Deref(vector.get(i));
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        jDDVars.derefAll();
        jDDVars2.derefAll();
        return stateValues2;
    }

    protected StateValues checkRewardCumul(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismException("Cumulative reward operator without time bound (C) is only allowed for multi-objective queries");
        }
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
        }
        if (n == 0) {
            stateValues = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        } else {
            stateValues = this.computeCumulRewards(this.trans, jDDNode, jDDNode2, n, bl);
        }
        return stateValues;
    }

    protected StateValues checkRewardTotal(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        JDD.Deref(jDDNode3);
        StateValues stateValues = this.computeTotalRewards(this.trans, this.trans01, this.transActions, jDDNode, jDDNode2, bl);
        return stateValues;
    }

    protected StateValues checkRewardInst(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        int n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        if (n < 0) {
            throw new PrismException("Invalid bound " + n + " in instantaneous reward property");
        }
        stateValues = this.computeInstRewards(this.trans, jDDNode, n, bl);
        return stateValues;
    }

    protected StateValues checkRewardPathFormula(Expression expression, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        if (Expression.isReach(expression)) {
            return this.checkRewardReach((ExpressionTemporal)expression, jDDNode, jDDNode2, bl, jDDNode3);
        }
        if (Expression.isCoSafeLTLSyntactic(expression, true)) {
            return this.checkRewardCoSafeLTL(expression, jDDNode, jDDNode2, bl, jDDNode3);
        }
        JDD.Deref(jDDNode3);
        throw new PrismException("R operator contains a path formula that is not syntactically co-safe: " + expression);
    }

    protected StateValues checkRewardReach(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        if (this.fairness && !bl) {
            JDD.Deref(jDDNode3);
            throw new PrismNotSupportedException("Maximum reward computation currently not supported under fairness.");
        }
        JDD.Deref(jDDNode3);
        if (expressionTemporal.hasBounds()) {
            throw new PrismNotSupportedException("R operator cannot contain a bounded F operator: " + expressionTemporal);
        }
        JDDNode jDDNode4 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        try {
            stateValues = this.computeReachRewards(this.trans, this.transActions, this.trans01, jDDNode, jDDNode2, jDDNode4, bl);
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode4);
            throw prismException;
        }
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues checkRewardCoSafeLTL(Expression expression, JDDNode jDDNode, JDDNode jDDNode2, boolean bl, JDDNode jDDNode3) throws PrismException {
        Object object;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        Vector<JDDNode> vector = new Vector<JDDNode>();
        if (this.fairness && !bl) {
            JDD.Deref(jDDNode3);
            throw new PrismNotSupportedException("Maximum reward computation currently not supported under fairness.");
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (this.model.getModelType().continuousTime()) {
                JDD.Deref(jDDNode3);
                throw new PrismException("DA construction for time-bounded operators not supported for " + this.model.getModelType() + ".");
            }
            if (expression.isSimplePathFormula()) {
                expression = Expression.convertSimplePathFormulaToCanonicalForm(expression);
            } else {
                JDD.Deref(jDDNode3);
                throw new PrismException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        if (expression instanceof ExpressionFunc && ((ExpressionFunc)expression).getName().equals("dfa")) {
            JDD.Deref(jDDNode3);
            throw new PrismException("Model checking for \"dfa\" specifications not supported yet");
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this.prism);
        DA<BitSet, AcceptanceReach> dA = lTLModelChecker.constructDFAForCosafetyRewardLTL(this, this.model, expression, vector);
        if (this.prism.getSettings().getExportPropAut()) {
            this.mainLog.println("Exporting DA to file \"" + this.prism.getSettings().getExportPropAutFilename() + "\"...");
            object = PrismUtils.newPrintStream(this.prism.getSettings().getExportPropAutFilename());
            dA.print((PrintStream)object, this.prism.getSettings().getExportPropAutType());
            ((PrintStream)object).close();
        }
        LTLModelChecker.LTLProduct<NondetModel> lTLProduct = lTLModelChecker.constructProductMDP(this.model, dA, vector, jDDNode3);
        if (this.prism.getExportProductTrans()) {
            try {
                this.mainLog.println("\nExporting product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"...");
                ((NondetModel)lTLProduct.getProductModel()).exportToFile(1, true, new File(this.prism.getExportProductTransFilename()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export product transition matrix to file \"" + this.prism.getExportProductTransFilename() + "\"");
            }
        }
        if (this.prism.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.prism.getExportProductStatesFilename() + "\"...");
            object = new PrismFileLog(this.prism.getExportProductStatesFilename());
            ((NondetModel)lTLProduct.getProductModel()).exportStates(1, (PrismLog)object);
            ((PrismFileLog)object).close();
        }
        object = JDD.Apply(3, jDDNode.copy(), ((NondetModel)lTLProduct.getProductModel()).getReach().copy());
        JDDNode jDDNode4 = JDD.Apply(3, jDDNode2.copy(), ((NondetModel)lTLProduct.getProductModel()).getTrans01().copy());
        AcceptanceReachDD acceptanceReachDD = (AcceptanceReachDD)lTLProduct.getProductAcceptance();
        JDDNode jDDNode5 = acceptanceReachDD.getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        NondetModelChecker nondetModelChecker = this.createNewModelChecker(this.prism, (Model)lTLProduct.getProductModel(), null);
        stateValues = nondetModelChecker.computeReachRewards(((NondetModel)lTLProduct.getProductModel()).getTrans(), ((NondetModel)lTLProduct.getProductModel()).getTransActions(), ((NondetModel)lTLProduct.getProductModel()).getTrans01(), (JDDNode)object, jDDNode4, jDDNode5, bl);
        stateValues2 = lTLProduct.projectToOriginalModel(stateValues);
        JDD.Deref((JDDNode)object);
        JDD.Deref(jDDNode4);
        lTLProduct.clear();
        JDD.Deref(jDDNode5);
        return stateValues2;
    }

    protected StateValues computeNextProbs(JDDNode jDDNode, JDDNode jDDNode2, boolean bl) {
        StateValuesMTBDD stateValuesMTBDD = null;
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode2, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        if (bl) {
            JDD.Ref(this.nondetMask);
            jDDNode3 = JDD.Apply(6, jDDNode3, this.nondetMask);
            jDDNode3 = JDD.MinAbstract(jDDNode3, this.allDDNondetVars);
        } else {
            jDDNode3 = JDD.MaxAbstract(jDDNode3, this.allDDNondetVars);
        }
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        return stateValuesMTBDD;
    }

    protected StateValues computeRestrictedNext(JDDNode jDDNode, JDDNode jDDNode2, StateValues stateValues, boolean bl) {
        StateValuesMTBDD stateValuesMTBDD = null;
        StateValuesMTBDD stateValuesMTBDD2 = stateValues.convertToStateValuesMTBDD();
        JDDNode jDDNode3 = stateValuesMTBDD2.getJDDNode();
        JDD.Ref(jDDNode3);
        jDDNode3 = JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars);
        JDD.Ref(jDDNode);
        jDDNode3 = JDD.MatrixMultiply(jDDNode, jDDNode3, this.allDDColVars, 2);
        if (bl) {
            JDD.Ref(this.nondetMask);
            jDDNode3 = JDD.Apply(6, jDDNode3, this.nondetMask);
            jDDNode3 = JDD.MinAbstract(jDDNode3, this.allDDNondetVars);
        } else {
            jDDNode3 = JDD.MaxAbstract(jDDNode3, this.allDDNondetVars);
        }
        JDD.Ref(jDDNode2);
        jDDNode3 = JDD.Apply(5, jDDNode3, jDDNode2);
        stateValuesMTBDD = new StateValuesMTBDD(jDDNode3, this.model);
        stateValuesMTBDD2.clear();
        return stateValuesMTBDD;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, int n, boolean bl) throws PrismException {
        JDDNode jDDNode5;
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        StateValues stateValues = null;
        if (jDDNode4.equals(JDD.ZERO)) {
            jDDNode7 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode5 = JDD.Constant(0.0);
        } else if (jDDNode3.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode4);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode4));
            jDDNode5 = JDD.Constant(0.0);
        } else {
            JDD.Ref(jDDNode4);
            jDDNode7 = jDDNode4;
            if (jDDNode7.equals(this.reach)) {
                jDDNode6 = JDD.Constant(0.0);
            } else if (this.precomp && this.prob0) {
                jDDNode6 = bl ? PrismMTBDD.Prob0E(jDDNode2, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode3, jDDNode7) : PrismMTBDD.Prob0A(jDDNode2, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode3, jDDNode7);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode3);
                JDD.Ref(jDDNode4);
                jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode3, jDDNode4)));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode7);
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode7, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()) + "\n");
        if (jDDNode5.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode7);
            stateValues = new StateValuesMTBDD(jDDNode7, this.model);
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode8 = PrismMTBDD.NondetBoundedUntil(jDDNode, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesMTBDD(jDDNode8, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = PrismSparse.NondetBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        DoubleVector doubleVector = PrismHybrid.NondetBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5, n, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                JDD.Deref(jDDNode5);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode5);
        return stateValues;
    }

    protected StateValues computeUntilProbsQual(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) {
        JDDNode jDDNode4;
        JDDNode jDDNode5 = null;
        JDDNode jDDNode6 = null;
        StateValuesMTBDD stateValuesMTBDD = null;
        if (jDDNode3.equals(JDD.ZERO)) {
            jDDNode5 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode6 = this.reach;
            jDDNode4 = JDD.Constant(0.0);
        } else if (jDDNode2.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode3);
            jDDNode5 = jDDNode3;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode3);
            jDDNode6 = JDD.And(this.reach, JDD.Not(jDDNode3));
            jDDNode4 = JDD.Constant(0.0);
        } else {
            if (bl) {
                jDDNode6 = PrismMTBDD.Prob0E(jDDNode, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3);
                jDDNode5 = PrismMTBDD.Prob1A(jDDNode, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode3);
            } else {
                jDDNode6 = PrismMTBDD.Prob0A(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3);
                jDDNode5 = PrismMTBDD.Prob1E(jDDNode, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode2, jDDNode3, jDDNode6);
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode6);
            jDDNode4 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode5, jDDNode6)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode4, this.allDDRowVars.n()) + "\n");
        if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            stateValuesMTBDD = new StateValuesMTBDD(jDDNode5, this.model);
        } else {
            JDD.Ref(jDDNode5);
            JDD.Ref(jDDNode4);
            stateValuesMTBDD = new StateValuesMTBDD(JDD.Apply(1, jDDNode5, JDD.Apply(3, jDDNode4, JDD.Constant(0.5))), this.model);
        }
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode4);
        return stateValuesMTBDD;
    }

    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, boolean bl) throws PrismException {
        JDDNode jDDNode6;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        Object object;
        Object object2;
        StateValues stateValues = null;
        boolean bl2 = this.getSettings().getBoolean("prism.pmaxQuotient");
        if (this.doIntervalIteration) {
            if (!(this.precomp && this.prob0 && this.prob1)) {
                throw new PrismNotSupportedException("Precomputations (Prob0 & Prob1) must be enabled for interval iteration");
            }
            if (!bl) {
                bl2 = true;
            }
        }
        if (bl2 && bl) {
            bl2 = false;
        }
        if (!(!bl2 || this.precomp && this.prob0 && this.prob1)) {
            throw new PrismNotSupportedException("Precomputations (Prob0 & Prob1) must be enabled for -pmaxquotient setting");
        }
        if (this.prism.getExportTarget()) {
            object2 = new JDDNode[]{this.model.getStart(), jDDNode5};
            object = new String[]{"init", "target"};
            try {
                this.mainLog.println("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                PrismMTBDD.ExportLabels((JDDNode[])object2, (String[])object, "l", this.model.getAllDDRowVars(), this.model.getODD(), 1, this.prism.getExportTargetFilename());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
            }
        }
        if (jDDNode5.equals(JDD.ZERO)) {
            jDDNode8 = JDD.Constant(0.0);
            JDD.Ref(this.reach);
            jDDNode7 = this.reach;
            jDDNode6 = JDD.Constant(0.0);
        } else if (jDDNode4.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode5);
            jDDNode8 = jDDNode5;
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode5);
            jDDNode7 = JDD.And(this.reach, JDD.Not(jDDNode5));
            jDDNode6 = JDD.Constant(0.0);
        } else {
            if (this.precomp && (this.prob0 || this.prob1)) {
                jDDNode7 = bl ? PrismMTBDD.Prob0E(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5) : PrismMTBDD.Prob0A(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5);
            } else {
                JDD.Ref(this.reach);
                JDD.Ref(jDDNode4);
                JDD.Ref(jDDNode5);
                jDDNode7 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode4, jDDNode5)));
            }
            if (this.precomp && this.prob1) {
                jDDNode8 = bl ? PrismMTBDD.Prob1A(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode7, jDDNode5) : PrismMTBDD.Prob1E(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode4, jDDNode5, jDDNode7);
            } else {
                JDD.Ref(jDDNode5);
                jDDNode8 = jDDNode5;
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode8);
            JDD.Ref(jDDNode7);
            jDDNode6 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode8, jDDNode7)));
        }
        this.mainLog.print("\nyes = " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        this.mainLog.print(", no = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()) + "\n");
        if (jDDNode6.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode8);
            stateValues = new StateValuesMTBDD(jDDNode8, this.model);
        } else {
            this.mainLog.println("\nComputing remaining probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            try {
                Object object3;
                Object object4;
                object2 = null;
                object = null;
                JDDNode jDDNode9 = null;
                JDDNode jDDNode10 = null;
                if (bl2) {
                    if (!(jDDNode.equals(this.model.getTrans()) && jDDNode2.equals(this.model.getTransActions()) && jDDNode3.equals(this.model.getTrans01()))) {
                        throw new PrismException("Can currently not compute MEC quotient for changed functions");
                    }
                    this.mainLog.println("\nBuilding quotient MDP, collapsing maximal end components as well as yes and no states...");
                    object4 = new StopWatch(this.mainLog);
                    ((StopWatch)object4).start("computing maximal end components");
                    object3 = ECComputer.createECComputer(this, this.model);
                    ((ECComputer)object3).computeMECStates(jDDNode6);
                    ((StopWatch)object4).stop("found " + ((ECComputer)object3).getMECStates().size() + " MECs");
                    ArrayList<JDDNode> arrayList = new ArrayList<JDDNode>(((ECComputer)object3).getMECStates());
                    arrayList.add(jDDNode8.copy());
                    arrayList.add(jDDNode7.copy());
                    StopWatch stopWatch = new StopWatch(this.mainLog);
                    stopWatch.start("building MEC quotient");
                    object2 = MDPQuotient.transform(this, this.model, arrayList, this.model.getReach().copy());
                    stopWatch.stop();
                    object = ((MDPQuotient)object2).getTransformedModel();
                    this.mainLog.println("\nQuotient MDP:");
                    ((ProbModel)object).printTransInfo(this.mainLog);
                    jDDNode9 = ((MDPQuotient)object2).mapStateSetToQuotient(jDDNode8.copy());
                    jDDNode10 = ((MDPQuotient)object2).mapStateSetToQuotient(jDDNode6.copy());
                }
                switch (this.engine) {
                    case 1: {
                        JDDNode jDDNode11 = this.doIntervalIteration ? (object2 != null ? PrismMTBDD.NondetUntilInterval(((ProbModel)object).getTrans(), ((ProbModel)object).getODD(), ((NondetModel)object).getNondetMask(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl, this.prism.getIntervalIterationFlags()) : PrismMTBDD.NondetUntilInterval(jDDNode, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl, this.prism.getIntervalIterationFlags())) : (object2 != null ? PrismMTBDD.NondetUntil(((ProbModel)object).getTrans(), ((ProbModel)object).getODD(), ((NondetModel)object).getNondetMask(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl) : PrismMTBDD.NondetUntil(jDDNode, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl));
                        stateValues = new StateValuesMTBDD(jDDNode11, this.model);
                        break;
                    }
                    case 2: {
                        object4 = null;
                        if (this.genStrat) {
                            object3 = JDD.ITE(jDDNode8.copy(), JDD.Constant(-2.0), JDD.Constant(-1.0));
                            object3 = JDD.Times((JDDNode)object3, this.reach.copy());
                            object4 = new IntegerVector((JDDNode)object3, this.allDDRowVars, this.odd);
                            JDD.Deref((JDDNode)object3);
                        }
                        if (this.doIntervalIteration) {
                            if (object2 != null) {
                                if (object4 != null) {
                                    ((IntegerVector)object4).clear();
                                    object4 = null;
                                }
                                DoubleVector doubleVector = PrismSparse.NondetUntilInterval(((ProbModel)object).getTrans(), ((ProbModel)object).getTransActions(), ((ProbModel)object).getSynchs(), ((ProbModel)object).getODD(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl, (IntegerVector)object4, this.prism.getIntervalIterationFlags());
                                stateValues = new StateValuesDV(doubleVector, (Model)object);
                            } else {
                                DoubleVector doubleVector = PrismSparse.NondetUntilInterval(jDDNode, jDDNode2, this.model.getSynchs(), this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl, (IntegerVector)object4, this.prism.getIntervalIterationFlags());
                                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                            }
                        } else if (object2 != null) {
                            if (object4 != null) {
                                ((IntegerVector)object4).clear();
                                object4 = null;
                            }
                            DoubleVector doubleVector = PrismSparse.NondetUntil(((ProbModel)object).getTrans(), ((ProbModel)object).getTransActions(), ((ProbModel)object).getSynchs(), ((ProbModel)object).getODD(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl, (IntegerVector)object4);
                            stateValues = new StateValuesDV(doubleVector, (Model)object);
                        } else {
                            DoubleVector doubleVector = PrismSparse.NondetUntil(jDDNode, jDDNode2, this.model.getSynchs(), this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl, (IntegerVector)object4);
                            stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        }
                        if (!this.genStrat || object4 == null) break;
                        this.result.setStrategy(new MDStrategyIV(this.model, (IntegerVector)object4));
                        break;
                    }
                    case 3: {
                        if (this.doIntervalIteration) {
                            if (object2 != null) {
                                DoubleVector doubleVector = PrismHybrid.NondetUntilInterval(((ProbModel)object).getTrans(), ((ProbModel)object).getODD(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl, this.prism.getIntervalIterationFlags());
                                stateValues = new StateValuesDV(doubleVector, (Model)object);
                                break;
                            }
                            DoubleVector doubleVector = PrismHybrid.NondetUntilInterval(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl, this.prism.getIntervalIterationFlags());
                            stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                            break;
                        }
                        if (object2 != null) {
                            DoubleVector doubleVector = PrismHybrid.NondetUntil(((ProbModel)object).getTrans(), ((ProbModel)object).getODD(), ((ProbModel)object).getAllDDRowVars(), ((ProbModel)object).getAllDDColVars(), ((NondetModel)object).getAllDDNondetVars(), jDDNode9, jDDNode10, bl);
                            stateValues = new StateValuesDV(doubleVector, (Model)object);
                            break;
                        }
                        DoubleVector doubleVector = PrismHybrid.NondetUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode8, jDDNode6, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
                if (object2 != null) {
                    stateValues = ((MDPQuotient)object2).projectToOriginalModel(stateValues);
                    ((MDPQuotient)object2).clear();
                    JDD.Deref(jDDNode9, jDDNode10);
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode8);
                JDD.Deref(jDDNode7);
                JDD.Deref(jDDNode6);
                throw prismException;
            }
        }
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode6);
        return stateValues;
    }

    protected StateValues computeCumulRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, int n, boolean bl) throws PrismException {
        StateValuesDV stateValuesDV = null;
        int n2 = this.engine;
        this.mainLog.println("\nComputing rewards...");
        if (n2 == 3) {
            this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
            n2 = 2;
        }
        this.mainLog.println("Engine: " + Prism.getEngineString(n2));
        switch (n2) {
            case 1: {
                throw new PrismNotSupportedException("MTBDD engine does not yet support this type of property (use the sparse engine instead)");
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.NondetCumulReward(jDDNode, jDDNode2, jDDNode3, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl);
                stateValuesDV = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                throw new PrismNotSupportedException("Hybrid engine does not yet support this type of property (use the sparse engine instead)");
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValuesDV;
    }

    protected StateValues computeTotalRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismNotSupportedException("Expected minimum total reward (C) is not yet supported for MDPs.");
        }
        return this.computeTotalRewardsMax(jDDNode, jDDNode2, jDDNode3, jDDNode4, jDDNode5, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected StateValues computeTotalRewardsMax(JDDNode var1_1, JDDNode var2_2, JDDNode var3_3, JDDNode var4_4, JDDNode var5_5, boolean var6_6) throws PrismException {
        var11_7 /* !! */  = null;
        var12_8 = this.engine;
        if (this.doIntervalIteration) {
            throw new PrismNotSupportedException("Interval iteration for total rewards is currently not supported");
        }
        this.mainLog.println("\nStarting total expected reward (max)...");
        var13_9 = System.currentTimeMillis();
        if (var6_6) {
            var7_10 = JDD.Constant(0.0);
            var8_11 = this.reach.copy();
        } else {
            this.mainLog.println("Precomputation: Find positive end components...");
            var15_12 = System.currentTimeMillis();
            var17_13 = JDD.GreaterThan(var4_4.copy(), 0.0);
            var18_14 = JDD.GreaterThan(var5_5.copy(), 0.0);
            var19_15 = new ECComputerDefault(this.prism, this.reach, this.trans, this.trans01, this.model.getAllDDRowVars(), this.model.getAllDDColVars(), this.model.getAllDDNondetVars());
            var19_15.computeMECStates();
            var20_16 = JDD.Constant(0.0);
            for (JDDNode var22_18 : var19_15.getMECStates()) {
                var23_19 = false;
                if (JDD.AreIntersecting(var22_18, var17_13)) {
                    var23_19 = true;
                } else {
                    var24_20 = var19_15.getStableTransitions(var22_18.copy());
                    if (JDD.AreIntersecting(var24_20, var18_14)) {
                        var23_19 = true;
                    }
                    JDD.Deref(var24_20);
                }
                if (var23_19) {
                    var20_16 = JDD.Or(var20_16, var22_18.copy());
                }
                JDD.Deref(var22_18);
            }
            JDD.Deref(new JDDNode[]{var17_13, var18_14});
            var8_11 = PrismMTBDD.Prob0A(this.trans01, this.reach, this.model.getAllDDRowVars(), this.model.getAllDDColVars(), this.model.getAllDDNondetVars(), this.reach, var20_16);
            var7_10 = JDD.And(this.reach.copy(), JDD.Not(var8_11.copy()));
            JDD.Deref(var20_16);
            var15_12 = System.currentTimeMillis() - var15_12;
            this.mainLog.print("Total expected reward precomputation took " + (double)var15_12 / 1000.0 + " seconds, ");
            this.mainLog.print(JDD.GetNumMintermsString(var7_10, this.allDDRowVars.n()) + " infinite states, ");
            this.mainLog.println(JDD.GetNumMintermsString(var8_11, this.allDDRowVars.n()) + " states remaining.");
        }
        if (var8_11.equals(JDD.ZERO)) {
            var11_7 /* !! */  = new StateValuesMTBDD(JDD.ITE(var7_10.copy(), JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
            JDD.Deref(new JDDNode[]{var8_11, var7_10});
        } else {
            this.mainLog.println("\nComputing remaining total rewards...");
            if (var12_8 == 3) {
                this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
                var12_8 = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(var12_8));
            try {
                switch (var12_8) {
                    case 1: {
                        var9_21 = PrismMTBDD.NondetReachReward(var1_1, var4_4, var5_5, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, JDD.ZERO, var7_10, var8_11, false);
                        var11_7 /* !! */  = new StateValuesMTBDD(var9_21, this.model);
                        ** break;
lbl54:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        var10_22 = PrismSparse.NondetReachReward(var1_1, var3_3, this.model.getSynchs(), var4_4, var5_5, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, JDD.ZERO, var7_10, var8_11, false);
                        var11_7 /* !! */  = new StateValuesDV(var10_22, (Model)this.model);
                        ** break;
lbl59:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        throw new PrismNotSupportedException("Hybrid engine does not yet support this type of property (use sparse or MTBDD engine instead)");
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            finally {
                JDD.Deref(var7_10);
                JDD.Deref(var8_11);
            }
        }
        var13_9 = System.currentTimeMillis() - var13_9;
        this.mainLog.println("Time for total reward computation: " + (double)var13_9 / 1000.0 + " seconds.");
        return var11_7 /* !! */ ;
    }

    protected StateValues computeInstRewards(JDDNode jDDNode, JDDNode jDDNode2, int n, boolean bl) throws PrismException {
        StateValues stateValues = null;
        int n2 = this.engine;
        if (n == 0) {
            JDD.Ref(jDDNode2);
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
        } else {
            this.mainLog.println("\nComputing rewards...");
            if (n2 == 3) {
                this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
                n2 = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(n2));
            switch (n2) {
                case 1: {
                    JDDNode jDDNode3 = PrismMTBDD.NondetInstReward(jDDNode, jDDNode2, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl, this.start);
                    stateValues = new StateValuesMTBDD(jDDNode3, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = PrismSparse.NondetInstReward(jDDNode, jDDNode2, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, n, bl, this.start);
                    stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                    break;
                }
                case 3: {
                    throw new PrismException("Hybrid engine does not yet support this type of property (use sparse or MTBDD engine instead)");
                }
                default: {
                    throw new PrismException("Unknown engine");
                }
            }
        }
        return stateValues;
    }

    protected StateValues computeReachRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6, boolean bl) throws PrismException {
        double d;
        Object object;
        JDDNode jDDNode7;
        JDDNode jDDNode8;
        Object object2;
        Object object3;
        StateValues stateValues = null;
        int n = this.engine;
        List<JDDNode> list = null;
        if (this.doIntervalIteration && bl) {
            throw new PrismNotSupportedException("Currently, Rmin is not supported with interval iteration and the symbolic engines");
        }
        if (this.prism.getExportTarget()) {
            object3 = new JDDNode[]{this.model.getStart(), jDDNode6};
            object2 = new String[]{"init", "target"};
            try {
                this.mainLog.println("\nExporting target states info to file \"" + this.prism.getExportTargetFilename() + "\"...");
                PrismMTBDD.ExportLabels(object3, object2, "l", this.model.getAllDDRowVars(), this.model.getODD(), 1, this.prism.getExportTargetFilename());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.printWarning("Could not export target to file \"" + this.prism.getExportTargetFilename() + "\"");
            }
        }
        if (jDDNode6.equals(JDD.ZERO)) {
            JDD.Ref(this.reach);
            jDDNode8 = this.reach;
            jDDNode7 = JDD.Constant(0.0);
        } else if (jDDNode6.equals(this.reach)) {
            jDDNode8 = JDD.Constant(0.0);
            jDDNode7 = JDD.Constant(0.0);
        } else {
            JDDNode jDDNode9;
            JDDNode jDDNode10;
            if (!bl) {
                jDDNode10 = PrismMTBDD.Prob0E(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6);
                jDDNode9 = PrismMTBDD.Prob1A(jDDNode3, this.reach, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode10, jDDNode6);
                JDD.Deref(jDDNode10);
                JDD.Ref(this.reach);
                jDDNode8 = JDD.And(this.reach, JDD.Not(jDDNode9));
            } else {
                if (this.prism.getCheckZeroLoops()) {
                    JDD.Ref(jDDNode4);
                    JDD.Ref(this.reach);
                    object3 = JDD.And(this.reach, JDD.Apply(7, jDDNode4, JDD.Constant(0.0)));
                    JDD.Ref(jDDNode6);
                    object3 = JDD.And((JDDNode)object3, JDD.Not(jDDNode6));
                    JDD.Ref(jDDNode5);
                    object2 = JDD.Apply(7, jDDNode5, JDD.Constant(0.0));
                    JDD.Ref(this.trans);
                    JDD.Ref((JDDNode)object2);
                    object = JDD.And(this.trans, (JDDNode)object2);
                    JDD.Ref(this.trans01);
                    JDDNode jDDNode11 = JDD.And(this.trans01, (JDDNode)object2);
                    ECComputerDefault eCComputerDefault = new ECComputerDefault(this.prism, (JDDNode)object3, (JDDNode)object, jDDNode11, this.model.getAllDDRowVars(), this.model.getAllDDColVars(), this.model.getAllDDNondetVars());
                    ((ECComputer)eCComputerDefault).computeMECStates();
                    list = eCComputerDefault.getMECStates();
                    JDD.Deref((JDDNode)object3);
                    JDD.Deref(object);
                    JDD.Deref(jDDNode11);
                }
                jDDNode10 = PrismMTBDD.Prob0A(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6);
                jDDNode9 = PrismMTBDD.Prob1E(jDDNode3, this.reach, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.reach, jDDNode6, jDDNode10);
                JDD.Deref(jDDNode10);
                JDD.Ref(this.reach);
                jDDNode8 = JDD.And(this.reach, JDD.Not(jDDNode9));
            }
            JDD.Ref(this.reach);
            JDD.Ref(jDDNode8);
            JDD.Ref(jDDNode6);
            jDDNode7 = JDD.And(this.reach, JDD.Not(JDD.Or(jDDNode8, jDDNode6)));
        }
        if (this.prism.getCheckZeroLoops()) {
            if (bl && list != null && list.size() > 0) {
                this.mainLog.printWarning("PRISM detected your model contains " + list.size() + " zero-reward " + (list.size() == 1 ? "loop." : "loops.\n") + "Your minimum rewards may be too low...");
            }
        } else if (bl) {
            this.mainLog.printWarning("PRISM hasn't checked for zero-reward loops.\nYour minimum rewards may be too low...");
        }
        this.mainLog.print("\ngoal = " + JDD.GetNumMintermsString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.print(", inf = " + JDD.GetNumMintermsString(jDDNode8, this.allDDRowVars.n()));
        this.mainLog.print(", maybe = " + JDD.GetNumMintermsString(jDDNode7, this.allDDRowVars.n()) + "\n");
        object3 = null;
        object2 = null;
        if (jDDNode7.equals(JDD.ZERO)) {
            JDD.Ref(jDDNode8);
            stateValues = new StateValuesMTBDD(JDD.ITE(jDDNode8, JDD.PlusInfinity(), JDD.Constant(0.0)), this.model);
        } else {
            if (this.doIntervalIteration) {
                double d2;
                double d3;
                object = OptionsIntervalIteration.from(this);
                if (((OptionsIntervalIteration)object).hasManualUpperBound()) {
                    d3 = ((OptionsIntervalIteration)object).getManualUpperBound();
                    this.getLog().printWarning("Upper bound for interval iteration manually set to " + d3);
                } else {
                    d3 = ProbModelChecker.computeReachRewardsUpperBound(this, this.model, jDDNode, jDDNode4, jDDNode5, jDDNode6, jDDNode7);
                }
                object2 = JDD.ITE(jDDNode7.copy(), JDD.Constant(d3), JDD.Constant(0.0));
                if (((OptionsIntervalIteration)object).hasManualLowerBound()) {
                    d2 = ((OptionsIntervalIteration)object).getManualLowerBound();
                    this.getLog().printWarning("Lower bound for interval iteration manually set to " + d2);
                } else {
                    d2 = 0.0;
                }
                object3 = JDD.ITE(jDDNode7.copy(), JDD.Constant(d2), JDD.Constant(0.0));
            }
            this.mainLog.println("\nComputing remaining rewards...");
            if (n == 3) {
                this.mainLog.println("Switching engine since hybrid engine does yet support this computation...");
                n = 2;
            }
            this.mainLog.println("Engine: " + Prism.getEngineString(n));
            try {
                switch (n) {
                    case 1: {
                        JDDNode jDDNode12 = this.doIntervalIteration ? PrismMTBDD.NondetReachRewardInterval(jDDNode, jDDNode4, jDDNode5, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, (JDDNode)object3, (JDDNode)object2, bl, this.prism.getIntervalIterationFlags()) : PrismMTBDD.NondetReachReward(jDDNode, jDDNode4, jDDNode5, this.odd, this.nondetMask, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, bl);
                        stateValues = new StateValuesMTBDD(jDDNode12, this.model);
                        break;
                    }
                    case 2: {
                        DoubleVector doubleVector = this.doIntervalIteration ? PrismSparse.NondetReachRewardInterval(jDDNode, jDDNode2, this.model.getSynchs(), jDDNode4, jDDNode5, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, (JDDNode)object3, (JDDNode)object2, bl, this.prism.getIntervalIterationFlags()) : PrismSparse.NondetReachReward(jDDNode, jDDNode2, this.model.getSynchs(), jDDNode4, jDDNode5, this.odd, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, jDDNode6, jDDNode8, jDDNode7, bl);
                        stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                        break;
                    }
                    case 3: {
                        throw new PrismException("Hybrid engine does not yet support this type of property (use sparse or MTBDD engine instead)");
                    }
                    default: {
                        throw new PrismException("Unknown engine");
                    }
                }
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode8);
                JDD.Deref(jDDNode7);
                if (object3 != null) {
                    JDD.Deref((JDDNode)object3);
                }
                if (object2 != null) {
                    JDD.Deref((JDDNode)object2);
                }
                throw prismException;
            }
        }
        if (list != null) {
            for (JDDNode jDDNode11 : list) {
                JDD.Deref(jDDNode11);
            }
        }
        if (this.doIntervalIteration && (d = stateValues.maxFiniteOverBDD(jDDNode7)) != Double.NEGATIVE_INFINITY) {
            this.mainLog.println("Maximum finite value in solution vector at end of interval iteration: " + d);
        }
        JDD.Deref(jDDNode8);
        JDD.Deref(jDDNode7);
        if (object3 != null) {
            JDD.Deref((JDDNode)object3);
        }
        if (object2 != null) {
            JDD.Deref((JDDNode)object2);
        }
        return stateValues;
    }

    private boolean checkWeakAbsorbing(JDDNode jDDNode, NondetModel nondetModel) {
        JDD.Ref(nondetModel.getTrans01());
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.And(nondetModel.getTrans01(), jDDNode);
        jDDNode2 = JDD.SwapVariables(jDDNode2, nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
        jDDNode2 = JDD.ThereExists(jDDNode2, nondetModel.getAllDDNondetVars());
        jDDNode2 = JDD.ThereExists(jDDNode2, nondetModel.getAllDDColVars());
        JDD.Ref(nondetModel.getReach());
        jDDNode2 = JDD.And(nondetModel.getReach(), jDDNode2);
        JDD.Ref(jDDNode);
        jDDNode2 = JDD.And(jDDNode2, JDD.Not(jDDNode));
        boolean bl = jDDNode2.equals(JDD.ZERO);
        JDD.Deref(jDDNode2);
        return bl;
    }
}

