/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Collections;
import java.util.List;
import parser.Values;
import parser.VarList;
import parser.type.Type;
import prism.ModelType;
import prism.PrismException;

public interface ModelInfo {
    public ModelType getModelType();

    default public void setSomeUndefinedConstants(Values values) throws PrismException {
        if (values != null && values.getNumValues() > 0) {
            throw new PrismException("This model has no constants to set");
        }
    }

    default public void setSomeUndefinedConstants(Values values, boolean bl) throws PrismException {
        if (bl) {
            throw new PrismException("This model can not set constants in exact mode");
        }
        this.setSomeUndefinedConstants(values);
    }

    default public Values getConstantValues() {
        return new Values();
    }

    default public boolean containsUnboundedVariables() {
        return false;
    }

    default public int getNumVars() {
        return this.getVarNames().size();
    }

    public List<String> getVarNames();

    default public int getVarIndex(String string) {
        return this.getVarNames().indexOf(string);
    }

    default public String getVarName(int n) {
        return this.getVarNames().get(n);
    }

    public List<Type> getVarTypes();

    default public Type getVarType(int n) throws PrismException {
        return this.getVarTypes().get(n);
    }

    default public String getActionStringDescription() {
        return "Action";
    }

    default public int getNumLabels() {
        return this.getLabelNames().size();
    }

    default public List<String> getLabelNames() {
        return Collections.emptyList();
    }

    default public String getLabelName(int n) throws PrismException {
        try {
            return this.getLabelNames().get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PrismException("Label number " + n + " not defined");
        }
    }

    default public int getLabelIndex(String string) {
        return this.getLabelNames().indexOf(string);
    }

    public VarList createVarList() throws PrismException;
}

