/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.RewardGenerator;

public class ExplicitFiles2ModelInfo
extends PrismComponent {
    private int numVars;
    private List<String> varNames;
    private List<Type> varTypes;
    private VarList varList;
    private List<String> labelNames;
    private int numStates = 0;

    public ExplicitFiles2ModelInfo(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public int getNumStates() {
        return this.numStates;
    }

    public ModelInfo buildModelInfo(File file, File file2, File file3, ModelType modelType) throws PrismException {
        ModelType modelType2;
        Object object;
        if (file != null) {
            this.extractVarInfoFromStatesFile(file);
        } else {
            this.extractVarInfoFromTransFile(file2);
        }
        if (file3 != null) {
            this.extractLabelNamesFromLabelsFile(file3);
        }
        if (modelType == null) {
            object = this.autodetectModelType(file2);
            if (object != null) {
                this.mainLog.println("Auto-detected model type: " + object);
            } else {
                object = ModelType.MDP;
                this.mainLog.println("Assuming default model type: " + object);
            }
            modelType2 = object;
        } else {
            this.mainLog.println("Using specified model type: " + modelType);
            modelType2 = modelType;
        }
        object = new ModelInfo(){

            @Override
            public ModelType getModelType() {
                return modelType2;
            }

            @Override
            public List<String> getVarNames() {
                return ExplicitFiles2ModelInfo.this.varNames;
            }

            @Override
            public List<Type> getVarTypes() {
                return ExplicitFiles2ModelInfo.this.varTypes;
            }

            @Override
            public VarList createVarList() throws PrismException {
                return ExplicitFiles2ModelInfo.this.varList;
            }

            @Override
            public List<String> getLabelNames() {
                return ExplicitFiles2ModelInfo.this.labelNames;
            }
        };
        return object;
    }

    public RewardGenerator buildRewardInfo(File file) throws PrismException {
        if (file != null) {
            return new RewardGenerator(){

                @Override
                public List<String> getRewardStructNames() {
                    return Collections.singletonList("");
                }
            };
        }
        return new RewardGenerator(){};
    }

    private void extractVarInfoFromStatesFile(File file) throws PrismException {
        int n;
        int[] nArray;
        int[] nArray2;
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            n2 = 1;
            if (string == null) {
                throw new PrismException("empty states file");
            }
            if ((string = string.trim()).charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
                throw new PrismException("badly formatted state");
            }
            string = string.substring(1, string.length() - 1);
            this.varNames = new ArrayList<String>(Arrays.asList(string.split(",")));
            this.numVars = this.varNames.size();
            nArray2 = new int[this.numVars];
            nArray = new int[this.numVars];
            int[] nArray3 = new int[this.numVars];
            this.varTypes = new ArrayList<Type>();
            string = bufferedReader.readLine();
            ++n2;
            this.numStates = 0;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    ++this.numStates;
                    String[] stringArray = (string = string.substring(string.indexOf(40) + 1, string.indexOf(41))).split(",");
                    if (stringArray.length != this.numVars) {
                        throw new PrismException("wrong number of variables");
                    }
                    for (n = 0; n < this.numVars; ++n) {
                        if (this.numStates == 1) {
                            if (stringArray[n].equals("true") || stringArray[n].equals("false")) {
                                this.varTypes.add(TypeBool.getInstance());
                            } else {
                                this.varTypes.add(TypeInt.getInstance());
                            }
                        }
                        if (!(this.varTypes.get(n) instanceof TypeInt)) continue;
                        int n3 = Integer.parseInt(stringArray[n]);
                        if (this.numStates == 1) {
                            nArray2[n] = nArray[n] = n3;
                            continue;
                        }
                        if (n3 < nArray2[n]) {
                            nArray2[n] = n3;
                        }
                        if (n3 <= nArray[n]) continue;
                        nArray[n] = n3;
                    }
                }
                string = bufferedReader.readLine();
                ++n2;
            }
            for (n = 0; n < this.numVars; ++n) {
                if (!(this.varTypes.get(n) instanceof TypeInt)) continue;
                nArray3[n] = nArray[n] - nArray2[n];
                if (nArray3[n] != 0) continue;
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n2 + " of states file \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n2 + " of states file \"" + file + "\"");
        }
        this.varList = new VarList();
        for (n = 0; n < this.numVars; ++n) {
            Declaration declaration;
            DeclarationType declarationType;
            if (this.varTypes.get(n) instanceof TypeInt) {
                declarationType = new DeclarationInt(Expression.Int(nArray2[n]), Expression.Int(nArray[n]));
                declaration = new Declaration(this.varNames.get(n), declarationType);
                declaration.setStart(Expression.Int(nArray2[n]));
            } else {
                declarationType = new DeclarationBool();
                declaration = new Declaration(this.varNames.get(n), declarationType);
                declaration.setStart(Expression.False());
            }
            this.varList.addVar(declaration, -1, null);
        }
    }

    private void extractVarInfoFromTransFile(File file) throws PrismException {
        Object object;
        Object object2;
        try {
            object2 = new BufferedReader(new FileReader(file));
            try {
                object = ((BufferedReader)object2).readLine();
                if (object == null) {
                    throw new PrismException("empty transitions file");
                }
                String[] stringArray = ((String)(object = ((String)object).trim())).split(" ");
                if (stringArray.length < 2) {
                    throw new PrismException("");
                }
                this.numStates = Integer.parseInt(stringArray[0]);
            }
            finally {
                ((BufferedReader)object2).close();
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line 1 of transition matrix file \"" + file + "\"");
        }
        this.varList = new VarList();
        object2 = new DeclarationInt(Expression.Int(0), Expression.Int(this.numStates - 1));
        object = new Declaration("x", (DeclarationType)object2);
        ((Declaration)object).setStart(Expression.Int(0));
        this.varList.addVar((Declaration)object, -1, null);
    }

    private void extractLabelNamesFromLabelsFile(File file) throws PrismException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            Pattern pattern = Pattern.compile("(\\d+)=\"([^\"]+)\"\\s*");
            Matcher matcher = pattern.matcher(string);
            this.labelNames = new ArrayList<String>();
            while (matcher.find()) {
                String string2 = matcher.group(2);
                if (string2.equals("init") || string2.equals("deadlock")) continue;
                if (!ExpressionIdent.isLegalIdentifierName(string2)) {
                    throw new PrismException("Illegal label name \"" + string2 + "\"");
                }
                if (this.labelNames.contains(string2)) {
                    throw new PrismException("Duplicate label \"" + string2 + "\"");
                }
                this.labelNames.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelType autodetectModelType(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            if (string == null) {
                ModelType modelType = null;
                return modelType;
            }
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length == 3) {
                ModelType modelType = ModelType.MDP;
                return modelType;
            }
            if (stringArray.length != 2) {
                ModelType modelType = null;
                return modelType;
            }
            int n = 5;
            string = bufferedReader.readLine();
            for (int i = 0; string != null && i < n; ++i) {
                stringArray = string.trim().split(" ");
                double d = Double.parseDouble(stringArray[2]);
                if (d > 1.0) {
                    ModelType modelType = ModelType.CTMC;
                    return modelType;
                }
                if (i == n) {
                    ModelType modelType = ModelType.DTMC;
                    return modelType;
                }
                string = bufferedReader.readLine();
            }
            ModelType modelType = null;
            return modelType;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

