/*
 * Decompiled with CFR 0.152.
 */
package parser.type;

import param.BigRational;
import parser.type.Type;
import parser.type.TypeInt;
import prism.PrismLangException;

public class TypeDouble
extends Type {
    private static TypeDouble singleton = new TypeDouble();

    private TypeDouble() {
    }

    public boolean equals(Object object) {
        return object instanceof TypeDouble;
    }

    @Override
    public String getTypeString() {
        return "double";
    }

    @Override
    public Object defaultValue() {
        return new Double(0.0);
    }

    public static TypeDouble getInstance() {
        return singleton;
    }

    @Override
    public boolean canAssign(Type type) {
        return type instanceof TypeDouble || type instanceof TypeInt;
    }

    @Override
    public Number castValueTo(Object object) throws PrismLangException {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigRational) {
            return (BigRational)object;
        }
        if (object instanceof Integer) {
            return new Double(((Integer)object).intValue());
        }
        throw new PrismLangException("Can't convert " + object.getClass() + " to type " + this.getTypeString());
    }

    @Override
    public Object castFromBigRational(BigRational bigRational) throws PrismLangException {
        return bigRational.doubleValue();
    }
}

