/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import param.BigRational;
import param.ParamResult;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeVoid;
import parser.visitor.ASTVisitor;
import prism.DefinedConstant;
import prism.Point;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.TileList;

public class Property
extends ASTElement {
    private Expression expr;
    private String name;
    private String comment;

    public Property(Expression expression) {
        this(expression, null, null);
    }

    public Property(Expression expression, String string) {
        this(expression, string, null);
    }

    public Property(Expression expression, String string, String string2) {
        this.expr = expression;
        this.name = string;
        this.comment = string2;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean checkAgainstExpectedResult(Object object) throws PrismException {
        return this.checkAgainstExpectedResult(object, null);
    }

    public boolean checkAgainstExpectedResult(Object object, Values values) throws PrismException {
        String string = this.getExpectedResultString(values);
        return this.checkAgainstExpectedResultString(string, values, object);
    }

    private String getExpectedResultString(Values values) throws PrismException {
        String string = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String[] stringArray;
                String string2 = matcher.group(2) == null ? "" : matcher.group(2);
                boolean bl = true;
                for (String string3 : stringArray = string2.split(",")) {
                    boolean bl2 = true;
                    if ((string3 = string3.trim()).length() == 0) continue;
                    String[] stringArray2 = string3.split("=");
                    if (stringArray2.length != 2) {
                        throw new PrismException("Badly formed RESULT specification \"" + matcher.group() + "\"");
                    }
                    String string4 = stringArray2[0].trim();
                    String string5 = stringArray2[1].trim();
                    Object object = values.getIndexOf(string4) == -1 ? null : values.getValueOf(string4);
                    bl2 = object == null ? false : (object instanceof Double ? PrismUtils.doublesAreCloseRel((Double)object, DefinedConstant.parseDouble(string5), 1.0E-10) : (object instanceof BigRational ? BigRational.from(string5).equals(object) : object.toString().equals(string5)));
                    bl &= bl2;
                }
                if (!bl) continue;
                string = matcher.group(3);
                break;
            }
        }
        if (string == null) {
            throw new PrismException("Did not find a RESULT specification (for " + values + ") to test against");
        }
        return string;
    }

    private String getExpectedResultString(String string) throws PrismException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        if (this.comment != null) {
            Pattern pattern = Pattern.compile("RESULT[ \t]*(\\(([^\\)]+)\\))?[ \t]*:[ \t]*([^ \t\n\r]+)");
            Matcher matcher = pattern.matcher(this.comment);
            while (matcher.find()) {
                String string3;
                String string4 = matcher.group(2) == null ? "" : matcher.group(2);
                if (hashMap.put(string4, string3 = matcher.group(3)) == null) continue;
                if (string4.length() == 0) {
                    throw new PrismException("Multiple RESULT specificiations for test");
                }
                throw new PrismException("Multiple RESULT (" + string4 + ") specificiations for test");
            }
        }
        if (hashMap.size() == 0) {
            throw new PrismException("Did not find any RESULT specifications to test against");
        }
        string2 = (String)hashMap.get(string);
        if (string2 == null) {
            throw new PrismException("Did not find a RESULT specification (for " + string + ") to test against");
        }
        return string2;
    }

    private boolean checkAgainstExpectedResultString(String string, Values values, Object object) throws PrismException {
        if (string.equals("?")) {
            return false;
        }
        if (object instanceof Exception) {
            String string2 = ((Exception)object).getMessage();
            if (string.startsWith("Error")) {
                if (string.startsWith("Error:")) {
                    String[] stringArray;
                    for (String string3 : stringArray = string.substring(6).split(",")) {
                        if (string3.length() == 0) {
                            throw new PrismException("Invalid RESULT specification: no expected words immediately following 'Error:'");
                        }
                        if (string2.toLowerCase().contains(string3)) continue;
                        throw new PrismException("Error message should contain \"" + string3 + "\"");
                    }
                }
                return true;
            }
            if (object instanceof PrismNotSupportedException) {
                throw (PrismNotSupportedException)object;
            }
            throw new PrismException("Unexpected error: " + string2);
        }
        if (string.startsWith("Error")) {
            throw new PrismException("Was expecting an error");
        }
        Type type = this.expr.getType();
        if (object instanceof ParamResult) {
            ParamResult paramResult = (ParamResult)object;
            return paramResult.test(type, string, values);
        }
        if (type instanceof TypeBool) {
            boolean bl;
            boolean bl2 = true;
            if ((string = string.toLowerCase()).equals("true")) {
                bl = true;
            } else if (string.equals("false")) {
                bl = false;
            } else {
                Expression expression = null;
                try {
                    expression = Prism.parseSingleExpressionString(string);
                    expression = (Expression)expression.findAllConstants(new ConstantList(values));
                    expression.typeCheck();
                    bl = expression.evaluateBoolean(values);
                    bl2 = false;
                }
                catch (PrismLangException prismLangException) {
                    throw new PrismException("Invalid RESULT specification \"" + string + "\" for boolean-valued property: " + prismLangException.getMessage());
                }
            }
            if (!(object instanceof Boolean)) {
                throw new PrismException("Result is wrong type for (boolean-valued) property");
            }
            boolean bl3 = (Boolean)object;
            if (bl3 != bl) {
                throw new PrismException("Wrong result (expected " + (String)(bl2 ? "" : string + " = ") + bl + ", got " + bl3 + ")");
            }
        } else if (type instanceof TypeInt && !(object instanceof BigRational)) {
            int n;
            boolean bl = true;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Expression expression = null;
                try {
                    expression = Prism.parseSingleExpressionString(string);
                    expression = (Expression)expression.findAllConstants(new ConstantList(values));
                    expression.typeCheck();
                    n = expression.evaluateInt(values);
                    bl = false;
                }
                catch (PrismLangException prismLangException) {
                    throw new PrismException("Invalid RESULT specification \"" + string + "\" for integer-valued property: " + prismLangException.getMessage());
                }
            }
            if (!(object instanceof Integer)) {
                throw new PrismException("Result is wrong type for (integer-valued) property");
            }
            int n2 = (Integer)object;
            if (n2 != n) {
                throw new PrismException("Wrong result (expected " + (String)(bl ? "" : string + " = ") + n + ", got " + n2 + ")");
            }
        } else if (type instanceof TypeDouble && !(object instanceof BigRational)) {
            double d;
            String string4;
            boolean bl = true;
            boolean bl4 = false;
            if (string.startsWith("~")) {
                bl4 = true;
                string4 = string.substring(1);
            } else {
                string4 = string;
            }
            try {
                if (string4.equals("NaN")) {
                    d = Double.NaN;
                } else if (string4.matches("[0-9]+/[0-9]+")) {
                    int n = Integer.parseInt(string4.substring(0, string4.indexOf(47)));
                    int n3 = Integer.parseInt(string4.substring(string4.indexOf(47) + 1));
                    d = (double)n / (double)n3;
                    bl = false;
                } else {
                    d = Double.parseDouble(string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Expression expression = null;
                try {
                    expression = Prism.parseSingleExpressionString(string4);
                    expression = (Expression)expression.findAllConstants(new ConstantList(values));
                    expression.typeCheck();
                    d = expression.evaluateDouble(values);
                    bl = false;
                }
                catch (PrismLangException prismLangException) {
                    throw new PrismException("Invalid RESULT specification \"" + string + "\" for double-valued property: " + prismLangException.getMessage());
                }
            }
            if (!(object instanceof Double)) {
                throw new PrismException("Result is wrong type (" + object.getClass() + ") for (double-valued) property");
            }
            double d2 = (Double)object;
            if (Double.isNaN(d2)) {
                if (!Double.isNaN(d)) {
                    throw new PrismException("Wrong result (expected " + (String)(bl ? "" : string + " = ") + d + ", got NaN)");
                }
            } else if (!PrismUtils.doublesAreCloseRel(d, d2, 1.0E-5)) {
                throw new PrismException("Wrong result (expected " + (String)(bl ? "" : string + " = ") + d + ", got " + d2 + ")");
            }
        } else if ((type instanceof TypeDouble || type instanceof TypeInt) && object instanceof BigRational) {
            String string5;
            BigRational bigRational = (BigRational)object;
            BigRational bigRational2 = null;
            boolean bl = false;
            if (string.startsWith("~")) {
                bl = true;
                string5 = string.substring(1);
            } else {
                string5 = string;
            }
            try {
                if (string5.equals("NaN")) {
                    if (!bigRational.isNaN()) {
                        throw new PrismException("Wrong result (expected NaN, got " + bigRational + ")");
                    }
                } else {
                    bigRational2 = new BigRational(string5);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Expression expression = null;
                try {
                    expression = Prism.parseSingleExpressionString(string5);
                    expression = (Expression)expression.findAllConstants(new ConstantList(values));
                    expression.typeCheck();
                    bigRational2 = expression.evaluateExact(values);
                }
                catch (PrismLangException prismLangException) {
                    throw new PrismException("Invalid RESULT specification \"" + string + "\" for rational-valued property: " + prismLangException.getMessage());
                }
            }
            if (!bigRational.equals(bigRational2)) {
                boolean bl5;
                block70: {
                    bl5 = false;
                    if (type instanceof TypeDouble) {
                        try {
                            double d = Double.parseDouble(string5);
                            boolean bl6 = PrismUtils.doublesAreCloseRel(d, bigRational.doubleValue(), 1.0E-5);
                            if (!bl6) break block70;
                            if (bl) {
                                bl5 = true;
                                break block70;
                            }
                            throw new PrismException("Inexact, but close result (expected '" + string + "' = " + bigRational2 + " (" + bigRational2.toApproximateString() + "), got " + bigRational + " (" + bigRational.toApproximateString() + "))");
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (!bl5) {
                    throw new PrismException("Wrong result (expected '" + string + "' = " + bigRational2 + " (" + bigRational2.toApproximateString() + "), got " + bigRational + " (" + bigRational.toApproximateString() + "))");
                }
            }
        } else if (type instanceof TypeVoid && object instanceof TileList) {
            boolean bl;
            ArrayList<Point> arrayList = new ArrayList<Point>();
            Pattern pattern = Pattern.compile("\\(([^,]*),([^)]*)\\)");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) {
                throw new PrismException("The expected result does not contain any points, or does not have the required format.");
            }
            do {
                double d = Double.parseDouble(matcher.group(1));
                double d3 = Double.parseDouble(matcher.group(2));
                Iterator iterator = new Point(new double[]{d, d3});
                arrayList.add((Point)((Object)iterator));
            } while (matcher.find());
            List<Point> list = ((TileList)object).getRealPoints();
            if (list.size() != arrayList.size()) {
                throw new PrismException("The expected Pareto curve and the computed Pareto curve have a different number of points.");
            }
            for (Point point : arrayList) {
                bl = false;
                for (Point point2 : list) {
                    if (!point2.isCloseTo(point)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new PrismException("The point " + point + " in the expected Pareto curve has no match among the points in the computed Pareto curve.");
            }
            for (Point point : list) {
                bl = false;
                for (Point point2 : arrayList) {
                    if (!point2.isCloseTo(point)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new PrismException("The point " + point + " in the computed Pareto curve has no match among the points in the expected Pareto curve");
            }
        } else {
            throw new PrismException("Don't know how to test properties of type " + type);
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        if (this.name != null) {
            object = (String)object + "\"" + this.name + "\": ";
        }
        object = (String)object + this.expr;
        return object;
    }

    @Override
    public Property deepCopy() {
        Property property = new Property(this.expr.deepCopy(), this.name, this.comment);
        property.setType(this.type);
        property.setPosition(this);
        return property;
    }
}

