/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import param.BigRational;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLiteral;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class ConstantList
extends ASTElement {
    private Vector<String> names = new Vector();
    private Vector<Expression> constants = new Vector();
    private Vector<Type> types = new Vector();
    private Vector<ExpressionIdent> nameIdents = new Vector();

    public ConstantList() {
    }

    public ConstantList(Values values) throws PrismLangException {
        for (int i = 0; i < values.getNumValues(); ++i) {
            Type type = values.getType(i);
            if (!(type.equals(TypeBool.getInstance()) || type.equals(TypeInt.getInstance()) || type.equals(TypeDouble.getInstance()))) {
                throw new PrismLangException("Unsupported type for constant " + values.getName(i));
            }
            this.addConstant(new ExpressionIdent(values.getName(i)), new ExpressionLiteral(type, values.getValue(i)), type);
        }
    }

    public void addConstant(ExpressionIdent expressionIdent, Expression expression, Type type) {
        this.names.addElement(expressionIdent.getName());
        this.constants.addElement(expression);
        this.types.addElement(type);
        this.nameIdents.addElement(expressionIdent);
    }

    public void setConstant(int n, Expression expression) {
        this.constants.setElementAt(expression, n);
    }

    public int size() {
        return this.constants.size();
    }

    public String getConstantName(int n) {
        return this.names.elementAt(n);
    }

    public Expression getConstant(int n) {
        return this.constants.elementAt(n);
    }

    public Type getConstantType(int n) {
        return this.types.elementAt(n);
    }

    public ExpressionIdent getConstantNameIdent(int n) {
        return this.nameIdents.elementAt(n);
    }

    public int getConstantIndex(String string) {
        return this.names.indexOf(string);
    }

    public void removeConstant(String string, boolean bl) throws PrismLangException {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            if (bl) {
                return;
            }
            throw new PrismLangException("Can not remove nonexistent constant: " + string);
        }
        this.removeConstant(n);
    }

    public void removeConstant(int n) {
        this.names.remove(n);
        this.constants.remove(n);
        this.types.remove(n);
        this.nameIdents.remove(n);
    }

    public void findCycles() throws PrismLangException {
        Object object;
        int n;
        int n2 = this.constants.size();
        boolean[][] blArray = new boolean[n2][n2];
        for (n = 0; n < n2; ++n) {
            object = this.getConstant(n);
            if (object == null) continue;
            Vector<String> vector = ((ASTElement)object).getAllConstants();
            for (int i = 0; i < vector.size(); ++i) {
                int n3 = this.getConstantIndex(vector.elementAt(i));
                if (n3 == -1) continue;
                blArray[n][n3] = true;
            }
        }
        n = PrismUtils.findCycle(blArray);
        if (n != -1) {
            object = "Cyclic dependency in definition of constant \"" + this.getConstantName(n) + "\"";
            throw new PrismLangException((String)object, this.getConstant(n));
        }
    }

    public int getNumUndefined() {
        int n = 0;
        int n2 = this.constants.size();
        for (int i = 0; i < n2; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            ++n;
        }
        return n;
    }

    public Vector<String> getUndefinedConstants() {
        Vector<String> vector = new Vector<String>();
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getConstant(i);
            if (expression != null) continue;
            vector.addElement(this.getConstantName(i));
        }
        return vector;
    }

    public boolean isDefinedConstant(String string) {
        int n = this.getConstantIndex(string);
        if (n == -1) {
            return false;
        }
        return this.getConstant(n) != null;
    }

    public Values evaluateConstants(Values values, Values values2) throws PrismLangException {
        return this.evaluateConstants(values, values2, false);
    }

    public Values evaluateConstants(Values values, Values values2, boolean bl) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(values, values2, true, bl);
    }

    public Values evaluateSomeConstants(Values values, Values values2) throws PrismLangException {
        return this.evaluateSomeConstants(values, values2, false);
    }

    public Values evaluateSomeConstants(Values values, Values values2, boolean bl) throws PrismLangException {
        return this.evaluateSomeOrAllConstants(values, values2, false, bl);
    }

    private Values evaluateSomeOrAllConstants(Values values, Values values2, boolean bl, boolean bl2) throws PrismLangException {
        Object object;
        Expression expression;
        int n;
        Type type = null;
        ConstantList constantList = new ConstantList();
        int n2 = this.constants.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            ExpressionIdent expressionIdent = this.getConstantNameIdent(n);
            expression = this.getConstant(n);
            type = this.getConstantType(n);
            if (expression != null) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), expression.deepCopy(), type);
                continue;
            }
            if (values != null && (n3 = values.getIndexOf(expressionIdent.getName())) != -1) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), new ExpressionLiteral(type, type.castValueTo(values.getValue(n3))), type);
                continue;
            }
            if (!bl) continue;
            throw new PrismLangException("No value specified for constant", expressionIdent);
        }
        int n4 = constantList.size();
        if (values2 != null) {
            n2 = values2.getNumValues();
            for (n = 0; n < n2; ++n) {
                object = values2.getType(n);
                constantList.addConstant(new ExpressionIdent(values2.getName(n)), new ExpressionLiteral((Type)object, ((Type)object).castValueTo(values2.getValue(n))), (Type)object);
            }
        }
        for (n = 0; n < n4; ++n) {
            try {
                expression = (Expression)constantList.getConstant(n).expandConstants(constantList);
                constantList.setConstant(n, expression);
                continue;
            }
            catch (PrismLangException prismLangException) {
                if (bl) {
                    throw prismLangException;
                }
                constantList.setConstant(n, null);
            }
        }
        Values values3 = new Values();
        for (n = 0; n < n4; ++n) {
            Object object2;
            object = constantList.getConstant(n);
            if (object == null) continue;
            if (bl2) {
                BigRational bigRational = ((Expression)object).evaluateExact(null, values2);
                object2 = ((ASTElement)object).getType() instanceof TypeDouble ? bigRational : ((ASTElement)object).getType().castFromBigRational(bigRational);
            } else {
                object2 = ((Expression)object).evaluate(null, values2);
            }
            values3.addValue(constantList.getConstantName(n), object2);
        }
        return values3;
    }

    public Map<String, Expression> evaluateConstantsPartially(Values values, Values values2) throws PrismLangException {
        Object object;
        Expression expression;
        int n;
        Type type = null;
        ConstantList constantList = new ConstantList();
        int n2 = this.constants.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            ExpressionIdent expressionIdent = this.getConstantNameIdent(n);
            expression = this.getConstant(n);
            type = this.getConstantType(n);
            if (expression != null) {
                constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), expression.deepCopy(), type);
                continue;
            }
            if (values == null || (n3 = values.getIndexOf(expressionIdent.getName())) == -1) continue;
            constantList.addConstant((ExpressionIdent)expressionIdent.deepCopy(), new ExpressionLiteral(type, type.castValueTo(values.getValue(n3))), type);
        }
        int n4 = constantList.size();
        if (values2 != null) {
            n2 = values2.getNumValues();
            for (n = 0; n < n2; ++n) {
                object = values2.getType(n);
                constantList.addConstant(new ExpressionIdent(values2.getName(n)), new ExpressionLiteral((Type)object, ((Type)object).castValueTo(values2.getValue(n))), (Type)object);
            }
        }
        for (n = 0; n < n4; ++n) {
            try {
                expression = (Expression)constantList.getConstant(n).expandConstants(constantList);
                constantList.setConstant(n, expression);
                continue;
            }
            catch (PrismLangException prismLangException) {
                constantList.setConstant(n, null);
            }
        }
        object = new HashMap();
        for (n = 0; n < n4; ++n) {
            if (constantList.getConstant(n) == null) continue;
            object.put(constantList.getConstantName(n), constantList.getConstant(n).deepCopy());
        }
        return object;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.constants.size();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "const ";
            object = (String)object + this.getConstantType(i).getTypeString() + " ";
            object = (String)object + this.getConstantName(i);
            Expression expression = this.getConstant(i);
            if (expression != null) {
                object = (String)object + " = " + expression;
            }
            object = (String)object + ";\n";
        }
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        ConstantList constantList = new ConstantList();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getConstant(i) == null ? null : this.getConstant(i).deepCopy();
            constantList.addConstant((ExpressionIdent)this.getConstantNameIdent(i).deepCopy(), expression, this.getConstantType(i));
        }
        constantList.setPosition(this);
        return constantList;
    }
}

