/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import parser.PrismParser;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.visitor.ASTTraverseModify;
import prism.PrismException;
import prism.PrismLangException;

public class BooleanUtils {
    public static void extractConjuncts(Expression expression, List<Expression> list) {
        if (Expression.isAnd(expression)) {
            BooleanUtils.extractConjuncts(((ExpressionBinaryOp)expression).getOperand1(), list);
            BooleanUtils.extractConjuncts(((ExpressionBinaryOp)expression).getOperand2(), list);
        } else {
            list.add(expression);
        }
    }

    public static void extractDisjuncts(Expression expression, List<Expression> list) {
        if (Expression.isAnd(expression)) {
            BooleanUtils.extractDisjuncts(((ExpressionBinaryOp)expression).getOperand1(), list);
            BooleanUtils.extractDisjuncts(((ExpressionBinaryOp)expression).getOperand2(), list);
        } else {
            list.add(expression);
        }
    }

    public static Expression convertToPositiveNormalForm(Expression expression) {
        return BooleanUtils.doConversionToPositiveNormalForm(BooleanUtils.removeImpliesIffAndParentheses(expression), false);
    }

    public static Expression convertLTLToPositiveNormalForm(Expression expression) {
        return BooleanUtils.doConversionToPositiveNormalForm(BooleanUtils.removeImpliesIffAndParentheses(expression), true);
    }

    private static Expression removeImpliesIffAndParentheses(Expression expression) {
        Expression expression2 = null;
        try {
            expression2 = (Expression)expression.accept(new ASTTraverseModify(){

                @Override
                public Object visit(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
                    if (Expression.isParenth(expressionUnaryOp)) {
                        Expression expression = (Expression)expressionUnaryOp.getOperand().accept(this);
                        return expression;
                    }
                    return super.visit(expressionUnaryOp);
                }

                @Override
                public Object visit(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
                    if (Expression.isImplies(expressionBinaryOp)) {
                        Expression expression = (Expression)expressionBinaryOp.getOperand1().accept(this);
                        Expression expression2 = (Expression)expressionBinaryOp.getOperand2().accept(this);
                        return Expression.Or(Expression.Not(expression), expression2);
                    }
                    if (Expression.isIff(expressionBinaryOp)) {
                        Expression expression = (Expression)expressionBinaryOp.getOperand1().accept(this);
                        Expression expression3 = (Expression)expressionBinaryOp.getOperand2().accept(this);
                        return Expression.And(Expression.Or(expression, Expression.Not(expression3)), Expression.Or(Expression.Not(expression.deepCopy()), expression3.deepCopy()));
                    }
                    return super.visit(expressionBinaryOp);
                }
            });
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
        return expression2;
    }

    private static Expression doConversionToPositiveNormalForm(Expression expression, boolean bl) {
        Expression expression2;
        if (Expression.isNot(expression)) {
            expression2 = ((ExpressionUnaryOp)expression).getOperand();
            if (Expression.isTrue(expression2)) {
                return new ExpressionLiteral(TypeBool.getInstance(), false);
            }
            if (Expression.isFalse(expression2)) {
                return new ExpressionLiteral(TypeBool.getInstance(), true);
            }
            if (Expression.isNot(expression2)) {
                Expression expression3 = ((ExpressionUnaryOp)expression2).getOperand();
                return BooleanUtils.doConversionToPositiveNormalForm(expression3, bl);
            }
            if (Expression.isOr(expression2)) {
                Expression expression4 = ((ExpressionBinaryOp)expression2).getOperand1();
                Expression expression5 = ((ExpressionBinaryOp)expression2).getOperand2();
                Expression expression6 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression4), bl);
                Expression expression7 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression5), bl);
                return Expression.And(expression6, expression7);
            }
            if (Expression.isAnd(expression2)) {
                Expression expression8 = ((ExpressionBinaryOp)expression2).getOperand1();
                Expression expression9 = ((ExpressionBinaryOp)expression2).getOperand2();
                Expression expression10 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression8), bl);
                Expression expression11 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression9), bl);
                return Expression.Or(expression10, expression11);
            }
            if (bl) {
                if (expression2 instanceof ExpressionTemporal) {
                    ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression2;
                    Expression expression12 = expressionTemporal.getOperand1();
                    Expression expression13 = expressionTemporal.getOperand2();
                    Expression expression14 = null;
                    Expression expression15 = null;
                    Expression expression16 = null;
                    Expression expression17 = null;
                    ExpressionTemporal expressionTemporal2 = null;
                    switch (expressionTemporal.getOperator()) {
                        case 1: {
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            return new ExpressionTemporal(1, null, expression15);
                        }
                        case 2: {
                            expression14 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression12), bl);
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            expressionTemporal2 = new ExpressionTemporal(6, expression14, expression15);
                            expressionTemporal2.setBoundsFrom(expressionTemporal);
                            return expressionTemporal2;
                        }
                        case 3: {
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            expressionTemporal2 = new ExpressionTemporal(4, null, expression15);
                            expressionTemporal2.setBoundsFrom(expressionTemporal);
                            return expressionTemporal2;
                        }
                        case 4: {
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            expressionTemporal2 = new ExpressionTemporal(3, null, expression15);
                            expressionTemporal2.setBoundsFrom(expressionTemporal);
                            return expressionTemporal2;
                        }
                        case 5: {
                            expression16 = BooleanUtils.doConversionToPositiveNormalForm(expression12.deepCopy(), bl);
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            expression14 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression12), bl);
                            expression17 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13.deepCopy()), bl);
                            expressionTemporal2 = new ExpressionTemporal(6, Expression.And(expression16, expression15), Expression.And(expression14, expression17));
                            expressionTemporal2.setBoundsFrom(expressionTemporal);
                            return expressionTemporal2;
                        }
                        case 6: {
                            expression14 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression12), bl);
                            expression15 = BooleanUtils.doConversionToPositiveNormalForm(Expression.Not(expression13), bl);
                            expressionTemporal2 = new ExpressionTemporal(2, expression14, expression15);
                            expressionTemporal2.setBoundsFrom(expressionTemporal);
                            return expressionTemporal2;
                        }
                    }
                    return expression;
                }
            } else {
                return expression;
            }
        }
        if (Expression.isAnd(expression)) {
            expression2 = BooleanUtils.doConversionToPositiveNormalForm(((ExpressionBinaryOp)expression).getOperand1(), bl);
            Expression expression18 = BooleanUtils.doConversionToPositiveNormalForm(((ExpressionBinaryOp)expression).getOperand2(), bl);
            return Expression.And(expression2, expression18);
        }
        if (Expression.isOr(expression)) {
            expression2 = BooleanUtils.doConversionToPositiveNormalForm(((ExpressionBinaryOp)expression).getOperand1(), bl);
            Expression expression19 = BooleanUtils.doConversionToPositiveNormalForm(((ExpressionBinaryOp)expression).getOperand2(), bl);
            return Expression.Or(expression2, expression19);
        }
        if (bl && expression instanceof ExpressionTemporal) {
            expression2 = (ExpressionTemporal)expression;
            Expression expression20 = ((ExpressionTemporal)expression2).getOperand1();
            Expression expression21 = ((ExpressionTemporal)expression2).getOperand2();
            Expression expression22 = expression20 == null ? null : BooleanUtils.doConversionToPositiveNormalForm(expression20, bl);
            Expression expression23 = expression21 == null ? null : BooleanUtils.doConversionToPositiveNormalForm(expression21, bl);
            ExpressionTemporal expressionTemporal = new ExpressionTemporal(((ExpressionTemporal)expression2).getOperator(), expression22, expression23);
            expressionTemporal.setBoundsFrom((ExpressionTemporal)expression2);
            return expressionTemporal;
        }
        return expression;
    }

    public static Expression convertToDNF(Expression expression) {
        return BooleanUtils.convertDNFListsToExpression(BooleanUtils.doConversionToDNF(BooleanUtils.convertToPositiveNormalForm(expression)));
    }

    public static List<List<Expression>> convertToDNFLists(Expression expression) {
        return BooleanUtils.doConversionToDNF(BooleanUtils.convertToPositiveNormalForm(expression));
    }

    private static List<List<Expression>> doConversionToDNF(Expression expression) {
        if (Expression.isAnd(expression)) {
            Expression expression2 = ((ExpressionBinaryOp)expression).getOperand1();
            Expression expression3 = ((ExpressionBinaryOp)expression).getOperand2();
            List<List<Expression>> list = BooleanUtils.doConversionToDNF(expression2);
            List<List<Expression>> list2 = BooleanUtils.doConversionToDNF(expression3);
            ArrayList<List<Expression>> arrayList = new ArrayList<List<Expression>>();
            for (List<Expression> list3 : list) {
                for (List<Expression> list4 : list2) {
                    ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                    arrayList2.addAll(list3);
                    arrayList2.addAll(list4);
                    arrayList.add(arrayList2);
                }
            }
            return arrayList;
        }
        if (Expression.isOr(expression)) {
            Expression expression4 = ((ExpressionBinaryOp)expression).getOperand1();
            Expression expression5 = ((ExpressionBinaryOp)expression).getOperand2();
            List<List<Expression>> list = BooleanUtils.doConversionToDNF(expression4);
            List<List<Expression>> list5 = BooleanUtils.doConversionToDNF(expression5);
            list.addAll(list5);
            return list;
        }
        ArrayList<List<Expression>> arrayList = new ArrayList<List<Expression>>(1);
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>(1);
        arrayList3.add(expression);
        arrayList.add(arrayList3);
        return arrayList;
    }

    public static Expression convertToCNF(Expression expression) {
        return BooleanUtils.convertCNFListsToExpression(BooleanUtils.doConversionToCNF(BooleanUtils.convertToPositiveNormalForm(expression)));
    }

    public static List<List<Expression>> convertToCNFLists(Expression expression) {
        return BooleanUtils.doConversionToCNF(BooleanUtils.convertToPositiveNormalForm(expression));
    }

    private static List<List<Expression>> doConversionToCNF(Expression expression) {
        if (Expression.isParenth(expression)) {
            return BooleanUtils.doConversionToCNF(((ExpressionUnaryOp)expression).getOperand());
        }
        if (Expression.isOr(expression)) {
            Expression expression2 = ((ExpressionBinaryOp)expression).getOperand1();
            Expression expression3 = ((ExpressionBinaryOp)expression).getOperand2();
            List<List<Expression>> list = BooleanUtils.doConversionToCNF(expression2);
            List<List<Expression>> list2 = BooleanUtils.doConversionToCNF(expression3);
            ArrayList<List<Expression>> arrayList = new ArrayList<List<Expression>>();
            for (List<Expression> list3 : list) {
                for (List<Expression> list4 : list2) {
                    ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                    arrayList2.addAll(list3);
                    arrayList2.addAll(list4);
                    arrayList.add(arrayList2);
                }
            }
            return arrayList;
        }
        if (Expression.isAnd(expression)) {
            Expression expression4 = ((ExpressionBinaryOp)expression).getOperand1();
            Expression expression5 = ((ExpressionBinaryOp)expression).getOperand2();
            List<List<Expression>> list = BooleanUtils.doConversionToCNF(expression4);
            List<List<Expression>> list5 = BooleanUtils.doConversionToCNF(expression5);
            list.addAll(list5);
            return list;
        }
        ArrayList<List<Expression>> arrayList = new ArrayList<List<Expression>>(1);
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>(1);
        arrayList3.add(expression);
        arrayList.add(arrayList3);
        return arrayList;
    }

    public static Expression convertDNFListsToExpression(List<List<Expression>> list) {
        Expression expression = BooleanUtils.convertConjunctionListToExpression(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            expression = Expression.Or(expression, BooleanUtils.convertConjunctionListToExpression(list.get(i)));
        }
        return expression;
    }

    public static Expression convertCNFListsToExpression(List<List<Expression>> list) {
        Expression expression = BooleanUtils.convertDisjunctionListToExpression(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            expression = Expression.And(expression, BooleanUtils.convertDisjunctionListToExpression(list.get(i)));
        }
        return expression;
    }

    public static Expression convertDisjunctionListToExpression(List<Expression> list) {
        Expression expression = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            expression = Expression.Or(expression, list.get(i));
        }
        return expression;
    }

    public static Expression convertConjunctionListToExpression(List<Expression> list) {
        Expression expression = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            expression = Expression.And(expression, list.get(i));
        }
        return expression;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        PrismParser prismParser = new PrismParser();
        for (String string : stringArray2 = new String[]{"a&!(b=>c)", "(a|b)&(c|d|e)"}) {
            try {
                Expression expression = prismParser.parseSingleExpression(new ByteArrayInputStream(string.getBytes()));
                System.out.println(expression + " in CNF is " + BooleanUtils.convertToCNF(expression.deepCopy()));
                System.out.println(expression + " in DNF is " + BooleanUtils.convertToDNF(expression.deepCopy()));
            }
            catch (PrismException prismException) {
                System.out.println("Error: " + prismException.getMessage());
            }
        }
    }
}

