/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import param.BigRational;
import param.Function;
import param.ParamMode;
import param.Region;
import param.RegionFactory;
import param.RegionIntersection;
import param.RegionValuesIntersections;
import param.StateBoolean;
import param.StateValue;
import param.StateValues;
import parser.State;
import parser.type.Type;
import prism.PrismLog;

public final class RegionValues
implements Iterable<Map.Entry<Region, StateValues>> {
    private ArrayList<Region> regions = new ArrayList();
    private HashMap<Region, StateValues> values = new HashMap();
    private RegionFactory factory;

    public RegionValues(RegionFactory regionFactory) {
        this.factory = regionFactory;
    }

    public int getNumStates() {
        return this.factory.getNumStates();
    }

    public int getInitState() {
        return this.factory.getInitialState();
    }

    public void add(Region region, StateValues stateValues) {
        this.regions.add(region);
        this.values.put(region, stateValues);
    }

    private boolean simplifyIter() {
        boolean bl = false;
        ArrayList<Region> arrayList = new ArrayList<Region>();
        HashMap<Region, StateValues> hashMap = new HashMap<Region, StateValues>();
        HashSet<Region> hashSet = new HashSet<Region>();
        block0: for (Region region : this.regions) {
            for (Region region2 : this.regions) {
                if (!this.values.get(region).equals(this.values.get(region2)) || !region.adjacent(region2) || hashSet.contains(region) || hashSet.contains(region2)) continue;
                hashSet.add(region);
                hashSet.add(region2);
                Region region3 = region.glue(region2);
                arrayList.add(region3);
                hashMap.put(region3, this.values.get(region));
                bl = true;
                continue block0;
            }
        }
        for (Region region : this.regions) {
            if (hashSet.contains(region)) continue;
            arrayList.add(region);
            hashMap.put(region, this.values.get(region));
        }
        this.regions.clear();
        this.values.clear();
        this.regions.addAll(arrayList);
        this.values.putAll(hashMap);
        return bl;
    }

    public void simplify() {
        if (this.factory.isSubsumeRegions()) {
            while (this.simplifyIter()) {
            }
        }
    }

    public Region getRegion(int n) {
        return this.regions.get(n);
    }

    public int getNumRegions() {
        return this.regions.size();
    }

    public StateValues getResult(int n) {
        return this.values.get(this.regions.get(n));
    }

    public StateValues getResult(Region region) {
        return this.values.get(region);
    }

    public void cosplit(RegionValues regionValues) {
        this.simplify();
        regionValues.simplify();
        ArrayList<Region> arrayList = new ArrayList<Region>();
        HashMap<Region, StateValues> hashMap = new HashMap<Region, StateValues>();
        HashMap<Region, StateValues> hashMap2 = new HashMap<Region, StateValues>();
        for (Region region : this.regions) {
            for (Region region2 : regionValues.regions) {
                Region region3 = region.conjunct(region2);
                if (region3 == null) continue;
                arrayList.add(region3);
                hashMap.put(region3, this.values.get(region));
                hashMap2.put(region3, regionValues.values.get(region2));
            }
        }
        this.regions = new ArrayList(arrayList);
        this.values = hashMap;
        regionValues.regions = new ArrayList(arrayList);
        regionValues.values = hashMap2;
    }

    public void cosplit(RegionValues regionValues, RegionValues regionValues2) {
        this.simplify();
        regionValues.simplify();
        regionValues2.simplify();
        ArrayList<Region> arrayList = new ArrayList<Region>();
        HashMap<Region, StateValues> hashMap = new HashMap<Region, StateValues>();
        HashMap<Region, StateValues> hashMap2 = new HashMap<Region, StateValues>();
        HashMap<Region, StateValues> hashMap3 = new HashMap<Region, StateValues>();
        for (Region region : this.regions) {
            for (Region region2 : regionValues.regions) {
                for (Region region3 : regionValues2.regions) {
                    Region region4 = region.conjunct(region2);
                    if (region4 != null) {
                        region4 = region4.conjunct(region3);
                    }
                    if (region4 == null) continue;
                    arrayList.add(region4);
                    hashMap.put(region4, this.values.get(region));
                    hashMap2.put(region4, regionValues.values.get(region2));
                    hashMap3.put(region4, regionValues2.values.get(region3));
                }
            }
        }
        this.regions = new ArrayList(arrayList);
        this.values = hashMap;
        regionValues.regions = new ArrayList(arrayList);
        regionValues.values = hashMap2;
        regionValues2.regions = new ArrayList(arrayList);
        regionValues2.values = hashMap3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.regions.size(); ++i) {
            Region region = this.regions.get(i);
            stringBuilder.append(region);
            stringBuilder.append(": ");
            stringBuilder.append(this.values.get(region));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void addAll(RegionValues regionValues) {
        int n = regionValues.getNumRegions();
        for (int i = 0; i < n; ++i) {
            Region region = regionValues.getRegion(i);
            this.regions.add(region);
            this.values.put(region, regionValues.getResult(region));
        }
    }

    public void clearExcept(BitSet bitSet) {
        for (Region region : this.regions) {
            StateValues stateValues = this.values.get(region);
            for (int i = 0; i < stateValues.getNumStates(); ++i) {
                if (bitSet.get(i)) continue;
                StateValue stateValue = stateValues.getStateValue(i);
                if (stateValue instanceof StateBoolean) {
                    stateValues.setStateValue(i, false);
                    continue;
                }
                if (stateValue instanceof Function) {
                    stateValues.setStateValue(i, this.factory.getFunctionFactory().getZero());
                    continue;
                }
                throw new RuntimeException();
            }
        }
        this.simplify();
    }

    public void clearExceptInit() {
        if (this.regions.isEmpty()) {
            return;
        }
        int n = this.values.get(this.regions.get(0)).getNumStates();
        BitSet bitSet = new BitSet(n);
        bitSet.set(this.factory.getInitialState(), true);
        this.clearExcept(bitSet);
    }

    @Override
    public Iterator<Map.Entry<Region, StateValues>> iterator() {
        return this.values.entrySet().iterator();
    }

    public RegionFactory getRegionFactory() {
        return this.factory;
    }

    public boolean booleanValues() {
        if (this.regions.isEmpty()) {
            return true;
        }
        return this.values.get(this.regions.get(0)).getStateValue(0) instanceof StateBoolean;
    }

    public RegionValues binaryOp(int n, RegionValues regionValues) {
        RegionValues regionValues2 = new RegionValues(this.factory);
        RegionValuesIntersections regionValuesIntersections = new RegionValuesIntersections(this, regionValues);
        for (RegionIntersection regionIntersection : regionValuesIntersections) {
            Region region = regionIntersection.getRegion();
            StateValues stateValues = regionIntersection.getStateValues1();
            StateValues stateValues2 = regionIntersection.getStateValues2();
            RegionValues regionValues3 = region.binaryOp(n, stateValues, stateValues2);
            regionValues2.addAll(regionValues3);
        }
        return regionValues2;
    }

    public RegionValues binaryOp(int n, BigRational bigRational) {
        RegionValues regionValues = new RegionValues(this.factory);
        Function function = this.factory.getFunctionFactory().fromBigRational(bigRational);
        StateValues stateValues = new StateValues(this.values.get(this.regions.get(0)).getNumStates(), this.factory.getInitialState(), function);
        for (Region region : this.regions) {
            RegionValues regionValues2 = region.binaryOp(n, this.values.get(region), stateValues);
            regionValues.addAll(regionValues2);
        }
        return regionValues;
    }

    public RegionValues binaryOp(BigRational bigRational, int n) {
        RegionValues regionValues = new RegionValues(this.factory);
        Function function = this.factory.getFunctionFactory().fromBigRational(bigRational);
        StateValues stateValues = new StateValues(this.values.get(this.regions.get(0)).getNumStates(), this.factory.getInitialState(), function);
        for (Region region : this.regions) {
            RegionValues regionValues2 = region.binaryOp(n, stateValues, this.values.get(region));
            regionValues.addAll(regionValues2);
        }
        return regionValues;
    }

    public RegionValues op(int n, BitSet bitSet) {
        RegionValues regionValues = new RegionValues(this.factory);
        if (n == 15) {
            for (Region region : this.regions) {
                int n2 = bitSet.nextSetBit(0);
                StateValue stateValue = this.values.get(region).getStateValue(n2);
                StateValues stateValues = new StateValues(this.getNumStates(), this.getInitState());
                for (int i = 0; i < this.getNumStates(); ++i) {
                    stateValues.setStateValue(i, stateValue);
                }
                regionValues.add(region, stateValues);
            }
        } else if (n == 11 || n == 16) {
            for (Region region : this.regions) {
                StateValues stateValues = this.values.get(region);
                Function function = this.factory.getFunctionFactory().getZero();
                for (int i = 0; i < this.getNumStates(); ++i) {
                    if (!bitSet.get(i)) continue;
                    function = function.add(stateValues.getStateValueAsFunction(i));
                }
                if (n == 16) {
                    function = function.divide(bitSet.cardinality());
                }
                StateValues stateValues2 = new StateValues(this.getNumStates(), this.getInitState(), function);
                regionValues.add(region, stateValues2);
            }
        } else if (n == 17) {
            for (Region region : this.regions) {
                StateValues stateValues = this.values.get(region);
                int n3 = 0;
                for (int i = 0; i < this.getNumStates(); ++i) {
                    if (!bitSet.get(i) || !stateValues.getStateValueAsBoolean(i)) continue;
                    ++n3;
                }
                Function function = this.factory.getFunctionFactory().fromLong(n3);
                StateValues stateValues3 = new StateValues(this.getNumStates(), this.getInitState(), function);
                regionValues.add(region, stateValues3);
            }
        } else if (n == 21) {
            for (Region region : this.regions) {
                StateValues stateValues = this.values.get(region);
                boolean bl = true;
                for (int i = 0; i < this.getNumStates(); ++i) {
                    if (!bitSet.get(i) || stateValues.getStateValueAsBoolean(i)) continue;
                    bl = false;
                    break;
                }
                StateValues stateValues4 = new StateValues(this.getNumStates(), this.getInitState(), bl);
                regionValues.add(region, stateValues4);
            }
        } else if (n == 22) {
            for (Region region : this.regions) {
                StateValues stateValues = this.values.get(region);
                boolean bl = false;
                for (int i = 0; i < this.getNumStates(); ++i) {
                    if (!bitSet.get(i) || !stateValues.getStateValueAsBoolean(i)) continue;
                    bl = true;
                    break;
                }
                StateValues stateValues5 = new StateValues(this.getNumStates(), this.getInitState(), bl);
                regionValues.add(region, stateValues5);
            }
        } else {
            throw new RuntimeException("unknown operator");
        }
        return regionValues;
    }

    public boolean parameterIndependent() {
        this.simplify();
        if (this.regions.size() > 1) {
            return false;
        }
        return this.regions.get(0).volume().equals(this.factory.getFunctionFactory().getOne().asBigRational());
    }

    public StateValues getStateValues() {
        return this.values.get(this.regions.get(0));
    }

    public void clearNotNeeded(BitSet bitSet) {
        for (Region region : this.regions) {
            StateValues stateValues = this.values.get(region);
            for (int i = 0; i < stateValues.getNumStates(); ++i) {
                if (bitSet.get(i)) continue;
                if (stateValues.getStateValue(i) instanceof Function) {
                    stateValues.setStateValue(i, this.factory.getFunctionFactory().getZero());
                    continue;
                }
                stateValues.setStateValue(i, false);
            }
        }
        this.simplify();
    }

    public String filteredString(BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Region region : this.regions) {
            stringBuilder.append(region);
            StateValues stateValues = this.values.get(region);
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                stringBuilder.append(n);
                stringBuilder.append(":");
                stringBuilder.append("=");
                stringBuilder.append(stateValues.getStateValue(n));
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return stringBuilder.toString();
    }

    public void printFiltered(PrismLog prismLog, ParamMode paramMode, Type type, BitSet bitSet, List<State> list, boolean bl, boolean bl2, boolean bl3) {
        if (paramMode == ParamMode.EXACT) {
            assert (this.parameterIndependent());
            this.getStateValues().printFiltered(prismLog, paramMode, type, bitSet, list, bl, bl2, bl3);
        } else {
            for (Region region : this.regions) {
                prismLog.println(region + ":");
                StateValues stateValues = this.values.get(region);
                stateValues.printFiltered(prismLog, paramMode, type, bitSet, list, bl, bl2, bl3);
                prismLog.println();
            }
        }
    }

    public RegionValues unaryOp(int n) {
        RegionValues regionValues = new RegionValues(this.factory);
        for (Region region : this.regions) {
            StateValues stateValues = this.unaryOp(n, this.values.get(region));
            regionValues.add(region, stateValues);
        }
        return regionValues;
    }

    private StateValues unaryOp(int n, StateValues stateValues) {
        StateValues stateValues2 = new StateValues(this.getNumStates(), this.getInitState());
        for (int i = 0; i < stateValues.getNumStates(); ++i) {
            StateValue stateValue = null;
            switch (n) {
                case 18: {
                    stateValue = stateValues.getStateValueAsFunction(i).negate();
                    break;
                }
                case 19: {
                    stateValue = new StateBoolean(!stateValues.getStateValueAsBoolean(i));
                    break;
                }
                case 20: {
                    stateValue = stateValues.getStateValue(i);
                }
            }
            stateValues2.setStateValue(i, stateValue);
        }
        return stateValues2;
    }

    public RegionValues ITE(RegionValues regionValues, RegionValues regionValues2) {
        RegionValues regionValues3 = new RegionValues(this.factory);
        RegionValuesIntersections regionValuesIntersections = new RegionValuesIntersections(this, regionValues, regionValues2);
        for (RegionIntersection regionIntersection : regionValuesIntersections) {
            Region region = regionIntersection.getRegion();
            StateValues stateValues = regionIntersection.getStateValues1();
            StateValues stateValues2 = regionIntersection.getStateValues2();
            StateValues stateValues3 = regionIntersection.getStateValues3();
            RegionValues regionValues4 = region.ITE(stateValues, stateValues2, stateValues3);
            regionValues3.addAll(regionValues4);
        }
        return regionValues3;
    }
}

