/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.Function;
import param.FunctionFactory;
import param.Point;
import prism.PrismException;
import prism.PrismNotSupportedException;

final class ParamRewardStruct {
    Function[] rewards;
    FunctionFactory factory;

    ParamRewardStruct(FunctionFactory functionFactory, int n) {
        this.rewards = new Function[n];
        this.factory = functionFactory;
        for (int i = 0; i < n; ++i) {
            this.rewards[i] = functionFactory.getZero();
        }
    }

    ParamRewardStruct(ParamRewardStruct paramRewardStruct) {
        this.rewards = new Function[paramRewardStruct.rewards.length];
        for (int i = 0; i < paramRewardStruct.rewards.length; ++i) {
            this.rewards[i] = paramRewardStruct.rewards[i];
        }
        this.factory = paramRewardStruct.factory;
    }

    ParamRewardStruct instantiate(Point point) {
        ParamRewardStruct paramRewardStruct = new ParamRewardStruct(this.factory, this.rewards.length);
        for (int i = 0; i < this.rewards.length; ++i) {
            paramRewardStruct.rewards[i] = this.factory.fromBigRational(this.rewards[i].evaluate(point));
        }
        paramRewardStruct.factory = this.factory;
        return paramRewardStruct;
    }

    void setReward(int n, Function function) {
        this.rewards[n] = function;
    }

    void addReward(int n, Function function) {
        this.rewards[n] = this.rewards[n].add(function);
    }

    Function getReward(int n) {
        return this.rewards[n];
    }

    public boolean hasNegativeRewards() throws PrismException {
        for (Function function : this.rewards) {
            if (!function.isConstant()) {
                throw new UnsupportedOperationException("Can not check for negative rewards against non-constant functions");
            }
            BigRational bigRational = function.asBigRational();
            if (bigRational.isSpecial()) {
                throw new PrismNotSupportedException("Reward value " + bigRational + " not supported");
            }
            if (function.asBigRational().signum() >= 0) continue;
            return true;
        }
        return false;
    }

    public void checkForNonNormalRewards() throws PrismException {
        for (Function function : this.rewards) {
            if (!function.isInf() && !function.isMInf() && !function.isNaN()) continue;
            throw new PrismNotSupportedException("Reward value " + function + " not supported");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rewards.length; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(this.rewards[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParamRewardStruct)) {
            return false;
        }
        ParamRewardStruct paramRewardStruct = (ParamRewardStruct)object;
        if (!this.factory.equals(paramRewardStruct.factory)) {
            return false;
        }
        if (this.rewards.length != paramRewardStruct.rewards.length) {
            return false;
        }
        for (int i = 0; i < this.rewards.length; ++i) {
            if (this.rewards[i].equals(paramRewardStruct.rewards[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n = this.factory.hashCode();
        for (int i = 0; i < this.rewards.length; ++i) {
            n = this.rewards[i].hashCode() + (n << 6) + (n << 16) - n;
        }
        return n;
    }
}

