/*
 * Decompiled with CFR 0.152.
 */
package param;

import explicit.IndexedSet;
import explicit.StateStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import param.BigRational;
import param.CachedFunctionFactory;
import param.DagFunctionFactory;
import param.Function;
import param.FunctionFactory;
import param.JasFunctionFactory;
import param.ParamMode;
import param.ParamModel;
import parser.State;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionUnaryOp;
import prism.ModelGeneratorSymbolic;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;

public final class ModelBuilder
extends PrismComponent {
    private final ParamMode mode;
    private ModelGeneratorSymbolic modelGenSym;
    private FunctionFactory functionFactory;
    private String[] paramNames;
    private BigRational[] lower;
    private BigRational[] upper;
    private String functionType;
    private double dagMaxError;
    private static Map<String, Expression> constExprs;

    public ModelBuilder(PrismComponent prismComponent, ParamMode paramMode) throws PrismException {
        super(prismComponent);
        this.mode = paramMode;
        if (this.settings != null) {
            this.functionType = this.settings.getString("prism.param.function");
            this.dagMaxError = this.settings.getDouble("prism.param.functionDagMaxError");
        }
    }

    public Function expr2function(FunctionFactory functionFactory, Expression expression) throws PrismException {
        if (expression instanceof ExpressionLiteral) {
            String string = ((ExpressionLiteral)expression).getString();
            if (string == null || string.equals("")) {
                throw new PrismException("cannot convert from literal for which no string is set");
            }
            return functionFactory.fromBigRational(new BigRational(string));
        }
        if (expression instanceof ExpressionConstant) {
            String string = ((ExpressionConstant)expression).getName();
            if (this.modelGenSym.getConstantValues().contains(string)) {
                Object object = this.modelGenSym.getConstantValues().getValueOf(string);
                return functionFactory.fromBigRational(new BigRational(object.toString()));
            }
            Expression expression2 = this.modelGenSym.getUnknownConstantDefinition(string);
            if (expression2 == null) {
                return functionFactory.getVar(string);
            }
            return this.expr2function(functionFactory, expression2);
        }
        if (expression instanceof ExpressionBinaryOp) {
            ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
            Function function = this.expr2function(functionFactory, expressionBinaryOp.getOperand1());
            Function function2 = this.expr2function(functionFactory, expressionBinaryOp.getOperand2());
            switch (expressionBinaryOp.getOperator()) {
                case 11: {
                    return function.add(function2);
                }
                case 12: {
                    return function.subtract(function2);
                }
                case 13: {
                    return function.multiply(function2);
                }
                case 14: {
                    return function.divide(function2);
                }
            }
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", analysis with rate/probability of " + expression + " not implemented");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            Function function = this.expr2function(functionFactory, expressionUnaryOp.getOperand());
            switch (expressionUnaryOp.getOperator()) {
                case 2: {
                    return function.negate();
                }
                case 3: {
                    return function;
                }
            }
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", analysis with rate/probability of " + expression + " not implemented");
        }
        if (expression instanceof ExpressionITE) {
            ExpressionITE expressionITE = (ExpressionITE)expression;
            if (expressionITE.getOperand1().isConstant()) {
                try {
                    boolean bl = expressionITE.getOperand1().evaluateExact().toBoolean();
                    if (bl) {
                        return this.expr2function(functionFactory, expressionITE.getOperand2());
                    }
                    return this.expr2function(functionFactory, expressionITE.getOperand3());
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
            }
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", analysis with rate/probability of " + expression + " not implemented");
        }
        if (expression instanceof ExpressionFunc) {
            try {
                BigRational bigRational = expression.evaluateExact();
                return functionFactory.fromBigRational(bigRational);
            }
            catch (PrismException prismException) {
                throw new PrismNotSupportedException("For " + this.mode.engine() + ", analysis with rate/probability of " + expression + " not implemented");
            }
        }
        throw new PrismNotSupportedException("For " + this.mode.engine() + ", analysis with rate/probability of " + expression + " not implemented");
    }

    public List<String> getParameterNames() {
        return Arrays.asList(this.paramNames);
    }

    public ParamModel constructModel(ModelGeneratorSymbolic modelGeneratorSymbolic, String[] stringArray, String[] stringArray2, String[] stringArray3) throws PrismException {
        if (modelGeneratorSymbolic.getModelType() == ModelType.PTA) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", you cannot build a PTA model explicitly, only perform model checking");
        }
        this.modelGenSym = modelGeneratorSymbolic;
        this.paramNames = stringArray;
        this.lower = new BigRational[stringArray2.length];
        this.upper = new BigRational[stringArray3.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.lower[i] = new BigRational(stringArray2[i]);
            this.upper[i] = new BigRational(stringArray3[i]);
        }
        if (this.functionType.equals("JAS")) {
            this.functionFactory = new JasFunctionFactory(stringArray, this.lower, this.upper);
        } else if (this.functionType.equals("JAS-cached")) {
            this.functionFactory = new CachedFunctionFactory(new JasFunctionFactory(stringArray, this.lower, this.upper));
        } else if (this.functionType.equals("DAG")) {
            this.functionFactory = new DagFunctionFactory(stringArray, this.lower, this.upper, this.dagMaxError, false);
        }
        modelGeneratorSymbolic.setSymbolic(this, this.functionFactory);
        this.mainLog.print("\nBuilding model (" + this.mode.engine() + ")...\n");
        long l = System.currentTimeMillis();
        ParamModel paramModel = this.doModelConstruction(modelGeneratorSymbolic);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\n" + paramModel.infoStringTable());
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return paramModel;
    }

    private void reserveMemoryAndExploreStates(ModelGeneratorSymbolic modelGeneratorSymbolic, ParamModel paramModel, StateStorage<State> stateStorage) throws PrismException {
        boolean bl = modelGeneratorSymbolic.getModelType().nondeterministic();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList<State> linkedList = new LinkedList<State>();
        State state = modelGeneratorSymbolic.getInitialState();
        stateStorage.add(state);
        linkedList.add(state);
        ++n;
        while (!linkedList.isEmpty()) {
            state = (State)linkedList.removeFirst();
            modelGeneratorSymbolic.exploreState(state);
            int n4 = modelGeneratorSymbolic.getNumChoices();
            n2 = bl ? (n2 += n4) : ++n2;
            for (int i = 0; i < n4; ++i) {
                int n5 = modelGeneratorSymbolic.getNumTransitions(i);
                n3 += n5;
                for (int j = 0; j < n5; ++j) {
                    State state2 = modelGeneratorSymbolic.computeTransitionTarget(i, j);
                    if (!stateStorage.add(state2)) continue;
                    ++n;
                    linkedList.add(state2);
                    stateStorage.add(state2);
                }
            }
            if (n4 != 0) continue;
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        paramModel.reserveMem(n, n2, n3);
    }

    private ParamModel doModelConstruction(ModelGeneratorSymbolic modelGeneratorSymbolic) throws PrismException {
        if (!modelGeneratorSymbolic.hasSingleInitialState()) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", cannot do explicit-state reachability if there are multiple initial states");
        }
        boolean bl = this.getSettings().getBoolean("prism.doProbChecks");
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        long l = System.currentTimeMillis();
        ModelType modelType = modelGeneratorSymbolic.getModelType();
        ParamModel paramModel = new ParamModel();
        paramModel.setModelType(modelType);
        if (modelType != ModelType.DTMC && modelType != ModelType.CTMC && modelType != ModelType.MDP) {
            throw new PrismNotSupportedException("For " + this.mode.engine() + ", unsupported model type: " + modelType);
        }
        boolean bl2 = modelType == ModelType.MDP;
        boolean bl3 = modelType == ModelType.CTMC;
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        this.reserveMemoryAndExploreStates(modelGeneratorSymbolic, paramModel, indexedSet);
        int[] nArray = indexedSet.buildSortingPermutation();
        ArrayList<State> arrayList = indexedSet.toPermutedArrayList(nArray);
        paramModel.setStatesList(arrayList);
        paramModel.addInitialState(nArray[0]);
        int n = 0;
        for (State state : arrayList) {
            Object object;
            int n2;
            int n3;
            modelGeneratorSymbolic.exploreState(state);
            int n4 = modelGeneratorSymbolic.getNumChoices();
            boolean bl4 = !bl2;
            boolean bl5 = bl && paramModel.getModelType().choicesSumToOne();
            Function function = this.functionFactory.getZero();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = modelGeneratorSymbolic.getNumTransitions(n3);
                Function function2 = this.functionFactory.getZero();
                for (n2 = 0; n2 < n5; ++n2) {
                    object = modelGeneratorSymbolic.getTransitionProbabilityFunction(n3, n2);
                    if (bl4) {
                        function = function.add((Function)object);
                    }
                    if (!bl5) continue;
                    function2 = function2.add((Function)object);
                }
                if (!bl5 || function2.equals(this.functionFactory.getOne())) continue;
                if (function2.isConstant()) {
                    throw new PrismLangException("Probabilities sum to " + function2.asBigRational() + " instead of 1 in state " + state.toString(modelGeneratorSymbolic) + " for some command");
                }
                throw new PrismLangException("In state " + state.toString(modelGeneratorSymbolic) + " the probabilities sum to " + function2 + " for some command, which can not be determined to be equal to 1 (to ignore, use -noprobchecks option)");
            }
            if (function.isZero()) {
                function = this.functionFactory.getOne();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Object object2 = modelGeneratorSymbolic.getChoiceAction(n3);
                int n6 = modelGeneratorSymbolic.getNumTransitions(n3);
                for (n2 = 0; n2 < n6; ++n2) {
                    object = modelGeneratorSymbolic.computeTransitionTarget(n3, n2);
                    Function function3 = modelGeneratorSymbolic.getTransitionProbabilityFunction(n3, n2);
                    if (modelType == ModelType.CTMC) {
                        if (function3.isInf() || function3.isMInf() || function3.isNaN()) {
                            throw new PrismException("For state " + state.toString(modelGeneratorSymbolic) + ", illegal rate " + function3.asBigRational());
                        }
                        if (function3.isConstant() && function3.asBigRational().signum() < 0) {
                            throw new PrismException("For state " + state.toString(modelGeneratorSymbolic) + ", negative rate " + function3.asBigRational());
                        }
                    }
                    function3 = function3.divide(function);
                    if (modelType == ModelType.DTMC || modelType == ModelType.MDP) {
                        if (function3.isInf() || function3.isMInf() || function3.isNaN()) {
                            throw new PrismException("For state " + state.toString(modelGeneratorSymbolic) + ", illegal probability " + function3.asBigRational());
                        }
                        if (function3.isConstant() && function3.asBigRational().signum() < 0) {
                            throw new PrismException("For state " + state.toString(modelGeneratorSymbolic) + ", negative probability " + function3.asBigRational());
                        }
                    }
                    paramModel.addTransition(nArray[indexedSet.get((State)object)], function3, object2 == null ? "" : object2.toString());
                }
                if (!bl2) continue;
                paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            if (n4 == 0) {
                paramModel.addDeadlockState(n);
                paramModel.addTransition(n, this.functionFactory.getOne(), null);
                if (bl2) {
                    paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                    paramModel.finishChoice();
                }
            }
            if (!bl2) {
                paramModel.setSumLeaving(bl3 ? function : this.functionFactory.getOne());
                paramModel.finishChoice();
            }
            paramModel.finishState();
            ++n;
        }
        paramModel.setFunctionFactory(this.functionFactory);
        this.mainLog.println();
        this.mainLog.print("Reachable states exploration and model construction");
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        return paramModel;
    }
}

