/*
 * Decompiled with CFR 0.152.
 */
package org.spg.PrismAPI;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.spg.utils.PrismAPIUtilities;
import param.Function;
import param.ParamResult;
import param.StateValues;
import parser.Values;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.Prism;
import prism.PrismDevNullLog;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.Result;
import prism.ResultsCollection;
import prism.UndefinedConstants;

public class PrismParamAPI {
    private String PROPERTIESFILENAME;
    private PrismLog mainLog;
    private Prism prism;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;
    private String modelString;
    private File props;
    private List<Property> propertiesToCheck;
    private UndefinedConstants[] undefinedConstants;
    private UndefinedConstants undefinedMFConstants;
    private Values definedMFConstants;
    private Values definedPFConstants;
    private ResultsCollection[] results = null;
    List<String> formulaeList;

    public PrismParamAPI() {
        this(null);
    }

    public PrismParamAPI(String outputFilename) {
        try {
            this.mainLog = outputFilename == null ? new PrismDevNullLog() : (outputFilename == "stdout" ? new PrismFileLog("stdout") : new PrismFileLog(outputFilename, false));
            this.prism = new Prism(this.mainLog);
            this.prism.initialise();
            this.prism.setLinEqMethod(1);
            this.prism.setMaxIters(100000);
            this.formulaeList = new ArrayList<String>();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void setPropertiesFile(String propertiesFilename, String[] paramNames) {
        this.PROPERTIESFILENAME = propertiesFilename;
        this.props = new File(this.PROPERTIESFILENAME);
        try {
            this.propertiesFile = this.prism.parsePropertiesFile(this.props);
            this.propertiesToCheck = new ArrayList<Property>();
            int numProperties = this.propertiesFile.getNumProperties();
            int i = 0;
            while (i < numProperties) {
                this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(i));
                ++i;
            }
            this.undefinedMFConstants = new UndefinedConstants(this.modulesFile, null);
            this.undefinedMFConstants.setExactMode(true);
            int numPropertiesToCheck = this.propertiesFile.getNumProperties();
            this.undefinedConstants = new UndefinedConstants[numPropertiesToCheck];
            int i2 = 0;
            while (i2 < numPropertiesToCheck) {
                this.undefinedConstants[i2] = new UndefinedConstants(this.modulesFile, this.propertiesFile, this.propertiesToCheck.get(i2));
                this.undefinedConstants[i2].setExactMode(true);
                ++i2;
            }
            this.undefinedMFConstants.removeConstants(paramNames);
            i2 = 0;
            while (i2 < numPropertiesToCheck) {
                this.undefinedConstants[i2].removeConstants(paramNames);
                ++i2;
            }
        }
        catch (FileNotFoundException | PrismLangException e) {
            e.printStackTrace();
        }
    }

    public void loadParamModel(String modelString, String[] paramNames) {
        try {
            this.modelString = modelString;
            this.modulesFile = this.prism.parseModelString(this.modelString);
            this.prism.loadPRISMModel(this.modulesFile);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public List<String> getPrismParamExpression(String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        int numPropertiesToCheck = this.propertiesFile.getNumProperties();
        this.formulaeList.clear();
        try {
            this.definedMFConstants = this.undefinedMFConstants.getMFConstantValues();
            this.prism.setPRISMModelConstants(this.definedMFConstants, true);
            this.results = new ResultsCollection[numPropertiesToCheck];
            int i = 0;
            while (i < numPropertiesToCheck) {
                this.definedPFConstants = this.undefinedConstants[i].getPFConstantValues();
                this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, true);
                this.results[i] = new ResultsCollection(this.undefinedConstants[i], this.propertiesToCheck.get(i).getExpression().getResultName());
                Result res = this.prism.modelCheckParametric(this.propertiesFile, this.propertiesToCheck.get(i), paramNames, paramLowerBounds, paramUpperBounds);
                this.results[i].setResult(this.definedMFConstants, this.definedPFConstants, res.getResult());
                StateValues v = ((ParamResult)res.getResult()).getRegionValues().getResult(0);
                Function f = v.getInitStateValueAsFunction();
                this.formulaeList.add(f.toString());
                ++i;
            }
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return this.formulaeList;
    }

    public String getParametricTransitionMatrix(String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        int numPropertiesToCheck = this.propertiesFile.getNumProperties();
        try {
            this.definedMFConstants = this.undefinedMFConstants.getMFConstantValues();
            this.prism.setPRISMModelConstants(this.definedMFConstants, true);
            int i = 0;
            if (i < numPropertiesToCheck) {
                this.definedPFConstants = this.undefinedConstants[i].getPFConstantValues();
                this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, true);
                String transitionMatrix = this.prism.getParametricTransitionMatrix(this.propertiesFile, this.propertiesToCheck.get(i), paramNames, paramLowerBounds, paramUpperBounds);
                return transitionMatrix;
            }
        }
        catch (PrismException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void saveParametricTransitionMatrix(String fileName, String[] paramNames, String[] paramLowerBounds, String[] paramUpperBounds) {
        String transitionMatrix = this.getParametricTransitionMatrix(paramNames, paramLowerBounds, paramUpperBounds);
        PrismAPIUtilities.saveToFile(fileName, transitionMatrix);
    }

    public void closeDown() {
        if (this.mainLog != null) {
            this.mainLog.close();
        }
        this.modulesFile = null;
        this.propertiesFile = null;
        this.props = null;
        this.prism = null;
    }

    public void importParametricTransitionMatrix(String transitionMatrixFile, String statesFile) {
    }
}

