/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.Stack;
import jltl2ba.APElement;
import jltl2ba.APElementIterator;
import jltl2ba.APSet;
import jltl2dstar.DAUnionAlgorithm;
import jltl2dstar.DA_State;
import jltl2dstar.DRA;
import jltl2dstar.StateMapper;
import jltl2dstar.UnionState;
import prism.PrismException;

public class UnionNBA2DRA {
    private boolean _detailed_states;

    public UnionNBA2DRA(boolean bl) {
        this._detailed_states = bl;
    }

    public void convert(DAUnionAlgorithm dAUnionAlgorithm, DRA dRA, int n, StateMapper<UnionState.Result, UnionState, DA_State> stateMapper) throws PrismException {
        APSet aPSet = dRA.getAPSet();
        if (dAUnionAlgorithm.checkEmpty()) {
            dRA.constructEmpty();
            return;
        }
        dAUnionAlgorithm.prepareAcceptance(dRA.acceptance());
        UnionState unionState = dAUnionAlgorithm.getStartState();
        DA_State dA_State = dRA.newState();
        unionState.generateAcceptance(dA_State.acceptance());
        if (this._detailed_states) {
            dA_State.setDescription(unionState.toHTML());
        }
        stateMapper.add(unionState, dA_State);
        dRA.setStartState(dA_State);
        Stack<unprocessed_value> stack = new Stack<unprocessed_value>();
        stack.push(new unprocessed_value(unionState, dA_State));
        while (!stack.empty()) {
            unprocessed_value unprocessed_value2 = (unprocessed_value)stack.pop();
            UnionState unionState2 = unprocessed_value2.algo_state;
            DA_State dA_State2 = unprocessed_value2.da_state;
            APElementIterator aPElementIterator = new APElementIterator(aPSet.size());
            while (aPElementIterator.hasNext()) {
                APElement aPElement = aPElementIterator.next();
                UnionState.Result result = dAUnionAlgorithm.delta(unionState2, aPElement);
                DA_State dA_State3 = stateMapper.find(result);
                if (dA_State3 == null) {
                    dA_State3 = dRA.newState();
                    result.getState().generateAcceptance(dA_State3.acceptance());
                    if (this._detailed_states) {
                        dA_State3.setDescription(result.getState().toHTML());
                    }
                    stateMapper.add(result.getState(), dA_State3);
                    stack.push(new unprocessed_value(result.getState(), dA_State3));
                }
                dA_State2.edges().put(aPElement, dA_State3);
                if (n == 0 || dRA.size() <= n) continue;
                throw new PrismException("State limit reached");
            }
        }
    }

    private class unprocessed_value {
        public UnionState algo_state;
        public DA_State da_state;

        public unprocessed_value(UnionState unionState, DA_State dA_State) {
            this.algo_state = unionState;
            this.da_state = dA_State;
        }
    }
}

