/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IteratorTools;
import explicit.DTMCFromMDPAndMDStrategy;
import explicit.Distribution;
import explicit.MDP;
import explicit.Model;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.modelviews.ModelView;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import strat.MDStrategy;

public abstract class MDPView
extends ModelView
implements MDP,
Cloneable {
    public MDPView() {
    }

    public MDPView(MDPView mDPView) {
        super(mDPView);
    }

    public String toString() {
        Object object = "[ ";
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": ";
            object = (String)object + "[";
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + object2 + ":";
                }
                object = (String)object + new Distribution(this.getTransitionsIterator(i, j));
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]";
        return object;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.MDP;
    }

    @Override
    public int getNumTransitions() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                n += this.getNumTransitions(i, j);
            }
        }
        return n;
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        int n = this.getNumStates();
        prismLog.print(n + " " + this.getNumChoices() + " " + this.getNumTransitions() + "\n");
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Integer, Double> entry : treeMap.entrySet()) {
                    prismLog.print(i + " " + j + " " + entry.getKey() + " " + PrismUtils.formatDouble(entry.getValue()));
                    Object object = this.getAction(i, j);
                    prismLog.print((String)(object == null ? "\n" : " " + object + "\n"));
                }
                treeMap.clear();
            }
        }
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(this.getModelType().keyword() + "\n");
            int n = this.getNumStates();
            fileWriter.write("module M\nx : [0.." + (n - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            for (int i = 0; i < n; ++i) {
                int n2 = this.getNumChoices(i);
                for (int j = 0; j < n2; ++j) {
                    Object object = this.getTransitionsIterator(i, j);
                    while (object.hasNext()) {
                        Map.Entry<Integer, Double> entry = object.next();
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    object = this.getAction(i, j);
                    fileWriter.write((String)(object != null ? "[" + object + "]" : "[]"));
                    fileWriter.write("x=" + i + "->");
                    boolean bl = true;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        if (bl) {
                            bl = false;
                        } else {
                            fileWriter.write("+");
                        }
                        fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                    }
                    fileWriter.write(";\n");
                    treeMap.clear();
                }
            }
            fileWriter.write("endmodule\n");
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + this.getModelType() + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public String infoString() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + n + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        object = (String)object + ", " + this.getNumChoices() + " choices";
        object = (String)object + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n);
        return object;
    }

    @Override
    public String infoStringTable() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + "States:      " + n + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        object = (String)object + "Choices:     " + this.getNumChoices() + "\n";
        object = (String)object + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n) + "\n";
        return object;
    }

    @Override
    public int getNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumChoices(i);
        }
        return n;
    }

    @Override
    public int getMaxNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, this.getNumChoices(i));
        }
        return n;
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            if (n2 <= 1) continue;
            hashSet.clear();
            for (int j = 0; j < n2; ++j) {
                if (hashSet.add(this.getAction(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return IteratorTools.count(this.getTransitionsIterator(n, n2));
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        final Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n, n2);
        return SuccessorsIterator.from(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return (Integer)((Map.Entry)iterator.next()).getKey();
            }
        }, true);
    }

    @Override
    public Model constructInducedModel(MDStrategy mDStrategy) {
        return new DTMCFromMDPAndMDStrategy(this, mDStrategy);
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        prismLog.print("digraph " + this.getModelType() + " {\nnode [shape=box];\n");
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (bitSet != null && bitSet.get(i)) {
                prismLog.print(i + " [style=filled  fillcolor=\"#cccccc\"]\n");
            }
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                String string = nArray[i] == j ? ",color=\"#ff0000\",fontcolor=\"#ff0000\"" : "";
                Object object = this.getAction(i, j);
                String string2 = "n" + i + "_" + j;
                prismLog.print(i + " -> " + string2 + " [ arrowhead=none,label=\"" + j);
                if (object != null) {
                    prismLog.print(":" + object);
                }
                prismLog.print("\"" + string + " ];\n");
                prismLog.print(string2 + " [ shape=point,height=0.1,label=\"\"" + string + " ];\n");
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    prismLog.print(string2 + " -> " + entry.getKey() + " [ label=\"" + entry.getValue() + "\"" + string + " ];\n");
                }
            }
        }
        prismLog.print("}\n");
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            Object object = this.getAction(n, i);
            String string = "n" + n + "_" + i;
            prismLog.print(n + " -> " + string + " ");
            Decoration decoration = new Decoration();
            decoration.attributes().put("arrowhead", "none");
            decoration.setLabel(i + (String)(object != null ? ":" + object : ""));
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration = decorator.decorateTransition(n, i, decoration);
                }
            }
            prismLog.print(decoration);
            prismLog.println(";");
            prismLog.print(string + " [ shape=point,width=0.1,height=0.1,label=\"\" ];\n");
            Iterator<Object> iterator = this.getTransitionsIterator(n, i);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                prismLog.print(string + " -> " + entry.getKey() + " ");
                decoration = new Decoration();
                decoration.setLabel(((Double)entry.getValue()).toString());
                if (iterable != null) {
                    for (Decorator decorator : iterable) {
                        decoration = decorator.decorateProbability(n, (Integer)entry.getKey(), i, entry.getValue(), decoration);
                    }
                }
                prismLog.print(decoration);
                prismLog.println(";");
            }
        }
    }
}

