/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.PredecessorRelation;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.graphviz.MarkStateSetDecorator;
import explicit.graphviz.ShowStatesDecorator;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public interface Model {
    public ModelType getModelType();

    public int getNumStates();

    public int getNumInitialStates();

    public Iterable<Integer> getInitialStates();

    public int getFirstInitialState();

    public boolean isInitialState(int var1);

    public int getNumDeadlockStates();

    public Iterable<Integer> getDeadlockStates();

    public StateValues getDeadlockStatesList();

    public int getFirstDeadlockState();

    public boolean isDeadlockState(int var1);

    public List<State> getStatesList();

    public VarList getVarList();

    public Values getConstantValues();

    public BitSet getLabelStates(String var1);

    public Set<String> getLabels();

    public boolean hasLabel(String var1);

    public int getNumTransitions();

    default public Iterator<Integer> getSuccessorsIterator(int n) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        return successorsIterator.distinct();
    }

    public SuccessorsIterator getSuccessors(int var1);

    default public boolean isSuccessor(int n, int n2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    default public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.allSuccessorsMatch(n, bitSet::get);
    }

    default public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.someSuccessorsMatch(n, bitSet::get);
    }

    default public boolean allSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (intPredicate.test(n2)) continue;
            return false;
        }
        return true;
    }

    default public boolean someSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!intPredicate.test(n2)) continue;
            return true;
        }
        return false;
    }

    public void findDeadlocks(boolean var1) throws PrismException;

    public void checkForDeadlocks() throws PrismException;

    public void checkForDeadlocks(BitSet var1) throws PrismException;

    public void exportToPrismExplicit(String var1) throws PrismException;

    public void exportToPrismExplicitTra(String var1) throws PrismException;

    public void exportToPrismExplicitTra(File var1) throws PrismException;

    public void exportToPrismExplicitTra(PrismLog var1);

    default public void exportToDotFile(String string) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile(prismFileLog);
        }
    }

    default public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, bitSet);
        }
    }

    default public void exportToDotFile(String string, Iterable<Decorator> iterable) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, iterable);
        }
    }

    default public void exportToDotFile(PrismLog prismLog) {
        this.exportToDotFile(prismLog, (Iterable<Decorator>)null);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet) {
        if (bitSet == null) {
            this.exportToDotFile(prismLog);
        }
        this.exportToDotFile(prismLog, Collections.singleton(new MarkStateSetDecorator(bitSet)));
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl) {
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (bl) {
            arrayList.add(new ShowStatesDecorator(this.getStatesList()));
        }
        if (bitSet != null) {
            arrayList.add(new MarkStateSetDecorator(bitSet));
        }
        this.exportToDotFile(prismLog, arrayList);
    }

    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable) {
        Decoration decoration = new Decoration();
        decoration.attributes().put("shape", "box");
        prismLog.print("digraph " + this.getModelType() + " {\nnode " + decoration.toString() + ";\n");
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Decoration decoration2 = new Decoration(decoration);
            decoration2.setLabel(Integer.toString(i));
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration2 = decorator.decorateState(i, decoration2);
                }
            }
            String string = decoration2.toString();
            prismLog.println(i + " " + (String)string + ";");
            this.exportTransitionsToDotFile(i, prismLog, iterable);
        }
        prismLog.print("}\n");
    }

    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        throw new UnsupportedOperationException();
    }

    public void exportToPrismLanguage(String var1) throws PrismException;

    public void exportStates(int var1, VarList var2, PrismLog var3) throws PrismException;

    public String infoString();

    public String infoStringTable();

    public boolean hasStoredPredecessorRelation();

    public PredecessorRelation getPredecessorRelation(PrismComponent var1, boolean var2);

    public void clearPredecessorRelation();
}

