/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.MDPExplicit;
import explicit.MDPSparse;
import explicit.NondetModelSimple;
import explicit.SuccessorsIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;

public class MDPSimple
extends MDPExplicit
implements NondetModelSimple {
    protected List<List<Distribution>> trans;
    protected List<List<Object>> actions;
    protected boolean allowDupes = false;
    protected int numDistrs;
    protected int numTransitions;
    protected int maxNumDistrs;
    protected boolean maxNumDistrsOk;

    public MDPSimple() {
        this.initialise(0);
    }

    public MDPSimple(int n) {
        this.initialise(n);
    }

    public MDPSimple(MDPSimple mDPSimple) {
        this(mDPSimple.numStates);
        int n;
        this.copyFrom(mDPSimple);
        for (n = 0; n < this.numStates; ++n) {
            List<Distribution> list = this.trans.get(n);
            for (Distribution distribution : mDPSimple.trans.get(n)) {
                list.add(new Distribution(distribution));
            }
        }
        if (mDPSimple.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.actions.add(null);
            }
            for (n = 0; n < this.numStates; ++n) {
                if (mDPSimple.actions.get(n) == null) continue;
                int n2 = mDPSimple.trans.get(n).size();
                ArrayList arrayList = new ArrayList(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(mDPSimple.actions.get(n).get(i));
                }
                this.actions.set(n, arrayList);
            }
        }
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(DTMCSimple dTMCSimple) {
        this(dTMCSimple.getNumStates());
        this.copyFrom(dTMCSimple);
        for (int i = 0; i < this.numStates; ++i) {
            this.addChoice(i, new Distribution(dTMCSimple.getTransitions(i)));
        }
    }

    public MDPSimple(MDPSimple mDPSimple, int[] nArray) {
        this(mDPSimple.numStates);
        int n;
        this.copyFrom(mDPSimple, nArray);
        for (n = 0; n < this.numStates; ++n) {
            List<Distribution> list = this.trans.get(nArray[n]);
            for (Distribution distribution : mDPSimple.trans.get(n)) {
                list.add(new Distribution(distribution, nArray));
            }
        }
        if (mDPSimple.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.actions.add(null);
            }
            for (n = 0; n < this.numStates; ++n) {
                if (mDPSimple.actions.get(n) == null) continue;
                int n2 = mDPSimple.trans.get(n).size();
                ArrayList arrayList = new ArrayList(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(mDPSimple.actions.get(n).get(i));
                }
                this.actions.set(nArray[n], arrayList);
            }
        }
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(MDPSparse mDPSparse) {
        this(mDPSparse.numStates);
        Iterable<Map.Entry<Integer, Double>> iterable;
        int n;
        int n2;
        this.copyFrom(mDPSparse);
        for (n2 = 0; n2 < this.numStates; ++n2) {
            for (n = 0; n < mDPSparse.getNumChoices(n2); ++n) {
                iterable = new Distribution();
                Iterator<Map.Entry<Integer, Double>> iterator = mDPSparse.getTransitionsIterator(n2, n);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    ((Distribution)iterable).add(entry.getKey(), entry.getValue());
                }
                this.addChoice(n2, (Distribution)iterable);
            }
        }
        if (mDPSparse.actions != null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n2 = 0; n2 < this.numStates; ++n2) {
                this.actions.add(null);
            }
            for (n2 = 0; n2 < this.numStates; ++n2) {
                n = mDPSparse.getNumChoices(n2);
                iterable = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    iterable.add(mDPSparse.getAction(n2, i));
                }
                this.actions.set(n2, (List<Object>)iterable);
            }
        }
        this.allowDupes = false;
        this.numDistrs = mDPSparse.numDistrs;
        this.numTransitions = mDPSparse.numTransitions;
        this.maxNumDistrs = mDPSparse.maxNumDistrs;
        this.maxNumDistrsOk = true;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.maxNumDistrs = 0;
        this.numTransitions = 0;
        this.numDistrs = 0;
        this.maxNumDistrsOk = true;
        this.trans = new ArrayList<List<Distribution>>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
        this.actions = null;
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        List<Distribution> list = this.trans.get(n);
        this.numDistrs -= list.size();
        for (Distribution distribution : list) {
            this.numTransitions -= distribution.size();
        }
        this.maxNumDistrsOk = false;
        this.trans.get(n).clear();
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).clear();
        }
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
            if (this.actions != null) {
                this.actions.add(null);
            }
            ++this.numStates;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        this.allowDupes = true;
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));){
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            if (stringArray.length < 3) {
                throw new PrismException("First line of .tra file must read #states, #choices, #transitions");
            }
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            int n4 = Integer.parseInt(stringArray[2]);
            int n5 = 0;
            this.initialise(n2);
            String string3 = bufferedReader.readLine();
            ++n;
            while (string3 != null) {
                if ((string3 = string3.trim()).length() > 0) {
                    String[] stringArray2 = string3.split(" ");
                    int n6 = Integer.parseInt(stringArray2[0]);
                    int n7 = Integer.parseInt(stringArray2[1]);
                    int n8 = Integer.parseInt(stringArray2[2]);
                    double d = Double.parseDouble(stringArray2[3]);
                    if (n6 < 0 || n6 >= this.numStates) {
                        throw new PrismException("Problem in .tra file (line " + n + "): illegal source state index " + n6);
                    }
                    if (n8 < 0 || n8 >= this.numStates) {
                        throw new PrismException("Problem in .tra file (line " + n + "): illegal target state index " + n8);
                    }
                    while (n7 >= this.getNumChoices(n6)) {
                        this.addChoice(n6, new Distribution());
                        ++n5;
                    }
                    if (this.trans.get(n6).get(n7).isEmpty()) {
                        --n5;
                    }
                    if (!this.trans.get(n6).get(n7).add(n8, d)) {
                        ++this.numTransitions;
                    } else {
                        throw new PrismException("Problem in .tra file (line " + n + "): redefinition of probability for " + n6 + " " + n7 + " " + n8);
                    }
                    if (stringArray2.length > 4) {
                        String string4 = stringArray2[4];
                        Object object = this.getAction(n6, n7);
                        if (object != null && !string4.equals(object)) {
                            throw new PrismException("Problem in .tra file (line " + n + "):inconsistent action label for " + n6 + ", " + n7 + ": " + object + " and " + string4);
                        }
                        this.setAction(n6, n7, string4);
                    }
                }
                string3 = bufferedReader.readLine();
                ++n;
            }
            if (this.getNumChoices() != n3) {
                throw new PrismException("Problem in .tra file: unexpected number of choices: " + this.getNumChoices());
            }
            if (this.getNumTransitions() != n4) {
                throw new PrismException("Problem in .tra file: unexpected number of transitions: " + this.getNumTransitions());
            }
            assert (n5 >= 0);
            if (n5 > 0) {
                throw new PrismException("Problem in .tra file: there are " + n5 + " empty distribution, are there gaps in the choice indices?");
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + string + "\": " + iOException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + this.getModelType());
        }
    }

    public int addChoice(int n, Distribution distribution) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfChoice(n, distribution)) != -1) {
            return n2;
        }
        List<Distribution> list = this.trans.get(n);
        list.add(distribution);
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).add(null);
        }
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public int addActionLabelledChoice(int n, Distribution distribution, Object object) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfActionLabelledChoice(n, distribution, object)) != -1) {
            return n2;
        }
        List<Distribution> list = this.trans.get(n);
        list.add(distribution);
        if (this.actions != null && this.actions.get(n) != null) {
            this.actions.get(n).add(null);
        }
        this.setAction(n, list.size() - 1, object);
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public void setAction(int n, int n2, Object object) {
        int n3;
        if (object == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<List<Object>>(this.numStates);
            for (n3 = 0; n3 < this.numStates; ++n3) {
                this.actions.add(null);
            }
        }
        if (this.actions.get(n) == null) {
            n3 = this.trans.get(n).size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(null);
            }
            this.actions.set(n, arrayList);
        }
        this.actions.get(n).set(n2, object);
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            Distribution distribution = new Distribution();
            distribution.add(i, 1.0);
            this.addChoice(i, distribution);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("MDP has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumChoices(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public int getMaxNumChoices() {
        if (!this.maxNumDistrsOk) {
            this.maxNumDistrs = 0;
            for (int i = 0; i < this.numStates; ++i) {
                this.maxNumDistrs = Math.max(this.maxNumDistrs, this.getNumChoices(i));
            }
        }
        return this.maxNumDistrs;
    }

    @Override
    public int getNumChoices() {
        return this.numDistrs;
    }

    @Override
    public Object getAction(int n, int n2) {
        List<Object> list;
        if (n2 < 0 || this.actions == null || (list = this.actions.get(n)) == null) {
            return null;
        }
        return list.get(n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).containsOneOf(bitSet);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).getSupport().iterator();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        return SuccessorsIterator.from(this.getSuccessorsIterator(n, n2), true);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.trans.get(n).get(n2).size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).iterator();
    }

    public List<Distribution> getChoices(int n) {
        return this.trans.get(n);
    }

    public Distribution getChoice(int n, int n2) {
        return this.trans.get(n).get(n2);
    }

    public int indexOfChoice(int n, Distribution distribution) {
        return this.trans.get(n).indexOf(distribution);
    }

    public int indexOfActionLabelledChoice(int n, Distribution distribution, Object object) {
        List<Distribution> list = this.trans.get(n);
        int n2 = list.size();
        if (distribution == null) {
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) != null) continue;
                Object object2 = this.getAction(n, i);
                if (!(object == null ? object2 == null : object.equals(object2))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!distribution.equals(list.get(i))) continue;
                Object object3 = this.getAction(n, i);
                if (!(object == null ? object3 == null : object.equals(object3))) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": ";
            object = (String)object + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + object2 + ":";
                }
                object = (String)object + this.trans.get(i).get(j);
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]\n";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof MDPSimple)) {
            return false;
        }
        MDPSimple mDPSimple = (MDPSimple)object;
        if (this.numStates != mDPSimple.numStates) {
            return false;
        }
        if (!this.initialStates.equals(mDPSimple.initialStates)) {
            return false;
        }
        return this.trans.equals(mDPSimple.trans);
    }
}

