/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.rewards.MCRewards;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DTMCUniformisedSimple
extends DTMCExplicit {
    protected CTMCSimple ctmc;
    protected double q;
    protected int numExtraTransitions;

    public DTMCUniformisedSimple(CTMCSimple cTMCSimple, double d) {
        this.ctmc = cTMCSimple;
        this.numStates = cTMCSimple.getNumStates();
        this.q = d;
        this.numExtraTransitions = 0;
        for (int i = 0; i < this.numStates; ++i) {
            if (cTMCSimple.getTransitions(i).get(i) != 0.0 || !(cTMCSimple.getTransitions(i).sumAllBut(i) < d)) continue;
            ++this.numExtraTransitions;
        }
    }

    public DTMCUniformisedSimple(CTMCSimple cTMCSimple) {
        this(cTMCSimple, cTMCSimple.getDefaultUniformisationRate());
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new PrismNotSupportedException("Not supported");
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumStates() {
        return this.ctmc.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.ctmc.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.ctmc.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.ctmc.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.ctmc.isInitialState(n);
    }

    @Override
    public int getNumDeadlockStates() {
        return this.ctmc.getNumDeadlockStates();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        return this.ctmc.getDeadlockStates();
    }

    @Override
    public StateValues getDeadlockStatesList() {
        return this.ctmc.getDeadlockStatesList();
    }

    @Override
    public int getFirstDeadlockState() {
        return this.ctmc.getFirstDeadlockState();
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.ctmc.isDeadlockState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.ctmc.getStatesList();
    }

    @Override
    public Values getConstantValues() {
        return this.ctmc.getConstantValues();
    }

    @Override
    public int getNumTransitions() {
        return this.ctmc.getNumTransitions() + this.numExtraTransitions;
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        throw new Error("Not yet supported");
    }

    public int getNumChoices(int n) {
        return 1;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.getNumStates() + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions (incl. " + this.numExtraTransitions + " self-loops)";
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.getNumStates() + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        return object;
    }

    @Override
    public int getNumTransitions(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d3 = entry.getValue();
            if (n2 == n) continue;
            d2 += d3;
            d += d3 / this.q * dArray[n2];
        }
        if (d2 < this.q) {
            d += (1.0 - d2 / this.q) * dArray[n];
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d3 = entry.getValue();
            if (n2 == n) continue;
            d2 += d3;
            d += d3 / this.q * dArray[n2];
        }
        return d /= d2 / this.q;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards mCRewards) {
        throw new Error("Not yet supported");
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < this.numStates; ++i) {
            double d = 0.0;
            Iterator<Map.Entry<Integer, Double>> iterator = this.ctmc.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                int n = entry.getKey();
                double d2 = entry.getValue() / this.q;
                if (n == i) continue;
                d += d2;
                int n2 = n;
                dArray2[n2] = dArray2[n2] + d2 * dArray[i];
            }
            int n = i;
            dArray2[n] = dArray2[n] + (1.0 - d) * dArray[i];
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + "ctmc: " + this.ctmc;
        object = ", q: " + this.q;
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCUniformisedSimple)) {
            return false;
        }
        DTMCUniformisedSimple dTMCUniformisedSimple = (DTMCUniformisedSimple)object;
        if (!this.ctmc.equals(dTMCUniformisedSimple.ctmc)) {
            return false;
        }
        if (this.q != dTMCUniformisedSimple.q) {
            return false;
        }
        return this.numExtraTransitions == dTMCUniformisedSimple.numExtraTransitions;
    }
}

