/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.ComplexRoots;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.Rectangle;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import edu.jas.structure.UnaryFunctor;
import edu.jas.ufd.Squarefree;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public abstract class ComplexRootsAbstract<C extends RingElem<C> & Rational>
implements ComplexRoots<C> {
    private static final Logger logger = Logger.getLogger(ComplexRootsAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Squarefree<Complex<C>> engine;

    public ComplexRootsAbstract(RingFactory<Complex<C>> ringFactory) {
        if (!(ringFactory instanceof ComplexRing)) {
            throw new IllegalArgumentException("cf not supported coefficients " + ringFactory);
        }
        this.engine = SquarefreeFactory.getImplementation(ringFactory);
    }

    @Override
    public Complex<C> rootBound(GenPolynomial<Complex<C>> genPolynomial) {
        if (genPolynomial == null) {
            return null;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        Complex complex = (Complex)ringFactory.getONE();
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return complex;
        }
        StarRingElem starRingElem = genPolynomial.leadingBaseCoefficient().norm();
        for (Complex<C> complex2 : genPolynomial.getMap().values()) {
            Complex complex3 = ((Complex)complex2.norm()).divide(starRingElem);
            if (complex.compareTo(complex3) >= 0) continue;
            complex = complex3;
        }
        complex = complex.sum((Complex)ringFactory.getONE());
        return complex;
    }

    public C magnitudeBound(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial) {
        StarRingElem starRingElem;
        Object c;
        if (genPolynomial == null) {
            return null;
        }
        if (genPolynomial.isZERO()) {
            return ((Complex)genPolynomial.ring.coFac.getONE()).getRe();
        }
        if (genPolynomial.isConstant()) {
            Complex<C> complex = genPolynomial.leadingBaseCoefficient();
            return ((Complex)complex.norm()).getRe();
        }
        GenPolynomial<Complex<C>> genPolynomial2 = genPolynomial.map(new UnaryFunctor<Complex<C>, Complex<C>>(){

            @Override
            public Complex<C> eval(Complex<C> complex) {
                return complex.norm();
            }
        });
        StarRingElem starRingElem2 = rectangle.getNW().norm();
        Object c2 = ((Complex)starRingElem2).getRe();
        if (c2.compareTo(c = ((Complex)(starRingElem = rectangle.getSW().norm())).getRe()) < 0) {
            c2 = c;
            starRingElem2 = starRingElem;
        }
        if (c2.compareTo(c = ((Complex)(starRingElem = rectangle.getSE().norm())).getRe()) < 0) {
            c2 = c;
            starRingElem2 = starRingElem;
        }
        if (c2.compareTo(c = ((Complex)(starRingElem = rectangle.getNE().norm())).getRe()) < 0) {
            starRingElem2 = starRingElem;
        }
        Complex complex = (Complex)PolyUtil.evaluateMain(genPolynomial.ring.coFac, genPolynomial2, starRingElem2);
        return complex.getRe();
    }

    @Override
    public abstract long complexRootCount(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public abstract List<Rectangle<C>> complexRoots(Rectangle<C> var1, GenPolynomial<Complex<C>> var2) throws InvalidBoundaryException;

    @Override
    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> genPolynomial) {
        ArrayList<Rectangle<C>> arrayList = new ArrayList<Rectangle<C>>();
        if (genPolynomial.isConstant() || genPolynomial.isZERO()) {
            return arrayList;
        }
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = this.engine.squarefreeFactors(genPolynomial);
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<Complex<C>> genPolynomial2 = entry.getKey();
            Complex<C> complex = this.rootBound(genPolynomial2);
            AbelianGroupElem abelianGroupElem = complex.getRe();
            RingElem ringElem = (RingElem)abelianGroupElem.sum((AbelianGroupElem)((AbelianGroupElem)abelianGroupElem.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info("rootBound = " + abelianGroupElem);
            }
            Complex[] complexArray = new Complex[]{new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)abelianGroupElem), new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)ringElem.negate()), new Complex<RingElem>(complexRing, (RingElem)abelianGroupElem, (RingElem)ringElem.negate()), new Complex<C>(complexRing, abelianGroupElem, abelianGroupElem)};
            Rectangle rectangle = new Rectangle(complexArray);
            try {
                List list = this.complexRoots(rectangle, genPolynomial2);
                long l = entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.addAll(list);
                    ++n;
                }
            }
            catch (InvalidBoundaryException invalidBoundaryException) {
                throw new RuntimeException("this should never happen " + invalidBoundaryException);
            }
        }
        return arrayList;
    }

    @Override
    public Rectangle<C> complexRootRefinement(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, BigRational bigRational) throws InvalidBoundaryException {
        long l;
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        Rectangle<C> rectangle2 = rectangle;
        if (this.debug && (l = this.complexRootCount(rectangle2, genPolynomial)) != 1L) {
            System.out.println("#root = " + l);
            System.out.println("root = " + rectangle2);
            throw new ArithmeticException("no initial isolating rectangle " + rectangle);
        }
        Complex complex = complexRing.fromInteger(1L);
        complex = complex.divide(complexRing.fromInteger(1000L));
        BigRational bigRational2 = bigRational.multiply(bigRational);
        Complex complex2 = null;
        boolean bl = true;
        while (bl) {
            try {
                while (rectangle2.rationalLength().compareTo(bigRational2) > 0) {
                    if (complex2 == null) {
                        complex2 = rectangle2.corners[3].subtract(rectangle2.corners[1]);
                        complex2 = complex2.divide(complexRing.fromInteger(2L));
                    }
                    Complex complex3 = rectangle2.corners[1].sum(complex2);
                    if (this.debug) {
                        logger.info("new center = " + complex3);
                    }
                    Complex[] complexArray = this.copyOfComplex(rectangle2.corners, 4);
                    complexArray[1] = new Complex(complexRing, complexArray[1].getRe(), complex3.getIm());
                    complexArray[2] = complex3;
                    complexArray[3] = new Complex(complexRing, complex3.getRe(), complexArray[3].getIm());
                    Rectangle rectangle3 = new Rectangle(complexArray);
                    l = this.complexRootCount(rectangle3, genPolynomial);
                    if (l == 1L) {
                        rectangle2 = rectangle3;
                        complex2 = null;
                        continue;
                    }
                    complexArray = this.copyOfComplex(rectangle2.corners, 4);
                    complexArray[0] = new Complex(complexRing, complexArray[0].getRe(), complex3.getIm());
                    complexArray[2] = new Complex(complexRing, complex3.getRe(), complexArray[2].getIm());
                    complexArray[3] = complex3;
                    Rectangle rectangle4 = new Rectangle(complexArray);
                    l = this.complexRootCount(rectangle4, genPolynomial);
                    if (l == 1L) {
                        rectangle2 = rectangle4;
                        complex2 = null;
                        continue;
                    }
                    complexArray = this.copyOfComplex(rectangle2.corners, 4);
                    complexArray[0] = complex3;
                    complexArray[1] = new Complex(complexRing, complex3.getRe(), complexArray[1].getIm());
                    complexArray[3] = new Complex(complexRing, complexArray[3].getRe(), complex3.getIm());
                    Rectangle rectangle5 = new Rectangle(complexArray);
                    l = this.complexRootCount(rectangle5, genPolynomial);
                    if (l == 1L) {
                        rectangle2 = rectangle5;
                        complex2 = null;
                        continue;
                    }
                    complexArray = this.copyOfComplex(rectangle2.corners, 4);
                    complexArray[0] = new Complex(complexRing, complex3.getRe(), complexArray[0].getIm());
                    complexArray[1] = complex3;
                    complexArray[2] = new Complex(complexRing, complexArray[2].getRe(), complex3.getIm());
                    Rectangle rectangle6 = new Rectangle(complexArray);
                    l = this.complexRootCount(rectangle6, genPolynomial);
                    if (l == 1L) {
                        rectangle2 = rectangle6;
                        complex2 = null;
                        continue;
                    }
                    l = this.complexRootCount(rectangle2, genPolynomial);
                    System.out.println("#root = " + l);
                    System.out.println("root = " + rectangle2);
                    throw new ArithmeticException("no isolating rectangle " + rectangle);
                }
                bl = false;
            }
            catch (InvalidBoundaryException invalidBoundaryException) {
                complex2 = complex2.sum(complex2.multiply(complex));
                complex = complex.sum(complex.multiply(complexRing.getIMAG()));
            }
        }
        return rectangle2;
    }

    public List<Rectangle<C>> complexRoots(GenPolynomial<Complex<C>> genPolynomial, BigRational bigRational) {
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = this.engine.squarefreeFactors(genPolynomial);
        ArrayList<Rectangle<C>> arrayList = new ArrayList<Rectangle<C>>();
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<Complex<C>> genPolynomial2 = entry.getKey();
            Complex<C> complex = this.rootBound(genPolynomial2);
            AbelianGroupElem abelianGroupElem = complex.getRe();
            RingElem ringElem = (RingElem)abelianGroupElem.sum((AbelianGroupElem)((AbelianGroupElem)abelianGroupElem.factory().fromInteger(1L)));
            if (this.debug) {
                logger.info("rootBound = " + abelianGroupElem);
            }
            Complex[] complexArray = new Complex[]{new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)abelianGroupElem), new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)ringElem.negate()), new Complex<RingElem>(complexRing, (RingElem)abelianGroupElem, (RingElem)ringElem.negate()), new Complex<C>(complexRing, abelianGroupElem, abelianGroupElem)};
            Rectangle rectangle = new Rectangle(complexArray);
            try {
                List list = this.complexRoots(rectangle, genPolynomial2);
                ArrayList arrayList2 = new ArrayList(list.size());
                for (Rectangle rectangle2 : list) {
                    Rectangle rectangle3 = this.complexRootRefinement(rectangle2, genPolynomial2, bigRational);
                    arrayList2.add(rectangle3);
                }
                long l = entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.addAll(arrayList2);
                    ++n;
                }
            }
            catch (InvalidBoundaryException invalidBoundaryException) {
                throw new RuntimeException("this should never happen " + invalidBoundaryException);
            }
        }
        return arrayList;
    }

    public abstract Rectangle<C> invariantRectangle(Rectangle<C> var1, GenPolynomial<Complex<C>> var2, GenPolynomial<Complex<C>> var3) throws InvalidBoundaryException;

    public String toDecimal(Complex<C> complex) {
        C c = complex.getRe();
        String string = c.toString();
        BigRational bigRational = new BigRational(string);
        BigDecimal bigDecimal = new BigDecimal(bigRational);
        C c2 = complex.getIm();
        string = c2.toString();
        BigRational bigRational2 = new BigRational(string);
        BigDecimal bigDecimal2 = new BigDecimal(bigRational2);
        return bigDecimal.toString() + " i " + bigDecimal2.toString();
    }

    public Complex<BigDecimal> approximateRoot(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, C c) throws NoConvergenceException {
        if (rectangle == null) {
            throw new IllegalArgumentException("null interval not allowed");
        }
        Complex<GcdRingElem<BigDecimal>> complex = rectangle.getDecimalCenter();
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return complex;
        }
        if (rectangle.length().compareTo(c) < 0) {
            return complex;
        }
        ComplexRing complexRing = complex.ring;
        Complex<C> complex2 = rectangle.getSW();
        BigDecimal bigDecimal = new BigDecimal(((Rational)complex2.getRe()).getRational());
        BigDecimal bigDecimal2 = new BigDecimal(((Rational)complex2.getIm()).getRational());
        Complex<BigDecimal> complex3 = new Complex<BigDecimal>(complexRing, bigDecimal, bigDecimal2);
        Complex<C> complex4 = rectangle.getNE();
        BigDecimal bigDecimal3 = new BigDecimal(((Rational)complex4.getRe()).getRational());
        BigDecimal bigDecimal4 = new BigDecimal(((Rational)complex4.getIm()).getRational());
        Complex<BigDecimal> complex5 = new Complex<BigDecimal>(complexRing, bigDecimal3, bigDecimal4);
        BigDecimal bigDecimal5 = new BigDecimal(((Rational)c).getRational());
        Complex<BigDecimal> complex6 = new Complex<BigDecimal>(complexRing, new BigDecimal("0.25"));
        bigDecimal5 = bigDecimal5.multiply((BigDecimal)((Complex)complex.norm()).getRe());
        GenPolynomialRing<Complex<BigDecimal>> genPolynomialRing = new GenPolynomialRing<Complex<BigDecimal>>(complexRing, genPolynomial.ring);
        GenPolynomial<Complex<BigDecimal>> genPolynomial2 = PolyUtil.complexDecimalFromRational(genPolynomialRing, genPolynomial);
        GenPolynomial<Complex<C>> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        GenPolynomial<Complex<BigDecimal>> genPolynomial4 = PolyUtil.complexDecimalFromRational(genPolynomialRing, genPolynomial3);
        int n = 0;
        int n2 = -1;
        while (n++ < 50) {
            Complex<BigDecimal> complex7 = PolyUtil.evaluateMain(complexRing, genPolynomial2, complex);
            if (complex7.isZERO()) {
                return complex;
            }
            Complex<BigDecimal> complex8 = PolyUtil.evaluateMain(complexRing, genPolynomial4, complex);
            if (complex8.isZERO()) {
                throw new NoConvergenceException("zero deriviative should not happen");
            }
            AbelianGroupElem abelianGroupElem = complex7.divide(complex8);
            Complex<BigDecimal> complex9 = complex.subtract((Complex<GcdRingElem<BigDecimal>>)abelianGroupElem);
            if (((BigDecimal)((Complex)complex.subtract(complex9).norm()).getRe()).compareTo(bigDecimal5) <= 0) {
                return complex9;
            }
            while (complex9.getRe().compareTo(complex3.getRe()) < 0 || complex9.getIm().compareTo(complex3.getIm()) < 0 || complex9.getRe().compareTo(complex5.getRe()) > 0 || complex9.getIm().compareTo(complex5.getIm()) > 0) {
                GcdRingElem gcdRingElem;
                Serializable serializable;
                Complex<C> complex10;
                if (n++ > 50) {
                    throw new NoConvergenceException("no convergence after " + n + " steps");
                }
                if (n > 25 && n2 == 0) {
                    complex10 = rectangle.getCenter();
                    serializable = rectangle.exchangeSE(complex10);
                    gcdRingElem = serializable.getDecimalCenter();
                    complex = gcdRingElem;
                    abelianGroupElem = complexRing.getZERO();
                    logger.info("trying new SE starting point " + complex);
                    n = 0;
                    n2 = 1;
                }
                if (n > 25 && n2 == 1) {
                    complex10 = rectangle.getCenter();
                    serializable = rectangle.exchangeNW(complex10);
                    gcdRingElem = serializable.getDecimalCenter();
                    complex = gcdRingElem;
                    abelianGroupElem = complexRing.getZERO();
                    logger.info("trying new NW starting point " + complex);
                    n = 0;
                    n2 = 2;
                }
                if (n > 25 && n2 == 2) {
                    complex10 = rectangle.getCenter();
                    serializable = rectangle.exchangeSW(complex10);
                    gcdRingElem = serializable.getDecimalCenter();
                    complex = gcdRingElem;
                    abelianGroupElem = complexRing.getZERO();
                    logger.info("trying new SW starting point " + complex);
                    n = 0;
                    n2 = 3;
                }
                if (n > 25 && n2 == 3) {
                    complex10 = rectangle.getCenter();
                    serializable = rectangle.exchangeNE(complex10);
                    gcdRingElem = serializable.getDecimalCenter();
                    complex = gcdRingElem;
                    abelianGroupElem = complexRing.getZERO();
                    logger.info("trying new NE starting point " + complex);
                    n = 0;
                    n2 = 4;
                }
                if (n > 25 && (n2 == -1 || n2 == 4 || n2 == 5)) {
                    complex10 = rectangle.randomPoint();
                    serializable = new BigDecimal(((Rational)complex10.getRe()).getRational());
                    gcdRingElem = new BigDecimal(((Rational)complex10.getIm()).getRational());
                    Complex<Complex<BigDecimal>> complex11 = new Complex<Complex<BigDecimal>>(complexRing, (Complex<BigDecimal>)serializable, (Complex<BigDecimal>)gcdRingElem);
                    complex = complex11;
                    abelianGroupElem = complexRing.getZERO();
                    logger.info("trying new random starting point " + complex);
                    if (n2 == -1) {
                        n = 0;
                        n2 = 0;
                    } else if (n2 == 4) {
                        n = 0;
                        n2 = 5;
                    } else {
                        n2 = 6;
                    }
                }
                abelianGroupElem = abelianGroupElem.multiply(complex6);
                complex9 = complex.subtract((Complex<GcdRingElem<BigDecimal>>)abelianGroupElem);
            }
            complex = complex9;
        }
        throw new NoConvergenceException("no convergence after " + n + " steps");
    }

    public List<Complex<BigDecimal>> approximateRoots(GenPolynomial<Complex<C>> genPolynomial, C c) {
        ComplexRing complexRing = (ComplexRing)genPolynomial.ring.coFac;
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = this.engine.squarefreeFactors(genPolynomial);
        ArrayList<Complex<BigDecimal>> arrayList = new ArrayList<Complex<BigDecimal>>();
        for (Map.Entry<GenPolynomial<Complex<C>>, Long> entry : sortedMap.entrySet()) {
            Serializable serializable;
            Object object;
            RingElem ringElem;
            AbelianGroupElem abelianGroupElem;
            AbelianGroupElem<Complex<C>> abelianGroupElem2;
            GenPolynomial<Complex<C>> genPolynomial2 = entry.getKey();
            ArrayList arrayList2 = null;
            if (genPolynomial2.degree(0) <= 1L) {
                abelianGroupElem2 = genPolynomial2.trailingBaseCoefficient();
                abelianGroupElem2 = ((Complex)abelianGroupElem2).negate();
                abelianGroupElem = new BigDecimal(((Rational)((Complex)abelianGroupElem2).getRe()).getRational());
                ringElem = new BigDecimal(((Rational)((Complex)abelianGroupElem2).getIm()).getRational());
                object = new ComplexRing(abelianGroupElem);
                serializable = new Complex<RingElem>((ComplexRing<RingElem>)object, (RingElem)abelianGroupElem, ringElem);
                arrayList2 = new ArrayList(1);
                arrayList2.add(serializable);
            } else {
                abelianGroupElem2 = this.rootBound(genPolynomial2);
                abelianGroupElem = ((Complex)abelianGroupElem2).getRe();
                ringElem = (RingElem)abelianGroupElem.sum((AbelianGroupElem)((AbelianGroupElem)abelianGroupElem.factory().fromInteger(1L)));
                if (this.debug) {
                    logger.info("rootBound = " + abelianGroupElem);
                }
                object = new Complex[]{new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)abelianGroupElem), new Complex<RingElem>(complexRing, (RingElem)ringElem.negate(), (RingElem)ringElem.negate()), new Complex<RingElem>(complexRing, (RingElem)abelianGroupElem, (RingElem)ringElem.negate()), new Complex<C>(complexRing, abelianGroupElem, abelianGroupElem)};
                serializable = new Rectangle((Complex<C>[])object);
                List<Rectangle<RingElem>> list = null;
                try {
                    list = this.complexRoots((Rectangle<C>)serializable, genPolynomial2);
                }
                catch (InvalidBoundaryException invalidBoundaryException) {
                    throw new RuntimeException("this should never happen " + invalidBoundaryException);
                }
                arrayList2 = new ArrayList(list.size());
                for (Rectangle<RingElem> rectangle : list) {
                    Complex<BigDecimal> complex = null;
                    while (complex == null) {
                        try {
                            complex = this.approximateRoot(rectangle, genPolynomial2, c);
                            arrayList2.add(complex);
                        }
                        catch (NoConvergenceException noConvergenceException) {
                            BigRational bigRational = rectangle.rationalLength();
                            bigRational = bigRational.multiply(new BigRational(1L, 1000L));
                            try {
                                rectangle = this.complexRootRefinement(rectangle, genPolynomial2, bigRational);
                                logger.info("fall back rootRefinement = " + rectangle);
                            }
                            catch (InvalidBoundaryException invalidBoundaryException) {
                                throw new RuntimeException("this should never happen " + invalidBoundaryException);
                            }
                        }
                    }
                }
            }
            long l = entry.getValue();
            int n = 0;
            while ((long)n < l) {
                arrayList.addAll(arrayList2);
                ++n;
            }
        }
        return arrayList;
    }

    public Complex[] copyOfComplex(Complex[] complexArray, int n) {
        Complex[] complexArray2 = new Complex[n];
        System.arraycopy(complexArray, 0, complexArray2, 0, Math.min(complexArray.length, n));
        return complexArray2;
    }

    public Rectangle<C> invariantMagnitudeRectangle(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2, C c) throws InvalidBoundaryException {
        Rectangle<C> rectangle2 = rectangle;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return rectangle2;
        }
        if (genPolynomial2.isConstant()) {
            return rectangle2;
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return rectangle2;
        }
        GenPolynomial<Complex<C>> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        Object object = this.magnitudeBound(rectangle, genPolynomial3);
        BigRational bigRational = rectangle2.rationalLength();
        BigRational bigRational2 = new BigRational(1L, 2L);
        Object object2 = rectangle2.length();
        object2 = (RingElem)object2.multiply(object2);
        while (((RingElem)object.multiply(object2)).compareTo(c) >= 0) {
            bigRational = bigRational.multiply(bigRational2);
            rectangle2 = this.complexRootRefinement(rectangle2, genPolynomial, bigRational);
            object2 = rectangle2.length();
            object2 = (RingElem)object2.multiply((Object)object2);
        }
        return rectangle2;
    }

    public Complex<C> complexRectangleMagnitude(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2) {
        if (genPolynomial2.isZERO() || genPolynomial2.isConstant()) {
            return genPolynomial2.leadingBaseCoefficient();
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        Complex<C> complex = rectangle.getCenter();
        Complex<C> complex2 = PolyUtil.evaluateMain(ringFactory, genPolynomial2, complex);
        return complex2;
    }

    public Complex<C> complexMagnitude(Rectangle<C> rectangle, GenPolynomial<Complex<C>> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2, C c) throws InvalidBoundaryException {
        if (genPolynomial2.isZERO() || genPolynomial2.isConstant()) {
            return genPolynomial2.leadingBaseCoefficient();
        }
        Rectangle<C> rectangle2 = this.invariantMagnitudeRectangle(rectangle, genPolynomial, genPolynomial2, c);
        return this.complexRectangleMagnitude(rectangle2, genPolynomial, genPolynomial2);
    }
}

