/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationGenerator;
import edu.jas.poly.RelationTable;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class WeylRelations<C extends RingElem<C>>
implements RelationGenerator<C> {
    private final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(WeylRelations.class);

    public WeylRelations() {
        this.ring = null;
    }

    public WeylRelations(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.ring = genSolvablePolynomialRing;
        if (this.ring.nvar <= 1 || this.ring.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + this.ring.nvar);
        }
    }

    public void generate() {
        if (this.ring == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.generate(this.ring);
    }

    @Override
    public void generate(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        if (genSolvablePolynomialRing == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        if (genSolvablePolynomialRing.nvar <= 1 || genSolvablePolynomialRing.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + genSolvablePolynomialRing.nvar);
        }
        RelationTable relationTable = genSolvablePolynomialRing.table;
        int n = genSolvablePolynomialRing.nvar;
        int n2 = n / 2;
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomialRing.getONE()).copy();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)genSolvablePolynomialRing.getZERO()).copy();
        for (int i = n2; i < n; ++i) {
            ExpVector expVector = ExpVector.create(n, i, 1L);
            int n3 = i - n2;
            ExpVector expVector2 = ExpVector.create(n, n3, 1L);
            ExpVector expVector3 = expVector2.sum(expVector);
            GenPolynomial genPolynomial3 = ((GenSolvablePolynomial)genPolynomial).multiply(expVector3);
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial3.sum(genPolynomial);
            if (genSolvablePolynomial.isZERO()) {
                logger.info("ring = " + genSolvablePolynomialRing);
                logger.info("one  = " + genPolynomial);
                logger.info("zero = " + genPolynomial2);
                logger.info("b    = " + genPolynomial3);
                logger.info("rel  = " + genSolvablePolynomial);
                throw new RuntimeException("rel.isZERO()");
            }
            relationTable.update(expVector2, expVector, genSolvablePolynomial);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\nWeyl relations = " + relationTable);
        }
    }
}

