/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBaseFGLM<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseFGLM.class);
    private GroebnerBaseAbstract<C> sgb;

    public GroebnerBaseFGLM() {
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> reduction) {
        super(reduction);
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> reduction, PairList<C> pairList) {
        super(reduction, pairList);
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> reduction, PairList<C> pairList, GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        super(reduction, pairList);
        this.sgb = groebnerBaseAbstract;
    }

    public GroebnerBaseFGLM(GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        this.sgb = groebnerBaseAbstract;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        if (n != 0) {
            throw new UnsupportedOperationException("case modv != 0 not yet implemented");
        }
        if (list == null || list.size() == 0) {
            return list;
        }
        List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>();
        if (list.size() <= 1) {
            GenPolynomial<C> genPolynomial = list.get(0).monic();
            list2.add(genPolynomial);
            return list2;
        }
        ArrayList arrayList = new ArrayList(list.size());
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field: " + genPolynomialRing.coFac);
        }
        TermOrder termOrder = new TermOrder(4);
        GenPolynomialRing<C> genPolynomialRing2 = new GenPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, termOrder, genPolynomialRing.getVars());
        for (GenPolynomial<C> genPolynomial : list) {
            GenPolynomial genPolynomial2 = genPolynomialRing2.copy(genPolynomial);
            arrayList.add(genPolynomial2);
        }
        if (this.sgb == null) {
            this.sgb = GBFactory.getImplementation(genPolynomialRing.coFac);
        }
        List list3 = this.sgb.GB(n, arrayList);
        logger.info("graded GB = " + list3);
        if (termOrder.equals(genPolynomialRing.tord)) {
            return list3;
        }
        if (list3.size() == 0) {
            return list3;
        }
        if (list3.size() == 1) {
            GenPolynomial<C> genPolynomial;
            genPolynomial = genPolynomialRing.copy((GenPolynomial)list3.get(0));
            list2.add(genPolynomial);
            return list2;
        }
        list2 = this.convGroebnerToLex(list3);
        return list2;
    }

    public List<GenPolynomial<C>> convGroebnerToLex(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        int n = this.commonZeroTest(list);
        if (n != 0) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional, dim =  " + n);
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        int n2 = genPolynomialRing.nvar;
        String[] stringArray = genPolynomialRing.getVars();
        RingFactory ringFactory = genPolynomialRing.coFac;
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing<GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>> genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>>(ringFactory, n2, termOrder, stringArray);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>();
        ArrayList arrayList3 = new ArrayList();
        GenPolynomial genPolynomial = genPolynomialRing.ONE;
        arrayList3.add(genPolynomial);
        int n3 = 1;
        GenPolynomialRing genPolynomialRing3 = this.createRingOfIndeterminates(genPolynomialRing, n3);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, genPolynomialRing);
        GenPolynomial<GenPolynomial<Object>> genPolynomial2 = ((GenPolynomial)genPolynomialRing4.getZERO()).sum(genPolynomialRing3.univariate(0));
        n = -1;
        genPolynomial = this.lMinterm(arrayList2, genPolynomial);
        while (genPolynomial != null) {
            GenPolynomial genPolynomial3;
            GenPolynomial<C> genPolynomial4 = this.red.normalform(list, genPolynomial);
            GenPolynomial genPolynomial5 = PolyUtil.toRecursive(genPolynomialRing4, genPolynomial4);
            GenPolynomial genPolynomial6 = genPolynomial5.sum(genPolynomial2);
            List list2 = new ArrayList(genPolynomial6.getMap().values());
            n = this.commonZeroTest(list2 = this.red.irreducibleSet(list2));
            if (n != 0) {
                ++n3;
                arrayList3.add(genPolynomial);
                genPolynomialRing3 = this.addIndeterminate(genPolynomialRing3);
                genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing3, genPolynomialRing);
                genPolynomial5 = PolyUtil.toRecursive(genPolynomialRing4, genPolynomial4);
                genPolynomial3 = ((GenPolynomial)genPolynomialRing4.getZERO()).sum(genPolynomialRing3.univariate(0));
                GenPolynomial genPolynomial7 = genPolynomial5.multiply(genPolynomial3);
                genPolynomial2 = PolyUtil.extendCoefficients(genPolynomialRing4, genPolynomial2, 0, 0L);
                genPolynomial2 = genPolynomial7.sum(genPolynomial2);
            } else {
                genPolynomial3 = genPolynomialRing2.getZERO();
                for (GenPolynomial genPolynomial8 : list2) {
                    int[] nArray;
                    ExpVector expVector = genPolynomial8.leadingExpVector();
                    if (expVector == null || (nArray = expVector.dependencyOnVariables()) == null || nArray.length == 0) continue;
                    int n4 = nArray[0];
                    n4 = n3 - n4;
                    GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial8.trailingBaseCoefficient();
                    if (gcdRingElem.isZERO()) continue;
                    gcdRingElem = (GcdRingElem)gcdRingElem.negate();
                    GenPolynomial<GcdRingElem> genPolynomial9 = ((GenPolynomial)arrayList3.get(n4 - 1)).multiply(gcdRingElem);
                    genPolynomial3 = genPolynomial3.sum((GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>)genPolynomial9);
                }
                genPolynomial3 = genPolynomial3.sum((GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>)genPolynomial);
                genPolynomial3 = genPolynomialRing2.copy(genPolynomial3);
                arrayList2.add(genPolynomial);
                if (!genPolynomial3.isZERO()) {
                    arrayList.add(genPolynomial3);
                    logger.info("new element for GB = " + genPolynomial3.leadingExpVector());
                }
            }
            genPolynomial = this.lMinterm(arrayList2, genPolynomial);
        }
        return arrayList;
    }

    public GenPolynomial<C> lMinterm(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        int n = genPolynomialRing.nvar;
        GenPolynomial<Object> genPolynomial2 = new GenPolynomial(genPolynomialRing, genPolynomial.leadingBaseCoefficient(), genPolynomial.leadingExpVector());
        ReductionSeq<Object> reductionSeq = new ReductionSeq<Object>();
        for (int i = n - 1; i >= 0; --i) {
            GenPolynomial genPolynomial3 = genPolynomialRing.univariate(i);
            if (!reductionSeq.isTopReducible(list, genPolynomial2 = genPolynomial2.multiply((Object)genPolynomial3))) {
                return genPolynomial2;
            }
            GenPolynomial genPolynomial4 = genPolynomialRing.univariate(i, genPolynomial2.degree(n - (i + 1)));
            genPolynomial2 = genPolynomial2.divide(genPolynomial4);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<C>> redTerms(List<GenPolynomial<C>> list) {
        int n;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("groebnerBasis may not be null or empty");
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        int n2 = genPolynomialRing.nvar;
        long[] lArray = new long[n2];
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isONE()) {
                arrayList.clear();
                return arrayList;
            }
            ExpVector expVector = genPolynomial.leadingExpVector();
            if (expVector.totalDeg() != expVector.maxDeg()) continue;
            for (n = 0; n < n2; ++n) {
                long l = expVector.getVal(n);
                if (l <= 0L) continue;
                lArray[n] = l;
            }
        }
        long l = this.maxArray(lArray);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] != 0L) continue;
            logger.info("dimension not zero, setting degree to " + l);
            lArray[i] = l;
        }
        arrayList.add(genPolynomialRing.ONE);
        ReductionSeq reductionSeq = new ReductionSeq();
        for (n = 0; n < n2; ++n) {
            GenPolynomial genPolynomial = genPolynomialRing.univariate(n);
            ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList);
            for (GenPolynomial genPolynomial2 : arrayList2) {
                int n3 = 1;
                while ((long)n3 <= lArray[n]) {
                    void genPolynomial22;
                    GenPolynomial genPolynomial3 = genPolynomial22.multiply(genPolynomial);
                    if (!reductionSeq.isReducible(list, genPolynomial3)) {
                        arrayList.add(genPolynomial3);
                    }
                    ++n3;
                }
            }
        }
        return arrayList;
    }

    GenPolynomialRing<C> createRingOfIndeterminates(GenPolynomialRing<C> genPolynomialRing, int n) {
        RingFactory ringFactory = genPolynomialRing.coFac;
        int n2 = n;
        String[] stringArray = new String[n2];
        for (int i = 1; i <= n2; ++i) {
            stringArray[i - 1] = "Y" + i;
        }
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(ringFactory, n2, termOrder, stringArray);
        return genPolynomialRing2;
    }

    GenPolynomialRing<C> addIndeterminate(GenPolynomialRing<C> genPolynomialRing) {
        String[] stringArray = new String[1];
        int n = genPolynomialRing.nvar + 1;
        stringArray[0] = "Y" + n;
        genPolynomialRing = genPolynomialRing.extend(stringArray);
        return genPolynomialRing;
    }

    long maxArray(long[] lArray) {
        if (lArray.length == 0) {
            return 0L;
        }
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] <= l) continue;
            l = lArray[i];
        }
        return l;
    }

    @Override
    public void terminate() {
        if (this.sgb == null) {
            return;
        }
        this.sgb.terminate();
    }

    @Override
    public int cancel() {
        if (this.sgb == null) {
            return 0;
        }
        return this.sgb.cancel();
    }
}

