/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBExerClient;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerServerEC;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReducerClientEC;
import edu.jas.gb.ReducerServerEC;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.DistThreadPool;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseDistributedEC<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseDistributedEC.class);
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final transient ThreadPool pool;
    protected static final int DEFAULT_PORT = 55711;
    protected final int DHT_PORT;
    protected final int port;
    protected final String mfile;
    private final transient DistThreadPool dtp;
    private final transient DistHashTableServer<Integer> dhts;

    public GroebnerBaseDistributedEC(String string) {
        this(string, 2, 55711);
    }

    public GroebnerBaseDistributedEC(String string, int n) {
        this(string, n, new ThreadPool(n), 55711);
    }

    public GroebnerBaseDistributedEC(String string, int n, int n2) {
        this(string, n, new ThreadPool(n), n2);
    }

    public GroebnerBaseDistributedEC(String string, int n, ThreadPool threadPool, int n2) {
        this(string, n, threadPool, new OrderedPairlist(), n2);
    }

    public GroebnerBaseDistributedEC(String string, int n, PairList<C> pairList, int n2) {
        this(string, n, new ThreadPool(n), pairList, n2);
    }

    public GroebnerBaseDistributedEC(String string, int n, ThreadPool threadPool, PairList<C> pairList, int n2) {
        super(new ReductionPar(), pairList);
        this.threads = n;
        this.mfile = string == null || string.length() == 0 ? "../util/machines" : string;
        if (n < 1) {
            n = 1;
        }
        if (threadPool == null) {
            threadPool = new ThreadPool(n);
        }
        this.pool = threadPool;
        this.port = n2;
        logger.info("machine file " + string + ", port = " + n2);
        this.dtp = new DistThreadPool(this.threads, this.mfile);
        logger.info("running " + this.dtp);
        this.DHT_PORT = this.dtp.getEC().getMasterPort() + 100;
        this.dhts = new DistHashTableServer(this.DHT_PORT);
        this.dhts.init();
        logger.info("running " + this.dhts);
    }

    @Override
    public void terminate() {
        this.terminate(true);
    }

    public void terminate(boolean bl) {
        this.pool.terminate();
        this.dtp.terminate(bl);
        logger.info("dhts.terminate()");
        this.dhts.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        if (!list2.get((int)0).ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        String string = this.dtp.getEC().getMasterHost();
        GBExerClient gBExerClient = new GBExerClient(string, this.port, this.DHT_PORT);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gBExerClient);
        }
        List<GenPolynomial<C>> list3 = this.GBMaster(n, list2);
        return list3;
    }

    List<GenPolynomial<C>> GBMaster(int n, List<GenPolynomial<C>> list) {
        int n2;
        GenPolynomial genPolynomial;
        ChannelFactory channelFactory = new ChannelFactory(this.port);
        channelFactory.init();
        logger.info("GBMaster on " + channelFactory);
        List<GenPolynomial<C>> list2 = list;
        if (list2.isEmpty()) {
            throw new IllegalArgumentException("empty polynomial list not allowed");
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.debug("looking for clients");
        DistHashTable distHashTable = new DistHashTable("localhost", this.DHT_PORT);
        distHashTable.init();
        List list3 = pairList.getList();
        for (int i = 0; i < list3.size(); ++i) {
            genPolynomial = distHashTable.put(i, list3.get(i));
            if (genPolynomial == null) continue;
            logger.info("double polynomials " + i + ", nn = " + genPolynomial + ", al(i) = " + list3.get(i));
        }
        while (distHashTable.size() < list3.size()) {
            logger.info("#distributed list = " + distHashTable.size() + " #pairlist list = " + list3.size());
            GenPolynomial genPolynomial2 = distHashTable.getWait(list3.size() - 1);
        }
        Terminator terminator = new Terminator(this.threads);
        for (n2 = 0; n2 < this.threads; ++n2) {
            genPolynomial = new ReducerServerEC(terminator, channelFactory, distHashTable, pairList);
            this.pool.addJob((Runnable)((Object)genPolynomial));
        }
        logger.debug("main loop waiting");
        terminator.waitDone();
        n2 = distHashTable.size();
        logger.debug("#distributed list = " + n2);
        list2 = pairList.getList();
        if (n2 != list2.size()) {
            logger.warn("#distributed list = " + distHashTable.size() + " #pairlist list = " + list2.size());
        }
        long l = System.currentTimeMillis();
        List<GenPolynomial<C>> list4 = this.minimalGB(list2);
        l = System.currentTimeMillis() - l;
        logger.debug("parallel gbmi = " + l);
        list2 = list4;
        logger.debug("cf.terminate()");
        channelFactory.terminate();
        logger.debug("theList.terminate()");
        distHashTable.clear();
        distHashTable.terminate();
        logger.info("" + pairList);
        return list2;
    }

    public static <C extends RingElem<C>> void clientPart(String string, int n, int n2) throws IOException {
        ChannelFactory channelFactory = new ChannelFactory(n + 10);
        channelFactory.init();
        logger.info("clientPart connecting to " + string + ", port = " + n + ", dhtport = " + n2);
        SocketChannel socketChannel = channelFactory.getChannel(string, n);
        DistHashTable distHashTable = new DistHashTable(string, n2);
        distHashTable.init();
        ReducerClientEC reducerClientEC = new ReducerClientEC(socketChannel, distHashTable);
        logger.info("clientPart running on " + string + ", pairChannel = " + socketChannel);
        reducerClientEC.run();
        socketChannel.close();
        distHashTable.terminate();
        channelFactory.terminate();
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerServerEC[] miReducerServerECArray = new MiReducerServerEC[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerServerECArray[n] = new MiReducerServerEC(arrayList3, genPolynomial);
            this.pool.addJob(miReducerServerECArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerServerECArray.length; ++n) {
            genPolynomial = miReducerServerECArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

