/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalSolvablePolynomialRing;
import edu.jas.application.SolvableLocal;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class LocalSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableLocal<C>> {
    public final LocalSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(LocalSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> localSolvablePolynomialRing) {
        super(localSolvablePolynomialRing);
        this.ring = localSolvablePolynomialRing;
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> localSolvablePolynomialRing, SolvableLocal<C> solvableLocal, ExpVector expVector) {
        this(localSolvablePolynomialRing);
        if (solvableLocal != null && !solvableLocal.isZERO()) {
            this.val.put(expVector, solvableLocal);
        }
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> localSolvablePolynomialRing, SolvableLocal<C> solvableLocal) {
        this(localSolvablePolynomialRing, solvableLocal, localSolvablePolynomialRing.evzero);
    }

    public LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> localSolvablePolynomialRing, GenSolvablePolynomial<SolvableLocal<C>> genSolvablePolynomial) {
        this(localSolvablePolynomialRing, genSolvablePolynomial.getMap());
    }

    protected LocalSolvablePolynomial(LocalSolvablePolynomialRing<C> localSolvablePolynomialRing, SortedMap<ExpVector, SolvableLocal<C>> sortedMap) {
        this(localSolvablePolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public LocalSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public LocalSolvablePolynomial<C> copy() {
        return new LocalSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LocalSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(LocalSolvablePolynomial<C> localSolvablePolynomial) {
        if (localSolvablePolynomial == null || localSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (localSolvablePolynomial.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return localSolvablePolynomial;
        }
        assert (this.ring.nvar == localSolvablePolynomial.ring.nvar);
        if (this.debug) {
            logger.debug("ring = " + this.ring);
        }
        ExpVector expVector = this.ring.evzero;
        GenSolvablePolynomial genSolvablePolynomial = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableLocal solvableLocal = (SolvableLocal)this.ring.getONECoefficient();
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = localSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            SolvableLocal solvableLocal2 = (SolvableLocal)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (this.debug) {
                logger.info("e = " + expVector2 + ", a = " + solvableLocal2);
            }
            for (Map.Entry entry2 : set) {
                AbelianGroupElem<ExpVector> abelianGroupElem;
                RingElem ringElem;
                Object object;
                LocalSolvablePolynomial<C> localSolvablePolynomial2;
                GenSolvablePolynomial genSolvablePolynomial3;
                RingElem<GenPolynomial<GenPolynomial<C>>> ringElem2;
                GenSolvablePolynomial genSolvablePolynomial4;
                SolvableLocal solvableLocal3 = (SolvableLocal)entry2.getValue();
                ExpVector expVector3 = (ExpVector)entry2.getKey();
                if (this.debug) {
                    logger.info("f = " + expVector3 + ", b = " + solvableLocal3);
                }
                int[] nArray = expVector3.dependencyOnVariables();
                int n = 0;
                if (nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                }
                int n2 = this.ring.nvar + 1 - n;
                LocalSolvablePolynomial<ExpVector> localSolvablePolynomial3 = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || solvableLocal3.isConstant() || expVector2.isZERO()) {
                    localSolvablePolynomial3 = new LocalSolvablePolynomial<ExpVector>(this.ring, solvableLocal3, expVector2);
                    if (this.debug) {
                        logger.info("symmetric coeff: b = " + solvableLocal3 + ", e = " + expVector2);
                    }
                } else {
                    if (this.debug) {
                        logger.info("unsymmetric coeff: b = " + solvableLocal3 + ", e = " + expVector2);
                    }
                    if (solvableLocal3.den.isONE()) {
                        genSolvablePolynomial4 = new RecSolvablePolynomial(this.ring.polCoeff, expVector2);
                        ringElem2 = new RecSolvablePolynomial(this.ring.polCoeff, solvableLocal3.num);
                        genSolvablePolynomial3 = ((RecSolvablePolynomial)genSolvablePolynomial4).multiply(ringElem2);
                        localSolvablePolynomial2 = this.ring.fromPolyCoefficients(genSolvablePolynomial3);
                        localSolvablePolynomial3 = localSolvablePolynomial2;
                    } else {
                        if (this.debug) {
                            logger.info("coeff-num: Cps = " + localSolvablePolynomial3 + ", num = " + solvableLocal3.num + ", den = " + solvableLocal3.den);
                        }
                        localSolvablePolynomial3 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal3.ring.getONE(), expVector2);
                        genSolvablePolynomial4 = localSolvablePolynomial3;
                        ringElem2 = new SolvableLocal(solvableLocal3.ring, solvableLocal3.den);
                        genSolvablePolynomial3 = ((LocalSolvablePolynomial)genSolvablePolynomial4).multiply((SolvableLocal<C>)ringElem2);
                        localSolvablePolynomial2 = ((LocalSolvablePolynomial)genSolvablePolynomial4).multiplyLeft((SolvableLocal<C>)ringElem2);
                        object = (LocalSolvablePolynomial)genSolvablePolynomial3.subtract(localSolvablePolynomial2);
                        SolvableLocal solvableLocal4 = new SolvableLocal(solvableLocal3.ring, solvableLocal3.ring.ring.getONE(), solvableLocal3.den);
                        ringElem = ((LocalSolvablePolynomial)object).multiply(solvableLocal4);
                        LocalSolvablePolynomial localSolvablePolynomial4 = (LocalSolvablePolynomial)genSolvablePolynomial4.subtract(ringElem);
                        localSolvablePolynomial4 = localSolvablePolynomial4.multiplyLeft(solvableLocal4);
                        localSolvablePolynomial3 = localSolvablePolynomial4;
                        if (!solvableLocal3.num.isONE()) {
                            abelianGroupElem = new SolvableLocal(solvableLocal3.ring, solvableLocal3.num);
                            localSolvablePolynomial3 = localSolvablePolynomial3.multiply((SolvableLocal<ExpVector>)abelianGroupElem);
                        }
                    }
                }
                if (this.debug) {
                    logger.info("coeff-den: Cps = " + localSolvablePolynomial3);
                }
                genSolvablePolynomial4 = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
                ringElem2 = null;
                if (this.ring.table.isEmpty() || localSolvablePolynomial3.isConstant() || expVector3.isZERO()) {
                    if (this.debug) {
                        logger.info("symmetric poly: b = " + solvableLocal3 + ", e = " + expVector2);
                    }
                    object = expVector2.sum(expVector3);
                    ringElem2 = localSolvablePolynomial3.isConstant() ? new LocalSolvablePolynomial<C>(this.ring, (SolvableLocal)localSolvablePolynomial3.leadingBaseCoefficient(), (ExpVector)object) : this.shift(localSolvablePolynomial3, expVector3);
                } else {
                    if (this.debug) {
                        logger.info("unsymmetric poly: Cps = " + localSolvablePolynomial3 + ", f = " + expVector3);
                    }
                    for (Map.Entry entry3 : localSolvablePolynomial3.val.entrySet()) {
                        ExpVector expVector4;
                        int n3;
                        ringElem = (SolvableLocal)entry3.getValue();
                        abelianGroupElem = (ExpVector)entry3.getKey();
                        if (this.debug) {
                            logger.info("g = " + abelianGroupElem + ", c = " + ringElem);
                        }
                        int[] nArray2 = ((ExpVector)abelianGroupElem).dependencyOnVariables();
                        int n4 = this.ring.nvar + 1;
                        if (nArray2.length > 0) {
                            n4 = nArray2[0];
                        }
                        if ((n3 = this.ring.nvar + 1 - n4) <= n2) {
                            expVector4 = ((ExpVector)abelianGroupElem).sum(expVector3);
                            if (this.debug) {
                                logger.info("disjoint poly: g = " + abelianGroupElem + ", f = " + expVector3 + ", h = " + expVector4);
                            }
                            ringElem2 = (LocalSolvablePolynomial)genSolvablePolynomial2.sum(solvableLocal, expVector4);
                        } else {
                            expVector4 = ((ExpVector)abelianGroupElem).subst(n4, 0L);
                            ExpVector expVector5 = expVector.subst(n4, ((ExpVector)abelianGroupElem).getVal(n4));
                            ExpVector expVector6 = expVector3.subst(n, 0L);
                            ExpVector expVector7 = expVector.subst(n, expVector3.getVal(n));
                            if (this.debug) {
                                logger.info("poly, g1 = " + expVector4 + ", f1 = " + expVector6 + ", Dps = " + genSolvablePolynomial4);
                                logger.info("poly, g2 = " + expVector5 + ", f2 = " + expVector7);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector5, expVector7);
                            if (this.debug) {
                                logger.info("poly, g  = " + abelianGroupElem + ", f  = " + expVector3 + ", rel = " + tableRelation);
                            }
                            ringElem2 = new LocalSolvablePolynomial<C>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                localSolvablePolynomial2 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, tableRelation.f);
                                ringElem2 = ((LocalSolvablePolynomial)ringElem2).multiply(localSolvablePolynomial2);
                                ExpVector expVector8 = tableRelation.e == null ? expVector5 : expVector5.subtract(tableRelation.e);
                                this.ring.table.update(expVector8, expVector7, ringElem2);
                            }
                            if (tableRelation.e != null) {
                                genSolvablePolynomial3 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, tableRelation.e);
                                ringElem2 = ((LocalSolvablePolynomial)genSolvablePolynomial3).multiply((LocalSolvablePolynomial<C>)ringElem2);
                                this.ring.table.update(expVector5, expVector7, ringElem2);
                            }
                            if (!expVector6.isZERO()) {
                                localSolvablePolynomial2 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector6);
                                ringElem2 = ((LocalSolvablePolynomial)ringElem2).multiply(localSolvablePolynomial2);
                            }
                            if (!expVector4.isZERO()) {
                                genSolvablePolynomial3 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector4);
                                ringElem2 = ((LocalSolvablePolynomial)genSolvablePolynomial3).multiply((LocalSolvablePolynomial<C>)ringElem2);
                            }
                        }
                        ringElem2 = ((LocalSolvablePolynomial)ringElem2).multiplyLeft((SolvableLocal<C>)ringElem);
                        genSolvablePolynomial4 = (LocalSolvablePolynomial)genSolvablePolynomial4.sum(ringElem2);
                    }
                    ringElem2 = genSolvablePolynomial4;
                }
                ringElem2 = ((LocalSolvablePolynomial)ringElem2).multiplyLeft(solvableLocal2);
                if (this.debug) {
                    logger.debug("Ds = " + ringElem2);
                }
                genSolvablePolynomial = (LocalSolvablePolynomial)genSolvablePolynomial.sum(ringElem2);
            }
        }
        return genSolvablePolynomial;
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(LocalSolvablePolynomial<C> localSolvablePolynomial, LocalSolvablePolynomial<C> localSolvablePolynomial2) {
        if (localSolvablePolynomial.isZERO() || localSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (localSolvablePolynomial.isONE()) {
            return this.multiply(localSolvablePolynomial2);
        }
        if (localSolvablePolynomial2.isONE()) {
            return localSolvablePolynomial.multiply(this);
        }
        return localSolvablePolynomial.multiply(this).multiply(localSolvablePolynomial2);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> solvableLocal) {
        LocalSolvablePolynomial<C> localSolvablePolynomial = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return localSolvablePolynomial;
        }
        if (solvableLocal.isONE()) {
            return this;
        }
        localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, this.ring.evzero);
        return this.multiply(localSolvablePolynomial);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> solvableLocal, SolvableLocal<C> solvableLocal2) {
        LocalSolvablePolynomial<C> localSolvablePolynomial = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return localSolvablePolynomial;
        }
        if (solvableLocal2 == null || solvableLocal2.isZERO()) {
            return localSolvablePolynomial;
        }
        if (solvableLocal.isONE() && solvableLocal2.isONE()) {
            return this;
        }
        localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, this.ring.evzero);
        LocalSolvablePolynomial<C> localSolvablePolynomial2 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal2, this.ring.evzero);
        return this.multiply(localSolvablePolynomial, localSolvablePolynomial2);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableLocal solvableLocal = (SolvableLocal)this.ring.getONECoefficient();
        return this.multiply(solvableLocal, expVector);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        SolvableLocal solvableLocal = (SolvableLocal)this.ring.getONECoefficient();
        return this.multiply(solvableLocal, expVector, solvableLocal, expVector2);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> solvableLocal, ExpVector expVector) {
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableLocal.isONE() && expVector.isZERO()) {
            return this;
        }
        LocalSolvablePolynomial<C> localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector);
        return this.multiply(localSolvablePolynomial);
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(SolvableLocal<C> solvableLocal, ExpVector expVector, SolvableLocal<C> solvableLocal2, ExpVector expVector2) {
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableLocal2 == null || solvableLocal2.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableLocal.isONE() && expVector.isZERO() && solvableLocal2.isONE() && expVector2.isZERO()) {
            return this;
        }
        LocalSolvablePolynomial<C> localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector);
        LocalSolvablePolynomial<C> localSolvablePolynomial2 = new LocalSolvablePolynomial<C>(this.ring, solvableLocal2, expVector2);
        return this.multiply(localSolvablePolynomial, localSolvablePolynomial2);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(SolvableLocal<C> solvableLocal, ExpVector expVector) {
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return this.ring.getZERO();
        }
        LocalSolvablePolynomial<C> localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector);
        return localSolvablePolynomial.multiply(this);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableLocal solvableLocal = (SolvableLocal)this.ring.getONECoefficient();
        LocalSolvablePolynomial<C> localSolvablePolynomial = new LocalSolvablePolynomial<C>(this.ring, solvableLocal, expVector);
        return localSolvablePolynomial.multiply(this);
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(SolvableLocal<C> solvableLocal) {
        GenSolvablePolynomial genSolvablePolynomial = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableLocal == null || solvableLocal.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((LocalSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            SolvableLocal solvableLocal2 = (SolvableLocal)entry.getValue();
            SolvableLocal<SolvableLocal> solvableLocal3 = solvableLocal.multiply(solvableLocal2);
            if (solvableLocal3.isZERO()) continue;
            sortedMap.put(expVector, solvableLocal3);
        }
        return genSolvablePolynomial;
    }

    @Override
    public LocalSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableLocal<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public LocalSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableLocal<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    protected LocalSolvablePolynomial<C> shift(LocalSolvablePolynomial<C> localSolvablePolynomial, ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((LocalSolvablePolynomial)this.ring.getZERO()).copy();
        if (localSolvablePolynomial == null || localSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return localSolvablePolynomial;
        }
        SortedMap sortedMap = ((LocalSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = localSolvablePolynomial.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            SolvableLocal solvableLocal = (SolvableLocal)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (solvableLocal.isZERO()) continue;
            sortedMap.put(expVector3, solvableLocal);
        }
        return genSolvablePolynomial;
    }
}

