/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.PrimitiveIterator;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceGenericDD
implements AcceptanceOmegaDD {
    private AcceptanceGeneric.ElementType kind;
    private AcceptanceGenericDD left = null;
    private AcceptanceGenericDD right = null;
    private JDDNode states = null;

    public AcceptanceGenericDD(AcceptanceGeneric acceptanceGeneric, JDDVars jDDVars) {
        switch (acceptanceGeneric.getKind()) {
            case AND: 
            case OR: {
                this.kind = acceptanceGeneric.getKind();
                this.left = (AcceptanceGenericDD)acceptanceGeneric.getLeft().toAcceptanceDD(jDDVars);
                this.right = (AcceptanceGenericDD)acceptanceGeneric.getRight().toAcceptanceDD(jDDVars);
                return;
            }
            case TRUE: {
                this.kind = AcceptanceGeneric.ElementType.TRUE;
                return;
            }
            case FALSE: {
                this.kind = AcceptanceGeneric.ElementType.FALSE;
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                this.kind = acceptanceGeneric.getKind();
                this.states = JDD.Constant(0.0);
                PrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(acceptanceGeneric.getStates()).iterator();
                while (ofInt.hasNext()) {
                    int n = (Integer)ofInt.next();
                    this.states = JDD.SetVectorElement(this.states, jDDVars, n, 1.0);
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operatator in generic acceptance condition");
    }

    public AcceptanceGenericDD(boolean bl) {
        this.kind = bl ? AcceptanceGeneric.ElementType.TRUE : AcceptanceGeneric.ElementType.FALSE;
    }

    public AcceptanceGenericDD(AcceptanceGeneric.ElementType elementType, JDDNode jDDNode) {
        this.kind = elementType;
        this.left = null;
        this.right = null;
        this.states = jDDNode;
    }

    public AcceptanceGenericDD(AcceptanceGeneric.ElementType elementType, AcceptanceGenericDD acceptanceGenericDD, AcceptanceGenericDD acceptanceGenericDD2) {
        this.kind = elementType;
        this.left = acceptanceGenericDD;
        this.right = acceptanceGenericDD2;
        this.states = null;
    }

    public AcceptanceGeneric.ElementType getKind() {
        return this.kind;
    }

    public AcceptanceGenericDD getLeft() {
        return this.left;
    }

    public AcceptanceGenericDD getRight() {
        return this.right;
    }

    public JDDNode getStates() {
        if (this.states != null) {
            JDD.Ref(this.states);
        }
        return this.states;
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        switch (this.kind) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case AND: {
                return this.left.isBSCCAccepting(jDDNode) && this.right.isBSCCAccepting(jDDNode);
            }
            case OR: {
                return this.left.isBSCCAccepting(jDDNode) || this.right.isBSCCAccepting(jDDNode);
            }
            case INF: {
                return JDD.AreIntersecting(this.states, jDDNode);
            }
            case INF_NOT: {
                JDD.Ref(this.states);
                return JDD.AreIntersecting(JDD.Not(this.states), jDDNode);
            }
            case FIN: {
                return !JDD.AreIntersecting(this.states, jDDNode);
            }
            case FIN_NOT: {
                JDD.Ref(this.states);
                return !JDD.AreIntersecting(JDD.Not(this.states), jDDNode);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return;
            }
            case AND: 
            case OR: {
                this.left.intersect(jDDNode);
                this.right.intersect(jDDNode);
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                this.states = JDD.And(this.states, jDDNode.copy());
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }

    @Override
    public AcceptanceGenericDD clone() {
        switch (this.kind) {
            case TRUE: {
                return new AcceptanceGenericDD(true);
            }
            case FALSE: {
                return new AcceptanceGenericDD(false);
            }
            case AND: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, this.left.clone(), this.right.clone());
            }
            case OR: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.OR, this.left.clone(), this.right.clone());
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return new AcceptanceGenericDD(this.kind, this.states.copy());
            }
        }
        throw new UnsupportedOperationException("Unsupported operatator in generic acceptance condition");
    }

    @Override
    public String getSizeStatistics() {
        return "generic acceptance with " + this.countAcceptanceSets() + " acceptance sets";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERIC;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to required acceptance type");
    }

    @Override
    public AcceptanceGenericDD complementToGeneric() {
        switch (this.kind) {
            case TRUE: {
                return new AcceptanceGenericDD(false);
            }
            case FALSE: {
                return new AcceptanceGenericDD(true);
            }
            case AND: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.OR, this.getLeft().complementToGeneric(), this.getRight().complementToGeneric());
            }
            case OR: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, this.getLeft().complementToGeneric(), this.getRight().complementToGeneric());
            }
            case FIN: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, this.states.copy());
            }
            case FIN_NOT: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF_NOT, this.states.copy());
            }
            case INF: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.FIN, this.states.copy());
            }
            case INF_NOT: {
                return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.FIN_NOT, this.states.copy());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        return this.clone();
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void clear() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return;
            }
            case AND: 
            case OR: {
                this.left.clear();
                this.right.clear();
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                if (this.states != null) {
                    JDD.Deref(this.states);
                }
                this.states = null;
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }

    public int countAcceptanceSets() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return 0;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return 1;
            }
            case AND: 
            case OR: {
                return this.left.countAcceptanceSets() + this.right.countAcceptanceSets();
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance expression");
    }
}

