/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceBuchi;
import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabinDD;
import acceptance.AcceptanceStreettDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.PrimitiveIterator;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceBuchiDD
implements AcceptanceOmegaDD {
    private JDDNode acceptingStates;

    public AcceptanceBuchiDD(JDDNode jDDNode) {
        this.acceptingStates = jDDNode;
    }

    public AcceptanceBuchiDD(AcceptanceBuchi acceptanceBuchi, JDDVars jDDVars) {
        this.acceptingStates = JDD.Constant(0.0);
        PrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(acceptanceBuchi.getAcceptingStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.acceptingStates = JDD.SetVectorElement(this.acceptingStates, jDDVars, n, 1.0);
        }
    }

    public JDDNode getAcceptingStates() {
        JDD.Ref(this.acceptingStates);
        return this.acceptingStates;
    }

    public void setAcceptingStates(JDDNode jDDNode) {
        this.clear();
        this.acceptingStates = jDDNode;
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        return JDD.AreIntersecting(this.acceptingStates, jDDNode);
    }

    @Override
    public AcceptanceBuchiDD clone() {
        return new AcceptanceBuchiDD(this.acceptingStates.copy());
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        this.acceptingStates = JDD.And(this.acceptingStates, jDDNode.copy());
    }

    @Override
    public String getSizeStatistics() {
        return "one set of accepting states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.BUCHI;
    }

    public AcceptanceStreettDD toStreett() {
        AcceptanceStreettDD acceptanceStreettDD = new AcceptanceStreettDD();
        acceptanceStreettDD.add(new AcceptanceStreettDD.StreettPairDD(JDD.Constant(1.0), this.acceptingStates.copy()));
        return acceptanceStreettDD;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return this.complementToRabin();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    public AcceptanceRabinDD complementToRabin() {
        AcceptanceRabinDD acceptanceRabinDD = new AcceptanceRabinDD();
        acceptanceRabinDD.add(new AcceptanceRabinDD.RabinPairDD(this.acceptingStates.copy(), JDD.Constant(1.0)));
        return acceptanceRabinDD;
    }

    public AcceptanceStreettDD complementToStreett() {
        AcceptanceStreettDD acceptanceStreettDD = new AcceptanceStreettDD();
        acceptanceStreettDD.add(new AcceptanceStreettDD.StreettPairDD(this.acceptingStates.copy(), JDD.Constant(0.0)));
        return acceptanceStreettDD;
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, this.acceptingStates.copy());
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void clear() {
        if (this.acceptingStates != null) {
            JDD.Deref(this.acceptingStates);
        }
    }
}

