/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import userinterface.util.FontColorPair;

public class FontChooser
extends JDialog
implements ListSelectionListener,
ActionListener,
FocusListener,
ChangeListener {
    protected Font lastFont;
    protected Color lastColor;
    protected Font defaultFont;
    protected Color defaultColor;
    protected boolean shouldReturn;
    String tempValue;
    private JButton cancelButton;
    protected JColorChooser colorChooser;
    private JButton defaultButton;
    private JTextField fontBox;
    private JList fontList;
    private JPanel fontPanel;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel32;
    private JPanel jPanel33;
    private JPanel jPanel34;
    private JPanel jPanel35;
    private JPanel jPanel36;
    private JPanel jPanel37;
    private JPanel jPanel38;
    private JPanel jPanel39;
    private JPanel jPanel40;
    private JPanel jPanel41;
    private JPanel jPanel42;
    private JPanel jPanel43;
    private JPanel jPanel44;
    private JPanel jPanel45;
    private JPanel jPanel46;
    private JPanel jPanel47;
    private JPanel jPanel48;
    private JPanel jPanel49;
    private JPanel jPanel50;
    private JPanel jPanel51;
    private JPanel jPanel52;
    private JPanel jPanel53;
    private JPanel jPanel54;
    private JPanel jPanel55;
    private JPanel jPanel56;
    private JPanel jPanel57;
    private JPanel jPanel58;
    private JPanel jPanel59;
    private JPanel jPanel60;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JButton okayButton;
    private JLabel previewLabel;
    private JTextField sizeBox;
    private JList sizeList;
    private JTextField styleBox;
    private JList styleList;
    private JTabbedPane theTabs;

    public FontChooser(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.previewLabel.setBackground(Color.white);
        this.doListModels();
        this.doListeners();
        this.shouldReturn = true;
    }

    public FontChooser(Dialog dialog) {
        super(dialog, true);
        this.initComponents();
        this.previewLabel.setBackground(Color.white);
        this.doListModels();
        this.doListeners();
        this.shouldReturn = true;
        this.setLocationRelativeTo(this.getParent());
    }

    public static FontColorPair getFont(Dialog dialog, Font font, Color color, Font font2, Color color2) {
        FontChooser fontChooser = new FontChooser(dialog);
        fontChooser.shouldReturn = true;
        fontChooser.defaultFont = font2;
        fontChooser.defaultColor = color2;
        fontChooser.lastColor = color;
        fontChooser.lastFont = font;
        fontChooser.colorChooser.setColor(fontChooser.lastColor);
        fontChooser.setFont(fontChooser.lastFont);
        fontChooser.updatePreview();
        fontChooser.setVisible(true);
        FontColorPair fontColorPair = new FontColorPair();
        fontColorPair.f = fontChooser.lastFont;
        fontColorPair.c = fontChooser.lastColor;
        if (fontChooser.shouldReturn) {
            return fontColorPair;
        }
        return null;
    }

    public static FontColorPair getFont(Frame frame, Font font, Color color, Font font2, Color color2) {
        FontChooser fontChooser = new FontChooser(frame);
        fontChooser.shouldReturn = true;
        fontChooser.defaultFont = font2;
        fontChooser.defaultColor = color2;
        fontChooser.lastColor = color;
        fontChooser.lastFont = font;
        fontChooser.colorChooser.setColor(fontChooser.lastColor);
        fontChooser.setFont(fontChooser.lastFont);
        fontChooser.updatePreview();
        fontChooser.setVisible(true);
        FontColorPair fontColorPair = new FontColorPair();
        fontColorPair.f = fontChooser.lastFont;
        fontColorPair.c = fontChooser.lastColor;
        if (fontChooser.shouldReturn) {
            return fontColorPair;
        }
        return null;
    }

    private void doListModels() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        String[] stringArray2 = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        String[] stringArray3 = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray2);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(stringArray3);
        this.fontList.setModel(defaultComboBoxModel);
        this.styleList.setModel(defaultComboBoxModel2);
        this.sizeList.setModel(defaultComboBoxModel3);
    }

    private void doListeners() {
        this.fontList.addListSelectionListener(this);
        this.styleList.addListSelectionListener(this);
        this.sizeList.addListSelectionListener(this);
        this.fontBox.addActionListener(this);
        this.styleBox.addActionListener(this);
        this.sizeBox.addActionListener(this);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.defaultButton.addActionListener(this);
        this.fontPanel.addFocusListener(this);
        this.theTabs.addChangeListener(this);
    }

    private void initComponents() {
        this.theTabs = new JTabbedPane();
        this.fontPanel = new JPanel();
        this.jPanel35 = new JPanel();
        this.jPanel36 = new JPanel();
        this.jPanel37 = new JPanel();
        this.jPanel38 = new JPanel();
        this.jPanel39 = new JPanel();
        this.fontBox = new JTextField();
        this.jPanel40 = new JPanel();
        this.jPanel41 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel42 = new JPanel();
        this.jPanel43 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.fontList = new JList();
        this.jPanel44 = new JPanel();
        this.jPanel45 = new JPanel();
        this.jPanel46 = new JPanel();
        this.jPanel47 = new JPanel();
        this.styleBox = new JTextField();
        this.jPanel48 = new JPanel();
        this.jPanel49 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel50 = new JPanel();
        this.jPanel51 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.styleList = new JList();
        this.jPanel52 = new JPanel();
        this.jPanel53 = new JPanel();
        this.jPanel54 = new JPanel();
        this.sizeBox = new JTextField();
        this.jPanel55 = new JPanel();
        this.jPanel56 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel57 = new JPanel();
        this.jPanel58 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.sizeList = new JList();
        this.jPanel59 = new JPanel();
        this.jPanel60 = new JPanel();
        this.previewLabel = new JLabel();
        this.colorChooser = new JColorChooser();
        this.jPanel32 = new JPanel();
        this.jPanel33 = new JPanel();
        this.defaultButton = new JButton();
        this.jPanel34 = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FontChooser.this.closeDialog(windowEvent);
            }
        });
        this.fontPanel.setLayout(new BorderLayout());
        this.jPanel35.setLayout(new BorderLayout());
        this.jPanel35.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.jPanel36.setLayout(new BorderLayout());
        this.jPanel36.setMaximumSize(new Dimension(450, 100));
        this.jPanel36.setPreferredSize(new Dimension(450, 100));
        this.jPanel37.setLayout(new BoxLayout(this.jPanel37, 0));
        this.jPanel38.setLayout(new BorderLayout());
        this.jPanel38.setPreferredSize(new Dimension(200, 183));
        this.jPanel39.setLayout(new BorderLayout());
        this.jPanel39.add((Component)this.fontBox, "Center");
        this.jPanel40.setMinimumSize(new Dimension(5, 10));
        this.jPanel40.setPreferredSize(new Dimension(5, 10));
        this.jPanel39.add((Component)this.jPanel40, "West");
        this.jPanel41.setLayout(new BorderLayout());
        this.jLabel4.setDisplayedMnemonic('F');
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setLabelFor(this.fontList);
        this.jLabel4.setText("Font:");
        this.jPanel41.add((Component)this.jLabel4, "Center");
        this.jPanel42.setMinimumSize(new Dimension(5, 10));
        this.jPanel42.setPreferredSize(new Dimension(5, 10));
        this.jPanel41.add((Component)this.jPanel42, "West");
        this.jPanel39.add((Component)this.jPanel41, "North");
        this.jPanel38.add((Component)this.jPanel39, "North");
        this.jPanel43.setLayout(new BorderLayout());
        this.jPanel43.setPreferredSize(new Dimension(269, 100));
        this.jScrollPane4.setViewportView(this.fontList);
        this.jPanel43.add((Component)this.jScrollPane4, "Center");
        this.jPanel43.add((Component)this.jPanel44, "West");
        this.jPanel38.add((Component)this.jPanel43, "Center");
        this.jPanel37.add(this.jPanel38);
        this.jPanel45.setLayout(new BoxLayout(this.jPanel45, 0));
        this.jPanel45.setPreferredSize(new Dimension(100, 163));
        this.jPanel46.setLayout(new BorderLayout());
        this.jPanel47.setLayout(new BorderLayout());
        this.jPanel47.add((Component)this.styleBox, "Center");
        this.jPanel48.setMinimumSize(new Dimension(5, 10));
        this.jPanel48.setPreferredSize(new Dimension(5, 10));
        this.jPanel47.add((Component)this.jPanel48, "West");
        this.jPanel49.setLayout(new BorderLayout());
        this.jLabel5.setDisplayedMnemonic('y');
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setLabelFor(this.styleList);
        this.jLabel5.setText("Font style:");
        this.jPanel49.add((Component)this.jLabel5, "Center");
        this.jPanel50.setMinimumSize(new Dimension(5, 10));
        this.jPanel50.setPreferredSize(new Dimension(5, 10));
        this.jPanel49.add((Component)this.jPanel50, "West");
        this.jPanel47.add((Component)this.jPanel49, "North");
        this.jPanel46.add((Component)this.jPanel47, "North");
        this.jPanel51.setLayout(new BorderLayout());
        this.jPanel51.setPreferredSize(new Dimension(269, 100));
        this.jScrollPane5.setViewportView(this.styleList);
        this.jPanel51.add((Component)this.jScrollPane5, "Center");
        this.jPanel51.add((Component)this.jPanel52, "West");
        this.jPanel46.add((Component)this.jPanel51, "Center");
        this.jPanel45.add(this.jPanel46);
        this.jPanel37.add(this.jPanel45);
        this.jPanel53.setLayout(new BorderLayout());
        this.jPanel53.setPreferredSize(new Dimension(100, 163));
        this.jPanel54.setLayout(new BorderLayout());
        this.jPanel54.add((Component)this.sizeBox, "Center");
        this.jPanel55.setMinimumSize(new Dimension(5, 10));
        this.jPanel55.setPreferredSize(new Dimension(5, 10));
        this.jPanel54.add((Component)this.jPanel55, "West");
        this.jPanel56.setLayout(new BorderLayout());
        this.jLabel6.setDisplayedMnemonic('S');
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setLabelFor(this.sizeList);
        this.jLabel6.setText("Size:");
        this.jPanel56.add((Component)this.jLabel6, "Center");
        this.jPanel57.setMinimumSize(new Dimension(5, 10));
        this.jPanel57.setPreferredSize(new Dimension(5, 10));
        this.jPanel56.add((Component)this.jPanel57, "West");
        this.jPanel54.add((Component)this.jPanel56, "North");
        this.jPanel53.add((Component)this.jPanel54, "North");
        this.jPanel58.setLayout(new BorderLayout());
        this.jPanel58.setPreferredSize(new Dimension(269, 100));
        this.jScrollPane6.setViewportView(this.sizeList);
        this.jPanel58.add((Component)this.jScrollPane6, "Center");
        this.jPanel58.add((Component)this.jPanel59, "West");
        this.jPanel53.add((Component)this.jPanel58, "Center");
        this.jPanel37.add(this.jPanel53);
        this.jPanel36.add((Component)this.jPanel37, "Center");
        this.jPanel35.add((Component)this.jPanel36, "Center");
        this.jPanel60.setLayout(new BorderLayout());
        this.jPanel60.setBorder(new TitledBorder(null, "Preview", 0, 0, new Font("Dialog", 0, 12)));
        this.previewLabel.setBackground(new Color(255, 255, 255));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setText("AaBbCcDdEeFf123456789!\"\u00a3$%^");
        this.previewLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.previewLabel.setMaximumSize(new Dimension(207, 75));
        this.previewLabel.setMinimumSize(new Dimension(207, 75));
        this.previewLabel.setPreferredSize(new Dimension(207, 75));
        this.jPanel60.add((Component)this.previewLabel, "North");
        this.jPanel35.add((Component)this.jPanel60, "South");
        this.fontPanel.add((Component)this.jPanel35, "Center");
        this.theTabs.addTab("Font", this.fontPanel);
        this.theTabs.addTab("Colour", this.colorChooser);
        this.getContentPane().add((Component)this.theTabs, "North");
        this.jPanel32.setLayout(new GridLayout(1, 0));
        this.jPanel33.setLayout(new FlowLayout(0));
        this.defaultButton.setFont(new Font("Dialog", 0, 12));
        this.defaultButton.setMnemonic('D');
        this.defaultButton.setText("Default...");
        this.jPanel33.add(this.defaultButton);
        this.jPanel32.add(this.jPanel33);
        this.jPanel34.setLayout(new FlowLayout(2));
        this.okayButton.setFont(new Font("Dialog", 0, 12));
        this.okayButton.setText("OK");
        this.okayButton.setMaximumSize(new Dimension(89, 25));
        this.okayButton.setMinimumSize(new Dimension(89, 25));
        this.okayButton.setPreferredSize(new Dimension(89, 25));
        this.jPanel34.add(this.okayButton);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(89, 25));
        this.cancelButton.setMinimumSize(new Dimension(89, 25));
        this.cancelButton.setPreferredSize(new Dimension(89, 25));
        this.jPanel34.add(this.cancelButton);
        this.jPanel32.add(this.jPanel34);
        this.getContentPane().add((Component)this.jPanel32, "South");
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new FontChooser(new JFrame()).setVisible(true);
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fontBox) {
            String string = this.fontBox.getText();
            for (int i = 0; i < this.fontList.getModel().getSize(); ++i) {
                String string2 = ((String)this.fontList.getModel().getElementAt(i)).toLowerCase();
                if (!string2.startsWith(string.toLowerCase())) continue;
                Object e = this.fontList.getModel().getElementAt(i);
                this.fontList.setSelectedValue(e, true);
                break;
            }
            this.tempValue = (String)this.fontList.getSelectedValue();
            if (this.tempValue != null) {
                this.fontBox.setText(this.tempValue);
            } else {
                this.fontBox.setText("");
            }
        } else if (actionEvent.getSource() == this.styleBox) {
            String string = this.styleBox.getText();
            for (int i = 0; i < this.styleList.getModel().getSize(); ++i) {
                String string3 = ((String)this.styleList.getModel().getElementAt(i)).toLowerCase();
                if (!string3.startsWith(string.toLowerCase())) continue;
                Object e = this.styleList.getModel().getElementAt(i);
                this.styleList.setSelectedValue(e, true);
                break;
            }
            this.tempValue = (String)this.styleList.getSelectedValue();
            if (this.tempValue != null) {
                this.fontBox.setText(this.tempValue);
            } else {
                this.fontBox.setText("");
            }
        } else if (actionEvent.getSource() == this.sizeBox) {
            String string = this.sizeBox.getText();
            boolean bl = false;
            for (int i = 0; i < this.sizeList.getModel().getSize(); ++i) {
                String string4 = ((String)this.sizeList.getModel().getElementAt(i)).toLowerCase();
                if (!string4.startsWith(string.toLowerCase())) continue;
                bl = true;
                Object e = this.sizeList.getModel().getElementAt(i);
                this.sizeList.setSelectedValue(e, true);
                this.tempValue = (String)this.sizeList.getSelectedValue();
                if (this.tempValue != null) {
                    this.sizeBox.setText(this.tempValue);
                    break;
                }
                this.sizeBox.setText("");
                break;
            }
            if (!bl) {
                this.sizeList.setSelectedIndex(-1);
            }
        } else if (actionEvent.getSource() == this.defaultButton) {
            if (this.defaultFont != null && this.defaultColor != null) {
                this.setFont(this.defaultFont);
                this.colorChooser.setColor(this.defaultColor);
                this.lastColor = this.colorChooser.getColor();
                this.updatePreview();
            }
        } else if (actionEvent.getSource() == this.okayButton) {
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.shouldReturn = false;
            this.setVisible(false);
        }
        if (this.fontValid()) {
            this.lastFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            this.lastColor = this.colorChooser.getColor();
            this.updatePreview();
        }
    }

    public String getFontName() {
        return this.fontBox.getText();
    }

    public int getFontStyle() {
        int n = 0;
        switch (this.styleList.getSelectedIndex()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
            }
        }
        return n;
    }

    public int getFontSize() {
        int n = 12;
        try {
            n = Integer.parseInt(this.sizeBox.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public boolean fontValid() {
        boolean bl = false;
        String string = this.fontBox.getText();
        for (int i = 0; i < this.fontList.getModel().getSize(); ++i) {
            String string2 = ((String)this.fontList.getModel().getElementAt(i)).toLowerCase();
            if (!string2.startsWith(string.toLowerCase())) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        return bl;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            Object object;
            int n;
            String string = font.getName();
            int n2 = font.getStyle();
            String string2 = "" + font.getSize();
            for (n = 0; n < this.fontList.getModel().getSize(); ++n) {
                String string3 = ((String)this.fontList.getModel().getElementAt(n)).toLowerCase();
                if (!string3.equals(string.toLowerCase())) continue;
                object = this.fontList.getModel().getElementAt(n);
                this.fontList.setSelectedValue(object, true);
                this.fontBox.setText((String)object);
                break;
            }
            switch (n2) {
                case 0: {
                    this.styleList.setSelectedIndex(0);
                    break;
                }
                case 2: {
                    this.styleList.setSelectedIndex(2);
                    break;
                }
                case 1: {
                    this.styleList.setSelectedIndex(1);
                    break;
                }
                case 3: {
                    this.styleList.setSelectedIndex(3);
                }
            }
            n = 0;
            for (int i = 0; i < this.sizeList.getModel().getSize(); ++i) {
                object = ((String)this.sizeList.getModel().getElementAt(i)).toLowerCase();
                if (!((String)object).equals(string2.toLowerCase())) continue;
                Object e = this.sizeList.getModel().getElementAt(i);
                this.sizeList.setSelectedValue(e, true);
                this.sizeBox.setText((String)e);
                n = 1;
                break;
            }
            if (n == 0) {
                this.sizeBox.setText(string2);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.fontList) {
            this.tempValue = (String)this.fontList.getSelectedValue();
            if (this.tempValue != null) {
                this.fontBox.setText(this.tempValue);
            } else {
                this.fontBox.setText("");
            }
        } else if (listSelectionEvent.getSource() == this.styleList) {
            this.tempValue = (String)this.styleList.getSelectedValue();
            if (this.tempValue != null) {
                this.styleBox.setText(this.tempValue);
            } else {
                this.styleBox.setText("");
            }
        } else if (listSelectionEvent.getSource() == this.sizeList) {
            this.tempValue = (String)this.sizeList.getSelectedValue();
            if (this.tempValue != null) {
                this.sizeBox.setText(this.tempValue);
            } else {
                this.sizeBox.setText("");
            }
        }
        if (this.fontValid()) {
            this.lastFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            this.lastColor = this.colorChooser.getColor();
            this.updatePreview();
        }
    }

    public void updatePreview() {
        if (this.lastFont != null && this.lastColor != null) {
            this.previewLabel.setForeground(this.lastColor);
            this.previewLabel.setFont(this.lastFont);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.fontValid()) {
            this.lastFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            this.lastColor = this.colorChooser.getColor();
            this.updatePreview();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.fontValid()) {
            this.lastFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            this.lastColor = this.colorChooser.getColor();
            this.updatePreview();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.fontValid()) {
            this.lastFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            this.lastColor = this.colorChooser.getColor();
            this.updatePreview();
        }
    }
}

