/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import userinterface.GUIPrism;
import userinterface.simulator.GUISimulator;

public class GUISimulatorUpdatesTable
extends JTable
implements ListSelectionListener {
    public static Color[] DISTRIBUTION_COLOURS = new Color[]{new Color(255, 255, 255), new Color(253, 255, 201)};
    private GUISimulator.UpdateTableModel utm;
    private UpdateHeaderListModel headerModel;
    private JList header;
    private UpdateHeaderRenderer updateHeaderRenderer;
    private UpdateTableRenderer updateTableRenderer;
    private GUISimulator sim;

    public GUISimulatorUpdatesTable(GUISimulator.UpdateTableModel updateTableModel, GUISimulator gUISimulator) {
        super(updateTableModel);
        this.sim = gUISimulator;
        this.utm = updateTableModel;
        this.getSelectionModel().addListSelectionListener(this);
        this.setColumnSelectionAllowed(false);
        this.getSelectionModel().setSelectionMode(0);
        this.headerModel = new UpdateHeaderListModel();
        JList jList = new JList(this.headerModel);
        jList.setBackground(new JPanel().getBackground());
        jList.setFixedCellWidth(15);
        jList.setFixedCellHeight(this.getRowHeight());
        this.updateHeaderRenderer = new UpdateHeaderRenderer(this);
        jList.setCellRenderer(this.updateHeaderRenderer);
        this.header = jList;
        this.updateTableRenderer = new UpdateTableRenderer();
        this.setDefaultRenderer(Object.class, this.updateTableRenderer);
        this.setAutoResizeMode(3);
        ComponentInputMap componentInputMap = new ComponentInputMap(this);
        ((InputMap)componentInputMap).put(KeyStroke.getKeyStroke(40, 0), "Down");
        ((InputMap)componentInputMap).put(KeyStroke.getKeyStroke(38, 0), "Up");
        ActionMap actionMap = new ActionMap();
        actionMap.put("Down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUISimulatorUpdatesTable.this.getSelectedRow();
                if (n != -1) {
                    if (n < GUISimulatorUpdatesTable.this.getRowCount() - 1) {
                        GUISimulatorUpdatesTable.this.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                    } else {
                        GUISimulatorUpdatesTable.this.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            }
        });
        actionMap.put("Up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUISimulatorUpdatesTable.this.getSelectedRow();
                if (n != -1) {
                    if (n >= 1) {
                        GUISimulatorUpdatesTable.this.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                    } else {
                        GUISimulatorUpdatesTable.this.getSelectionModel().setSelectionInterval(GUISimulatorUpdatesTable.this.getRowCount() - 1, GUISimulatorUpdatesTable.this.getRowCount() - 1);
                    }
                }
            }
        });
        this.setInputMap(0, componentInputMap);
        this.setActionMap(actionMap);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.updateTableRenderer != null) {
            this.updateTableRenderer.setFont(font);
        }
        this.setRowHeight(this.getFontMetrics(font).getHeight() + 4);
        if (this.header != null) {
            this.header.setFixedCellHeight(this.getRowHeight());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.headerModel != null) {
            this.headerModel.updateHeader();
        }
        this.repaint();
    }

    public JList getUpdateRowHeader() {
        return this.header;
    }

    class UpdateHeaderListModel
    extends AbstractListModel {
        UpdateHeaderListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return "" + n;
        }

        @Override
        public int getSize() {
            return GUISimulatorUpdatesTable.this.utm.getRowCount();
        }

        public void updateHeader() {
            this.fireContentsChanged(this, 0, GUISimulatorUpdatesTable.this.utm.getRowCount());
        }
    }

    class UpdateHeaderRenderer
    extends JButton
    implements ListCellRenderer {
        ImageIcon selectedIcon;
        ImageIcon selectedDisabledIcon;

        UpdateHeaderRenderer(JTable jTable) {
            this.setBorder(null);
            this.selectedIcon = GUIPrism.getIconFromImage("smallItemSelected.png");
            this.selectedDisabledIcon = GUIPrism.getIconFromImage("smallItemSelectedDisabled.png");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBorder(null);
            if (GUISimulatorUpdatesTable.this.getSelectedRow() == n) {
                if (GUISimulatorUpdatesTable.this.isEnabled()) {
                    this.setIcon(this.selectedIcon);
                } else {
                    this.setIcon(this.selectedDisabledIcon);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    class UpdateTableRenderer
    implements TableCellRenderer {
        JTextField renderer = new JTextField("");

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.renderer.setText(object == null ? "" : object.toString());
            int n3 = GUISimulatorUpdatesTable.this.sim.getModulesFile().getModelType().nondeterministic() ? GUISimulatorUpdatesTable.this.utm.getChoiceIndexOf(n) : 0;
            Color color = DISTRIBUTION_COLOURS[n3 % 2];
            if (bl) {
                Color color2 = new Color(color.getRed() - 20, color.getGreen() - 20, color.getBlue());
                if (GUISimulatorUpdatesTable.this.utm.oldUpdate) {
                    color2 = new Color(color2.getRed() - 7, color2.getGreen() - 7, color2.getBlue() - 7);
                    this.renderer.setBackground(color2);
                } else {
                    this.renderer.setBackground(color2);
                }
            } else if (GUISimulatorUpdatesTable.this.utm.oldUpdate) {
                Color color3 = new Color(color.getRed() - 7, color.getGreen() - 7, color.getBlue() - 7);
                this.renderer.setBackground(color3);
            } else {
                this.renderer.setBackground(color);
            }
            this.renderer.setBorder(new EmptyBorder(1, 1, 1, 1));
            return this.renderer;
        }

        public void setFont(Font font) {
            this.renderer.setFont(font);
        }
    }
}

