/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import prism.PrismException;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.graph.GUIImageExportDialog;
import userinterface.graph.Graph;
import userinterface.graph.GraphException;
import userinterface.graph.GraphOptions;

public class GUIGraphHandler
extends JPanel
implements MouseListener {
    private boolean canDelete;
    private JTabbedPane theTabs;
    private JPopupMenu backMenu;
    private JPopupMenu graphMenu;
    private List<Graph> models;
    private List<GraphOptions> options;
    private GUIPlugin plug;
    private Action graphOptions;
    private Action zoomIn;
    private Action zoomOut;
    private Action zoomDefault;
    private Action printGraph;
    private Action deleteGraph;
    private Action exportImageJPG;
    private Action exportImagePNG;
    private Action exportImageEPS;
    private Action exportXML;
    private Action exportMatlab;
    private Action importXML;
    private JMenu zoomMenu;
    private JMenu exportMenu;
    private JMenu importMenu;
    private FileFilter pngFilter;
    private FileFilter jpgFilter;
    private FileFilter epsFilter;
    private FileFilter graFilter;
    private FileFilter matlabFilter;

    public GUIGraphHandler(JFrame jFrame, GUIPlugin gUIPlugin, boolean bl) {
        this.plug = gUIPlugin;
        this.canDelete = bl;
        this.graphMenu = new JPopupMenu();
        this.backMenu = new JPopupMenu();
        this.initComponents();
        this.pngFilter = new FileNameExtensionFilter("PNG files (*.png)", "png");
        this.jpgFilter = new FileNameExtensionFilter("JPEG files (*.jpg, *.jpeg)", "jpg", "jpeg");
        this.epsFilter = new FileNameExtensionFilter("Encapsulated PostScript files (*.eps)", "eps");
        this.graFilter = new FileNameExtensionFilter("PRISM graph files (*.gra, *.xml)", "gra", "xml");
        this.matlabFilter = new FileNameExtensionFilter("Matlab files (*.m)", "m");
        this.models = new ArrayList<Graph>();
        this.options = new ArrayList<GraphOptions>();
    }

    private void initComponents() {
        this.theTabs = new JTabbedPane();
        this.theTabs.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.theTabs, "Center");
        this.graphOptions = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptions graphOptions = GUIGraphHandler.this.options.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                graphOptions.setVisible(true);
            }
        };
        this.graphOptions.putValue("Name", "Graph options");
        this.graphOptions.putValue("MnemonicKey", new Integer(71));
        this.graphOptions.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOptions.png"));
        this.graphOptions.putValue("LongDescription", "Displays the options dialog for the graph.");
        this.zoomIn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                graph.zoomInBoth(-1.0, -1.0);
            }
        };
        this.zoomIn.putValue("Name", "In");
        this.zoomIn.putValue("MnemonicKey", new Integer(73));
        this.zoomIn.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerFwd.png"));
        this.zoomIn.putValue("LongDescription", "Zoom in on the graph.");
        this.zoomOut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                graph.zoomOutBoth(-1.0, -1.0);
            }
        };
        this.zoomOut.putValue("Name", "Out");
        this.zoomOut.putValue("MnemonicKey", new Integer(79));
        this.zoomOut.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerRew.png"));
        this.zoomOut.putValue("LongDescription", "Zoom out of the graph.");
        this.zoomDefault = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                graph.restoreAutoBounds();
            }
        };
        this.zoomDefault.putValue("Name", "Default");
        this.zoomDefault.putValue("MnemonicKey", new Integer(68));
        this.zoomDefault.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPlayerStart.png"));
        this.zoomDefault.putValue("LongDescription", "Set the default zoom for the graph.");
        this.importXML = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIGraphHandler.this.plug.showOpenFileDialog(GUIGraphHandler.this.graFilter) != 0) {
                    return;
                }
                try {
                    Graph graph = Graph.load(GUIGraphHandler.this.plug.getChooserFile());
                    GUIGraphHandler.this.addGraph(graph);
                }
                catch (GraphException graphException) {
                    GUIGraphHandler.this.plug.error("Could not import PRISM graph file:\n" + graphException.getMessage());
                }
            }
        };
        this.importXML.putValue("Name", "PRISM graph (*.gra)");
        this.importXML.putValue("MnemonicKey", new Integer(73));
        this.importXML.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.importXML.putValue("LongDescription", "Imports a saved PRISM graph from a file.");
        this.exportXML = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIGraphHandler.this.plug.showSaveFileDialog(GUIGraphHandler.this.graFilter) != 0) {
                    return;
                }
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                try {
                    graph.save(GUIGraphHandler.this.plug.getChooserFile());
                }
                catch (PrismException prismException) {
                    GUIGraphHandler.this.plug.error("Could not export PRISM graph file:\n" + prismException.getMessage());
                }
            }
        };
        this.exportXML.putValue("Name", "PRISM graph (*.gra)");
        this.exportXML.putValue("MnemonicKey", new Integer(88));
        this.exportXML.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileGraph.png"));
        this.exportXML.putValue("LongDescription", "Export graph as a PRISM graph file.");
        this.exportImageJPG = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog gUIImageExportDialog = new GUIImageExportDialog(GUIGraphHandler.this.plug.getGUI(), GUIGraphHandler.this.getModel(GUIGraphHandler.this.theTabs.getSelectedIndex()), 0);
                GUIGraphHandler.this.saveImage(gUIImageExportDialog);
            }
        };
        this.exportImageJPG.putValue("Name", "JPEG Interchange Format (*.jpg, *.jpeg)");
        this.exportImageJPG.putValue("MnemonicKey", new Integer(74));
        this.exportImageJPG.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileImage.png"));
        this.exportImageJPG.putValue("LongDescription", "Export graph as a JPEG file.");
        this.exportImagePNG = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog gUIImageExportDialog = new GUIImageExportDialog(GUIGraphHandler.this.plug.getGUI(), GUIGraphHandler.this.getModel(GUIGraphHandler.this.theTabs.getSelectedIndex()), 1);
                GUIGraphHandler.this.saveImage(gUIImageExportDialog);
            }
        };
        this.exportImagePNG.putValue("Name", "Portable Network Graphics (*.png)");
        this.exportImagePNG.putValue("MnemonicKey", new Integer(80));
        this.exportImagePNG.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileImage.png"));
        this.exportImagePNG.putValue("LongDescription", "Export graph as a Portable Network Graphics file.");
        this.exportImageEPS = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog gUIImageExportDialog = new GUIImageExportDialog(GUIGraphHandler.this.plug.getGUI(), GUIGraphHandler.this.getModel(GUIGraphHandler.this.theTabs.getSelectedIndex()), 2);
                GUIGraphHandler.this.saveImage(gUIImageExportDialog);
            }
        };
        this.exportImageEPS.putValue("Name", "Encapsulated PostScript (*.eps)");
        this.exportImageEPS.putValue("MnemonicKey", new Integer(69));
        this.exportImageEPS.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFilePdf.png"));
        this.exportImageEPS.putValue("LongDescription", "Export graph as an Encapsulated PostScript file.");
        this.exportMatlab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIGraphHandler.this.plug.showSaveFileDialog(GUIGraphHandler.this.matlabFilter) != 0) {
                    return;
                }
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                try {
                    graph.exportToMatlab(GUIGraphHandler.this.plug.getChooserFile());
                }
                catch (IOException iOException) {
                    GUIGraphHandler.this.plug.error("Could not export Matlab file:\n" + iOException.getMessage());
                }
            }
        };
        this.exportMatlab.putValue("Name", "Matlab file (*.m)");
        this.exportMatlab.putValue("MnemonicKey", new Integer(77));
        this.exportMatlab.putValue("SmallIcon", GUIPrism.getIconFromImage("smallFileMatlab.png"));
        this.exportMatlab.putValue("LongDescription", "Export graph as a Matlab file.");
        this.printGraph = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                if (!graph.getDisplaySettings().getBackgroundColor().equals(Color.white) && GUIGraphHandler.this.plug.questionYesNo("Your graph has a coloured background, this background will show up on the \nprintout. Would you like to make the current background colour white?") == 0) {
                    graph.getDisplaySettings().setBackgroundColor(Color.white);
                }
                graph.createChartPrintJob();
            }
        };
        this.printGraph.putValue("Name", "Print graph");
        this.printGraph.putValue("MnemonicKey", new Integer(80));
        this.printGraph.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPrint.png"));
        this.printGraph.putValue("LongDescription", "Print the graph to a printer or file");
        this.deleteGraph = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Graph graph = GUIGraphHandler.this.models.get(GUIGraphHandler.this.theTabs.getSelectedIndex());
                GUIGraphHandler.this.models.remove(GUIGraphHandler.this.theTabs.getSelectedIndex());
                GUIGraphHandler.this.options.remove(GUIGraphHandler.this.theTabs.getSelectedIndex());
                GUIGraphHandler.this.theTabs.remove((Component)((Object)graph));
            }
        };
        this.deleteGraph.putValue("Name", "Delete graph");
        this.deleteGraph.putValue("MnemonicKey", new Integer(68));
        this.deleteGraph.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.deleteGraph.putValue("LongDescription", "Deletes the graph.");
        this.zoomMenu = new JMenu("Zoom");
        this.zoomMenu.setMnemonic('Z');
        this.zoomMenu.setIcon(GUIPrism.getIconFromImage("smallView.png"));
        this.zoomMenu.add(this.zoomIn);
        this.zoomMenu.add(this.zoomOut);
        this.zoomMenu.add(this.zoomDefault);
        this.exportMenu = new JMenu("Export graph");
        this.exportMenu.setMnemonic('E');
        this.exportMenu.setIcon(GUIPrism.getIconFromImage("smallExport.png"));
        this.exportMenu.add(this.exportXML);
        this.exportMenu.add(this.exportImagePNG);
        this.exportMenu.add(this.exportImageEPS);
        this.exportMenu.add(this.exportImageJPG);
        this.exportMenu.add(this.exportMatlab);
        this.importMenu = new JMenu("Import graph");
        this.importMenu.setMnemonic('I');
        this.importMenu.setIcon(GUIPrism.getIconFromImage("smallImport.png"));
        this.importMenu.add(this.importXML);
        this.graphMenu.add(this.graphOptions);
        this.graphMenu.add(this.zoomMenu);
        this.graphMenu.addSeparator();
        this.graphMenu.add(this.printGraph);
        this.graphMenu.add(this.deleteGraph);
        this.graphMenu.addSeparator();
        this.graphMenu.add(this.exportMenu);
        this.graphMenu.add(this.importMenu);
        this.backMenu.add(this.importXML);
    }

    public void saveImage(GUIImageExportDialog gUIImageExportDialog) {
        if (!gUIImageExportDialog.isCancelled()) {
            Graph graph = this.getModel(this.theTabs.getSelectedIndex());
            if (!(graph.getDisplaySettings().getBackgroundColor().equals(Color.white) || gUIImageExportDialog.getImageType() == 1 && gUIImageExportDialog.getAlpha() || this.plug.questionYesNo("Your graph has a coloured background, this background will show up on the \nexported image. Would you like to make the current background colour white?") != 0)) {
                graph.getDisplaySettings().setBackgroundColor(Color.white);
            }
            if (gUIImageExportDialog.getImageType() == 0) {
                if (this.plug.showSaveFileDialog(this.jpgFilter) != 0) {
                    return;
                }
                try {
                    graph.exportToJPEG(this.plug.getChooserFile(), gUIImageExportDialog.getExportWidth(), gUIImageExportDialog.getExportHeight());
                }
                catch (GraphException graphException) {
                    this.plug.error("Could not export JPEG file:\n" + graphException.getMessage());
                }
                catch (IOException iOException) {
                    this.plug.error("Could not export JPEG file:\n" + iOException.getMessage());
                }
            } else if (gUIImageExportDialog.getImageType() == 1) {
                if (this.plug.showSaveFileDialog(this.pngFilter) != 0) {
                    return;
                }
                try {
                    graph.exportToPNG(this.plug.getChooserFile(), gUIImageExportDialog.getExportWidth(), gUIImageExportDialog.getExportHeight(), gUIImageExportDialog.getAlpha());
                }
                catch (GraphException graphException) {
                    this.plug.error("Could not export PNG file:\n" + graphException.getMessage());
                }
                catch (IOException iOException) {
                    this.plug.error("Could not export PNG file:\n" + iOException.getMessage());
                }
            } else if (gUIImageExportDialog.getImageType() == 2) {
                if (this.plug.showSaveFileDialog(this.epsFilter) != 0) {
                    return;
                }
                try {
                    graph.exportToEPS(this.plug.getChooserFile(), gUIImageExportDialog.getExportWidth(), gUIImageExportDialog.getExportHeight());
                }
                catch (GraphException graphException) {
                    this.plug.error("Could not export EPS file:\n" + graphException.getMessage());
                }
                catch (IOException iOException) {
                    this.plug.error("Could not export EPS file:\n" + iOException.getMessage());
                }
            }
        }
    }

    public Action getPrintGraph() {
        return this.printGraph;
    }

    public Action getDeleteGraph() {
        if (this.canDelete) {
            return this.deleteGraph;
        }
        return null;
    }

    public int addGraph(Graph graph) {
        Object object = "";
        int n = 1;
        while (true) {
            object = "Graph " + n;
            boolean bl = true;
            for (int i = 0; i < this.theTabs.getComponentCount(); ++i) {
                if (!this.theTabs.getTitleAt(i).equals(object)) continue;
                bl = false;
            }
            if (bl) {
                return this.addGraph(graph, (String)object);
            }
            ++n;
        }
    }

    public int addGraph(Graph graph, String string) {
        this.models.add(graph);
        this.theTabs.add((Component)((Object)graph));
        this.options.add(new GraphOptions(this.plug, graph, this.plug.getGUI(), "Options for graph " + string));
        graph.addMouseListener(this);
        int n = this.models.indexOf(graph);
        this.theTabs.setTitleAt(n, string);
        this.theTabs.setSelectedIndex(this.theTabs.indexOfComponent((Component)((Object)graph)));
        return n;
    }

    public void jumpToGraph(Graph graph) {
        for (int i = 0; i < this.models.size(); ++i) {
            if (graph != this.models.get(i)) continue;
            this.theTabs.setSelectedComponent((Component)((Object)graph));
            break;
        }
    }

    public Graph getModel(int n) {
        return this.models.get(n);
    }

    public Graph getModel(String string) {
        for (int i = 0; i < this.theTabs.getComponentCount(); ++i) {
            if (!this.theTabs.getTitleAt(i).equals(string)) continue;
            return this.getModel(i);
        }
        return null;
    }

    public int getNumModels() {
        return this.models.size();
    }

    public String getGraphName(int n) {
        return this.theTabs.getTitleAt(n);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popUpTriggered(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() instanceof Graph) {
            ((Graph)mouseEvent.getSource()).restoreAutoBounds();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popUpTriggered(mouseEvent);
        }
    }

    private void popUpTriggered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.theTabs) {
            int n = this.theTabs.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1) {
                this.graphOptions.setEnabled(true);
                this.zoomMenu.setEnabled(true);
                this.exportMenu.setEnabled(true);
                this.importMenu.setEnabled(true);
                this.printGraph.setEnabled(true);
                this.deleteGraph.setEnabled(true);
                this.theTabs.setSelectedIndex(n);
                this.graphMenu.show(this.theTabs, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.graphOptions.setEnabled(false);
                this.zoomMenu.setEnabled(false);
                this.exportMenu.setEnabled(false);
                this.importMenu.setEnabled(true);
                this.printGraph.setEnabled(false);
                this.deleteGraph.setEnabled(false);
                this.graphMenu.show(this.theTabs, mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        for (int i = 0; i < this.models.size(); ++i) {
            if (mouseEvent.getSource() != this.models.get(i)) continue;
            this.graphOptions.setEnabled(true);
            this.zoomMenu.setEnabled(true);
            this.exportMenu.setEnabled(true);
            this.importMenu.setEnabled(true);
            this.printGraph.setEnabled(true);
            this.deleteGraph.setEnabled(true);
            this.theTabs.setSelectedIndex(i);
            this.graphMenu.show((Component)((Object)this.models.get(i)), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

