/*
 * Decompiled with CFR 0.152.
 */
package simulator.networking;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JProgressBar;
import javax.swing.tree.TreeNode;
import prism.PrismException;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingOwner;
import settings.SingleLineStringSetting;
import simulator.networking.FileSystem;
import simulator.networking.SSHHandler;
import simulator.networking.SimulatorResultsFile;

public class SSHHost
extends Thread
implements SettingOwner,
TreeNode {
    public static final int READY_UNKNOWN_STATUS = 0;
    public static final int READY_OKAY = 1;
    public static final int SENDING_FILES = 2;
    public static final int RUNNING = 3;
    public static final int TESTING = 4;
    public static final int RETRIEVING_FILES = 5;
    public static final int DONE = 6;
    public static final int ERROR = 7;
    public static final int STOPPED = 8;
    private FileSystem owner;
    private SingleLineStringSetting hostName;
    private SingleLineStringSetting userName;
    private int state = 0;
    private String errorMessage = "";
    private int totalDone;
    private int totalStints;
    private ArrayList resultFiles;
    File localResults;
    private int noToDoThisStint;
    private int noDoneThisStint;
    private boolean doFeedback = false;
    private boolean doFeedbackResults = false;
    private String feedbackName = "";
    private String feedbackResults = "";
    private String controlName = "";
    private JProgressBar progressBar;
    private File tempResults;
    private File controlFile;
    private boolean stopping = false;
    private Thread testThread = null;
    private Thread feedbackThread = null;
    private Thread stintThread = null;
    private SSHHost instance = this;
    private boolean resultsChanged = false;
    private SettingDisplay display;

    public SSHHost(String string, String string2, FileSystem fileSystem) {
        this.owner = fileSystem;
        this.hostName = new SingleLineStringSetting("host name", string, "This value must be the name used to connect to a host on the relevant network cluster.  This must be in the form of an IP address, or an name which can be resolved to an IP address from your version of PRISM.", (SettingOwner)this, true);
        this.userName = new SingleLineStringSetting("user name", string2, "This value must be a valid username for this host.  The host must also be setup for passwordless access using this username.", (SettingOwner)this, true);
        this.progressBar = new JProgressBar();
        this.resetAll();
    }

    public void resetAll() {
        this.setState(0);
        this.totalDone = 0;
        this.totalStints = 0;
        this.localResults = null;
        this.noToDoThisStint = 0;
        this.noDoneThisStint = 0;
        this.resultFiles = new ArrayList();
        this.owner.notifyChange(this);
    }

    private synchronized void setState(int n) {
        this.state = n;
        this.owner.notifyChange(this);
    }

    public synchronized boolean isStopping() {
        return this.stopping;
    }

    public synchronized void doneSuccessfulStint() {
        this.totalDone += this.noDoneThisStint;
        ++this.totalStints;
        this.noToDoThisStint = 0;
        this.noDoneThisStint = 0;
        this.resultFiles.add(this.localResults);
        this.resultsChanged = true;
        this.tempResults = null;
        this.setState(1);
    }

    private synchronized void setNoDoneThisStint(int n) {
        this.noDoneThisStint = n;
        this.progressBar.repaint();
        this.owner.notifyChange(this);
    }

    public void setErroneousStintToZero() {
        this.noDoneThisStint = 0;
        this.noToDoThisStint = 0;
        this.owner.notifyChange(this);
    }

    public File getResultsFile(int n) {
        return (File)this.resultFiles.get(n);
    }

    public String getHostName() {
        return this.hostName.getStringValue();
    }

    public String getUserName() {
        return this.userName.getStringValue();
    }

    @Override
    public String toString() {
        return "Host " + this.getHostName();
    }

    public synchronized int getHostState() {
        return this.state;
    }

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized int getTotalDone() {
        return this.totalDone;
    }

    public synchronized int getTotalStints() {
        return this.totalStints;
    }

    public synchronized int getNoToDoThisStint() {
        return this.noToDoThisStint;
    }

    public synchronized int getNoDoneThisStint() {
        return this.noDoneThisStint;
    }

    public synchronized boolean haveResultsChanged() {
        return this.resultsChanged;
    }

    public synchronized void resultsGot() {
        this.resultsChanged = false;
    }

    public synchronized JProgressBar getProgressBar() {
        this.progressBar.setMaximum(this.getNoToDoThisStint());
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(this.getNoDoneThisStint());
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.getNoDoneThisStint() + "/" + this.getNoToDoThisStint());
        return this.progressBar;
    }

    public synchronized boolean hasTempResults() {
        return this.tempResults != null;
    }

    public synchronized File getTempResults() {
        return this.tempResults;
    }

    public void sendFilesToFileSystem(File file) throws PrismException {
        this.setState(2);
        boolean bl = false;
        try {
            String[] stringArray = new String[]{"-p", "bin/prismsimulator", this.getUserName() + "@" + this.getHostName() + ":" + this.owner.getInputDir()};
            System.out.println("send1");
            SSHHandler.scp(this.getUserName(), this.getHostName(), stringArray);
            System.out.println("send2");
            String[] stringArray2 = new String[]{"-p", file.getPath(), this.getUserName() + "@" + this.getHostName() + ":" + this.owner.getInputDir()};
            System.out.println("send3");
            SSHHandler.scp(this.getUserName(), this.getHostName(), stringArray2);
            System.out.println("send4");
        }
        catch (PrismException prismException) {
            this.errorMessage = prismException.getMessage();
            this.setState(7);
            throw prismException;
        }
        this.setState(1);
    }

    public void startStint(int n, long l, String string, boolean bl, boolean bl2) {
        if (this.getHostState() != 1 && this.getHostState() != 0) {
            return;
        }
        this.noToDoThisStint = n;
        this.noDoneThisStint = 0;
        this.setState(3);
        if (bl || bl2) {
            this.doFeedback = bl;
            this.doFeedbackResults = bl2;
            this.feedbackName = "feedbackFile" + System.currentTimeMillis() + ".txt";
            if (bl2) {
                this.feedbackResults = "feedbackResultsFile" + System.currentTimeMillis() + ".txt";
            }
            this.feedbackThread = new StintFeedbackThread(bl, bl2);
            this.feedbackThread.start();
        } else {
            this.feedbackName = "";
        }
        this.controlName = "control" + string + System.currentTimeMillis();
        this.stintThread = new StintThread(string, this.controlName, l);
        this.stopping = false;
        this.stintThread.start();
    }

    public void stopStint() throws PrismException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SSHHost.this.getHostState() == 3) {
                    String[] stringArray;
                    String string = SSHHost.this.controlName;
                    try {
                        SSHHost.this.controlFile = File.createTempFile(string, ".txt");
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    try {
                        stringArray = new PrintWriter(new FileWriter(SSHHost.this.controlFile));
                        stringArray.write("STOP");
                        stringArray.flush();
                        stringArray.close();
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    stringArray = new String[]{"-p", SSHHost.this.controlFile.getPath(), SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getInputDir() + "/" + SSHHost.this.controlName + ".txt"};
                    try {
                        SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray);
                    }
                    catch (PrismException prismException) {
                        return;
                    }
                    SSHHost.this.stopping = true;
                }
            }
        });
        thread.start();
    }

    public void testHost() {
        this.testThread = new TestThread();
        this.testThread.start();
    }

    public Enumeration children() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.owner;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return 2;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.hostName;
            }
        }
        return this.userName;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "SSH Host";
    }

    @Override
    public int getSettingOwnerID() {
        return 16;
    }

    @Override
    public String getSettingOwnerName() {
        return this.getHostName();
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        if (this.state == 7 || this.state == 1) {
            this.setState(0);
        }
        this.owner.notifyChange(this);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    class StintFeedbackThread
    extends Thread {
        private boolean regular = false;
        private boolean results = false;

        public StintFeedbackThread(boolean bl, boolean bl2) {
            this.regular = bl;
            this.results = bl2;
        }

        @Override
        public void run() {
            String[] stringArray;
            String[] stringArray2;
            File file = null;
            File file2 = null;
            try {
                file = File.createTempFile("localFeedback" + System.currentTimeMillis(), ".txt");
                file2 = File.createTempFile("resultsFeedback" + System.currentTimeMillis(), ".txt");
            }
            catch (IOException iOException) {
                System.err.println("Warning: could not initialise feedback thread on " + SSHHost.this.getHostName());
                return;
            }
            try {
                while (SSHHost.this.getHostState() == 3 || SSHHost.this.getHostState() == 2) {
                    Thread.sleep(100L);
                    stringArray2 = new String[]{"test"};
                    SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "echo", stringArray2);
                    if (this.regular) {
                        stringArray = new String[]{"-p", SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackName, file.getPath()};
                        SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray);
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                            int n = Integer.parseInt(bufferedReader.readLine());
                            int n2 = Integer.parseInt(bufferedReader.readLine());
                            int n3 = Integer.parseInt(bufferedReader.readLine());
                            SSHHost.this.noDoneThisStint = n;
                            SSHHost.this.owner.notifyChange(SSHHost.this.instance);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!this.results) continue;
                    stringArray = new String[]{"-p", SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackResults, file2.getPath()};
                    SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray);
                    SSHHost.this.resultsChanged = true;
                    SSHHost.this.tempResults = file2;
                    System.out.println("got result");
                    SSHHost.this.owner.notifyChange(SSHHost.this.instance);
                }
            }
            catch (PrismException prismException) {
                SSHHost.this.stintThread.interrupt();
                return;
            }
            catch (InterruptedException interruptedException) {
                SSHHost.this.stintThread.interrupt();
                return;
            }
            SSHHost.this.tempResults = null;
            file.delete();
            file2.delete();
            stringArray2 = new String[]{"-f", SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackName};
            try {
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "rm", stringArray2);
            }
            catch (PrismException prismException) {
                return;
            }
            stringArray = new String[]{"-f", SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackResults};
            try {
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "rm", stringArray);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
    }

    class StintThread
    extends Thread {
        private String binaryName;
        private String controlName;
        private long maxPathLength;

        public StintThread(String string, String string2, long l) {
            this.binaryName = string;
            this.controlName = string2;
            this.maxPathLength = l;
        }

        @Override
        public void run() {
            String[] stringArray;
            String string = this.binaryName + SSHHost.this.userName + SSHHost.this.hostName + System.currentTimeMillis();
            String string2 = SSHHost.this.owner.getInputDir() + "/prismsimulator";
            String[] stringArray2 = SSHHost.this.feedbackName.equals("") ? new String[]{SSHHost.this.owner.getInputDir() + "/" + this.binaryName, SSHHost.this.owner.getOutputDir() + "/" + string + ".txt", "" + SSHHost.this.getNoToDoThisStint(), "" + this.maxPathLength, SSHHost.this.owner.getInputDir() + "/" + this.controlName + ".txt"} : (SSHHost.this.feedbackResults.equals("") ? new String[]{SSHHost.this.owner.getInputDir() + "/" + this.binaryName, SSHHost.this.owner.getOutputDir() + "/" + string + ".txt", "" + SSHHost.this.getNoToDoThisStint(), "" + this.maxPathLength, SSHHost.this.owner.getInputDir() + "/" + this.controlName + ".txt", SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackName} : new String[]{SSHHost.this.owner.getInputDir() + "/" + this.binaryName, SSHHost.this.owner.getOutputDir() + "/" + string + ".txt", "" + SSHHost.this.getNoToDoThisStint(), "" + this.maxPathLength, SSHHost.this.owner.getInputDir() + "/" + this.controlName + ".txt", SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackName, SSHHost.this.owner.getOutputDir() + "/" + SSHHost.this.feedbackResults});
            try {
                SSHHost.this.setState(3);
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), string2, stringArray2);
                SSHHost.this.localResults = File.createTempFile(string, ".txt");
                stringArray = new String[]{"-p", SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getOutputDir() + "/" + string + ".txt", SSHHost.this.localResults.getPath()};
                SSHHost.this.setState(5);
                SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray);
                String[] stringArray3 = new String[]{"-f", SSHHost.this.owner.getOutputDir() + "/" + string + ".txt"};
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "rm", stringArray3);
            }
            catch (PrismException prismException) {
                SSHHost.this.errorMessage = SSHHost.this.getHostState() == 3 ? "Error when executing simulator on " + SSHHost.this.getHostName() + "\n" + prismException.getMessage() : (SSHHost.this.getHostState() == 5 ? "Error when retrieving files from " + SSHHost.this.getHostName() + "\n" + prismException.getMessage() : prismException.getMessage());
                SSHHost.this.setState(7);
                if (!SSHHost.this.stopping) {
                    return;
                }
            }
            catch (IOException iOException) {
                SSHHost.this.errorMessage = iOException.getMessage();
                SSHHost.this.setState(7);
                return;
            }
            if (SSHHost.this.stopping) {
                stringArray = new SimulatorResultsFile();
                try {
                    stringArray.mergeResultsFile(SSHHost.this.localResults);
                    SSHHost.this.noDoneThisStint = stringArray.getNumResults() > 0 ? stringArray.getIterations(0) : 0;
                    SSHHost.this.owner.notifyChange(SSHHost.this.instance);
                }
                catch (PrismException prismException) {
                    SSHHost.this.noDoneThisStint = 0;
                }
                SSHHost.this.setState(8);
            } else {
                SSHHost.this.noDoneThisStint = SSHHost.this.noToDoThisStint;
                SSHHost.this.owner.notifyChange(SSHHost.this.instance);
                SSHHost.this.setState(6);
            }
            System.out.println(SSHHost.this.hostName + " is done");
        }
    }

    class TestThread
    extends Thread {
        TestThread() {
        }

        @Override
        public void run() {
            if (SSHHost.this.getHostState() != 0 && SSHHost.this.getHostState() != 1 && SSHHost.this.getHostState() != 7) {
                return;
            }
            try {
                SSHHost.this.setState(4);
                String[] stringArray = new String[]{"test"};
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "echo", stringArray);
                String string = "test123123" + System.currentTimeMillis();
                File file = File.createTempFile(string, ".txt");
                String[] stringArray2 = new String[]{"-p", file.getPath(), SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getInputDir() + "/" + string + ".txt"};
                SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray2);
                String[] stringArray3 = new String[]{"-f", SSHHost.this.owner.getInputDir() + "/" + string + ".txt"};
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "rm", stringArray3);
                String[] stringArray4 = new String[]{"test", SSHHost.this.owner.getOutputDir() + "/" + string + ".txt"};
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "echo", stringArray4);
                String[] stringArray5 = new String[]{"-p", SSHHost.this.getUserName() + "@" + SSHHost.this.getHostName() + ":" + SSHHost.this.owner.getOutputDir() + "/" + string + ".txt", file.getPath()};
                SSHHandler.scp(SSHHost.this.getUserName(), SSHHost.this.getHostName(), stringArray5);
                String[] stringArray6 = new String[]{"-f", SSHHost.this.owner.getOutputDir() + "/" + string + ".txt"};
                SSHHandler.ssh(SSHHost.this.getUserName(), SSHHost.this.getHostName(), "rm", stringArray3);
                if (file != null) {
                    file.delete();
                }
            }
            catch (PrismException prismException) {
                SSHHost.this.errorMessage = prismException.getMessage();
                SSHHost.this.setState(7);
                return;
            }
            catch (IOException iOException) {
                SSHHost.this.errorMessage = iOException.getMessage();
                SSHHost.this.setState(7);
                return;
            }
            SSHHost.this.setState(1);
            SSHHost.this.owner.notifyChange(SSHHost.this.instance);
        }
    }
}

