/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class CIconfidence
extends CIMethod {
    private double varEstimator;

    public CIconfidence(double d, int n) {
        this.width = d;
        this.numSamples = n;
        this.varEstimator = 0.0;
    }

    @Override
    public void computeMissingParameterAfterSim() {
        if (this.numSamples > 1) {
            double d = this.width * Math.sqrt((double)this.numSamples / this.varEstimator);
            double d2 = Double.isInfinite(d) ? 1.0 : (this.numSamples - 1 > 1 ? Probability.studentT((double)d, (double)(this.numSamples - 1)) : 0.5 + Math.atan(d) / Math.PI);
            this.confidence = 2.0 * (1.0 - d2);
            this.missingParameterComputed = true;
        }
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.confidence;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=" + this.width + ", confidence=unknown, number of samples=" + this.numSamples;
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        if (n >= this.numSamples) {
            this.varEstimator = sampler.getVariance();
            return true;
        }
        return false;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 10 * n / this.numSamples * 10;
    }

    @Override
    public SimulationMethod clone() {
        CIconfidence cIconfidence = new CIconfidence(this.width, this.numSamples);
        cIconfidence.confidence = this.confidence;
        cIconfidence.missingParameterComputed = this.missingParameterComputed;
        cIconfidence.prOp = this.prOp;
        cIconfidence.theta = this.theta;
        cIconfidence.varEstimator = this.varEstimator;
        return cIconfidence;
    }
}

