/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFileChooser;
import settings.FileEditor;
import settings.FileRenderer;
import settings.FileSelector;
import settings.FontColorConstraint;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class FileSetting
extends Setting {
    private static FileRenderer renderer;
    private static FileEditor editor;
    private boolean validFile;
    private FileSelector selector;

    private static FileSelector defaultSelector() {
        try {
            return new FileSelector(){
                JFileChooser choose = new JFileChooser();

                @Override
                public File getFile(Frame frame, File file) {
                    this.choose.setSelectedFile(file);
                    int n = this.choose.showOpenDialog(frame);
                    if (n == 1) {
                        return null;
                    }
                    return this.choose.getSelectedFile();
                }
            };
        }
        catch (HeadlessException headlessException) {
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    public FileSetting(String string, File file, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)file, string2, settingOwner, bl);
        this.validFile = file != null ? file.isFile() : false;
    }

    public FileSetting(String string, File file, String string2, SettingOwner settingOwner, boolean bl, FontColorConstraint fontColorConstraint) {
        super(string, file, string2, settingOwner, bl, fontColorConstraint);
        this.validFile = file != null ? file.isFile() : false;
    }

    @Override
    public void checkObjectWithConstraints(Object object) throws SettingException {
        super.checkObjectWithConstraints(object);
        if (object instanceof File) {
            File file = (File)object;
            this.validFile = file.isFile();
        } else {
            this.validFile = false;
        }
    }

    @Override
    public SettingEditor getSettingEditor() {
        if (editor == null) {
            editor = new FileEditor();
        }
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        if (renderer == null) {
            renderer = new FileRenderer();
        }
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return File.class;
    }

    public File getFileValue() {
        if (this.getValue() != null) {
            return (File)this.getValue();
        }
        return null;
    }

    public boolean isValidFile() {
        return this.validFile;
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        return new File(string);
    }

    @Override
    public String toString() {
        if (this.getFileValue() == null) {
            return "";
        }
        return this.getFileValue().getPath();
    }

    public void setFileSelector(FileSelector fileSelector) {
        this.selector = fileSelector;
    }

    public FileSelector getFileSelector() {
        if (this.selector == null) {
            this.selector = FileSetting.defaultSelector();
        }
        return this.selector;
    }
}

