/*
 * Decompiled with CFR 0.152.
 */
package settings;

import settings.DoubleEditor;
import settings.DoubleRenderer;
import settings.NumericConstraint;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class DoubleSetting
extends Setting {
    private static DoubleRenderer renderer;
    private static DoubleEditor editor;

    public DoubleSetting(String string, Double d, String string2, SettingOwner settingOwner, boolean bl, NumericConstraint numericConstraint) {
        super(string, d, string2, settingOwner, bl, numericConstraint);
    }

    public DoubleSetting(String string, Double d, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)d, string2, settingOwner, bl);
    }

    @Override
    public SettingEditor getSettingEditor() {
        if (editor == null) {
            editor = new DoubleEditor();
        }
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        if (renderer == null) {
            renderer = new DoubleRenderer();
        }
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return Double.class;
    }

    public double getDoubleValue() {
        return (Double)this.getValue();
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("Error when parsing: " + string + " as a Double value.");
        }
    }

    @Override
    public String toString() {
        return "" + this.getDoubleValue();
    }
}

