/*
 * Decompiled with CFR 0.152.
 */
package prism;

import cex.CexPathAsBDDs;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGServer;
import common.StackTraceHelper;
import common.Timeout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import jdd.DebugJDD;
import jdd.JDD;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionReward;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismModelListener;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.PrismUtils;
import prism.Result;
import prism.ResultsCollection;
import prism.ResultsExporter;
import prism.UndefinedConstants;
import simulator.GenerateSimulationPath;
import simulator.method.ACIconfidence;
import simulator.method.ACIiterations;
import simulator.method.ACIwidth;
import simulator.method.APMCapproximation;
import simulator.method.APMCconfidence;
import simulator.method.APMCiterations;
import simulator.method.CIconfidence;
import simulator.method.CIiterations;
import simulator.method.CIwidth;
import simulator.method.SPRTMethod;
import simulator.method.SimulationMethod;

public class PrismCL
implements PrismModelListener {
    private boolean importpepa = false;
    private boolean importprismpp = false;
    private boolean importtrans = false;
    private boolean importstates = false;
    private boolean importlabels = false;
    private boolean importstaterewards = false;
    private boolean importinitdist = false;
    private boolean steadystate = false;
    private boolean dotransient = false;
    private boolean exporttrans = false;
    private boolean exportstaterewards = false;
    private boolean exporttransrewards = false;
    private boolean exportstates = false;
    private boolean exportlabels = false;
    private boolean exportspy = false;
    private boolean exportdot = false;
    private boolean exporttransdot = false;
    private boolean exporttransdotstates = false;
    private boolean exportmodeldotview = false;
    private boolean exportsccs = false;
    private boolean exportbsccs = false;
    private boolean exportmecs = false;
    private boolean exportresults = false;
    private boolean exportresultsmatrix = false;
    private String exportResultsFormat = "plain";
    private boolean exportvector = false;
    private boolean exportPlainDeprecated = false;
    private boolean exportModelNoBasename = false;
    private int exportType = 1;
    private boolean exportordered = true;
    private boolean exportstrat = false;
    private boolean simulate = false;
    private boolean simpath = false;
    private boolean param = false;
    private ModelType typeOverride = null;
    private boolean orderingOverride = false;
    private boolean explicitbuild = false;
    private boolean explicitbuildtest = false;
    private boolean nobuild = false;
    private boolean test = false;
    private boolean testExitsOnFail = true;
    private List<Object> propertyIndices = null;
    private String propertyString = "";
    private String constSwitch = null;
    private String simpathDetails = null;
    private String prismppParams = null;
    private String paramSwitch = null;
    private String mainLogFilename = "stdout";
    private String settingsFilename = null;
    private String modelFilename = null;
    private String importStatesFilename = null;
    private String importLabelsFilename = null;
    private String importStateRewardsFilename = null;
    private String importInitDistFilename = null;
    private String importModelWarning = null;
    private String propertiesFilename = null;
    private String exportTransFilename = null;
    private String exportStateRewardsFilename = null;
    private String exportTransRewardsFilename = null;
    private String exportStatesFilename = null;
    private String exportLabelsFilename = null;
    private String exportSpyFilename = null;
    private String exportDotFilename = null;
    private String exportTransDotFilename = null;
    private String exportTransDotStatesFilename = null;
    private String exportSCCsFilename = null;
    private String exportBSCCsFilename = null;
    private String exportMECsFilename = null;
    private String exportResultsFilename = null;
    private String exportVectorFilename = null;
    private String exportSteadyStateFilename = null;
    private String exportTransientFilename = null;
    private String exportStratFilename = null;
    private String simpathFilename = null;
    private PrismLog mainLog = null;
    private Prism prism = null;
    private ModulesFile modulesFile = null;
    private PropertiesFile propertiesFile = null;
    boolean modelBuildFail = false;
    Exception modelBuildException = null;
    private int numPropertiesToCheck = 0;
    private List<Property> propertiesToCheck = null;
    private UndefinedConstants[] undefinedConstants;
    private UndefinedConstants undefinedMFConstants;
    private Values definedMFConstants;
    private Values definedPFConstants;
    private ResultsCollection[] results = null;
    private String transientTime;
    private String simMethodName = null;
    private double simApprox;
    private double simConfidence;
    private int simNumSamples;
    private double simWidth;
    private int reqIterToConclude;
    private double simMaxReward;
    private long simMaxPath;
    private boolean simApproxGiven = false;
    private boolean simConfidenceGiven = false;
    private boolean simNumSamplesGiven = false;
    private boolean simWidthGiven = false;
    private boolean reqIterToConcludeGiven = false;
    private boolean simMaxRewardGiven = false;
    private boolean simMaxPathGiven = false;
    private boolean simManual = false;
    private SimulationMethod simMethod = null;
    private Prism.StrategyExportType exportStratType = Prism.StrategyExportType.ACTIONS;
    private String[] paramLowerBounds = null;
    private String[] paramUpperBounds = null;
    private String[] paramNames = null;
    private boolean exactConstants = false;

    public void go(String[] stringArray) {
        try {
            this.run(stringArray);
        }
        catch (JDD.CuddOutOfMemoryException cuddOutOfMemoryException) {
            this.mainLog.println("\nCUDD internal error detected, from the following stack trace:");
            for (StackTraceElement stackTraceElement : cuddOutOfMemoryException.getStackTrace()) {
                this.mainLog.print("  ");
                this.mainLog.println(stackTraceElement);
            }
            this.errorAndExit(cuddOutOfMemoryException.getMessage() + ".\nTip: Try using the -cuddmaxmem switch to increase the memory available to CUDD");
        }
        catch (NGExitException nGExitException) {
            throw nGExitException;
        }
        catch (Exception | StackOverflowError throwable) {
            this.mainLog.println();
            if (throwable instanceof StackOverflowError) {
                this.mainLog.println(throwable.toString());
                this.mainLog.println(StackTraceHelper.asString(throwable, 25));
                this.mainLog.println("Try increasing the value of the Java stack size (via the -javastack argument).");
            } else {
                this.mainLog.print(throwable.toString() + "\n" + StackTraceHelper.asString(throwable, 0));
            }
            this.errorAndExit("Caught unhandled exception, aborting...");
        }
    }

    public void run(String[] stringArray) {
        PrismFileLog prismFileLog;
        Object object;
        int n;
        this.initialise(stringArray);
        this.doParsing();
        this.sortProperties();
        if (this.param && this.numPropertiesToCheck == 0) {
            this.errorAndExit("Parametric model checking requires at least one property to check");
        }
        this.exactConstants = this.param || this.prism.getSettings().getBoolean("prism.exact.enabled");
        try {
            this.undefinedMFConstants = this.exportlabels ? new UndefinedConstants(this.modulesFile, this.propertiesFile, true) : new UndefinedConstants(this.modulesFile, null);
            this.undefinedMFConstants.setExactMode(this.exactConstants);
            this.undefinedConstants = new UndefinedConstants[this.numPropertiesToCheck];
            for (n = 0; n < this.numPropertiesToCheck; ++n) {
                this.undefinedConstants[n] = new UndefinedConstants(this.modulesFile, this.propertiesFile, this.propertiesToCheck.get(n));
                this.undefinedConstants[n].setExactMode(this.exactConstants);
            }
            if (this.param) {
                this.undefinedMFConstants.removeConstants(this.paramNames);
                for (n = 0; n < this.numPropertiesToCheck; ++n) {
                    this.undefinedConstants[n].removeConstants(this.paramNames);
                }
            }
            this.undefinedMFConstants.defineUsingConstSwitch(this.constSwitch);
            for (n = 0; n < this.numPropertiesToCheck; ++n) {
                this.undefinedConstants[n].defineUsingConstSwitch(this.constSwitch);
            }
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        this.results = new ResultsCollection[this.numPropertiesToCheck];
        for (n = 0; n < this.numPropertiesToCheck; ++n) {
            this.results[n] = new ResultsCollection(this.undefinedConstants[n], this.propertiesToCheck.get(n).getExpression().getResultName());
        }
        for (n = 0; n < this.undefinedMFConstants.getNumModelIterations(); ++n) {
            int n2;
            try {
                this.definedMFConstants = this.undefinedMFConstants.getMFConstantValues();
                this.prism.setPRISMModelConstants(this.definedMFConstants, this.exactConstants);
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.results[n2].setMultipleErrors(this.definedMFConstants, null, prismException);
                }
                this.undefinedMFConstants.iterateModel();
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.undefinedConstants[n2].iterateModel();
                }
                continue;
            }
            this.modelBuildFail = false;
            if (this.simpath) {
                try {
                    if (!this.simMaxPathGiven) {
                        this.simMaxPath = this.prism.getSettings().getLong("simulator.defaultMaxPath");
                    }
                    object = this.simpathFilename.equals("stdout") ? null : new File(this.simpathFilename);
                    this.prism.generateSimulationPath(this.simpathDetails, this.simMaxPath, (File)object);
                }
                catch (PrismException prismException) {
                    this.error(prismException.getMessage());
                }
                this.undefinedMFConstants.iterateModel();
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.undefinedConstants[n2].iterateModel();
                }
            }
            this.doExports();
            if (this.modelBuildFail) continue;
            this.doSteadyState();
            if (this.modelBuildFail) continue;
            this.doTransient();
            if (this.modelBuildFail) continue;
            for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                block58: {
                    if (this.simulate && this.undefinedConstants[n2].getNumPropertyIterations() > 1) {
                        try {
                            this.simMethod = this.processSimulationOptions(this.propertiesToCheck.get(n2).getExpression());
                            this.prism.modelCheckSimulatorExperiment(this.propertiesFile, this.undefinedConstants[n2], this.results[n2], this.propertiesToCheck.get(n2).getExpression(), null, this.simMaxPath, this.simMethod);
                            break block58;
                        }
                        catch (PrismException prismException) {
                            this.error(prismException.getMessage());
                            this.results[n2].setMultipleErrors(this.definedMFConstants, null, prismException);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            break block58;
                        }
                    }
                    for (int i = 0; i < this.undefinedConstants[n2].getNumPropertyIterations(); ++i) {
                        Result result;
                        block59: {
                            try {
                                if (this.propertiesFile != null) {
                                    this.definedPFConstants = this.undefinedConstants[n2].getPFConstantValues();
                                    this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, this.exactConstants);
                                }
                                if (!this.simulate && !this.param) {
                                    result = this.prism.modelCheck(this.propertiesFile, this.propertiesToCheck.get(n2));
                                    break block59;
                                }
                                if (this.param) {
                                    result = this.prism.modelCheckParametric(this.propertiesFile, this.propertiesToCheck.get(n2), this.paramNames, this.paramLowerBounds, this.paramUpperBounds);
                                    break block59;
                                }
                                if (this.simulate) {
                                    this.simMethod = this.processSimulationOptions(this.propertiesToCheck.get(n2).getExpression());
                                    result = this.prism.modelCheckSimulator(this.propertiesFile, this.propertiesToCheck.get(n2).getExpression(), this.definedPFConstants, null, this.simMaxPath, this.simMethod);
                                    this.simMethod.reset();
                                    break block59;
                                }
                                throw new PrismException("Cannot use parametric model checking and simulation at the same time");
                            }
                            catch (PrismException prismException) {
                                this.error(prismException.getMessage(), true);
                                result = new Result(prismException);
                            }
                        }
                        if (this.modelBuildFail) {
                            this.results[n2].setMultipleErrors(this.definedMFConstants, null, this.modelBuildException);
                            if (!this.test) break;
                            this.doResultTest(this.propertiesToCheck.get(n2), new Result(this.modelBuildException), this.modulesFile.getConstantValues(), null);
                            break;
                        }
                        this.results[n2].setResult(this.definedMFConstants, this.definedPFConstants, result.getResult());
                        object = result.getCounterexample();
                        if (object != null) {
                            this.mainLog.println("\nCounterexample/witness:");
                            this.mainLog.println(object);
                            if (object instanceof CexPathAsBDDs) {
                                ((CexPathAsBDDs)object).clear();
                            }
                        }
                        if (this.exportstrat && result.getStrategy() != null) {
                            try {
                                this.prism.exportStrategy(result.getStrategy(), this.exportStratType, this.exportStratFilename.equals("stdout") ? null : new File(this.exportStratFilename));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.error("Couldn't open file \"" + this.exportStratFilename + "\" for output");
                            }
                            catch (PrismException prismException) {
                                this.error(prismException.getMessage());
                            }
                        }
                        if (this.exportvector && result.getVector() != null) {
                            this.mainLog.print("\nExporting vector of results for all states ");
                            this.mainLog.println((String)(this.exportVectorFilename.equals("stdout") ? "below:" : "to file \"" + this.exportVectorFilename + "\"..."));
                            prismFileLog = new PrismFileLog(this.exportVectorFilename);
                            if (!prismFileLog.ready()) {
                                this.errorAndExit("Couldn't open file \"" + this.exportVectorFilename + "\" for output");
                            }
                            boolean bl = this.exportVectorFilename.equals("stdout");
                            try {
                                result.getVector().print(prismFileLog, false, false, bl, bl);
                            }
                            catch (PrismException prismException) {
                                this.error(prismException.getMessage());
                            }
                            result.getVector().clear();
                            prismFileLog.close();
                        }
                        if (this.test) {
                            this.doResultTest(this.propertiesToCheck.get(n2), result, this.modulesFile.getConstantValues(), this.propertiesFile.getConstantValues());
                        }
                        this.undefinedConstants[n2].iterateProperty();
                    }
                }
                if (!this.modelBuildFail) continue;
                ++n2;
                while (n2 < this.numPropertiesToCheck) {
                    this.results[n2].setMultipleErrors(this.definedMFConstants, null, this.modelBuildException);
                    if (this.test) {
                        this.doResultTest(this.propertiesToCheck.get(n2), new Result(this.modelBuildException), this.modulesFile.getConstantValues(), this.propertiesFile.getConstantValues());
                    }
                    ++n2;
                }
                break;
            }
            if (!(this.propertiesToCheck.size() != 0 || this.steadystate || this.dotransient || this.simpath || this.nobuild || !this.prism.modelCanBeBuilt() || this.prism.modelIsBuilt())) {
                try {
                    this.prism.buildModel();
                }
                catch (PrismException prismException) {
                    this.error(prismException.getMessage());
                }
            }
            this.undefinedMFConstants.iterateModel();
            for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                this.undefinedConstants[n2].iterateModel();
            }
        }
        if (this.exportresults) {
            object = new ResultsExporter(this.exportResultsFormat, "string");
            this.mainLog.print("\nExporting results " + (this.exportresultsmatrix ? "in matrix form " : ""));
            this.mainLog.println((String)(this.exportResultsFilename.equals("stdout") ? "below:\n" : "to file \"" + this.exportResultsFilename + "\"..."));
            prismFileLog = new PrismFileLog(this.exportResultsFilename);
            if (!prismFileLog.ready()) {
                this.errorAndExit("Couldn't open file \"" + this.exportResultsFilename + "\" for output");
            }
            for (n = 0; n < this.numPropertiesToCheck; ++n) {
                if (n > 0) {
                    prismFileLog.println();
                }
                if (this.numPropertiesToCheck > 1) {
                    if (!this.exportresultsmatrix) {
                        ((ResultsExporter)object).setProperty(this.propertiesToCheck.get(n));
                    } else if (this.exportResultsFormat.equalsIgnoreCase("csv")) {
                        prismFileLog.print("\"" + this.propertiesToCheck.get(n).toString().replaceAll("\"", "\"\"") + "\"\n");
                    } else {
                        prismFileLog.print(this.propertiesToCheck.get(n) + ":\n");
                    }
                }
                if (!this.exportresultsmatrix) {
                    prismFileLog.println(this.results[n].export((ResultsExporter)object).getExportString());
                    continue;
                }
                String string = this.exportResultsFormat.equals("plain") ? "\t" : ", ";
                prismFileLog.println(this.results[n].toStringMatrix(string));
            }
            prismFileLog.close();
        }
        this.closeDown();
    }

    private void initialise(String[] stringArray) {
        try {
            this.mainLog = new PrismFileLog("stdout");
            this.prism = new Prism(this.mainLog);
            this.prism.addModelListener(this);
            this.parseArguments(stringArray);
            if (this.settingsFilename != null) {
                this.prism.loadUserSettingsFile(new File(this.settingsFilename));
            }
            this.prism.initialise();
            this.printArguments(stringArray);
            this.processOptions();
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
    }

    private void doParsing() {
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            if (this.importModelWarning != null) {
                this.mainLog.printWarning(this.importModelWarning);
            }
            if (this.importpepa) {
                this.mainLog.print("\nImporting PEPA file \"" + this.modelFilename + "\"...\n");
                this.modulesFile = this.prism.importPepaFile(new File(this.modelFilename));
                this.prism.loadPRISMModel(this.modulesFile);
            } else if (this.importprismpp) {
                this.mainLog.print("\nImporting PRISM preprocessor file \"" + this.modelFilename + "\"...\n");
                String[] stringArray = ("? " + this.prismppParams).split(" ");
                this.modulesFile = this.prism.importPrismPreprocFile(new File(this.modelFilename), stringArray);
                this.prism.loadPRISMModel(this.modulesFile);
            } else if (this.importtrans) {
                this.mainLog.print("\nImporting model from \"" + this.modelFilename + "\"");
                if (this.importstates) {
                    this.mainLog.print(", \"" + this.importStatesFilename + "\"");
                    file = new File(this.importStatesFilename);
                }
                if (this.importlabels) {
                    this.mainLog.print(", \"" + this.importLabelsFilename + "\"");
                    file2 = new File(this.importLabelsFilename);
                }
                if (this.importstaterewards) {
                    this.mainLog.print(", \"" + this.importStateRewardsFilename + "\"");
                    file3 = new File(this.importStateRewardsFilename);
                }
                this.mainLog.println("...");
                this.prism.loadModelFromExplicitFiles(file, new File(this.modelFilename), file2, file3, this.typeOverride);
            } else {
                this.mainLog.print("\nParsing model file \"" + this.modelFilename + "\"...\n");
                this.modulesFile = this.prism.parseModelFile(new File(this.modelFilename), this.typeOverride);
                this.prism.loadPRISMModel(this.modulesFile);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("File \"" + this.modelFilename + "\" not found");
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        try {
            if (this.propertiesFilename != null) {
                this.mainLog.print("\nParsing properties file \"" + this.propertiesFilename + "\"...\n");
                this.propertiesFile = this.prism.parsePropertiesFile(new File(this.propertiesFilename));
            } else {
                this.propertiesFile = !this.propertyString.equals("") ? this.prism.parsePropertiesString(this.propertyString) : null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("File \"" + this.propertiesFilename + "\" not found");
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        if (this.propertiesFile != null) {
            this.mainLog.print("\n" + this.propertiesFile.getNumProperties());
            this.mainLog.print(" propert" + (this.propertiesFile.getNumProperties() == 1 ? "y" : "ies") + ":\n");
            for (int i = 0; i < this.propertiesFile.getNumProperties(); ++i) {
                this.mainLog.println("(" + (i + 1) + ") " + this.propertiesFile.getPropertyObject(i));
            }
        }
    }

    private void sortProperties() {
        this.propertiesToCheck = new ArrayList<Property>();
        if (this.propertiesFile == null) {
            this.numPropertiesToCheck = 0;
        } else if (this.propertyIndices == null) {
            this.numPropertiesToCheck = this.propertiesFile.getNumProperties();
            for (int i = 0; i < this.numPropertiesToCheck; ++i) {
                this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(i));
            }
        } else {
            for (Object object : this.propertyIndices) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n <= 0 || n > this.propertiesFile.getNumProperties()) {
                        this.errorAndExit("There is not a property " + n + " to verify");
                    }
                    ++this.numPropertiesToCheck;
                    this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(n - 1));
                    continue;
                }
                if (object instanceof String) {
                    Property property = this.propertiesFile.getPropertyObjectByName((String)object);
                    if (property == null) {
                        this.errorAndExit("There is not a property \"" + this.propertyIndices + "\" to check");
                    }
                    ++this.numPropertiesToCheck;
                    this.propertiesToCheck.add(property);
                    continue;
                }
                this.errorAndExit("There is not a property " + this.propertyIndices + " to check");
            }
        }
    }

    private void doExports() {
        File file;
        if ((this.param || this.prism.getSettings().getBoolean("prism.exact.enabled")) && (this.exporttrans || this.exportstaterewards || this.exporttransrewards || this.exportstates || this.exportspy || this.exportdot || this.exporttransdot || this.exporttransdotstates || this.exportmodeldotview || this.exportlabels || this.exportsccs || this.exportbsccs || this.exportmecs)) {
            this.mainLog.printWarning("Skipping exports in parametric / exact model checking mode, currently not supported.");
            return;
        }
        if (this.exporttrans) {
            try {
                file = this.exportTransFilename.equals("stdout") ? null : new File(this.exportTransFilename);
                this.prism.exportTransToFile(this.exportordered, this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportTransFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
            if (this.exportPlainDeprecated) {
                this.mainLog.printWarning("The -exportplain switch is now deprecated. Please use -exporttrans in future.");
            }
        }
        if (this.exportstaterewards) {
            try {
                file = this.exportStateRewardsFilename.equals("stdout") ? null : new File(this.exportStateRewardsFilename);
                this.prism.exportStateRewardsToFile(this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportStateRewardsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exporttransrewards) {
            try {
                file = this.exportTransRewardsFilename.equals("stdout") ? null : new File(this.exportTransRewardsFilename);
                this.prism.exportTransRewardsToFile(this.exportordered, this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportTransRewardsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportstates) {
            try {
                file = this.exportStatesFilename.equals("stdout") ? null : new File(this.exportStatesFilename);
                this.prism.exportStatesToFile(this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportStatesFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportspy) {
            try {
                this.prism.exportToSpyFile(new File(this.exportSpyFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportSpyFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportdot) {
            try {
                this.prism.exportToDotFile(new File(this.exportDotFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportDotFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exporttransdot) {
            try {
                file = this.exportTransDotFilename.equals("stdout") ? null : new File(this.exportTransDotFilename);
                this.prism.exportTransToFile(this.exportordered, 3, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportTransDotFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exporttransdotstates) {
            try {
                file = this.exportTransDotStatesFilename.equals("stdout") ? null : new File(this.exportTransDotStatesFilename);
                this.prism.exportTransToFile(this.exportordered, 6, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportTransDotStatesFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportmodeldotview) {
            try {
                file = File.createTempFile("prism-dot-", ".dot", null);
                File file2 = File.createTempFile("prism-dot-", ".dot.pdf", null);
                this.prism.exportTransToFile(this.exportordered, 6, file);
                new ProcessBuilder("dot", "-Tpdf", "-o", file2.getPath(), file.getPath()).start().waitFor();
                new ProcessBuilder("open", file2.getPath()).start();
            }
            catch (IOException | InterruptedException exception) {
                this.error("Problem generating dot file: " + exception.getMessage());
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportlabels) {
            try {
                if (this.propertiesFile != null) {
                    this.definedPFConstants = this.undefinedMFConstants.getPFConstantValues();
                    this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, this.exactConstants);
                }
                file = this.exportLabelsFilename.equals("stdout") ? null : new File(this.exportLabelsFilename);
                this.prism.exportLabelsToFile(this.propertiesFile, this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mainLog.println("Couldn't open file \"" + this.exportLabelsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.mainLog.println("\nError: " + prismException.getMessage() + ".");
            }
        }
        if (this.exportsccs) {
            try {
                file = this.exportSCCsFilename.equals("stdout") ? null : new File(this.exportSCCsFilename);
                this.prism.exportSCCsToFile(this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportSCCsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportbsccs) {
            try {
                file = this.exportBSCCsFilename.equals("stdout") ? null : new File(this.exportBSCCsFilename);
                this.prism.exportBSCCsToFile(this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportBSCCsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
        if (this.exportmecs) {
            try {
                file = this.exportMECsFilename.equals("stdout") ? null : new File(this.exportMECsFilename);
                this.prism.exportMECsToFile(this.exportType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportMECsFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
    }

    private void doSteadyState() {
        File file = null;
        if (this.steadystate) {
            if (this.param || this.prism.getSettings().getBoolean("prism.exact.enabled")) {
                this.mainLog.printWarning("Skipping steady-state computation in parametric / exact model checking mode, currently not supported.");
                return;
            }
            try {
                file = this.exportSteadyStateFilename == null || this.exportSteadyStateFilename.equals("stdout") ? null : new File(this.exportSteadyStateFilename);
                this.prism.doSteadyState(this.exportType, file, this.importinitdist ? new File(this.importInitDistFilename) : null);
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
    }

    private void doTransient() {
        File file = null;
        if (this.dotransient) {
            try {
                if (this.param || this.prism.getSettings().getBoolean("prism.exact.enabled")) {
                    this.mainLog.printWarning("Skipping transient probability computation in parametric / exact model checking mode, currently not supported.");
                    return;
                }
                file = this.exportTransientFilename == null || this.exportTransientFilename.equals("stdout") ? null : new File(this.exportTransientFilename);
                ModelType modelType = this.prism.getModelType();
                String string = modelType.continuousTime() ? "double" : "int";
                UndefinedConstants undefinedConstants = new UndefinedConstants(null, this.prism.parsePropertiesString(null, "const " + string + " T; T;"));
                try {
                    undefinedConstants.defineUsingConstSwitch("T=" + this.transientTime);
                }
                catch (PrismException prismException) {
                    if (this.transientTime.contains(":")) {
                        this.errorAndExit("\"" + this.transientTime + "\" is not a valid time range for a " + modelType);
                    }
                    this.errorAndExit("\"" + this.transientTime + "\" is not a valid time for a " + modelType);
                }
                this.prism.doTransient(undefinedConstants, this.exportType, file, this.importinitdist ? new File(this.importInitDistFilename) : null);
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
            }
        }
    }

    private void doResultTest(Property property, Result result, Values values, Values values2) {
        block5: {
            try {
                Values values3 = new Values(values, values2);
                if (property.checkAgainstExpectedResult(result.getResult(), values3)) {
                    this.mainLog.println("Testing result: PASS");
                } else {
                    this.mainLog.println("Testing result: NOT TESTED");
                }
            }
            catch (PrismNotSupportedException prismNotSupportedException) {
                this.mainLog.println("Testing result: UNSUPPORTED: " + prismNotSupportedException.getMessage());
            }
            catch (PrismException prismException) {
                this.mainLog.println("Testing result: FAIL: " + prismException.getMessage());
                if (!this.testExitsOnFail) break block5;
                this.errorAndExit("Testing failed");
            }
        }
    }

    private void closeDown() {
        this.prism.closeDown(true);
        int n = this.mainLog.getNumberOfWarnings();
        if (n > 0) {
            this.mainLog.printSeparator();
            this.mainLog.print("\nNote: There ");
            if (n == 1) {
                this.mainLog.print("was 1 warning");
            } else {
                this.mainLog.print("were " + n + " warnings");
            }
            this.mainLog.println(" during computation.");
        }
        this.mainLog.println();
        this.mainLog.close();
    }

    private void setTimeout(final int n) {
        Timeout.setTimeout(n, new Runnable(){

            @Override
            public void run() {
                PrismCL.this.mainLog.println("\nError: Timeout (after " + n + " seconds).");
                PrismCL.this.mainLog.flush();
                System.exit(1);
            }
        });
    }

    @Override
    public void notifyModelBuildSuccessful() {
    }

    @Override
    public void notifyModelBuildFailed(PrismException prismException) {
        this.modelBuildFail = true;
        this.modelBuildException = prismException;
    }

    private void parseArguments(String[] stringArray) throws PrismException {
        this.constSwitch = "";
        this.paramSwitch = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '-') {
                String string;
                String string2 = stringArray[i].substring(1);
                if (string2.length() == 0) {
                    this.errorAndExit("Invalid empty switch");
                }
                if (string2.charAt(0) == '-') {
                    string2 = string2.substring(1);
                }
                if (string2.equals("help") || string2.equals("?")) {
                    if (i < stringArray.length - 1) {
                        this.printHelpSwitch(stringArray[++i]);
                    } else {
                        this.printHelp();
                    }
                    this.exit();
                    continue;
                }
                if (string2.equals("javamaxmem") || string2.equals("javastack")) {
                    ++i;
                    continue;
                }
                if (string2.equals("timeout")) {
                    if (i < stringArray.length - 1) {
                        int n;
                        if ((n = PrismUtils.convertTimeStringtoSeconds(stringArray[++i])) < 0) {
                            this.errorAndExit("Negative timeout value \"" + n + "\" for -" + string2 + " switch");
                        }
                        if (n <= 0) continue;
                        this.setTimeout(n);
                        continue;
                    }
                    this.errorAndExit("Missing timeout value for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("version")) {
                    this.printVersion();
                    this.exit();
                    continue;
                }
                if (string2.equals("settings")) {
                    if (i < stringArray.length - 1) {
                        this.settingsFilename = stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("keywords")) {
                    this.printListOfKeywords();
                    this.exit();
                    continue;
                }
                if (string2.equals("pf") || string2.equals("pctl") || string2.equals("csl")) {
                    if (i < stringArray.length - 1) {
                        this.propertyString = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No property specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("prop") || string2.equals("property")) {
                    if (i < stringArray.length - 1) {
                        String[] stringArray2 = stringArray[++i].trim().split(",");
                        this.propertyIndices = new ArrayList<Object>();
                        for (String string3 : stringArray2) {
                            if (string3.isEmpty()) continue;
                            try {
                                this.propertyIndices.add(Integer.parseInt(string3));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.propertyIndices.add(string3);
                            }
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("const")) {
                    if (i < stringArray.length - 1) {
                        if ("".equals(this.constSwitch)) {
                            this.constSwitch = stringArray[++i].trim();
                            continue;
                        }
                        this.constSwitch = this.constSwitch + "," + stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("param")) {
                    this.param = true;
                    if (i < stringArray.length - 1) {
                        if ("".equals(this.paramSwitch)) {
                            this.paramSwitch = stringArray[++i].trim();
                            continue;
                        }
                        this.paramSwitch = this.paramSwitch + "," + stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("steadystate") || string2.equals("ss")) {
                    this.steadystate = true;
                    continue;
                }
                if (string2.equals("transient") || string2.equals("tr")) {
                    if (i < stringArray.length - 1) {
                        this.dotransient = true;
                        this.transientTime = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simpath")) {
                    if (i < stringArray.length - 2) {
                        this.simpath = true;
                        this.simpathDetails = stringArray[++i];
                        this.simpathFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("The -" + string2 + " switch requires two arguments (path details, filename)");
                    continue;
                }
                if (string2.equals("nobuild")) {
                    this.nobuild = true;
                    continue;
                }
                if (string2.equals("test")) {
                    this.test = true;
                    continue;
                }
                if (string2.equals("testall")) {
                    this.test = true;
                    this.testExitsOnFail = false;
                    continue;
                }
                if (string2.equals("dddebug")) {
                    DebugJDD.enable();
                    continue;
                }
                if (string2.equals("ddtraceall")) {
                    DebugJDD.traceAll = true;
                    continue;
                }
                if (string2.equals("ddtracefollowcopies")) {
                    DebugJDD.traceFollowCopies = true;
                    continue;
                }
                if (string2.equals("dddebugwarnfatal")) {
                    DebugJDD.warningsAreFatal = true;
                    continue;
                }
                if (string2.equals("dddebugwarnoff")) {
                    DebugJDD.warningsOff = true;
                    continue;
                }
                if (string2.equals("ddtrace")) {
                    if (i < stringArray.length - 1) {
                        String string4 = stringArray[++i];
                        try {
                            int n = Integer.parseInt(string4);
                            DebugJDD.enableTracingForID(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("The -" + string2 + " switch requires an integer argument (JDDNode ID)");
                        }
                        continue;
                    }
                    this.errorAndExit("The -" + string2 + " switch requires an additional argument (JDDNode ID)");
                    continue;
                }
                if (string2.equals("importpepa")) {
                    this.importpepa = true;
                    continue;
                }
                if (string2.equals("importprismpp")) {
                    if (i < stringArray.length - 1) {
                        this.importprismpp = true;
                        this.prismppParams = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No parameters specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importmodel")) {
                    if (i < stringArray.length - 1) {
                        this.processImportModelSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importtrans")) {
                    this.importtrans = true;
                    continue;
                }
                if (string2.equals("importstates")) {
                    if (i < stringArray.length - 1) {
                        this.importstates = true;
                        this.importStatesFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importlabels")) {
                    if (i < stringArray.length - 1) {
                        this.importlabels = true;
                        this.importLabelsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importstaterewards")) {
                    if (i < stringArray.length - 1) {
                        this.importstaterewards = true;
                        this.importStateRewardsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importinitdist")) {
                    if (i < stringArray.length - 1) {
                        this.importinitdist = true;
                        this.importInitDistFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("dtmc")) {
                    this.typeOverride = ModelType.DTMC;
                    continue;
                }
                if (string2.equals("mdp")) {
                    this.typeOverride = ModelType.MDP;
                    continue;
                }
                if (string2.equals("ctmc")) {
                    this.typeOverride = ModelType.CTMC;
                    continue;
                }
                if (string2.equals("exportresults")) {
                    if (i < stringArray.length - 1) {
                        String[] stringArray3;
                        this.exportresults = true;
                        if ((stringArray3 = PrismCL.splitFilesAndOptions(string = stringArray[++i]))[1].length() == 0 && stringArray3[0].indexOf(44) > -1) {
                            int n = stringArray3[0].indexOf(44);
                            stringArray3[1] = stringArray3[0].substring(n + 1);
                            stringArray3[0] = stringArray3[0].substring(0, n);
                        }
                        this.exportResultsFilename = stringArray3[0];
                        String[] stringArray4 = stringArray3[1].split(",");
                        this.exportResultsFormat = "plain";
                        for (int j = 0; j < stringArray4.length; ++j) {
                            if (stringArray4[j].equals("")) continue;
                            if (stringArray4[j].equals("csv")) {
                                this.exportResultsFormat = "csv";
                                continue;
                            }
                            if (stringArray4[j].equals("matrix")) {
                                this.exportresultsmatrix = true;
                                continue;
                            }
                            if (stringArray4[j].equals("comment")) {
                                this.exportResultsFormat = "comment";
                                continue;
                            }
                            this.errorAndExit("Unknown option \"" + stringArray4[j] + "\" for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportvector")) {
                    if (i < stringArray.length - 1) {
                        this.exportvector = true;
                        this.exportVectorFilename = stringArray[++i];
                        this.prism.setStoreVector(true);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmodel")) {
                    if (i < stringArray.length - 1) {
                        this.processExportModelSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttrans")) {
                    if (i < stringArray.length - 1) {
                        this.exporttrans = true;
                        this.exportTransFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstaterewards")) {
                    if (i < stringArray.length - 1) {
                        this.exportstaterewards = true;
                        this.exportStateRewardsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttransrewards")) {
                    if (i < stringArray.length - 1) {
                        this.exporttransrewards = true;
                        this.exportTransRewardsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportrewards")) {
                    if (i < stringArray.length - 2) {
                        this.exportstaterewards = true;
                        this.exporttransrewards = true;
                        this.exportStateRewardsFilename = stringArray[++i];
                        this.exportTransRewardsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("Two files must be specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstates")) {
                    if (i < stringArray.length - 1) {
                        this.exportstates = true;
                        this.exportStatesFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportlabels")) {
                    if (i < stringArray.length - 1) {
                        this.exportlabels = true;
                        this.exportLabelsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmatlab")) {
                    this.exportType = 2;
                    continue;
                }
                if (string2.equals("exportmrmc")) {
                    this.exportType = 4;
                    continue;
                }
                if (string2.equals("exportrows")) {
                    this.exportType = 5;
                    continue;
                }
                if (string2.equals("exportordered") || string2.equals("ordered")) {
                    this.exportordered = true;
                    continue;
                }
                if (string2.equals("exportunordered") || string2.equals("unordered")) {
                    this.exportordered = false;
                    continue;
                }
                if (string2.equals("exporttransdot")) {
                    if (i < stringArray.length - 1) {
                        this.exporttransdot = true;
                        this.exportTransDotFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttransdotstates")) {
                    if (i < stringArray.length - 1) {
                        this.exporttransdotstates = true;
                        this.exportTransDotStatesFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportdot")) {
                    if (i < stringArray.length - 1) {
                        this.exportdot = true;
                        this.exportDotFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportsccs")) {
                    if (i < stringArray.length - 1) {
                        this.exportsccs = true;
                        this.exportSCCsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportbsccs")) {
                    if (i < stringArray.length - 1) {
                        this.exportbsccs = true;
                        this.exportBSCCsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmecs")) {
                    if (i < stringArray.length - 1) {
                        this.exportmecs = true;
                        this.exportMECsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportsteadystate") || string2.equals("exportss")) {
                    if (i < stringArray.length - 1) {
                        this.exportSteadyStateFilename = stringArray[++i];
                    } else {
                        this.errorAndExit("No file specified for -" + string2 + " switch");
                    }
                    this.steadystate = true;
                    continue;
                }
                if (string2.equals("exporttransient") || string2.equals("exporttr")) {
                    if (i < stringArray.length - 1) {
                        this.exportTransientFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstrat")) {
                    if (i < stringArray.length - 1) {
                        this.processExportStratSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprism")) {
                    if (i < stringArray.length - 1) {
                        String string5;
                        File file = (string5 = stringArray[++i]).equals("stdout") ? null : new File(string5);
                        this.prism.setExportPrism(true);
                        this.prism.setExportPrismFile(file);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprismconst")) {
                    if (i < stringArray.length - 1) {
                        String string6;
                        File file = (string6 = stringArray[++i]).equals("stdout") ? null : new File(string6);
                        this.prism.setExportPrismConst(true);
                        this.prism.setExportPrismConstFile(file);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportdigital")) {
                    if (i < stringArray.length - 1) {
                        String string7;
                        File file = (string7 = stringArray[++i]).equals("stdout") ? null : new File(string7);
                        this.prism.setExportDigital(true);
                        this.prism.setExportDigitalFile(file);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttarget")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportTarget(true);
                        this.prism.setExportTargetFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodtrans")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductTrans(true);
                        this.prism.setExportProductTransFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodstates")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductStates(true);
                        this.prism.setExportProductStatesFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodvector")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductVector(true);
                        this.prism.setExportProductVectorFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportplain")) {
                    if (i < stringArray.length - 1) {
                        this.exporttrans = true;
                        this.exportType = 1;
                        this.exportTransFilename = stringArray[++i];
                        this.exportPlainDeprecated = true;
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportspy")) {
                    if (i < stringArray.length - 1) {
                        this.exportspy = true;
                        this.exportSpyFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("sim")) {
                    this.simulate = true;
                    continue;
                }
                if (string2.equals("simmethod")) {
                    if (i < stringArray.length - 1) {
                        if ((string = stringArray[++i]).equals("ci") || string.equals("aci") || string.equals("apmc") || string.equals("sprt")) {
                            this.simMethodName = string;
                            continue;
                        }
                        this.errorAndExit("Unrecognised option for -" + string2 + " switch (options are: ci, aci, apmc, sprt)");
                        continue;
                    }
                    this.errorAndExit("No parameter specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simsamples")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simNumSamples = Integer.parseInt(stringArray[++i]);
                            if (this.simNumSamples <= 0) {
                                throw new NumberFormatException("");
                            }
                            this.simNumSamplesGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simconf")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simConfidence = Double.parseDouble(stringArray[++i]);
                            if (this.simConfidence <= 0.0 || this.simConfidence >= 1.0) {
                                throw new NumberFormatException("");
                            }
                            this.simConfidenceGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simwidth")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simWidth = Double.parseDouble(stringArray[++i]);
                            if (this.simWidth <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simWidthGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simapprox")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simApprox = Double.parseDouble(stringArray[++i]);
                            if (this.simApprox <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simApproxGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simmanual")) {
                    this.simManual = true;
                    continue;
                }
                if (string2.equals("simvar")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.reqIterToConclude = Integer.parseInt(stringArray[++i]);
                            if (this.reqIterToConclude <= 0) {
                                throw new NumberFormatException("");
                            }
                            this.reqIterToConcludeGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simmaxrwd")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simMaxReward = Double.parseDouble(stringArray[++i]);
                            if (this.simMaxReward <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simMaxRewardGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simpathlen")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simMaxPath = Long.parseLong(stringArray[++i]);
                            if (this.simMaxPath <= 0L) {
                                throw new NumberFormatException("");
                            }
                            this.simMaxPathGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("zerorewardcheck")) {
                    this.prism.setCheckZeroLoops(true);
                    continue;
                }
                if (string2.equals("explicitbuild")) {
                    this.explicitbuild = true;
                    continue;
                }
                if (string2.equals("explicitbuildtest")) {
                    this.explicitbuildtest = true;
                    continue;
                }
                if (string2.equals("mainlog")) {
                    if (i < stringArray.length - 1) {
                        this.mainLogFilename = stringArray[++i];
                        PrismFileLog prismFileLog = new PrismFileLog(this.mainLogFilename);
                        if (!((PrismLog)prismFileLog).ready()) {
                            this.errorAndExit("Couldn't open log file \"" + this.mainLogFilename + "\"");
                        }
                        this.mainLog = prismFileLog;
                        this.prism.setMainLog(this.mainLog);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmodeldotview")) {
                    this.exportmodeldotview = true;
                    continue;
                }
                if (string2.equals("c1")) {
                    this.prism.setConstruction(1);
                    continue;
                }
                if (string2.equals("c2")) {
                    this.prism.setConstruction(2);
                    continue;
                }
                if (string2.equals("c3")) {
                    this.prism.setConstruction(3);
                    continue;
                }
                if (string2.equals("o1")) {
                    this.prism.setOrdering(1);
                    this.orderingOverride = true;
                    continue;
                }
                if (string2.equals("o2")) continue;
                if (string2.equals("o2")) {
                    this.prism.setOrdering(2);
                    this.orderingOverride = true;
                    continue;
                }
                if (string2.equals("o2")) continue;
                if (string2.equals("noreach")) {
                    this.prism.setDoReach(false);
                    continue;
                }
                if (string2.equals("nobscc")) {
                    this.prism.setBSCCComp(false);
                    continue;
                }
                if (string2.equals("frontier")) {
                    this.prism.setReachMethod(Prism.REACH_FRONTIER);
                    continue;
                }
                if (string2.equals("bfs")) {
                    this.prism.setReachMethod(Prism.REACH_BFS);
                    continue;
                }
                if (string2.equals("bisim")) {
                    this.prism.setDoBisim(true);
                    continue;
                }
                i = this.prism.getSettings().setFromCommandLineSwitch(stringArray, i) - 1;
                continue;
            }
            if (this.modelFilename == null) {
                this.modelFilename = stringArray[i];
                continue;
            }
            if (this.propertiesFilename == null) {
                this.propertiesFilename = stringArray[i];
                continue;
            }
            this.errorAndExit("Invalid argument syntax");
        }
    }

    private void processImportModelSwitch(String string) throws PrismException {
        String[] stringArray = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new PrismException("No file name extension(s) in file(s) \"" + string2 + "\" for -importmodel");
        }
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1);
        String[] stringArray2 = string5.split(",");
        this.importModelWarning = null;
        for (String string6 : stringArray2) {
            if (string6.equals("all")) {
                this.importtrans = true;
                this.modelFilename = string4 + ".tra";
                this.importstates = true;
                this.importStatesFilename = string4 + ".sta";
                this.importlabels = true;
                this.importLabelsFilename = string4 + ".lab";
                if (new File(string4 + ".srew").exists()) {
                    this.importstaterewards = true;
                    this.importStateRewardsFilename = string4 + ".srew";
                }
                if (!new File(string4 + ".trew").exists()) continue;
                this.importModelWarning = "Import of transition rewards is not yet supported so " + string4 + ".trew is being ignored";
                continue;
            }
            if (string6.equals("tra")) {
                this.importtrans = true;
                this.modelFilename = string4 + ".tra";
                continue;
            }
            if (string6.equals("sta")) {
                this.importstates = true;
                this.importStatesFilename = string4 + ".sta";
                continue;
            }
            if (string6.equals("lab")) {
                this.importlabels = true;
                this.importLabelsFilename = string4 + ".lab";
                continue;
            }
            if (string6.equals("srew")) {
                this.importstaterewards = true;
                this.importStateRewardsFilename = string4 + ".srew";
                continue;
            }
            throw new PrismException("Unknown extension \"" + string6 + "\" for -importmodel switch");
        }
        if (!this.importtrans) {
            throw new PrismException("You must import the transition matrix when using -importmodel (use option \"tra\" or \"all\")");
        }
    }

    private void processExportModelSwitch(String string) throws PrismException {
        String[] stringArray = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new PrismException("No file name extension(s) in file(s) \"" + string2 + "\" for -exportmodel");
        }
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1);
        String[] stringArray2 = string5.split(",");
        if (string4.length() == 0) {
            string4 = "modelFileBasename";
            this.exportModelNoBasename = true;
        }
        String[] stringArray3 = stringArray2;
        int n2 = stringArray3.length;
        for (int i = 0; i < n2; ++i) {
            String string6 = stringArray3[i];
            if (string6.equals("all")) {
                this.exporttrans = true;
                this.exportTransFilename = string4.equals("stdout") ? "stdout" : string4 + ".tra";
                this.exportstaterewards = true;
                this.exportStateRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".srew";
                this.exporttransrewards = true;
                this.exportTransRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".trew";
                this.exportstates = true;
                this.exportStatesFilename = string4.equals("stdout") ? "stdout" : string4 + ".sta";
                this.exportlabels = true;
                this.exportLabelsFilename = string4.equals("stdout") ? "stdout" : string4 + ".lab";
                continue;
            }
            if (string6.equals("tra")) {
                this.exporttrans = true;
                this.exportTransFilename = string4.equals("stdout") ? "stdout" : string4 + ".tra";
                continue;
            }
            if (string6.equals("tra")) {
                this.exporttrans = true;
                this.exportTransFilename = string4.equals("stdout") ? "stdout" : string4 + ".tra";
                continue;
            }
            if (string6.equals("srew")) {
                this.exportstaterewards = true;
                this.exportStateRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".srew";
                continue;
            }
            if (string6.equals("trew")) {
                this.exporttransrewards = true;
                this.exportTransRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".trew";
                continue;
            }
            if (string6.equals("rew")) {
                this.exportstaterewards = true;
                this.exportStateRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".srew";
                this.exporttransrewards = true;
                this.exportTransRewardsFilename = string4.equals("stdout") ? "stdout" : string4 + ".trew";
                continue;
            }
            if (string6.equals("sta")) {
                this.exportstates = true;
                this.exportStatesFilename = string4.equals("stdout") ? "stdout" : string4 + ".sta";
                continue;
            }
            if (string6.equals("lab")) {
                this.exportlabels = true;
                this.exportLabelsFilename = string4.equals("stdout") ? "stdout" : string4 + ".lab";
                continue;
            }
            if (string6.equals("dot")) {
                this.exporttransdotstates = true;
                this.exportTransDotStatesFilename = string4.equals("stdout") ? "stdout" : string4 + ".dot";
                continue;
            }
            throw new PrismException("Unknown extension \"" + string6 + "\" for -exportmodel switch");
        }
        for (String string7 : stringArray3 = string3.split(",")) {
            if (string7.equals("")) continue;
            if (string7.equals("matlab")) {
                this.exportType = 2;
                continue;
            }
            if (string7.equals("mrmc")) {
                this.exportType = 4;
                continue;
            }
            if (string7.equals("rows")) {
                this.exportType = 5;
                continue;
            }
            if (string7.equals("unordered")) {
                this.exportordered = false;
                continue;
            }
            if (string7.equals("ordered")) {
                this.exportordered = true;
                continue;
            }
            throw new PrismException("Unknown option \"" + string7 + "\" for -exportmodel switch");
        }
    }

    private void processExportStratSwitch(String string) throws PrismException {
        String[] stringArray;
        String[] stringArray2 = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray2[0];
        String string3 = stringArray2[1];
        this.exportstrat = true;
        this.exportStratFilename = string2;
        this.prism.setGenStrat(true);
        for (String string4 : stringArray = string3.split(",")) {
            String string5;
            if (string4.equals("")) continue;
            if (string4.startsWith("type")) {
                if (!string4.startsWith("type=")) {
                    throw new PrismException("No value provided for \"type\" option of -exportstrat");
                }
                string5 = string4.substring(5);
                if (string5.equals("actions")) {
                    this.exportStratType = Prism.StrategyExportType.ACTIONS;
                    continue;
                }
                if (string5.equals("indices")) {
                    this.exportStratType = Prism.StrategyExportType.INDICES;
                    continue;
                }
                if (string5.equals("induced")) {
                    this.exportStratType = Prism.StrategyExportType.INDUCED_MODEL;
                    continue;
                }
                if (string5.equals("dot")) {
                    this.exportStratType = Prism.StrategyExportType.DOT_FILE;
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"type\" option of -exportstrat");
            }
            if (string4.startsWith("reach")) {
                if (!string4.startsWith("reach=")) {
                    throw new PrismException("No value provided for \"reach\" option of -exportstrat");
                }
                string5 = string4.substring(6);
                if (string5.equals("true")) {
                    this.prism.setRestrictStratToReach(true);
                    continue;
                }
                if (string5.equals("false")) {
                    this.prism.setRestrictStratToReach(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"reach\" option of -exportstrat");
            }
            throw new PrismException("Unknown option \"" + string4 + "\" for -exportstrat switch");
        }
    }

    private static String[] splitFilesAndOptions(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        while (string.length() > n + 1 && string.charAt(n + 1) == '\\') {
            n = string.indexOf(58, n + 1);
        }
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return stringArray;
    }

    public void printArguments(String[] stringArray) {
        this.mainLog.print("Command line: prism");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = PrismCL.shellQuoteSingleIfNecessary(string);
            this.mainLog.print(" " + string);
        }
        this.mainLog.println();
    }

    public static String shellQuoteSingleIfNecessary(String object) {
        if (((String)object).isEmpty()) {
            return "''";
        }
        if (((String)object).matches(".*[^_a-zA-Z0-9\\./\\-=].*")) {
            object = ((String)object).replace("'", "'\\''");
            object = "'" + (String)object + "'";
        }
        return object;
    }

    private void processOptions() throws PrismException {
        Object object;
        int n;
        if (this.modelFilename == null) {
            this.mainLog.println("Usage: " + Prism.getCommandLineName() + " [options] <model-file> [<properties-file>] [more-options]");
            this.mainLog.println("\nFor more information, type: prism -help");
            this.exit();
        }
        if (this.prism.getEngine() == 1 && !this.orderingOverride) {
            try {
                this.prism.setOrdering(2);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        if (this.prism.getExplicit()) {
            this.explicitbuild = false;
        }
        if (this.prism.getEngine() == 1 && !this.test) {
            n = this.prism.getLinEqMethod();
            if (n == 3 || n == 4 || n == 5 || n == 6) {
                this.errorAndExit("Gauss-Seidel and its variants are currently not supported by the MTBDD engine");
            }
            if (n == 8 || n == 9 || n == 10 || n == 11) {
                this.errorAndExit("SOR and its variants are currently not supported by the MTBDD engine");
            }
        } else if (!(this.prism.getEngine() != 2 || this.test || (n = this.prism.getLinEqMethod()) != 5 && n != 6 && n != 10 && n != 11)) {
            this.errorAndExit("Pseudo Gauss-Seidel/SOR methods are currently not supported by the sparse engine");
        }
        if (this.param) {
            object = this.paramSwitch.split(",");
            this.paramNames = new String[((String[])object).length];
            this.paramLowerBounds = new String[((Object)object).length];
            this.paramUpperBounds = new String[((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!((String)object[i]).contains("=")) {
                    this.paramNames[i] = object[i];
                    this.paramLowerBounds[i] = "0";
                    this.paramUpperBounds[i] = "1";
                    continue;
                }
                String[] stringArray = ((String)object[i]).split("=");
                this.paramNames[i] = stringArray[0];
                stringArray[1] = stringArray[1].trim();
                String[] stringArray2 = stringArray[1].split(":");
                if (stringArray2.length != 2) {
                    throw new PrismException("Invalid range \"" + stringArray[1] + "\" for parameter " + this.paramNames[i]);
                }
                this.paramLowerBounds[i] = stringArray2[0].trim();
                this.paramUpperBounds[i] = stringArray2[1].trim();
            }
        }
        if (this.exportModelNoBasename) {
            object = this.modelFilename;
            if (((String)object).lastIndexOf(46) > -1) {
                object = this.modelFilename.substring(0, ((String)object).lastIndexOf(46));
            }
            if (this.exporttrans) {
                this.exportTransFilename = this.exportTransFilename.replaceFirst("modelFileBasename", (String)object);
            }
            if (this.exportstaterewards) {
                this.exportStateRewardsFilename = this.exportStateRewardsFilename.replaceFirst("modelFileBasename", (String)object);
            }
            if (this.exporttransrewards) {
                this.exportTransRewardsFilename = this.exportTransRewardsFilename.replaceFirst("modelFileBasename", (String)object);
            }
            if (this.exportstates) {
                this.exportStatesFilename = this.exportStatesFilename.replaceFirst("modelFileBasename", (String)object);
            }
            if (this.exportlabels) {
                this.exportLabelsFilename = this.exportLabelsFilename.replaceFirst("modelFileBasename", (String)object);
            }
            if (this.exporttransdotstates) {
                this.exportTransDotStatesFilename = this.exportTransDotStatesFilename.replaceFirst("modelFileBasename", (String)object);
            }
        }
    }

    private SimulationMethod processSimulationOptions(Expression expression) throws PrismException {
        SimulationMethod simulationMethod = null;
        boolean bl = expression instanceof ExpressionReward;
        boolean bl2 = Expression.isQuantitative(expression);
        if (!this.simApproxGiven) {
            this.simApprox = this.prism.getSettings().getDouble("simulator.defaultApprox");
        }
        if (!this.simConfidenceGiven) {
            this.simConfidence = this.prism.getSettings().getDouble("simulator.defaultConfidence");
        }
        if (!this.simNumSamplesGiven) {
            this.simNumSamples = this.prism.getSettings().getInteger("simulator.defaultNumSamples");
        }
        if (!this.simWidthGiven) {
            this.simWidth = this.prism.getSettings().getDouble("simulator.defaultWidth");
        }
        if (!this.reqIterToConcludeGiven) {
            this.reqIterToConclude = this.prism.getSettings().getInteger("simulator.decide");
        }
        if (!this.simMaxRewardGiven) {
            this.simMaxReward = this.prism.getSettings().getDouble("simulator.maxReward");
        }
        if (!this.simMaxPathGiven) {
            this.simMaxPath = this.prism.getSettings().getLong("simulator.defaultMaxPath");
        }
        if (this.simMethodName == null) {
            String string = this.simMethodName = bl2 ? "ci" : "sprt";
        }
        if (this.simMethodName.equals("ci")) {
            if (this.simWidthGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (width/confidence/samples) for CI method");
            }
            simulationMethod = !this.simWidthGiven ? new CIwidth(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? (this.simManual ? new CIiterations(this.simConfidence, this.simWidth, this.reqIterToConclude) : (bl ? new CIiterations(this.simConfidence, this.simWidth, this.simMaxReward) : new CIiterations(this.simConfidence, this.simWidth))) : new CIconfidence(this.simWidth, this.simNumSamples));
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the CI method and is being ignored");
            }
        } else if (this.simMethodName.equals("aci")) {
            if (this.simWidthGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (width/confidence/samples) for ACI method");
            }
            simulationMethod = !this.simWidthGiven ? new ACIwidth(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? (this.simManual ? new ACIiterations(this.simConfidence, this.simWidth, this.reqIterToConclude) : (bl ? new ACIiterations(this.simConfidence, this.simWidth, this.simMaxReward) : new CIiterations(this.simConfidence, this.simWidth))) : new ACIconfidence(this.simWidth, this.simNumSamples));
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the ACI method and is being ignored");
            }
        } else if (this.simMethodName.equals("apmc")) {
            if (bl) {
                throw new PrismException("Cannot use the APMC method on reward properties; try CI (switch -simci) instead");
            }
            if (this.simApproxGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (approximation/confidence/samples) for APMC method");
            }
            simulationMethod = !this.simApproxGiven ? new APMCapproximation(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? new APMCiterations(this.simConfidence, this.simApprox) : new APMCconfidence(this.simApprox, this.simNumSamples));
            if (this.simWidthGiven) {
                this.mainLog.printWarning("Option -simwidth is not used for the APMC method and is being ignored");
            }
        } else if (this.simMethodName.equals("sprt")) {
            if (bl2) {
                throw new PrismException("Cannot use SPRT on a quantitative (=?) property");
            }
            simulationMethod = new SPRTMethod(this.simConfidence, this.simConfidence, this.simWidth);
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the SPRT method and is being ignored");
            }
            if (this.simNumSamplesGiven) {
                this.mainLog.printWarning("Option -simsamples is not used for the SPRT method and is being ignored");
            }
        } else {
            throw new PrismException("Unknown simulation method \"" + this.simMethodName + "\"");
        }
        return simulationMethod;
    }

    private void printHelp() {
        this.mainLog.println("Usage: " + Prism.getCommandLineName() + " [options] <model-file> [<properties-file>] [more-options]");
        this.mainLog.println();
        this.mainLog.println("Options:");
        this.mainLog.println("========");
        this.mainLog.println();
        this.mainLog.println("-help .......................... Display this help message");
        this.mainLog.println("-version ....................... Display PRISM version info");
        this.mainLog.println("-settings <file>................ Load settings from <file>");
        this.mainLog.println();
        this.mainLog.println("-pf <props> (or -pctl or -csl) . Model check properties <props>");
        this.mainLog.println("-property <refs> (or -prop) .... Only model check properties included in list <refs> of indices/names");
        this.mainLog.println("-const <vals> .................. Define constant values as <vals> (e.g. for experiments)");
        this.mainLog.println("-steadystate (or -ss) .......... Compute steady-state probabilities (D/CTMCs only)");
        this.mainLog.println("-transient <x> (or -tr <x>) .... Compute transient probabilities for time (or time range) <x> (D/CTMCs only)");
        this.mainLog.println("-simpath <options> <file>....... Generate a random path with the simulator");
        this.mainLog.println("-nobuild ....................... Skip model construction (just do parse/export)");
        this.mainLog.println("-test .......................... Enable \"test\" mode");
        this.mainLog.println("-testall ....................... Enable \"test\" mode, but don't exit on error");
        this.mainLog.println("-javamaxmem <x>................. Set the maximum heap size for Java, e.g. 500m, 4g [default: 1g]");
        this.mainLog.println("-javastack <x> ................. Set the Java stack size [default: 4m]");
        this.mainLog.println("-timeout <n> ................... Exit after a time-out of <n> seconds if not already terminated");
        this.mainLog.println("-ng ............................ Run PRISM in Nailgun server mode; subsequent calls are then made via \"ngprism\"");
        this.mainLog.println();
        this.mainLog.println("IMPORT OPTIONS:");
        this.mainLog.println("-importpepa .................... Model description is in PEPA, not the PRISM language");
        this.mainLog.println("-importmodel <files> ........... Import the model directly from text file(s)");
        this.mainLog.println("-importtrans <file> ............ Import the transition matrix directly from a text file");
        this.mainLog.println("-importstates <file>............ Import the list of states directly from a text file");
        this.mainLog.println("-importlabels <file>............ Import the list of labels directly from a text file");
        this.mainLog.println("-importstaterewards <file>...... Import the state rewards directly from a text file");
        this.mainLog.println("-importinitdist <file>.......... Specify initial probability distribution for transient/steady-state analysis");
        this.mainLog.println("-dtmc .......................... Force imported/built model to be a DTMC");
        this.mainLog.println("-ctmc .......................... Force imported/built model to be a CTMC");
        this.mainLog.println("-mdp ........................... Force imported/built model to be an MDP");
        this.mainLog.println();
        this.mainLog.println("EXPORT OPTIONS:");
        this.mainLog.println("-exportresults <file[:options]>  Export the results of model checking to a file");
        this.mainLog.println("-exportmodel <files[:options]> . Export the built model to file(s)");
        this.mainLog.println("-exporttrans <file> ............ Export the transition matrix to a file");
        this.mainLog.println("-exportstaterewards <file> ..... Export the state rewards vector to a file");
        this.mainLog.println("-exporttransrewards <file> ..... Export the transition rewards matrix to a file");
        this.mainLog.println("-exportrewards <file1> <file2>.. Export state/transition rewards to files 1/2");
        this.mainLog.println("-exportstates <file> ........... Export the list of reachable states to a file");
        this.mainLog.println("-exportlabels <file> ........... Export the list of labels and satisfying states to a file");
        this.mainLog.println("-exportmatlab .................. When exporting matrices/vectors/labels/etc., use Matlab format");
        this.mainLog.println("-exportmrmc .................... When exporting matrices/vectors/labels, use MRMC format");
        this.mainLog.println("-exportrows .................... When exporting matrices, put a whole row on one line");
        this.mainLog.println("-exportordered ................. When exporting matrices, order entries (by row) [default]");
        this.mainLog.println("-exportunordered ............... When exporting matrices, don't order entries");
        this.mainLog.println("-exporttransdot <file> ......... Export the transition matrix graph to a dot file");
        this.mainLog.println("-exporttransdotstates <file> ... Export the transition matrix graph to a dot file, with state info");
        this.mainLog.println("-exportdot <file> .............. Export the transition matrix MTBDD to a dot file");
        this.mainLog.println("-exportsccs <file> ............. Compute and export all SCCs of the model");
        this.mainLog.println("-exportbsccs <file> ............ Compute and export all BSCCs of the model");
        this.mainLog.println("-exportmecs <file> ............. Compute and export all maximal end components (MDPs only)");
        this.mainLog.println("-exportsteadystate <file> ...... Export steady-state probabilities to a file");
        this.mainLog.println("-exporttransient <file> ........ Export transient probabilities to a file");
        this.mainLog.println("-exportprism <file> ............ Export final PRISM model to a file");
        this.mainLog.println("-exportprismconst <file> ....... Export final PRISM model with expanded constants to a file");
        PrismSettings.printHelp(this.mainLog);
        this.mainLog.println();
        this.mainLog.println("SIMULATION OPTIONS:");
        this.mainLog.println("-sim ........................... Use the PRISM simulator to approximate results of model checking");
        this.mainLog.println("-simmethod <name> .............. Specify the method for approximate model checking (ci, aci, apmc, sprt)");
        this.mainLog.println("-simsamples <n> ................ Set the number of samples for the simulator (CI/ACI/APMC methods)");
        this.mainLog.println("-simconf <x> ................... Set the confidence parameter for the simulator (CI/ACI/APMC methods)");
        this.mainLog.println("-simwidth <x> .................. Set the interval width for the simulator (CI/ACI methods)");
        this.mainLog.println("-simapprox <x> ................. Set the approximation parameter for the simulator (APMC method)");
        this.mainLog.println("-simmanual ..................... Do not use the automated way of deciding whether the variance is null or not");
        this.mainLog.println("-simvar <n> .................... Set the minimum number of samples to know the variance is null or not");
        this.mainLog.println("-simmaxrwd <x> ................. Set the maximum reward -- useful to display the CI/ACI methods progress");
        this.mainLog.println("-simpathlen <n> ................ Set the maximum path length for the simulator");
        this.mainLog.println();
        this.mainLog.println("You can also use \"prism -help xxx\" for help on some switches -xxx with non-obvious syntax.");
    }

    private void printHelpSwitch(String string) {
        if (string.charAt(0) == '-') {
            string = string.substring(1);
        }
        if (string.equals("const")) {
            this.mainLog.println("Switch: -const <vals>\n");
            this.mainLog.println("<vals> is a comma-separated list of values or value ranges for undefined constants");
            this.mainLog.println("in the model or properties (i.e. those declared without values, such as \"const int a;\").");
            this.mainLog.println("You can either specify a single value (a=1), a range (a=1:10) or a range with a step (a=1:2:50).");
            this.mainLog.println("For convenience, constant definutions can also be split across multiple -const switches.");
            this.mainLog.println("\nExamples:");
            this.mainLog.println(" -const a=1,b=5.6,c=true");
            this.mainLog.println(" -const a=1:10,b=5.6");
            this.mainLog.println(" -const a=1:2:50,b=5.6");
            this.mainLog.println(" -const a=1:2:50 -const b=5.6");
        } else if (string.equals("simpath")) {
            this.mainLog.println("Switch: -simpath <options> <file>\n");
            this.mainLog.println("Generate a random path with the simulator and export it to <file> (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("<options> is a comma-separated list of options taken from:");
            GenerateSimulationPath.printOptions(this.mainLog);
        } else if (string.equals("importmodel")) {
            this.mainLog.println("Switch: -importmodel <files>\n");
            this.mainLog.println("Import the model directly from text file(s).");
            this.mainLog.println("Use a list of file extensions to indicate which files should be read, e.g.:");
            this.mainLog.println("\n -importmodel in.tra,sta\n");
            this.mainLog.println("Possible extensions are: .tra, .sta, .lab, .srew");
            this.mainLog.println("Use extension .all to import all, e.g.:");
            this.mainLog.println("\n -importmodel in.all\n");
        } else if (string.equals("exportresults")) {
            this.mainLog.println("Switch: -exportresults <file[:options]>\n");
            this.mainLog.println("Exports the results of model checking to <file> (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("The default behaviour is to export a list of results in text form, using tabs to separate items.");
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * csv - Export results as comma-separated values");
            this.mainLog.println(" * matrix - Export results as one or more 2D matrices (e.g. for surface plots)");
            this.mainLog.println(" * comment - Export results in comment format for regression testing)");
        } else if (string.equals("exportmodel")) {
            this.mainLog.println("Switch: -exportmodel <files[:options]>\n");
            this.mainLog.println("Export the built model to file(s) (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("Use a list of file extensions to indicate which files should be generated, e.g.:");
            this.mainLog.println("\n -exportmodel out.tra,sta\n");
            this.mainLog.println("Possible extensions are: .tra, .srew, .trew, .sta, .lab, .dot");
            this.mainLog.println("Use extension .all to export all (except .dot) and .rew to export both .srew/.trew, e.g.:");
            this.mainLog.println("\n -exportmodel out.all\n");
            this.mainLog.println("Omit the file basename to use the basename of the model file, e.g.:");
            this.mainLog.println("\n -exportmodel .all\n");
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * mrmc - export data in MRMC format");
            this.mainLog.println(" * matlab - export data in Matlab format");
            this.mainLog.println(" * rows - export matrices with one row/distribution on each line");
            this.mainLog.println(" * ordered - output states indices in ascending order [default]");
            this.mainLog.println(" * unordered - don't output states indices in ascending order");
        } else {
            if (PrismSettings.printHelpSwitch(this.mainLog, string)) {
                return;
            }
            this.mainLog.println("Sorry - no help available for switch -" + string);
        }
    }

    private void printVersion() {
        this.mainLog.println(Prism.getToolName() + " version " + Prism.getVersion());
    }

    private void printListOfKeywords() {
        List<String> list = Prism.getListOfKeywords();
        this.mainLog.print("PRISM keywords:");
        for (String string : list) {
            this.mainLog.print(" " + string);
        }
        this.mainLog.println();
    }

    private void error(String string) {
        this.error(string, false);
    }

    private void error(String string, boolean bl) {
        if (this.test && this.testExitsOnFail && !bl) {
            this.errorAndExit(string);
        }
        this.mainLog.println("\nError: " + string + ".");
        this.mainLog.flush();
    }

    private void errorAndExit(String string) {
        this.prism.closeDown(false);
        this.mainLog.println("\nError: " + string + ".");
        this.mainLog.flush();
        System.exit(1);
    }

    private void exit() {
        this.prism.closeDown(true);
        System.exit(0);
    }

    private void exit(int n) {
        this.prism.closeDown(true);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0 || !"-ng".equals(stringArray[0])) {
            new PrismCL().go(stringArray);
        } else {
            try {
                System.out.println("Starting PRISM-Nailgun server...");
                NGServer.main((String[])new String[0]);
            }
            catch (NumberFormatException | UnknownHostException exception) {
                System.out.println("Failed to launch Nailgun server: " + exception);
            }
        }
    }
}

