/*
 * Decompiled with CFR 0.152.
 */
package prism;

import param.BigRational;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;
import prism.PrismLangException;

public class DefinedConstant {
    public static final double DOUBLE_PRECISION_CORRECTION = 0.001;
    private String name;
    private Type type;
    private Object low;
    private Object high;
    private Object step;
    private int numSteps;
    private Object value;

    public DefinedConstant(String string, Type type) {
        this.name = string;
        this.type = type;
        this.clear();
    }

    public void clear() {
        this.low = null;
        this.high = null;
        this.step = null;
        this.numSteps = -1;
        this.value = null;
    }

    public boolean isDefined() {
        return this.low != null;
    }

    public void define(String string, String string2, String string3, boolean bl) throws PrismException {
        if (this.type instanceof TypeInt) {
            this.defineInt(string, string2, string3);
        } else if (this.type instanceof TypeDouble) {
            if (bl) {
                this.defineBigRational(string, string2, string3);
            } else {
                this.defineDouble(string, string2, string3);
            }
        } else if (this.type instanceof TypeBool) {
            this.defineBoolean(string, string2, string3);
        } else {
            throw new PrismException("Unknown type for undefined constant " + this.name);
        }
    }

    public void defineInt(String string, String string2, String string3) throws PrismException {
        int n;
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string + " for constant " + this.name + " is not a valid integer");
        }
        if (string2 == null) {
            n2 = n3;
            n = 1;
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string2 + " for constant " + this.name + " is not a valid integer");
            }
            if (n2 < n3) {
                throw new PrismException("Low value " + n3 + " for constant " + this.name + " is higher than the high value " + n2);
            }
            if (string3 == null) {
                n = 1;
            } else {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string3 + " for constant " + this.name + " is not a valid integer");
                }
                if (n == 0) {
                    throw new PrismException("Step value for constant " + this.name + " cannot be zero");
                }
                if (n < 0) {
                    throw new PrismException("Step value for constant " + this.name + " must be positive");
                }
                if (n > n2 - n3) {
                    throw new PrismException("Step value " + n + " for constant " + this.name + " is bigger than the difference between " + n3 + " and " + n2);
                }
            }
        }
        this.numSteps = 0;
        int n4 = n2;
        int n5 = n3;
        while (n5 <= n2) {
            ++this.numSteps;
            n4 = n5;
            n5 = n3 + this.numSteps * n;
        }
        n2 = n4;
        this.low = new Integer(n3);
        this.high = new Integer(n2);
        this.step = new Integer(n);
    }

    public void defineDouble(String string, String string2, String string3) throws PrismException {
        double d;
        double d2;
        double d3;
        try {
            d3 = DefinedConstant.parseDouble(string);
            if (!Double.isFinite(d3)) {
                throw new NumberFormatException("Value is not finite");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string + " for constant " + this.name + " is not a valid double");
        }
        if (string2 == null) {
            d2 = d3;
            d = 1.0;
        } else {
            try {
                d2 = DefinedConstant.parseDouble(string2);
                if (!Double.isFinite(d2)) {
                    throw new NumberFormatException("Value is not finite");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string2 + " for constant " + this.name + " is not a valid double");
            }
            if (d2 < d3) {
                throw new PrismException("Low value " + d3 + " for constant " + this.name + " is higher than the high value " + d2);
            }
            if (string3 == null) {
                d = 1.0;
            } else {
                try {
                    d = DefinedConstant.parseDouble(string3);
                    if (!Double.isFinite(d)) {
                        throw new NumberFormatException("Value is not finite");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string3 + " for constant " + this.name + " is not a valid double");
                }
                if (d == 0.0) {
                    throw new PrismException("Step value for constant " + this.name + " cannot be zero");
                }
                if (d < 0.0) {
                    throw new PrismException("Step value for constant " + this.name + " must be positive");
                }
                if (d > d2 - d3) {
                    throw new PrismException("Step value " + d + " for constant " + this.name + " is bigger than the difference between " + d3 + " and " + d2);
                }
            }
        }
        this.numSteps = 0;
        double d4 = d2;
        double d5 = d3;
        while (d5 <= d2 + 0.001 * d) {
            ++this.numSteps;
            d4 = d5;
            d5 = d3 + (double)this.numSteps * d;
        }
        d2 = d4;
        this.low = new Double(d3);
        this.high = new Double(d2);
        this.step = new Double(d);
    }

    public void defineBigRational(String string, String string2, String string3) throws PrismException {
        BigRational bigRational;
        BigRational bigRational2;
        BigRational bigRational3;
        try {
            bigRational3 = BigRational.from(string);
            if (bigRational3.isSpecial()) {
                throw new NumberFormatException("Value is not finite");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Value " + string + " for constant " + this.name + " is not a valid rational number");
        }
        if (string2 == null) {
            bigRational2 = bigRational3;
            bigRational = BigRational.from(1);
        } else {
            try {
                bigRational2 = BigRational.from(string2);
                if (bigRational2.isSpecial()) {
                    throw new NumberFormatException("Value is not finite");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Value " + string2 + " for constant " + this.name + " is not a valid rational number");
            }
            if (bigRational2.lessThan(bigRational3)) {
                throw new PrismException("Low value " + bigRational3 + " for constant " + this.name + " is higher than the high value " + bigRational2);
            }
            if (string3 == null) {
                bigRational = BigRational.from(1);
            } else {
                try {
                    bigRational = BigRational.from(string3);
                    if (bigRational.isSpecial()) {
                        throw new NumberFormatException("Value is not finite");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value " + string3 + " for constant " + this.name + " is not a valid double");
                }
                if (bigRational.isZero()) {
                    throw new PrismException("Step value for constant " + this.name + " cannot be zero");
                }
                if (bigRational.lessThan(BigRational.ZERO)) {
                    throw new PrismException("Step value for constant " + this.name + " must be positive");
                }
                if (bigRational.greaterThan(bigRational2.subtract(bigRational3))) {
                    throw new PrismException("Step value " + bigRational + " for constant " + this.name + " is bigger than the difference between " + bigRational3 + " and " + bigRational2);
                }
            }
        }
        this.numSteps = 0;
        BigRational bigRational4 = bigRational2;
        BigRational bigRational5 = bigRational3;
        while (bigRational5.lessThanEquals(bigRational2)) {
            ++this.numSteps;
            bigRational4 = bigRational5;
            bigRational5 = bigRational3.add(bigRational.multiply(this.numSteps));
        }
        bigRational2 = bigRational4;
        this.low = bigRational3;
        this.high = bigRational2;
        this.step = bigRational;
    }

    public void defineBoolean(String string, String string2, String string3) throws PrismException {
        if (string.equals("true")) {
            this.low = new Boolean(true);
        } else if (string.equals("false")) {
            this.low = new Boolean(false);
        } else {
            throw new PrismException("Value " + string + " for constant " + this.name + " is not a valid Boolean");
        }
        if (string2 != null) {
            throw new PrismException("Cannot define ranges for Boolean constants");
        }
        if (string3 != null) {
            throw new PrismException("Cannot define ranges for Boolean constants");
        }
        this.numSteps = 1;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public boolean incr() {
        boolean bl = false;
        if (this.type instanceof TypeInt) {
            int n = (Integer)this.low;
            int n2 = (Integer)this.high;
            int n3 = (Integer)this.step;
            int n4 = (Integer)this.value;
            if (n4 + n3 <= n2) {
                this.value = new Integer(n4 + n3);
            } else {
                this.value = this.low;
                bl = true;
            }
        } else if (this.type instanceof TypeDouble) {
            if (this.low instanceof BigRational) {
                BigRational bigRational = (BigRational)this.low;
                BigRational bigRational2 = (BigRational)this.high;
                BigRational bigRational3 = (BigRational)this.step;
                BigRational bigRational4 = (BigRational)this.value;
                int n = this.getValueIndex(this.value) + 1;
                bigRational4 = bigRational.add(bigRational3.multiply(n));
                if (bigRational4.lessThanEquals(bigRational2)) {
                    this.value = bigRational4;
                } else {
                    this.value = this.low;
                    bl = true;
                }
            } else {
                double d = (Double)this.low;
                double d2 = (Double)this.high;
                double d3 = (Double)this.step;
                double d4 = (Double)this.value;
                int n = this.getValueIndex(this.value) + 1;
                d4 = d + (double)n * d3;
                if (d4 <= d2 + 0.001 * d3) {
                    this.value = new Double(d4);
                } else {
                    this.value = this.low;
                    bl = true;
                }
            }
        } else if (this.type instanceof TypeBool) {
            this.value = this.low;
            bl = true;
        }
        return bl;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(int n) {
        if (this.type instanceof TypeInt) {
            int n2 = (Integer)this.low;
            int n3 = (Integer)this.step;
            int n4 = n2;
            for (int i = 0; i < n; ++i) {
                n4 += n3;
            }
            return new Integer(n4);
        }
        if (this.type instanceof TypeDouble) {
            if (this.low instanceof BigRational) {
                BigRational bigRational = (BigRational)this.low;
                BigRational bigRational2 = (BigRational)this.low;
                BigRational bigRational3 = bigRational.add(bigRational2.multiply(n));
                return bigRational3;
            }
            double d = (Double)this.low;
            double d2 = (Double)this.step;
            double d3 = d;
            d3 = d + (double)n * d2;
            return new Double(d3);
        }
        if (this.type instanceof TypeBool) {
            if (n == 0) {
                return new Boolean(false);
            }
            if (n == 1) {
                return new Boolean(true);
            }
        }
        return null;
    }

    public int getValueIndex(Object object) {
        if (this.type instanceof TypeInt) {
            int n = (Integer)this.low;
            int n2 = (Integer)this.step;
            int n3 = (Integer)object;
            return (n3 - n) / n2;
        }
        if (this.type instanceof TypeDouble) {
            if (this.low instanceof BigRational) {
                BigRational bigRational = (BigRational)this.low;
                BigRational bigRational2 = (BigRational)this.step;
                BigRational bigRational3 = (BigRational)this.value;
                BigRational bigRational4 = bigRational3.subtract(bigRational).divide(bigRational2);
                try {
                    return bigRational4.toInt();
                }
                catch (PrismLangException prismLangException) {
                    throw new IllegalArgumentException("Can not compute value index, out of range: " + prismLangException);
                }
            }
            double d = (Double)this.low;
            double d2 = (Double)this.step;
            double d3 = (Double)object;
            return (int)Math.round((d3 - d) / d2);
        }
        if (!(this.type instanceof TypeBool)) {
            if (((Boolean)object).booleanValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Object getLow() {
        return this.low;
    }

    public Object getHigh() {
        return this.high;
    }

    public Object getStep() {
        return this.step;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.name + "=";
        object = (String)object + this.low;
        if (this.numSteps > 1) {
            object = (String)object + ":" + this.step + ":" + this.high;
        }
        return object;
    }

    public static double parseDouble(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return Double.parseDouble(string);
        }
        if (n == 0 || n == string.length() - 1) {
            throw new NumberFormatException("Illegal fraction syntax");
        }
        double d = DefinedConstant.parseDouble(string.substring(0, n));
        double d2 = DefinedConstant.parseDouble(string.substring(n + 1));
        return d / d2;
    }

    public static boolean isValidDouble(String string) {
        try {
            DefinedConstant.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

