/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.Vector;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.RewardStructItem;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class RewardStruct
extends ASTElement {
    private String name = "";
    private Vector<RewardStructItem> items = new Vector();
    private int numStateItems = 0;
    private int numTransItems = 0;

    public void setName(String string) {
        this.name = string;
    }

    public void addItem(String string, Expression expression, Expression expression2) {
        this.addItem(new RewardStructItem(string, expression, expression2));
    }

    public void addItem(RewardStructItem rewardStructItem) {
        this.items.add(rewardStructItem);
        if (rewardStructItem.isTransitionReward()) {
            ++this.numTransItems;
        } else {
            ++this.numStateItems;
        }
    }

    public void setRewardStructItem(int n, RewardStructItem rewardStructItem) {
        if (this.getRewardStructItem(n).isTransitionReward()) {
            --this.numTransItems;
        } else {
            --this.numStateItems;
        }
        this.items.set(n, rewardStructItem);
        if (rewardStructItem.isTransitionReward()) {
            ++this.numTransItems;
        } else {
            ++this.numStateItems;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNumItems() {
        return this.items.size();
    }

    public int getNumStateItems() {
        return this.numStateItems;
    }

    public int getNumTransItems() {
        return this.numTransItems;
    }

    public RewardStructItem getRewardStructItem(int n) {
        return this.items.elementAt(n);
    }

    public String getSynch(int n) {
        return this.getRewardStructItem(n).getSynch();
    }

    public Expression getStates(int n) {
        return this.getRewardStructItem(n).getStates();
    }

    public Expression getReward(int n) {
        return this.getRewardStructItem(n).getReward();
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + "rewards";
        if (this.name != null && this.name.length() > 0) {
            object = (String)object + " \"" + this.name + "\"";
        }
        object = (String)object + " \n\n";
        int n = this.getNumItems();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "\t" + this.getRewardStructItem(i) + "\n";
        }
        object = (String)object + "\nendrewards\n";
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        RewardStruct rewardStruct = new RewardStruct();
        rewardStruct.setName(this.name);
        int n = this.getNumItems();
        for (int i = 0; i < n; ++i) {
            rewardStruct.addItem((RewardStructItem)this.getRewardStructItem(i).deepCopy());
        }
        rewardStruct.setPosition(this);
        return rewardStruct;
    }
}

