/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import parser.ast.ASTElement;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class RenamedModule
extends ASTElement {
    private String name;
    private String baseModule;
    private ArrayList<String> oldNames;
    private ArrayList<String> newNames;
    private ExpressionIdent nameASTElement;
    private ExpressionIdent baseModuleASTElement;
    private ArrayList<ExpressionIdent> oldNameASTElements;
    private ArrayList<ExpressionIdent> newNameASTElements;

    public RenamedModule(String string, String string2) {
        this.name = string;
        this.baseModule = string2;
        this.oldNames = new ArrayList();
        this.newNames = new ArrayList();
        this.oldNameASTElements = new ArrayList();
        this.newNameASTElements = new ArrayList();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setBaseModule(String string) {
        this.baseModule = string;
    }

    public void setNameASTElement(ExpressionIdent expressionIdent) {
        this.nameASTElement = expressionIdent;
    }

    public void setBaseModuleASTElement(ExpressionIdent expressionIdent) {
        this.baseModuleASTElement = expressionIdent;
    }

    public void addRename(String string, String string2) {
        this.addRename(string, string2, null, null);
    }

    public void addRename(String string, String string2, ExpressionIdent expressionIdent, ExpressionIdent expressionIdent2) {
        this.oldNames.add(string);
        this.newNames.add(string2);
        this.oldNameASTElements.add(expressionIdent);
        this.newNameASTElements.add(expressionIdent2);
    }

    public String getName() {
        return this.name;
    }

    public String getBaseModule() {
        return this.baseModule;
    }

    public String getNewName(String string) {
        int n = this.oldNames.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.newNames.get(n);
    }

    public String getOldName(String string) {
        int n = this.newNames.indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.oldNames.get(n);
    }

    public int getNumRenames() {
        return this.oldNames.size();
    }

    public String getOldName(int n) {
        return this.oldNames.get(n);
    }

    public String getNewName(int n) {
        return this.newNames.get(n);
    }

    public ExpressionIdent getNameASTElement() {
        return this.nameASTElement;
    }

    public ExpressionIdent getBaseModuleASTElement() {
        return this.baseModuleASTElement;
    }

    public ExpressionIdent getOldNameASTElement(int n) {
        return this.oldNameASTElements.get(n);
    }

    public ExpressionIdent getNewNameASTElement(int n) {
        return this.newNameASTElements.get(n);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        int n;
        Object object = "";
        object = (String)object + "module " + this.name + " = " + this.baseModule + " [";
        for (n = 0; n < this.oldNames.size() - 1; ++n) {
            object = (String)object + this.oldNames.get(n) + " = " + this.newNames.get(n) + ", ";
        }
        n = this.oldNames.size() - 1;
        object = (String)object + this.oldNames.get(n) + " = " + this.newNames.get(n) + "] endmodule";
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        RenamedModule renamedModule = new RenamedModule(this.name, this.baseModule);
        renamedModule.setNameASTElement((ExpressionIdent)this.nameASTElement.deepCopy());
        renamedModule.setBaseModuleASTElement((ExpressionIdent)this.baseModuleASTElement.deepCopy());
        int n = this.oldNames.size();
        for (int i = 0; i < n; ++i) {
            renamedModule.addRename(this.oldNames.get(i), this.newNames.get(i));
        }
        renamedModule.setPosition(this);
        return renamedModule;
    }
}

