/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionUnaryOp
extends Expression {
    public static final int NOT = 1;
    public static final int MINUS = 2;
    public static final int PARENTH = 3;
    public static final String[] opSymbols = new String[]{"", "!", "-", "()"};
    protected int op = 0;
    protected Expression operand = null;

    public ExpressionUnaryOp() {
    }

    public ExpressionUnaryOp(int n, Expression expression) {
        this.operand = expression;
        this.op = n;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperator(String string) throws PrismLangException {
        for (int i = 1; i < opSymbols.length; ++i) {
            if (!opSymbols[i].equals(string)) continue;
            this.setOperator(i);
            return;
        }
        throw new PrismLangException("Unknown unary operator '" + string + "'");
    }

    public void setOperand(Expression expression) {
        this.operand = expression;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public boolean isConstant() {
        return this.operand.isConstant();
    }

    @Override
    public boolean isProposition() {
        return this.operand.isProposition();
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.op) {
            case 1: {
                return !this.operand.evaluateBoolean(evaluateContext);
            }
            case 2: {
                if (this.type instanceof TypeInt) {
                    try {
                        return Math.negateExact(this.operand.evaluateInt(evaluateContext));
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new PrismLangException(arithmeticException.getMessage(), this);
                    }
                }
                return -this.operand.evaluateDouble(evaluateContext);
            }
            case 3: {
                return this.operand.evaluate(evaluateContext);
            }
        }
        throw new PrismLangException("Unknown unary operator", this);
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.op) {
            case 1: {
                return BigRational.from(!this.operand.evaluateExact(evaluateContext).toBoolean());
            }
            case 2: {
                return this.operand.evaluateExact(evaluateContext).negate();
            }
            case 3: {
                return this.operand.evaluateExact(evaluateContext);
            }
        }
        throw new PrismLangException("Unknown unary operator", this);
    }

    @Override
    public boolean returnsSingleValue() {
        return this.operand.returnsSingleValue();
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionUnaryOp expressionUnaryOp = new ExpressionUnaryOp(this.op, this.operand.deepCopy());
        expressionUnaryOp.setType(this.type);
        expressionUnaryOp.setPosition(this);
        return expressionUnaryOp;
    }

    @Override
    public String toString() {
        if (this.op == 3) {
            return "(" + this.operand + ")";
        }
        return opSymbols[this.op] + this.operand;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.op;
        n = 31 * n + (this.operand == null ? 0 : this.operand.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)object;
        if (this.op != expressionUnaryOp.op) {
            return false;
        }
        return !(this.operand == null ? expressionUnaryOp.operand != null : !this.operand.equals(expressionUnaryOp.operand));
    }
}

