/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionLiteral
extends Expression {
    Object value;
    String string;

    public ExpressionLiteral(Type type, Object object) {
        this(type, object, "" + object);
    }

    public ExpressionLiteral(Type type, Object object, String string) {
        this.type = type;
        this.value = object;
        this.string = string;
    }

    public void setValue(Object object) {
        this.value = object;
        this.string = "" + object;
    }

    public void setString(String string) {
        this.string = string;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.value instanceof BigRational) {
            return this.getType().castFromBigRational((BigRational)this.value);
        }
        return this.value;
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.value instanceof BigRational) {
            return (BigRational)this.value;
        }
        if (this.value instanceof Boolean) {
            return BigRational.from(this.value);
        }
        return BigRational.from(this.string);
    }

    @Override
    public boolean returnsSingleValue() {
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionLiteral expressionLiteral = new ExpressionLiteral(this.type, this.value, this.string);
        expressionLiteral.setPosition(this);
        return expressionLiteral;
    }

    @Override
    public String toString() {
        return this.string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.string == null ? 0 : this.string.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionLiteral expressionLiteral = (ExpressionLiteral)object;
        if (this.string == null ? expressionLiteral.string != null : !this.string.equals(expressionLiteral.string)) {
            return false;
        }
        return !(this.value == null ? expressionLiteral.value != null : !this.value.equals(expressionLiteral.value));
    }
}

