/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.ast.ASTElement;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.type.TypeArray;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class DeclarationArray
extends DeclarationType {
    protected Expression low;
    protected Expression high;
    protected DeclarationType subtype;

    public DeclarationArray(Expression expression, Expression expression2, DeclarationType declarationType) {
        this.low = expression;
        this.high = expression2;
        this.subtype = declarationType;
        this.setType(new TypeArray(declarationType.getType()));
    }

    public void setLow(Expression expression) {
        this.low = expression;
    }

    public void setHigh(Expression expression) {
        this.high = expression;
    }

    public void setSubtype(DeclarationType declarationType) {
        this.subtype = declarationType;
    }

    public Expression getLow() {
        return this.low;
    }

    public Expression getHigh() {
        return this.high;
    }

    public DeclarationType getSubtype() {
        return this.subtype;
    }

    @Override
    public Expression getDefaultStart() {
        return null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "array [" + this.low + ".." + this.high + "] of " + this.subtype;
    }

    @Override
    public ASTElement deepCopy() {
        Expression expression = this.low == null ? null : this.low.deepCopy();
        Expression expression2 = this.high == null ? null : this.high.deepCopy();
        DeclarationType declarationType = (DeclarationType)this.subtype.deepCopy();
        DeclarationArray declarationArray = new DeclarationArray(expression, expression2, declarationType);
        declarationArray.setPosition(this);
        return declarationArray;
    }
}

