/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionUnaryOp;
import prism.PrismLangException;

public class ParserUtils {
    public static List<Expression> splitConjunction(Expression expression) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ParserUtils.splitOnBinaryOp(expression, 4, arrayList);
        return arrayList;
    }

    public static List<Expression> splitDisjunction(Expression expression) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ParserUtils.splitOnBinaryOp(expression, 3, arrayList);
        return arrayList;
    }

    public static void splitOnBinaryOp(Expression expression, int n, List<Expression> list) {
        if (Expression.isParenth(expression)) {
            ParserUtils.splitOnBinaryOp(((ExpressionUnaryOp)expression).getOperand(), n, list);
            return;
        }
        if (expression instanceof ExpressionBinaryOp && ((ExpressionBinaryOp)expression).getOperator() == n) {
            ParserUtils.splitOnBinaryOp(((ExpressionBinaryOp)expression).getOperand1(), n, list);
            ParserUtils.splitOnBinaryOp(((ExpressionBinaryOp)expression).getOperand2(), n, list);
            return;
        }
        list.add(expression);
    }

    public static int findMinForIntExpression(Expression expression, VarList varList, Values values) throws PrismLangException {
        if (expression.isConstant()) {
            return expression.evaluateInt(values);
        }
        Vector<String> vector = expression.getAllVars();
        List<Values> list = varList.getAllValues(vector);
        int n = Integer.MAX_VALUE;
        for (Values values2 : list) {
            int n2 = expression.evaluateInt(values, values2);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static int findMaxForIntExpression(Expression expression, VarList varList, Values values) throws PrismLangException {
        if (expression.isConstant()) {
            return expression.evaluateInt(values);
        }
        Vector<String> vector = expression.getAllVars();
        List<Values> list = varList.getAllValues(vector);
        int n = Integer.MIN_VALUE;
        for (Values values2 : list) {
            int n2 = expression.evaluateInt(values, values2);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static Collection<Integer> findAllValsForIntExpression(Expression expression, VarList varList, Values values) throws PrismLangException {
        if (expression.isConstant()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(expression.evaluateInt(values));
            return hashSet;
        }
        Vector<String> vector = expression.getAllVars();
        List<Values> list = varList.getAllValues(vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Values values2 : list) {
            hashSet.add(expression.evaluateInt(values, values2));
        }
        return hashSet;
    }
}

