/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import param.ChoiceListFlexi;
import param.Function;
import parser.State;
import parser.VarList;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;

public class TransitionList {
    private ArrayList<ChoiceListFlexi> choices = new ArrayList();
    private ArrayList<Integer> transitionIndices = new ArrayList();
    private ArrayList<Integer> transitionOffsets = new ArrayList();
    private int numChoices = 0;
    private int numTransitions = 0;

    public void clear() {
        this.choices.clear();
        this.transitionIndices.clear();
        this.transitionOffsets.clear();
        this.numChoices = 0;
        this.numTransitions = 0;
    }

    public void add(ChoiceListFlexi choiceListFlexi) {
        this.choices.add(choiceListFlexi);
        int n = choiceListFlexi.size();
        for (int i = 0; i < n; ++i) {
            this.transitionIndices.add(this.choices.size() - 1);
            this.transitionOffsets.add(i);
        }
        ++this.numChoices;
        this.numTransitions += choiceListFlexi.size();
    }

    public int getNumChoices() {
        return this.numChoices;
    }

    public int getNumTransitions() {
        return this.numTransitions;
    }

    public ChoiceListFlexi getChoice(int n) {
        return this.choices.get(n);
    }

    public ChoiceListFlexi getChoiceOfTransition(int n) {
        return this.choices.get(this.transitionIndices.get(n));
    }

    public int getChoiceIndexOfTransition(int n) {
        return this.transitionIndices.get(n);
    }

    public int getChoiceOffsetOfTransition(int n) {
        return this.transitionOffsets.get(n);
    }

    public int getTotalIndexOfTransition(int n, int n2) {
        return this.transitionIndices.indexOf(n) + n2;
    }

    public void getChoiceIndexByProbabilitySum(double d, Ref ref) {
    }

    public String getTransitionModuleOrAction(int n) {
        return this.getChoiceOfTransition(n).getModuleOrAction();
    }

    public int getTransitionModuleOrActionIndex(int n) {
        return this.getChoiceOfTransition(n).getModuleOrActionIndex();
    }

    public int getChoiceModuleOrActionIndex(int n) {
        return this.getChoice(n).getModuleOrActionIndex();
    }

    public Function getTransitionProbability(int n) {
        return this.getChoiceOfTransition(n).getProbability(this.transitionOffsets.get(n));
    }

    public String getTransitionUpdateString(int n, State state) throws PrismLangException {
        return this.getChoiceOfTransition(n).getUpdateString(this.transitionOffsets.get(n), state);
    }

    public String getTransitionUpdateStringFull(int n) {
        return this.getChoiceOfTransition(n).getUpdateStringFull(this.transitionOffsets.get(n));
    }

    public State computeTransitionTarget(int n, State state) throws PrismLangException {
        return this.getChoiceOfTransition(n).computeTarget(this.transitionOffsets.get(n), state);
    }

    public boolean isDeadlock() {
        return this.numChoices == 0;
    }

    public boolean isDeterministic() {
        if (this.numTransitions == 1) {
            Function function = this.getChoice(0).getProbability(0);
            return function.isOne();
        }
        return false;
    }

    public boolean isDeterministicSelfLoop(State state) {
        State state2 = new State(state);
        try {
            for (ChoiceListFlexi choiceListFlexi : this.choices) {
                int n = choiceListFlexi.size();
                for (int i = 0; i < n; ++i) {
                    choiceListFlexi.computeTarget(i, state, state2);
                    if (state.equals(state2)) continue;
                    return false;
                }
            }
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
        return true;
    }

    public void checkValid(ModelType modelType) throws PrismException {
        for (ChoiceListFlexi choiceListFlexi : this.choices) {
            choiceListFlexi.checkValid(modelType);
        }
    }

    public void checkForErrors(State state, VarList varList) throws PrismException {
        for (ChoiceListFlexi choiceListFlexi : this.choices) {
            choiceListFlexi.checkForErrors(state, varList);
        }
    }

    public String toString() {
        Object object = "";
        boolean bl = true;
        for (ChoiceListFlexi choiceListFlexi : this.choices) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + choiceListFlexi.toString();
        }
        return object;
    }

    public class Ref {
        public int i;
        public int offset;
    }
}

