/*
 * Decompiled with CFR 0.152.
 */
package org.spg.PrismAPI.examples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spg.PrismAPI.PrismParamAPI;
import org.spg.utils.PrismAPIUtilities;

public class DPMDTMCParamExample {
    public static void main(String[] args) {
        System.out.println("Testing Prism API");
        PrismParamAPI api = new PrismParamAPI();
        String propsFile = "src/test/resources/models/DTMC-DPM/dpm.pctl";
        String modelFile = "src/test/resources/models/DTMC-DPM/dpm.pm";
        String model = PrismAPIUtilities.readModelFile(modelFile);
        api.loadParamModel(model);
        api.setPropertiesFile(propsFile);
        System.out.println("\nParametric Transition Matrix\n------------------------");
        String matrixFile = "matrixDTMCDPM.tra";
        api.saveParametricTransitionMatrix(matrixFile);
        String s = api.getModelStatesInfo();
        System.out.println("\nModel States Information\n------------------------");
        api.saveModelStatesInfo("DTMCDPM.sta");
        ArrayList<String> searchedVars = new ArrayList<String>();
        searchedVars.add("q");
        ArrayList<Number> searchedVarsValues = new ArrayList<Number>();
        searchedVarsValues.add(2);
        List<String> ss = api.findStatesWithVarValues(searchedVars, searchedVarsValues);
        System.out.println("\nModel States Matching Var Values\n------------------------");
        System.out.println(Arrays.toString(ss.toArray()));
        List<Integer> initialStates = api.getInitialStates();
        System.out.println(Arrays.toString(initialStates.toArray()));
        api.closeDown();
        System.exit(-1);
    }
}

