/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.FunctionExtension;
import org.mariuszgromada.math.mxparser.FunctionExtensionVariadic;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

public class Function
extends PrimitiveElement {
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    public static final int NOT_FOUND = -1;
    public static final int TYPE_ID = 103;
    public static final String TYPE_DESC = "User defined function";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int functionBodyType;
    Expression functionExpression;
    private String functionName;
    private String description;
    boolean isVariadic;
    private int parametersNumber;
    private FunctionExtension functionExtension;
    private FunctionExtensionVariadic functionExtensionVariadic;

    public Function(String string, String string2, PrimitiveElement ... primitiveElementArray) {
        super(103);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = string;
            this.functionExpression = new Expression(string2, primitiveElementArray);
            this.functionExpression.setDescription(string);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            this.parametersNumber = 0;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + string + "]Invalid function name, pattern not matches: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String string, String string2, String ... stringArray) {
        super(103);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = string;
            this.functionExpression = new Expression(string2, new PrimitiveElement[0]);
            this.functionExpression.setDescription(string);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            for (String string3 : stringArray) {
                this.functionExpression.addArguments(new Argument(string3, new PrimitiveElement[0]));
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + string + "]Invalid function name, pattern not matches: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String string, PrimitiveElement ... primitiveElementArray) {
        super(103);
        this.parametersNumber = 0;
        if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            if (headEqBody.headTokens.size() > 1) {
                for (int i = 1; i < headEqBody.headTokens.size(); ++i) {
                    Token token = headEqBody.headTokens.get(i);
                    if (token.tokenTypeId == 20) continue;
                    this.functionExpression.addArguments(new Argument(token.tokenStr, new PrimitiveElement[0]));
                }
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.functionExpression = new Expression(new PrimitiveElement[0]);
            this.functionExpression.setDescription(string);
            Object object = "";
            object = (String)object + "\n [" + string + "] --> pattern not mathes: f(x1,...,xn) = ... reg exp: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*";
            this.functionExpression.setSyntaxStatus(false, (String)object);
        }
    }

    public Function(String string, FunctionExtension functionExtension) {
        super(103);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = string;
            this.functionExpression = new Expression("{body-ext}", new PrimitiveElement[0]);
            this.isVariadic = false;
            this.parametersNumber = functionExtension.getParametersNumber();
            this.description = "";
            this.functionExtension = functionExtension;
            this.functionBodyType = 2;
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + string + "]Invalid function name, pattern not matches: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String string, FunctionExtensionVariadic functionExtensionVariadic) {
        super(103);
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = string;
            this.functionExpression = new Expression("{body-ext-var}", new PrimitiveElement[0]);
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionExtensionVariadic = functionExtensionVariadic;
            this.functionBodyType = 2;
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + string + "]Invalid function name, pattern not matches: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    private Function(Function function) {
        super(103);
        this.functionName = function.functionName;
        this.description = function.description;
        this.parametersNumber = function.parametersNumber;
        this.functionExpression = function.functionExpression.clone();
        this.functionBodyType = function.functionBodyType;
        this.isVariadic = function.isVariadic;
        if (this.functionBodyType == 2) {
            if (function.functionExtension != null) {
                this.functionExtension = function.functionExtension.clone();
            }
            if (function.functionExtensionVariadic != null) {
                this.functionExtensionVariadic = function.functionExtensionVariadic.clone();
            }
        }
    }

    public void setFunction(String string, PrimitiveElement ... primitiveElementArray) {
        this.parametersNumber = 0;
        if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            if (headEqBody.headTokens.size() > 1) {
                for (int i = 1; i < headEqBody.headTokens.size(); ++i) {
                    Token token = headEqBody.headTokens.get(i);
                    if (token.tokenTypeId == 20) continue;
                    this.functionExpression.addArguments(new Argument(token.tokenStr, new PrimitiveElement[0]));
                }
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(string);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, primitiveElementArray);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.functionExpression = new Expression(new PrimitiveElement[0]);
            this.functionExpression.setDescription(string);
            Object object = "";
            object = (String)object + "\n [" + string + "] --> pattern not mathes: f(x1,...,xn) = ... reg exp: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*";
            this.functionExpression.setSyntaxStatus(false, (String)object);
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionExpressionString() {
        return this.functionExpression.getExpressionString();
    }

    public void setFunctionName(String string) {
        if (mXparser.regexMatch(string, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = string;
            this.setExpressionModifiedFlags();
        } else {
            this.functionExpression.setSyntaxStatus(false, "[" + string + "]Invalid function name, pattern not matches: (\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public void setArgumentValue(int n, double d) {
        if (!this.isVariadic) {
            if (this.functionBodyType == 1) {
                this.functionExpression.argumentsList.get((int)n).argumentValue = d;
            } else if (!this.isVariadic) {
                this.functionExtension.setParameterValue(n, d);
            }
        }
    }

    public int getFunctionBodyType() {
        return this.functionBodyType;
    }

    public boolean checkSyntax() {
        boolean bl = true;
        if (this.functionBodyType != 2) {
            bl = this.functionExpression.checkSyntax();
        }
        this.checkRecursiveMode();
        return bl;
    }

    public String getErrorMessage() {
        return this.functionExpression.getErrorMessage();
    }

    protected Function clone() {
        Function function = new Function(this);
        return function;
    }

    public double calculate() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.calculate();
        }
        if (!this.isVariadic) {
            return this.functionExtension.calculate();
        }
        List<Double> list = this.functionExpression.UDFVariadicParamsAtRunTime;
        if (list != null) {
            int n = list.size();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = list.get(i);
            }
            return this.functionExtensionVariadic.calculate(dArray);
        }
        return Double.NaN;
    }

    public double calculate(double ... dArray) {
        if (dArray.length > 0) {
            this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
            for (double d : dArray) {
                this.functionExpression.UDFVariadicParamsAtRunTime.add(d);
            }
        } else {
            return Double.NaN;
        }
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                return this.functionExpression.calculate();
            }
            return this.functionExtensionVariadic.calculate(dArray);
        }
        if (dArray.length == this.getParametersNumber()) {
            if (this.functionBodyType == 1) {
                for (int i = 0; i < dArray.length; ++i) {
                    this.setArgumentValue(i, dArray[i]);
                }
                return this.functionExpression.calculate();
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.functionExtension.setParameterValue(i, dArray[i]);
            }
            return this.functionExtension.calculate();
        }
        this.functionExpression.setSyntaxStatus(false, "[" + this.functionName + "] incorrect number of function parameters (expecting " + this.getParametersNumber() + ", provided " + dArray.length + ")!");
        return Double.NaN;
    }

    public double calculate(Argument ... argumentArray) {
        double[] dArray;
        if (argumentArray.length > 0) {
            this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
            dArray = new double[argumentArray.length];
            for (int i = 0; i < argumentArray.length; ++i) {
                double d = argumentArray[i].getArgumentValue();
                this.functionExpression.UDFVariadicParamsAtRunTime.add(d);
                dArray[i] = d;
            }
        } else {
            return Double.NaN;
        }
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                return this.functionExpression.calculate();
            }
            return this.functionExtensionVariadic.calculate(dArray);
        }
        if (argumentArray.length == this.getParametersNumber()) {
            if (this.functionBodyType == 1) {
                for (int i = 0; i < argumentArray.length; ++i) {
                    this.setArgumentValue(i, argumentArray[i].getArgumentValue());
                }
                return this.functionExpression.calculate();
            }
            for (int i = 0; i < argumentArray.length; ++i) {
                this.functionExtension.setParameterValue(i, argumentArray[i].getArgumentValue());
            }
            return this.functionExtension.calculate();
        }
        this.functionExpression.setSyntaxStatus(false, "[" + this.functionName + "] incorrect number of function parameters (expecting " + this.getParametersNumber() + ", provided " + argumentArray.length + ")!");
        return Double.NaN;
    }

    public void addDefinitions(PrimitiveElement ... primitiveElementArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addDefinitions(primitiveElementArray);
        }
    }

    public void removeDefinitions(PrimitiveElement ... primitiveElementArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeDefinitions(primitiveElementArray);
        }
    }

    private int countRecursiveArguments() {
        int n = 0;
        if (this.functionBodyType == 1) {
            for (Argument argument : this.functionExpression.argumentsList) {
                if (argument.getArgumentType() != 3) continue;
                ++n;
            }
        }
        return n;
    }

    public void addArguments(Argument ... argumentArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addArguments(argumentArray);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void defineArguments(String ... stringArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineArguments(stringArray);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void defineArgument(String string, double d) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineArgument(string, d);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public int getArgumentIndex(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgumentIndex(string);
        }
        return -1;
    }

    public Argument getArgument(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgument(string);
        }
        return null;
    }

    public Argument getArgument(int n) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgument(n);
        }
        return null;
    }

    public int getParametersNumber() {
        if (!this.isVariadic) {
            return this.parametersNumber;
        }
        if (this.functionExpression.UDFVariadicParamsAtRunTime != null) {
            return this.functionExpression.UDFVariadicParamsAtRunTime.size();
        }
        return -1;
    }

    public void setParametersNumber(int n) {
        if (this.functionBodyType == 1) {
            this.parametersNumber = n;
            this.functionExpression.setExpressionModifiedFlag();
        }
    }

    public String getParameterName(int n) {
        if (n < 0) {
            return "";
        }
        if (n >= this.parametersNumber) {
            return "";
        }
        if (this.functionBodyType == 1) {
            return this.getArgument(n).getArgumentName();
        }
        if (this.functionBodyType == 2) {
            return this.functionExtension.getParameterName(n);
        }
        return "";
    }

    public int getArgumentsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgumentsNumber();
        }
        return 0;
    }

    public void removeArguments(String ... stringArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeArguments(stringArray);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void removeArguments(Argument ... argumentArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeArguments(argumentArray);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void removeAllArguments() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllArguments();
            this.parametersNumber = 0;
        }
    }

    public void addConstants(Constant ... constantArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(constantArray);
        }
    }

    public void addConstants(List<Constant> list) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(list);
        }
    }

    public void defineConstant(String string, double d) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineConstant(string, d);
        }
    }

    public int getConstantIndex(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstantIndex(string);
        }
        return -1;
    }

    public Constant getConstant(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstant(string);
        }
        return null;
    }

    public Constant getConstant(int n) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstant(n);
        }
        return null;
    }

    public int getConstantsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstantsNumber();
        }
        return 0;
    }

    public void removeConstants(String ... stringArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(stringArray);
        }
    }

    public void removeConstants(Constant ... constantArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(constantArray);
        }
    }

    public void removeAllConstants() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllConstants();
        }
    }

    public void addFunctions(Function ... functionArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addFunctions(functionArray);
        }
    }

    public void defineFunction(String string, String string2, String ... stringArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineFunction(string, string2, stringArray);
        }
    }

    public int getFunctionIndex(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunctionIndex(string);
        }
        return -1;
    }

    public Function getFunction(String string) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunction(string);
        }
        return null;
    }

    public Function getFunction(int n) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunction(n);
        }
        return null;
    }

    public int getFunctionsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunctionsNumber();
        }
        return 0;
    }

    public void removeFunctions(String ... stringArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(stringArray);
        }
    }

    public void removeFunctions(Function ... functionArray) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(functionArray);
        }
    }

    public void removeAllFunctions() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllFunctions();
        }
    }

    public void setVerboseMode() {
        this.functionExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.functionExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.functionExpression.getVerboseMode();
    }

    void checkRecursiveMode() {
        if (this.functionBodyType == 1) {
            List<Token> list = this.functionExpression.getInitialTokens();
            this.functionExpression.disableRecursiveMode();
            if (list != null) {
                for (Token token : list) {
                    if (!token.tokenStr.equals(this.functionName)) continue;
                    this.functionExpression.setRecursiveMode();
                    break;
                }
            }
        }
    }

    public boolean getRecursiveMode() {
        return this.functionExpression.getRecursiveMode();
    }

    public double getComputingTime() {
        return this.functionExpression.getComputingTime();
    }

    void addRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addRelatedExpression(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeRelatedExpression(expression);
        }
    }

    void setExpressionModifiedFlags() {
        if (this.functionBodyType == 1) {
            this.functionExpression.setExpressionModifiedFlag();
        }
    }
}

