/*
 * Decompiled with CFR 0.152.
 */
package mtbdd;

import java.io.FileNotFoundException;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import odd.ODDNode;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;

public class PrismMTBDD {
    private static PrismLog mainLog;
    private static PrismLog techLog;

    public static void initialise(PrismLog prismLog, PrismLog prismLog2) {
        PrismMTBDD.setCUDDManager();
        PrismMTBDD.setMainLog(prismLog);
        PrismMTBDD.setTechLog(prismLog2);
    }

    public static void closeDown() {
        PrismMTBDD.PM_FreeGlobalRefs();
    }

    private static native void PM_FreeGlobalRefs();

    private static native void PM_SetCUDDManager(long var0);

    public static void setCUDDManager() {
        PrismMTBDD.PM_SetCUDDManager(JDD.GetCUDDManager());
    }

    private static native void PM_SetMainLog(PrismLog var0);

    public static void setMainLog(PrismLog prismLog) {
        mainLog = prismLog;
        PrismMTBDD.PM_SetMainLog(prismLog);
    }

    private static native void PM_SetTechLog(PrismLog var0);

    public static void setTechLog(PrismLog prismLog) {
        techLog = prismLog;
        PrismMTBDD.PM_SetTechLog(prismLog);
    }

    private static native void PM_SetExportIterations(boolean var0);

    public static void SetExportIterations(boolean bl) {
        PrismMTBDD.PM_SetExportIterations(bl);
    }

    private static native String PM_GetErrorMessage();

    public static String getErrorMessage() {
        return PrismMTBDD.PM_GetErrorMessage();
    }

    private static PrismException generateExceptionForError() {
        String string = PrismMTBDD.getErrorMessage();
        if (string.contains("not supported")) {
            return new PrismNotSupportedException(string);
        }
        return new PrismException(string);
    }

    private static native long PM_Reachability(long var0, long var2, int var4, long var5, int var7, long var8);

    public static JDDNode Reachability(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
        }
        long l = PrismMTBDD.PM_Reachability(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob1(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, long var14);

    public static JDDNode Prob1(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode3, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode3, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode5, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode5, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob1(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode3.ptr(), jDDNode4.ptr(), jDDNode5.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob0(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12);

    public static JDDNode Prob0(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode3, JDDNode jDDNode4) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode3, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode3, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob0(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode3.ptr(), jDDNode4.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob1E(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13, long var15, long var17);

    public static JDDNode Prob1E(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode3, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode3, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode5, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode5, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob1E(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), jDDNode5.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob1A(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15, long var17);

    public static JDDNode Prob1A(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode4, JDDNode jDDNode5) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsDDOverVars(jDDNode3, jDDVars, jDDVars3);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode5, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode5, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob1A(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode4.ptr(), jDDNode5.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob0E(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15, long var17);

    public static JDDNode Prob0E(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode4, JDDNode jDDNode5) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsDDOverVars(jDDNode3, jDDVars, jDDVars3);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode5, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode5, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob0E(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode4.ptr(), jDDNode5.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_Prob0A(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13, long var15);

    public static JDDNode Prob0A(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars);
            SanityJDD.checkIsStateSet(jDDNode3, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode3, jDDNode2);
            SanityJDD.checkIsStateSet(jDDNode4, jDDVars);
            SanityJDD.checkIsContainedIn(jDDNode4, jDDNode2);
        }
        long l = PrismMTBDD.PM_Prob0A(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr());
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14);

    public static JDDNode ProbBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12);

    public static JDDNode ProbUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        long l = PrismMTBDD.PM_ProbUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr());
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbUntilInterval(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14);

    public static JDDNode ProbUntilInterval(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbUntilInterval(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, int var14);

    public static JDDNode ProbCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbInstReward(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static JDDNode ProbInstReward(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbInstReward(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbReachReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, long var16, long var18);

    public static JDDNode ProbReachReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6) throws PrismException {
        long l = PrismMTBDD.PM_ProbReachReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr());
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbReachRewardInterval(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, long var16, long var18, long var20, long var22, int var24);

    public static JDDNode ProbReachRewardInterval(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode4, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, JDDNode jDDNode8, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbReachRewardInterval(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode4.ptr(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), jDDNode8.ptr(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_ProbTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, int var12);

    public static JDDNode ProbTransient(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, int n) throws PrismException {
        long l = PrismMTBDD.PM_ProbTransient(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetBoundedUntil(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15, long var17, int var19, boolean var20);

    public static JDDNode NondetBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, int n, boolean bl) throws PrismException {
        long l = PrismMTBDD.PM_NondetBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), n, bl);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetUntil(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15, long var17, boolean var19);

    public static JDDNode NondetUntil(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl) throws PrismException {
        long l = PrismMTBDD.PM_NondetUntil(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), bl);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetUntilInterval(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15, long var17, boolean var19, int var20);

    public static JDDNode NondetUntilInterval(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, int n) throws PrismException {
        long l = PrismMTBDD.PM_NondetUntilInterval(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode3.ptr(), jDDNode4.ptr(), bl, n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetInstReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, long var14, int var16, int var17, boolean var18, long var19);

    public static JDDNode NondetInstReward(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, int n, boolean bl, JDDNode jDDNode4) throws PrismException {
        long l = PrismMTBDD.PM_NondetInstReward(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDNode3.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), n, bl, jDDNode4.ptr());
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetReachReward(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, int var15, long var16, int var18, long var19, long var21, long var23, boolean var25);

    public static JDDNode NondetReachReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDNode jDDNode4, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, boolean bl) throws PrismException {
        long l = PrismMTBDD.PM_NondetReachReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDNode4.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), bl);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_NondetReachRewardInterval(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, int var15, long var16, int var18, long var19, long var21, long var23, long var25, long var27, boolean var29, int var30);

    public static JDDNode NondetReachRewardInterval(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDNode jDDNode4, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode5, JDDNode jDDNode6, JDDNode jDDNode7, JDDNode jDDNode8, JDDNode jDDNode9, boolean bl, int n) throws PrismException {
        long l = PrismMTBDD.PM_NondetReachRewardInterval(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDNode4.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode5.ptr(), jDDNode6.ptr(), jDDNode7.ptr(), jDDNode8.ptr(), jDDNode9.ptr(), bl, n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_StochBoundedUntil(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, double var14, long var16);

    public static JDDNode StochBoundedUntil(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode2, JDDNode jDDNode3, double d, JDDNode jDDNode4) throws PrismException {
        long l = jDDNode4 == null ? 0L : jDDNode4.ptr();
        long l2 = PrismMTBDD.PM_StochBoundedUntil(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode2.ptr(), jDDNode3.ptr(), d, l);
        if (l2 == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l2);
    }

    private static native long PM_StochCumulReward(long var0, long var2, long var4, long var6, long var8, int var10, long var11, int var13, double var14);

    public static JDDNode StochCumulReward(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        long l = PrismMTBDD.PM_StochCumulReward(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_StochSteadyState(long var0, long var2, long var4, long var6, int var8, long var9, int var11);

    public static JDDNode StochSteadyState(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        long l = PrismMTBDD.PM_StochSteadyState(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n());
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_StochTransient(long var0, long var2, long var4, long var6, int var8, long var9, int var11, double var12);

    public static JDDNode StochTransient(JDDNode jDDNode, ODDNode oDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, double d) throws PrismException {
        long l = PrismMTBDD.PM_StochTransient(jDDNode.ptr(), oDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), d);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native int PM_ExportVector(long var0, String var2, long var3, int var5, long var6, int var8, String var9);

    public static void ExportVector(JDDNode jDDNode, String string, JDDVars jDDVars, ODDNode oDDNode, int n, String string2) throws FileNotFoundException {
        int n2 = PrismMTBDD.PM_ExportVector(jDDNode.ptr(), string, jDDVars.array(), jDDVars.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
    }

    private static native int PM_ExportMatrix(long var0, String var2, long var3, int var5, long var6, int var8, long var9, int var11, String var12);

    public static void ExportMatrix(JDDNode jDDNode, String string, JDDVars jDDVars, JDDVars jDDVars2, ODDNode oDDNode, int n, String string2) throws FileNotFoundException {
        int n2 = PrismMTBDD.PM_ExportMatrix(jDDNode.ptr(), string, jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
    }

    private static native int PM_ExportLabels(long[] var0, String[] var1, String var2, long var3, int var5, long var6, int var8, String var9);

    public static void ExportLabels(JDDNode[] jDDNodeArray, String[] stringArray, String string, JDDVars jDDVars, ODDNode oDDNode, int n, String string2) throws FileNotFoundException {
        int n2;
        long[] lArray = new long[jDDNodeArray.length];
        for (n2 = 0; n2 < jDDNodeArray.length; ++n2) {
            lArray[n2] = jDDNodeArray[n2].ptr();
        }
        n2 = PrismMTBDD.PM_ExportLabels(lArray, stringArray, string, jDDVars.array(), jDDVars.n(), oDDNode.ptr(), n, string2);
        if (n2 == -1) {
            throw new FileNotFoundException();
        }
    }

    private static native long PM_Power(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14);

    public static JDDNode Power(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl) throws PrismException {
        long l = PrismMTBDD.PM_Power(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_PowerInterval(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, long var14, boolean var16, int var17);

    public static JDDNode PowerInterval(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, int n) throws PrismException {
        long l = PrismMTBDD.PM_PowerInterval(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDNode4.ptr(), bl, n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_JOR(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, boolean var14, double var15);

    public static JDDNode JOR(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, boolean bl, double d) throws PrismException {
        long l = PrismMTBDD.PM_JOR(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), bl, d);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    private static native long PM_JORInterval(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12, long var14, boolean var16, double var17, int var19);

    public static JDDNode JORInterval(ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, boolean bl, double d, int n) throws PrismException {
        long l = PrismMTBDD.PM_JORInterval(oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr(), jDDNode4.ptr(), bl, d, n);
        if (l == 0L) {
            throw PrismMTBDD.generateExceptionForError();
        }
        return JDD.ptrToNode(l);
    }

    static {
        try {
            System.loadLibrary("prismmtbdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

